/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_hj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_l;
import com.inscada.mono.communication.base.services.c_Ej;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.s.c_pb;
import com.inscada.mono.log.v.c_ZC;
import com.inscada.mono.project.v.c_m;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.s.c_JA;
import com.inscada.mono.script.s.c_oc;
import com.inscada.mono.script.services.c_WA;
import com.inscada.mono.script.services.c_fb;
import com.inscada.mono.script.services.c_iB;
import com.inscada.mono.script.v.c_Hc;
import com.inscada.mono.script.v.c_xA;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.user.restcontrollers.PermissionController;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener,
c_m {
    private final c_WA f_lA;
    public static final short f_Uc = 304;
    public static final short f_kB = 302;
    public static final short f_Pd = 305;
    private final c_pb f_Ec;
    private final Map<String, Job> f_jd;
    private final Lock f_DC;
    private final c_hj f_mb;
    public static final short f_iB = 301;
    private final JedisPooled f_AA;
    private static final Logger f_Hb = LoggerFactory.getLogger(ScriptManager.class);
    private static final String f_nB = "scheduled_scripts";
    public static final short f_AB = 307;
    public static final short f_td = 303;
    private final c_iB f_MB;
    public static final short f_fA = 306;
    private final c_l f_Cd;
    private final c_ZC f_NB;

    protected Map<String, c_oc> getScriptStatusesByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_lA.m_AE((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, repeatableScriptSummary -> {
            ScriptManager a = repeatableScriptSummary;
            ScriptManager a2 = this;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.info(c_Ej.m_Wca((Object)"4%9$=2B@0\u0001\u0016\u0004\u0014\t\u0016\u0007X0\n\u000f\u0012\u0005\u001b\u0014<\u0005\u0019\u0003\f\t\u000e\u0001\f\u0005=\u0016\u001d\u000e\f@\u001e\u000f\n@\b\u0012\u0017\n\u001d\u0003\f@1$B@\u0003\u001d"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_Hb.debug(PermissionController.m_EA((Object)":\u001b:y8\u00115\u00101\u0006Nt=3\u001a;\u0006=\u001a3T\u0004\u0006;\u001e1\u0017 01\u00157\u0000=\u00025\u000011\"\u0011:\u0000t\u0012;\u0006t\u0004&\u001b>\u00117\u0000t=\u0010Nt\u000f)"), a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_Cd.m_ca();
        f_Hb.info(c_Ej.m_Wca((Object)"3\u001b\u0012\u0011\u0010\f-\u0019\u000e\u0019\u0007\u001d\u0012B@,\b\u0011\u0013X\u000e\u0017\u0004\u001d@P\u001b\u0005IX\b\u0019\u0013X\u0002\u001d\u0003\u0017\r\u001d@\f\b\u001d@4%9$=2V@*\u0005\u000b\u0014\u0017\u0012\u0011\u000e\u001f@\u000b\u0003\u0010\u0005\u001c\u0015\u0014\u0005\u001c@\u000b\u0003\n\t\b\u0014\u000bNVN"), a);
        scriptManager2.f_DC.lock();
        try {
            HashSet hashSet = new HashSet(scriptManager.f_AA.smembers(f_nB));
            if (hashSet.isEmpty()) {
                f_Hb.info(PermissionController.m_EA((Object)"'7\u0006=\u0004 95\u001a5\u00131\u0006t\\\u0018\u00115\u00101\u0006t\u000f)]nT\u001a\u001bt\u00077\u001c1\u0010!\u00181\u0010t\u00077\u0006=\u0004 \u0007t\u0012;\u0001:\u0010t\u001d:T\u0006\u00110\u001d'T \u001bt\u00061\u0007 \u001b&\u0011z"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_Hb.info(c_Ej.m_Wca((Object)"+\u0003\n\t\b\u00145\u0001\u0016\u0001\u001f\u0005\n@P,\u001d\u0001\u001c\u0005\n@\u0003\u001dQZX&\u0017\u0015\u0016\u0004X\u001b\u0005@\u000b\u0003\u0010\u0005\u001c\u0015\u0014\u0005\u001c@\u000b\u0003\n\t\b\u0014X)<\u0013X\t\u0016@*\u0005\u001c\t\u000b@\f\u000fX\u0012\u001d\u0013\f\u000f\n\u0005B@\u0003\u001d"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[3 & 4] = PermissionController.m_EA((Object)"\u0002=\u0011#\u000b'\u0017&\u001d$\u0000");
            scriptManager.f_mb.m_Qda(() -> {
                void a;
                Object a2 = hashSet;
                ScriptManager a3 = this;
                a.addAll(a3.f_lA.m_ae((Set)a2));
            }, stringArray);
            f_Hb.info(c_Ej.m_Wca((Object)"+\u0003\n\t\b\u00145\u0001\u0016\u0001\u001f\u0005\n@P,\u001d\u0001\u001c\u0005\n@\u0003\u001dQZX!\f\u0014\u001d\r\b\u0014\u0011\u000e\u001f@\f\u000fX\u0012\u001d\u0013\f\u000f\n\u0005X\u001b\u0005@\u000b\u0003\n\t\b\u0014\u000bN"), a, (Object)arrayList.size());
            arrayList.forEach(repeatableScript -> {
                void a;
                ScriptManager scriptManager;
                ScriptManager scriptManager2 = scriptManager = this;
                Object a2 = scriptManager2.f_Cd.m_ca();
                String[] stringArray = new String[5 >> 1];
                stringArray[3 & 4] = PermissionController.m_EA((Object)"\u00077\u001c1\u0010!\u00181\u000b'\u0017&\u001d$\u0000");
                stringArray[5 >> 2] = c_Ej.m_Wca((Object)"#9.;%4?+#*)(4");
                scriptManager2.f_mb.m_Nea(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1((String)a2, (RepeatableScript)a), a.getSpace(), stringArray);
            });
            f_Hb.info(PermissionController.m_EA((Object)"\u0007\u0017&\u001d$\u0000\u0019\u0015:\u00153\u0011&T|81\u00150\u0011&T/\t}Nt2=\u001a=\u0007<\u00110T'\u0017&\u001d$\u0000t\u00061\u0007 \u001b&\u0015 \u001d;\u001at\u0004&\u001b7\u0011'\u0007z"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Hb.error(c_Ej.m_Wca((Object)"+\u0003\n\t\b\u00145\u0001\u0016\u0001\u001f\u0005\n@P,\u001d\u0001\u001c\u0005\n@\u0003\u001dQZX%\n\u0012\u0017\u0012X\u0004\r\u0012\u0011\u000e\u001f@\u000b\u0003\n\t\b\u0014X\u0012\u001d\u0013\f\u000f\n\u0001\f\t\u0017\u000eX\u0010\n\u000f\u001b\u0005\u000b\u0013B@\u0003\u001d"), objectArray);
            return;
        }
        finally {
            scriptManager.f_DC.unlock();
        }
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_Ec.m_Qm(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createPeriodicScriptJob$7((RepeatableScript)a), Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    private /* synthetic */ void lambda$scheduleScriptInternal$4(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_DC.lock();
        try {
            Job job;
            ScriptManager scriptManager;
            block14: {
                a2.cancelScriptInternal((RepeatableScript)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to schedule script " + a.getName());
                }
                switch (c_fb.f_nC[a.getType().ordinal()]) {
                    case 1: {
                        ScriptManager scriptManager2 = a2;
                        while (false) {
                        }
                        scriptManager = scriptManager2;
                        job = scriptManager2.createDailyScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 2: {
                        ScriptManager scriptManager3 = a2;
                        scriptManager = scriptManager3;
                        job = scriptManager3.createPeriodicScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 3: {
                        job = a2.createOnceScriptJob((RepeatableScript)a);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                    }
                }
                scriptManager = a2;
            }
            scriptManager.f_jd.put(a.getId(), job);
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 ^ 3] = a.getId();
            a2.f_AA.sadd(f_nB, stringArray);
            return;
        }
        finally {
            a2.f_DC.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$createOnceScriptJob$6(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a2 = Script.newBuilder((RepeatableScript)a).build();
        scriptManager.f_MB.m_vE((Script)a2);
        scriptManager.cancelScript(a.getId());
    }

    private /* synthetic */ void lambda$createPeriodicScriptJob$7(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_MB.m_vE((Script)a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.scheduleScript(scriptManager.f_lA.m_df((String)a, (String)a3).getId());
    }

    protected Map<String, c_oc> getScriptStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ScriptManager scriptManager = this;
        try {
            Class[] classArray = new Class[3 >> 1];
            classArray[2 & 5] = String.class;
            scriptManager.f_Cd.m_Fa((short)(0x6BAF & 0x157D), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ej.m_Wca((Object)"\u000b\u0003\u0010\u0005\u001c\u0015\u0014\u0005+\u0003\n\t\b\u00141\u000e\f\u0005\n\u000e\u0019\f"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[2 & 5] = String.class;
            scriptManager.f_Cd.m_Fa((short)(0x1F3E & 0x61EF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(PermissionController.m_EA((Object)"\u00175\u001a7\u00118'7\u0006=\u0004 =:\u00001\u0006:\u00158"), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[2 & 5] = String.class;
            scriptManager.f_Cd.m_Fa((short)(0x472F & 0x39FF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ej.m_Wca((Object)"\u0007\u001d\u0014+\u0003\n\t\b\u0014+\u0014\u0019\u0014\r\u00131\u000e\f\u0005\n\u000e\u0019\f"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 ^ 3] = String.class;
            scriptManager.f_Cd.m_Fa((short)(0x1DBA & 0x6375), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(PermissionController.m_EA((Object)"\u00077\u001c1\u0010!\u00181'7\u0006=\u0004 \u0007\u0016\r\u0004\u0006;\u001e1\u0017 =0=:\u00001\u0006:\u00158"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[5 >> 3] = String.class;
            scriptManager.f_Cd.m_Fa((short)(0x7DB1 & 0x37F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ej.m_Wca((Object)"\u001b\u0001\u0016\u0003\u001d\f+\u0003\n\t\b\u0014\u000b\"\u00010\n\u000f\u0012\u0005\u001b\u00141\u00041\u000e\f\u0005\n\u000e\u0019\f"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            scriptManager.f_Cd.m_Fa((short)(0x1137 & 0x6FFA), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(PermissionController.m_EA((Object)"\u00131\u0000\u0007\u0017&\u001d$\u0000\u0007\u00005\u0000!\u00071\u0007\u0016\r\u001d\u0010'=:\u00001\u0006:\u00158"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            scriptManager.f_Cd.m_Fa((short)(0x13F & 0x7FF3), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ej.m_Wca((Object)"\u001f\u0005\f3\u001b\u0012\u0011\u0010\f3\f\u0001\f\u0015\u000b\u0005\u000b\"\u00010\n\u000f\u0012\u0005\u001b\u00141\u00041\u000e\f\u0005\n\u000e\u0019\f"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(PermissionController.m_EA((Object)"25\u001d8\u00110T \u001bt\u00061\u0013=\u0007 \u0011&T\u0007\u0017&\u001d$\u0000\u0019\u0015:\u00153\u0011&T\u0006$\u0017T9\u0011 \u001c;\u0010'"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Job createDailyScriptJob(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        Object a2 = a.getTime();
        a2 = LocalTime.of(((Date)a2).getHours(), ((Date)a2).getMinutes(), ((Date)a2).getSeconds());
        return scriptManager.f_Ec.m_Qn(a.getProject(), scriptManager.generateJobName((RepeatableScript)a), () -> scriptManager.lambda$createDailyScriptJob$8((RepeatableScript)a), (LocalTime)a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_oc getScriptStatus(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(c_Ej.m_Wca((Object)",=!<%*ZX'\u001d\u0014\f\t\u0016\u0007X\u0013\u001b\u0012\u0011\u0010\f@\u000b\u0014\u0019\u0014\r\u0013X\u0006\u0017\u0012X\u001b\u0005@\u0014\u000f\u001b\u0001\u0014\f\u0001N"), a);
            return a2.getScriptStatusInternal((String)a);
        }
        f_Hb.debug(PermissionController.m_EA((Object)"\u001a;\u001aY\u00181\u00150\u0011&nT\u0006\u0011%\u00011\u0007 \u001d:\u0013t\u00181\u00150\u0011&T2\u001b&T'\u0017&\u001d$\u0000t\u0007 \u0015 \u0001'T2\u001b&T/\tz"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            return (c_oc)a2.f_Cd.m_Aa(Short.valueOf((short)(0x797F & 0x7AF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ScriptManager(c_WA c_WA2, c_pb c_pb2, c_iB c_iB2, c_ZC c_ZC2, JedisPooled jedisPooled, c_l c_l2, c_hj c_hj2) {
        ScriptManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ScriptManager a8;
        ScriptManager scriptManager = scriptManager2;
        ScriptManager scriptManager2 = c_hj2;
        ScriptManager scriptManager3 = a8 = scriptManager;
        ScriptManager scriptManager4 = a8;
        ScriptManager scriptManager5 = a8;
        ScriptManager scriptManager6 = a8;
        ScriptManager scriptManager7 = a8;
        scriptManager6.f_DC = new ReentrantLock();
        scriptManager6.f_jd = new ConcurrentHashMap();
        scriptManager6.f_lA = a7;
        scriptManager5.f_Ec = a6;
        scriptManager5.f_MB = a5;
        scriptManager4.f_NB = a4;
        scriptManager4.f_AA = a3;
        scriptManager3.f_Cd = a2;
        scriptManager3.f_mb = a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_oc> getScriptStatuses(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(PermissionController.m_EA((Object)"\u00181\u00150\u0011&nT\u0013\u0011 \u0000=\u001a3T5\u00188T'\u0017&\u001d$\u0000t\u0007 \u0015 \u0001'\u0011'T2\u001b&T$\u0006;\u001e1\u0017 T/\tt\u0018;\u00175\u00188\rz"), a);
            return a2.getScriptStatusesByProjectIdInternal((String)a);
        }
        f_Hb.debug(c_Ej.m_Wca((Object)".7.U,=!<%*ZX2\u001d\u0011\r\u0005\u000b\u0014\u0011\u000e\u001f@\u0014\u0005\u0019\u0004\u001d\u0012X\u0006\u0017\u0012X\u0001\u0014\fX\u0013\u001b\u0012\u0011\u0010\f@\u000b\u0014\u0019\u0014\r\u0013\u001d\u0013X\u0006\u0017\u0012X\u0010\n\u000f\u0012\u0005\u001b\u0014X\u001b\u0005N"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_Cd.m_Aa(Short.valueOf((short)(0x4737 & 0x39FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.scheduleScriptInternal(scriptManager.f_lA.m_nf((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String string, RepeatableScript repeatableScript) {
        void a;
        ScriptManager a2 = repeatableScript;
        ScriptManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Hb.info(c_Ej.m_Wca((Object)"+\u0003\n\t\b\u00145\u0001\u0016\u0001\u001f\u0005\n@P,\u001d\u0001\u001c\u0005\n@\u0003\u001dQZX2\u001d\u0013\f\u000f\n\t\u0016\u0007X\u0013\u001b\u0012\u0011\u0010\fZX\u001b\u0005@P)<ZX\u001b\u0005I"), objectArray);
            a3.scheduleScriptInternal((RepeatableScript)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_NB.m_dJ(a2.getProject()).m_R("Script Restore (Leader " + (String)a + ")", PermissionController.m_EA((Object)"Q'T|=\u0010NtQ']t\u00125\u001d8\u00110T \u001bt\u00061\u0007 \u001b&\u0011zT\u0017\u0015!\u00071NtQ'").formatted(objectArray));
            try {
                f_Hb.warn(c_Ej.m_Wca((Object)"+\u0003\n\t\b\u00145\u0001\u0016\u0001\u001f\u0005\n@P,\u001d\u0001\u001c\u0005\n@\u0003\u001dQZX!\f\u0014\u001d\r\b\u0014\u0011\u000e\u001f@\f\u000fX\u0003\u0019\u000e\u001b\u0005\u0014@\u000b\u0003\n\t\b\u0014X\u001b\u0005@\u0019\u0006\f\u0005\n@\n\u0005\u000b\u0014\u0017\u0012\u0019\u0014\u0011\u000f\u0016@\u001e\u0001\u0011\f\r\u0012\u001dN"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal((RepeatableScript)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Hb.error(PermissionController.m_EA((Object)"\u0007\u0017&\u001d$\u0000\u0019\u0015:\u00153\u0011&T|81\u00150\u0011&T/\t}Nt25\u001d8\u00110T \u001bt\u00175\u001a7\u00118T'\u0017&\u001d$\u0000t\u000f)T5\u0012 \u0011&T&\u0011'\u0000;\u00065\u0000=\u001b:T2\u0015=\u0018!\u00061Nt\u000f)"), objectArray2);
                return;
            }
        }
    }

    @TransactionalEventListener(value={c_Hc.class})
    public void handleRescheduleEvent(c_Hc c_Hc2) {
        ScriptManager scriptManager = this;
        if (scriptManager.f_Cd.m_La()) {
            ScriptManager a = a.m_MI();
            f_Hb.info(c_Ej.m_Wca((Object)"4%9$=2B@0\u0001\u0016\u0004\u0014\t\u0016\u0007X2\u001d\u0013\u001b\b\u001d\u0004\r\f\u001d%\u000e\u0005\u0016\u0014X\u0006\u0017\u0012X\u0013\u001b\u0012\u0011\u0010\fZX\u001b\u0005@P)<ZX\u001b\u0005I"), (Object)a.getName(), (Object)a.getId());
            if (scriptManager.getScriptStatusInternal(a.getId()) == c_oc.f_ld) {
                scriptManager.scheduleScriptInternal(a.getId());
                return;
            }
        } else {
            f_Hb.debug(PermissionController.m_EA((Object)"\u001a;\u001aY\u00181\u00150\u0011&nT\u001d\u0013:\u001b&\u001d:\u0013t&1\u00077\u001c1\u0010!\u001811\"\u0011:\u0000t\u0012;\u0006t\u00077\u0006=\u0004 Nt\u000f)"), (Object)a.m_MI().getId());
        }
    }

    protected void cancelScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.cancelScriptInternal(scriptManager.f_lA.m_nf((String)a2));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(PermissionController.m_EA((Object)"8\u00115\u00101\u0006Nt'7\u001c1\u0010!\u0018=\u001a3T5\u00188T'\u0017&\u001d$\u0000'T2\u001b&T$\u0006;\u001e1\u0017 T/\tt\u0018;\u00175\u00188\rz"), a);
            a2.scheduleScriptsByProjectIdInternal((String)a);
            return;
        }
        f_Hb.debug(c_Ej.m_Wca((Object)".7.U,=!<%*ZX2\u001d\u0011\r\u0005\u000b\u0014\u0011\u000e\u001f@\u0014\u0005\u0019\u0004\u001d\u0012X\u0014\u0017@\u000b\u0003\u0010\u0005\u001c\u0015\u0014\u0005X\u0001\u0014\fX\u0013\u001b\u0012\u0011\u0010\f\u0013X\u0006\u0017\u0012X\u0010\n\u000f\u0012\u0005\u001b\u0014X\u001b\u0005N"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_Cd.m_Aa(Short.valueOf((short)(0x3B79 & 0x45B6)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule scripts for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a22 = (Job)scriptManager.f_jd.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_Hb.info(c_Ej.m_Wca((Object)"3\u001b\u0012\u0011\u0010\f-\u0019\u000e\u0019\u0007\u001d\u0012XH6\u000f\f@4\u0005\u0019\u0004\u001d\u0012X\u001b\u0005IB@;\u0001\u0016\u0003\u001d\f\u0014\t\u0016\u0007X\f\u0017\u0003\u0019\fX\n\u0017\u0002X\u0006\u0017\u0012X\u0013\u001b\u0012\u0011\u0010\f@1$B@\u0003\u001d"), (Object)a3, (Object)a);
                scriptManager.f_Ec.m_LM((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 & 4] = a3;
                objectArray[2 ^ 3] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_Hb.error(PermissionController.m_EA((Object)"'7\u0006=\u0004 95\u001a5\u00131\u0006t\\\u001a\u001b T\u0018\u00115\u00101\u0006t\u000f)]nT\u0011\u0006&\u001b&T7\u0015:\u00171\u00188\u001d:\u0013t\u0018;\u00175\u0018t\u001e;\u0016t\u0012;\u0006t\u00077\u0006=\u0004 T\u001d0t\u000f)Nt\u000f)"), objectArray);
            }
        }
    }

    protected void cancelScriptsByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_lA.m_dF((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    protected void cancelScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_mb.m_kEa(() -> a2.lambda$cancelScriptInternal$9((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_Ec.m_xm(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createOnceScriptJob$6((RepeatableScript)a), Duration.ofMillis(a.getDelay().intValue()), (2 & 5) != 0);
    }

    protected void scheduleScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_mb.m_kEa(() -> a2.lambda$scheduleScriptInternal$4((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.f_Cd.m_Q((ClusterNodeListener)a);
        f_Hb.info(PermissionController.m_EA((Object)"'7\u0006=\u0004 95\u001a5\u00131\u0006t\u001d:\u001d \u001d5\u0018=\u000e1\u0010t\u0015:\u0010t\u00061\u0013=\u0007 \u0011&\u00110T5\u0007t78\u0001'\u00001\u0006\u001a\u001b0\u0011\u0018\u001d'\u00001\u001a1\u0006z"));
    }

    protected c_oc getScriptStatusInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_jd.containsKey(a)) {
            return c_oc.f_ld;
        }
        return c_oc.f_uA;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(c_Ej.m_Wca((Object)"4%9$=2B@;\u0001\u0016\u0003\u001d\f\u0014\t\u0016\u0007X\u0001\u0014\fX\u0013\u001b\u0012\u0011\u0010\f\u0013X\u0006\u0017\u0012X\u0010\n\u000f\u0012\u0005\u001b\u0014X\u001b\u0005@\u0014\u000f\u001b\u0001\u0014\f\u0001N"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_Hb.debug(PermissionController.m_EA((Object)"\u001a;\u001aY\u00181\u00150\u0011&nT\u0006\u0011%\u00011\u0007 \u001d:\u0013t\u00181\u00150\u0011&T \u001bt\u00175\u001a7\u00118T5\u00188T'\u0017&\u001d$\u0000'T2\u001b&T$\u0006;\u001e1\u0017 T/\tz"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_Cd.m_Aa(Short.valueOf((short)(0x4131 & 0x3FFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel scripts for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(c_Ej.m_Wca((Object)",=!<%*ZX#\u0019\u000e\u001b\u0005\u0014\f\u0011\u000e\u001f@\u000b\u0003\n\t\b\u0014X\u001b\u0005@\u0014\u000f\u001b\u0001\u0014\f\u0001N"), a);
            a2.cancelScriptInternal((String)a);
            return;
        }
        f_Hb.debug(PermissionController.m_EA((Object)":\u001b:y8\u00115\u00101\u0006Nt&1\u0005!\u0011'\u0000=\u001a3T8\u00115\u00101\u0006t\u0000;T7\u0015:\u00171\u0018t\u00077\u0006=\u0004 T/\tz"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            a2.f_Cd.m_Aa(Short.valueOf((short)(0x53EE & 0x2D3F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel script " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(PermissionController.m_EA((Object)"\u00181\u00150\u0011&nT\u0007\u0017<\u00110\u00018\u001d:\u0013t\u00077\u0006=\u0004 T/\tt\u0018;\u00175\u00188\rz"), a);
            a2.scheduleScriptInternal((String)a);
            return;
        }
        f_Hb.debug(c_Ej.m_Wca((Object)"6/6M4%9$=2B@*\u0005\t\u0015\u001d\u0013\f\t\u0016\u0007X\f\u001d\u0001\u001c\u0005\n@\f\u000fX\u0013\u001b\b\u001d\u0004\r\f\u001d@\u000b\u0003\n\t\b\u0014X\u001b\u0005N"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_Cd.m_Aa(Short.valueOf((short)(0x25FF & 0x5B2D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule script " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_oc> getScriptStatuses(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Cd.m_La()) {
            f_Hb.debug(c_Ej.m_Wca((Object)"4%9$=2B@?\u0005\f\u0014\u0011\u000e\u001f@\u000b\u0003\n\t\b\u0014X\u0013\f\u0001\f\u0015\u000b\u0005\u000b@\u001e\u000f\n@\u0003\u001dX)<\u0013X\f\u0017\u0003\u0019\f\u0014\u0019B@\u0003\u001d"), (Object)a.size(), (Object)a);
            return a2.getScriptStatusesByIdsInternal((List)a);
        }
        f_Hb.debug(PermissionController.m_EA((Object)":\u001b:y8\u00115\u00101\u0006Nt&1\u0005!\u0011'\u0000=\u001a3T8\u00115\u00101\u0006t\u0012;\u0006t\u00077\u0006=\u0004 T'\u00005\u0000!\u00071\u0007t\u0012;\u0006t\u000f)T\u001d0'Nt\u000f)"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_Cd.m_Aa(Short.valueOf((short)(0x37FE & 0x4933)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_Ej.m_Wca((Object)"L"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.cancelScript(scriptManager.f_lA.m_df((String)a, (String)a3).getId());
    }

    private /* synthetic */ String generateJobName(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        Object[] objectArray = new Object[--2];
        objectArray[5 >> 3] = a.getType().m_yg();
        objectArray[3 >> 1] = a.getName();
        return PermissionController.m_EA((Object)"Q'T\u0007\u0017&\u001d$\u0000tYtQ'").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_xA.class})
    public void handleCancelEvent(c_xA c_xA2) {
        void a;
        ScriptManager scriptManager = this;
        if (scriptManager.f_Cd.m_La()) {
            ScriptManager a2 = a.m_zh();
            f_Hb.info(c_Ej.m_Wca((Object)"4%9$=2B@0\u0001\u0016\u0004\u0014\t\u0016\u0007X#\u0019\u000e\u001b\u0005\u0014%\u000e\u0005\u0016\u0014X\u0006\u0017\u0012X\u0013\u001b\u0012\u0011\u0010\fZX\u001b\u0005@P)<ZX\u001b\u0005I"), (Object)a2.getName(), (Object)a2.getId());
            scriptManager.cancelScriptInternal((RepeatableScript)a2);
            return;
        }
        f_Hb.debug(PermissionController.m_EA((Object)"\u001a;\u001aY\u00181\u00150\u0011&nT\u001d\u0013:\u001b&\u001d:\u0013t75\u001a7\u001181\"\u0011:\u0000t\u0012;\u0006t\u00077\u0006=\u0004 Nt\u000f)"), (Object)a.m_zh().getId());
    }

    private /* synthetic */ void lambda$createDailyScriptJob$8(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_MB.m_vE((Script)a);
    }

    protected void scheduleScriptsByProjectIdInternal(String string) {
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_lA.m_dF((String)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> {
            if (a.getType() != c_JA.f_Nb) {
                return (3 & 5) != 0;
            }
            return false;
        }).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    public void notLeader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_Cd.m_ca();
        f_Hb.info(PermissionController.m_EA((Object)"'7\u0006=\u0004 95\u001a5\u00131\u0006nT\u0000\u001c=\u0007t\u001a;\u00101T|\u000f)]t\u001d'T\u001a;t8\u001b:\u00131\u0006T\u0000<\u0011T\u00181\u00150\u0011&zT\u0017\u0015:\u00171\u00188\u001d:\u0013t\u00158\u0018t\u0018;\u00175\u0018t\u00077\u0006=\u0004 T>\u001b6\u0007zZz"), a);
        scriptManager2.f_DC.lock();
        try {
            new ArrayList(scriptManager.f_jd.keySet()).forEach(arg_0 -> scriptManager.lambda$notLeader$2((String)a, arg_0));
            scriptManager.f_jd.clear();
            f_Hb.info(c_Ej.m_Wca((Object)"3\u001b\u0012\u0011\u0010\f-\u0019\u000e\u0019\u0007\u001d\u0012XH6\u000f\f@4\u0005\u0019\u0004\u001d\u0012X\u001b\u0005IB@9\f\u0014@\u0014\u000f\u001b\u0001\u0014@\u000b\u0003\n\t\b\u0014X\n\u0017\u0002\u000b@\u0010\u0001\u000e\u0005X\u0002\u001d\u0005\u0016@\n\u0005\t\u0015\u001d\u0013\f\u0005\u001c@\f\u000fX\u0003\u0019\u000e\u001b\u0005\u0014@\u0019\u000e\u001c@\u001b\f\u001d\u0001\n\u0005\u001c@\u001e\u0012\u0017\rX\f\u0017\u0003\u0019\fX\u0014\n\u0001\u001b\u000b\u0011\u000e\u001fN"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Hb.error(PermissionController.m_EA((Object)"\u0007\u0017&\u001d$\u0000\u0019\u0015:\u00153\u0011&T|:;\u0000t81\u00150\u0011&T/\t}Nt1&\u0006;\u0006t\u0010!\u0006=\u001a3T$\u0006;\u00171\u0007'T;\u0012t\u00175\u001a7\u00118\u0018=\u001a3T8\u001b7\u00158T'\u0017&\u001d$\u0000t\u001e;\u0016'Nt\u000f)"), objectArray);
            return;
        }
        finally {
            scriptManager.f_DC.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_oc getScriptStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_lA.m_Bg((String)a2, (String)a)) == null) {
            return c_oc.f_uA;
        }
        return a3.getScriptStatus(a2.getId());
    }

    private /* synthetic */ void lambda$cancelScriptInternal$9(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_DC.lock();
        try {
            Job job = (Job)a2.f_jd.get(a.getId());
            if (job != null) {
                a2.f_Ec.m_LM(job);
            }
            ScriptManager scriptManager = a2;
            scriptManager.f_jd.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = a.getId();
            scriptManager.f_AA.srem(f_nB, stringArray);
            return;
        }
        finally {
            a2.f_DC.unlock();
        }
    }
}

