/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="jspdf_report")
@AttributeOverride(name="id", column=@Column(name="jspdf_report_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class JsPdfReport
extends SpaceBaseModel {
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    private String script;
    @Size(max=255)
    private String dsc;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;

    public void setScript(String string) {
        Object a = string;
        JsPdfReport a2 = this;
        a2.script = a;
    }

    public Project getProject() {
        JsPdfReport a;
        return a.project;
    }

    public boolean equals(Object object) {
        JsPdfReport a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof JsPdfReport)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (3 & 5) != 0;
        }
        return false;
    }

    public JsPdfReport() {
        JsPdfReport a;
    }

    public void setProject(Project project) {
        JsPdfReport a;
        JsPdfReport a2 = project;
        JsPdfReport jsPdfReport = a = this;
        jsPdfReport.project = a2;
        jsPdfReport.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public int hashCode() {
        JsPdfReport a;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = super.hashCode();
        objectArray[4 ^ 5] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getName() {
        JsPdfReport a;
        return a.name;
    }

    public void setDsc(String string) {
        Object a = string;
        JsPdfReport a2 = this;
        a2.dsc = a;
    }

    public void setProjectId(String string) {
        Object a = string;
        JsPdfReport a2 = this;
        a2.projectId = a;
    }

    public void setName(String string) {
        Object a = string;
        JsPdfReport a2 = this;
        a2.name = a;
    }

    public String getDsc() {
        JsPdfReport a;
        return a.dsc;
    }

    public String getScript() {
        JsPdfReport a;
        return a.script;
    }

    public String getProjectId() {
        JsPdfReport a;
        return a.projectId;
    }
}

