/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.filesystem.v;

import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.filesystem.repositories.FileInfoRepository;
import com.inscada.mono.menu.model.MenuDto;
import com.inscada.mono.settings.v.c_lC;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.ModelUpdater;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.u.c_Gc;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class c_qd {
    public static final String f_rH = "symbols";
    private static final Logger f_AI = LoggerFactory.getLogger(c_qd.class);
    public static final String f_Mi = "animations";
    public static final String f_Th = "jasper-templates";
    private final String f_vH;
    public static final String f_mG = "general-uploads";
    public static final String f_SG = "scl-files";
    public static final String f_ZI = "project-icons";
    public static final String f_QI = "faceplates";
    private final FileInfoRepository f_FI;
    public static final String f_JG = "login-images";
    private final ModelUpdater f_yg;
    public static final String f_aG = "logo";

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_eN(Collection<FileInfo> collection) {
        Iterator a;
        c_qd c_qd2 = this;
        Object object = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Object object2 = a.stream().map(FileInfo::getName).filter(c_Gc::m_fe).collect(Collectors.toSet());
        object = c_qd2.f_FI.findByIdInOrNameIn(object, object2);
        object2 = object.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(FileInfo::getName, Function.identity()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        a = a.iterator();
        while (a.hasNext()) {
            FileInfo fileInfo;
            c_qd a2 = (FileInfo)a.next();
            Object object3 = a2.getId() != null ? (FileInfo)object2.get(a2.getId()) : (fileInfo = c_Gc.m_fe((String)a2.getName()) ? (FileInfo)object.get(a2.getName()) : null);
            if (fileInfo != null) {
                c_qd2.f_yg.copyForUpdate((Object)a2, (SpaceBaseModel)fileInfo, new String[3 >> 2]);
                arrayList.add(fileInfo);
                continue;
            }
            arrayList.add(a2);
        }
        c_qd2.f_FI.bulkSave(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DELETE_FILE')")
    @Transactional
    public void m_rM(String string) {
        Path path;
        FileInfo fileInfo;
        void a;
        Object object;
        block5: {
            object = this;
            fileInfo = object.m_IN((String)a).orElse(null);
            if (fileInfo == null) {
                return;
            }
            String[] stringArray = new String[3 >> 1];
            stringArray[3 & 4] = fileInfo.getSpace().getName();
            Path path2 = Path.of(object.f_vH, stringArray);
            path = path2.resolve(fileInfo.getRelativePath()).normalize();
            if (!Files.exists(path, new LinkOption[2 & 5])) break block5;
            Object a2 = fileInfo.getFileName();
            String string2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern(MenuDto.m_AK((Object)"SRSRgfNOucbFGXY")));
            Object object2 = a2;
            String string3 = "";
            int n = ((String)object2).lastIndexOf(0x7E & 0x2F);
            if (n > 0) {
                Object object3 = a2;
                object2 = ((String)object3).substring(3 ^ 3, n);
                string3 = ((String)object3).substring(n);
            }
            a2 = (String)object2 + "_deleted_" + string2 + string3;
            Path path3 = path;
            a2 = path3.getParent().resolve((String)a2);
            Files.move(path3, (Path)a2, new CopyOption[3 ^ 3]);
            f_AI.info(c_lC.m_fE((Object)"}MWA\u001bV^JZI^@\u001bBIKV\u0004\u001c_F\u0003\u001bPT\u0004\u001c_F\u0003\u001bBTV\u001b@^H^P^"), (Object)path, a2);
        }
        try {
            f_AI.warn(MenuDto.m_AK((Object)"{BRYBIJF\u000bLBFN\nEE_\nME^DO\nMEY\nOOGO_O\u0011\nPW"), (Object)path);
        }
        catch (IOException iOException) {
            f_AI.error(c_lC.m_fE((Object)"gTQW@\u001bJTP\u001bV^JZI^\u0004]MWA\u001bBTV\u001b@^H^P^\u001e\u001b_F"), (Object)fileInfo.getFileName(), (Object)iOException);
        }
        object.f_FI.delete((Object)fileInfo);
        f_AI.info(MenuDto.m_AK((Object)"mCGO\u000bNNFN^NN\u000bLDX\u000bco\u0010\u000bQV\u0006\u000beYCLCEKG\neKFO\u0011\nPW"), (Object)a, (Object)fileInfo.getFileName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_bM(ZipFile zipFile, FileInfo fileInfo) {
        void a3222;
        InputStream a22;
        c_qd c_qd2 = this;
        ZipEntry zipEntry = ((ZipFile)((Object)a22)).getEntry(a3222.getFileName());
        if (zipEntry == null) return;
        Objects.requireNonNull(a3222, c_lC.m_fE((Object)"}MWArJ]K\u001bKYN^GO\u0004XEUJTP\u001bF^\u0004UQWH\u0015"));
        Object a = zipEntry.getName();
        if (((String)a).trim().isEmpty()) {
            throw new FileStorageException(MenuDto.m_AK((Object)"pBZ\u000bOE^YS\u000bDJGN\nHKEDD^\u000bHN\nNG[^R\u0004"));
        }
        if (((String)a).contains(c_lC.m_fE((Object)"\n\u0015")) || ((String)a).startsWith(MenuDto.m_AK((Object)"\u0005")) || ((String)a).startsWith(c_lC.m_fE((Object)"g")) || ((String)a).contains(MenuDto.m_AK((Object)"\u0011\u0005")) || ((String)a).contains(c_lC.m_fE((Object)"\u001eg"))) {
            f_AI.warn(MenuDto.m_AK((Object)"pBZ\u000bYGC[\nJ^_OFZ_\nOO_OH^NN\u000bCE\nND_XR\nEKFO\u0011\n\fQV\r"), a);
            throw new FileStorageException(c_lC.m_fE((Object)"~RT\u001bAUPI]\u001bGTJOERJH\u0004RJMEWM_\u0004KEOL\u001bW^UNAUG^\u0004OLZP\u001bGTQW@\u001bH^E_\u0004OK\u001b@RV^GOKI]\u001bPIEMAIWZH\u0015"));
        }
        Object object = ((String)a).replace((char)(0x7E & 0x5D), (char)(0x2F & 0x7F));
        if (((String)object).contains(MenuDto.m_AK((Object)"\u0004\u0005\u0005")) || ((String)object).contains(c_lC.m_fE((Object)"\u0014\n\u0015")) || ((String)object).equals(MenuDto.m_AK((Object)"\u0005\u0004"))) {
            f_AI.warn(c_lC.m_fE((Object)"~RT\u001bWWMK\u0004ZPOAVTO\u0004_AOAXP^@\u001bMU\u0004UKIIZHR^^@\u001bAUPI]\u001bJZI^\u001e\u001b\u0003@Y\u001c"), object);
            throw new FileStorageException(MenuDto.m_AK((Object)"pBZ\u000bOE^YS\u000bIDD_KBDX\nOCYOH^DXR\n_XJ\\NXXKG\nXOZ_NDHOX\u0004"));
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(0x6F & 0x3F);
        if (n >= 0) {
            object2 = ((String)object).substring(n + (5 >> 2));
        }
        if (((String)object2).isEmpty() || ((String)object2).equals(c_lC.m_fE((Object)"\u0015")) || ((String)object2).equals(MenuDto.m_AK((Object)"\u0005\u0004"))) {
            throw new FileStorageException("Invalid filename extracted from zip entry: " + (String)a);
        }
        if (((String)(object2 = StringUtils.cleanPath((String)object2))).contains(c_lC.m_fE((Object)"\n\u0015"))) {
            throw new FileStorageException(MenuDto.m_AK((Object)"mCGOEKFO\u000bIDD_KBDX\nBD]KGCO\n[K_B\u000bYN[^OEIN\n\f\u0004\u0005\r\u000bKM^NX\u000bIGOJDBDL\u0004"));
        }
        String string = a = StringUtils.hasText((String)a3222.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3222.getTargetSubdirectory()) : f_mG;
        if (((String)a).contains(c_lC.m_fE((Object)"\n\u0015"))) {
            throw new FileStorageException(MenuDto.m_AK((Object)"\u007fKYMN^\u000bY^HOCYOH^DXR\nHEE^JCEY\u000bCE\\JFBN\u000bZJ^C\nXOZ_NDHO\u000b\r\u0005\u0004\f\u0004"));
        }
        Space a3222 = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_lC.m_fE((Object)"eXPRR^\u0004HTZG^\u0004RW\u001bV^UNMIA_\u0004OK\u001bQKHTE_\u0004Z\u0004]MWA\u0015"));
        String[] stringArray = new String[--1];
        stringArray[2 & 5] = a3222.getName();
        object = Path.of(c_qd2.f_vH, stringArray).toAbsolutePath().normalize();
        Path path = object.resolve((String)a).normalize();
        if (!path.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = object;
            objectArray[5 >> 1] = a3222.getName();
            f_AI.warn(MenuDto.m_AK((Object)"{K_B\u000b^YK]OYYJF\u000bK_^NG[^\u0005\n~ZGEJN\u000b^D\nOOYC]OO\nOCYOH^DXR\n\fQV\r\u000bXNYDF]OX\nD__YBNN\nXZJIN\nYED^\u000b\rPW\f\nMEY\nXZJIN\n\fQV\r"), objectArray);
            throw new FileStorageException(c_lC.m_fE((Object)"rJMEWM_\u0004_AIMMA_\u0004KEOL\u001bWKAXM]M^@\u0015\u0004zPOAVTO\u0004OK\u001bEXG^WH\u0004TQOWR@^\u0004_AHM\\JZP^@\u001b@RV^GOKI]\u0015"));
        }
        a = path.resolve((String)object2).normalize();
        if (!a.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = object2;
            objectArray[4 ^ 5] = path;
            objectArray[--2] = a3222.getName();
            f_AI.warn(MenuDto.m_AK((Object)"{K_B\u000b^YK]OYYJF\u000bK_^NG[^\u000b\\BK\u000bLBFNDJGN\u0004\u000blBFNDJGN\n\fQV\r\u000bCE\nOCYOH^DXR\n\fQV\r\u000bXNYDF]OX\nD__YBNN\nMEY\nXZJIN\n\fQV\r"), objectArray);
            throw new FileStorageException("Invalid file name results in path traversal: " + (String)object2);
        }
        if (!a.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 >> 1] = object;
            objectArray[5 >> 1] = a3222.getName();
            f_AI.warn(c_lC.m_fE((Object)"bRJZH\u001bW^GNVRPB\u0004XL^GP\u0004]ERH^@\u0015\u0004oEIC^P\u001bBRH^\u0004KEOL\u001b\u0003@Y\u001c\u0004RW\u001bKNPHM_A\u001bWKEXA\u001bVTKO\u0004\u001c_F\u0003\u001bBTV\u001bWKEXA\u001b\u0003@Y\u001c"), objectArray);
            throw new FileStorageException(MenuDto.m_AK((Object)"~JXLO_\nMCGO\u000bZJ^C\nYOXEG\\NY\u000bE^^XCOO\u000bNNYBMEK_OO\nXZJIN\nOCYOH^DXR\u0004"));
        }
        String a3222 = object.relativize((Path)a).toString().replace(c_lC.m_fE((Object)"g"), MenuDto.m_AK((Object)"\u0005"));
        if (c_qd2.f_FI.existsByRelativePath(a3222)) {
            f_AI.info("A file already exists at path: " + a3222);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            a22 = ((ZipFile)((Object)a22)).getInputStream(zipEntry);
            try {
                CopyOption[] copyOptionArray = new CopyOption[1];
                copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(a22, (Path)a, copyOptionArray);
                f_AI.info(c_lC.m_fE((Object)"bRH^\u0004\u001c_F\u0003\u001bWNGXAHW]QWHB\u0004LVRPOAU\u0004OK\u001bBRH^WBWOAV\u0004ZP\u001b\u0003@Y\u001c"), object2, a);
                if (a22 == null) return;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a22 != null) {
                    try {
                        a22.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a3222) {
                        throwable.addSuppressed(a3222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a22.close();
            return;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store file " + (String)object2 + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public List<FileInfo> m_VM() {
        c_qd a;
        return a.f_FI.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_yn(String string) {
        Object a = string;
        c_qd a2 = this;
        return a2.f_FI.findById(a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_HO(String string) {
        Object a = string;
        c_qd a2 = this;
        return a2.f_FI.findByRelativePath((String)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_PN(String string) {
        Object a = string;
        c_qd a2 = this;
        return (FileInfo)a2.m_IN((String)a).orElseThrow(() -> c_qd.m_kO((String)a));
    }

    private static /* synthetic */ NotFoundException m_KO(String a) {
        return new NotFoundException("File info not found with relative path: " + a);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public String m_qo(MultipartFile multipartFile) {
        void a22;
        c_qd c_qd2 = this;
        void v0 = a22;
        Objects.requireNonNull(v0, c_lC.m_fE((Object)"vQWPRTZVObRH^\u0004XEUJTP\u001bF^\u0004UQWH\u0015"));
        if (v0.isEmpty()) {
            throw new FileStorageException(MenuDto.m_AK((Object)"iJDEE_\nX^DXN\nJD\u000bOFZ_S\u000bLBFN\u0004"));
        }
        Object a = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), c_lC.m_fE((Object)"vQWPRTZVObRH^\u0004TVRCRJZH\u001bBRH^JZI^\u0004XEUJTP\u001bF^\u0004UQWH\u0015")));
        if (a.contains(MenuDto.m_AK((Object)"\u0005\u0004"))) {
            throw new FileStorageException(c_lC.m_fE((Object)"}MWAUEVA\u001bGTJOERJH\u0004RJMEWM_\u0004KEOL\u001bW^UNAUG^\u0004\u001c\n\u0015\u0003\u0015"));
        }
        Path path = Path.of(c_qd2.f_vH, new String[2 & 5]).toAbsolutePath().normalize().resolve(f_JG).normalize();
        Path path2 = path.resolve((String)a).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException(MenuDto.m_AK((Object)"bD]KGCO\nGELCE\nBGJMN\n[K_B"));
        }
        try {
            Files.createDirectories(path, new FileAttribute[3 & 4]);
            CopyOption[] copyOptionArray = new CopyOption[5 >> 2];
            copyOptionArray[3 & 4] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path2, copyOptionArray);
            f_AI.info(c_lC.m_fE((Object)"wK\\MU\u0004RIZC^\u0004\u001c_F\u0003\u001bWNGXAHW]QWHB\u0004LVRPOAU\u0004OK\u001bBRH^WBWOAV\u0004ZP\u001b\u0003@Y\u001c"), a, (Object)path2);
            return a;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store login image " + (String)a + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_bo(String string) {
        Object a = string;
        c_qd a2 = this;
        return (FileInfo)a2.m_HO((String)a).orElseThrow(() -> c_qd.m_KO((String)a));
    }

    /*
     * WARNING - void declaration
     */
    public FileDownloadResult m_xM(String string) {
        Path path;
        block7: {
            FileInfo fileInfo;
            Object a;
            void a2;
            c_qd c_qd2 = this;
            if (!StringUtils.hasText((String)a2)) {
                throw new NotFoundException(MenuDto.m_AK((Object)"dD\nGELCE\nIKHALXD_EN\u000bCFKLO\u000bLBFNDJGN\n[XD\\BNNN"));
            }
            Path path2 = Path.of(c_qd2.f_vH, new String[3 >> 2]);
            path = path2.resolve(f_JG).resolve((String)a2).normalize();
            if (!path.startsWith((Path)(a = path2.resolve(f_JG).normalize()))) {
                throw new FileStorageException(c_lC.m_fE((Object)"mURZHR@\u001bHTCRJ\u001bMVE\\A\u001bTZPS"));
            }
            a = new UrlResource(path.toUri());
            if (!a.exists() || !a.isReadable()) break block7;
            FileInfo fileInfo2 = fileInfo = new FileInfo();
            fileInfo2.setFileName((String)a2);
            fileInfo2.setFileType(Files.probeContentType(path));
            if (fileInfo2.getFileType() == null) {
                fileInfo.setFileType(MenuDto.m_AK((Object)"JZ[FBIJ^BEE\u0005DI_O_\u0007X^YOJG"));
            }
            return new FileDownloadResult((Resource)a, fileInfo);
        }
        try {
            f_AI.error(c_lC.m_fE((Object)"hTCRJ\u001bMVE\\A\u001bBRH^\u0004UKO\u0004]KNJ_\u0004TJ\u001b@RWP\u001e\u001b_F"), (Object)path);
            throw new NotFoundException(MenuDto.m_AK((Object)"gELCE\nBGJMN\nMCGO\u000bDD^\u000bLD_EN"));
        }
        catch (MalformedURLException a) {
            throw new NotFoundException(c_lC.m_fE((Object)"wK\\MU\u0004RIZC^\u0004]MWA\u001bJTP\u001bBTQU@\u001b\fVEWBTVVA_\u0004nvw\r\u0015"));
        }
        catch (IOException a) {
            f_AI.error(MenuDto.m_AK((Object)"nXYEY\nJIHOXYBDL\nGELCE\nBGJMN\nMCGO\u0011\nPW"), (Object)path, (Object)a);
            throw new NotFoundException(c_lC.m_fE((Object)"hTCRJ\u001bMVE\\A\u001bBRH^\u0004UKO\u0004]KNJ_"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public void m_HM(String string) {
        void a;
        c_qd c_qd2 = this;
        if (!StringUtils.hasText((String)a)) {
            f_AI.warn(MenuDto.m_AK((Object)"OOGO_OgELCEcFKLO\u000bIJFGOO\n\\C_B\u000bOFZ_S\u000bEY\nE_GF\u000bLBFNDJGN\u0004"));
            return;
        }
        try {
            Object a2 = StringUtils.cleanPath((String)a);
            if (a2.contains(c_lC.m_fE((Object)"\n\u0015"))) {
                throw new FileStorageException(MenuDto.m_AK((Object)"lBFNDJGN\nHEE^JCEY\u000bCE\\JFBN\u000bZJ^C\nXOZ_NDHO\u000b\r\u0005\u0004\f\u0004"));
            }
            Path path = Path.of(c_qd2.f_vH, new String[3 >> 2]).toAbsolutePath().normalize().resolve(f_JG).normalize();
            Path path2 = path.resolve((String)a2).normalize();
            if (!path2.startsWith(path)) {
                f_AI.warn(c_lC.m_fE((Object)"kEOL\u001bPIEMAIWZH\u001bEOP^IKP\u001bBTV\u001bHTCRJ\u001bMVE\\A\u001b@^H^PRKU\u001e\u001b_F"), a2);
                throw new FileStorageException(MenuDto.m_AK((Object)"bD]KGCO\nGELCE\nBGJMN\n[K_B\u000bLDX\u000bNNFN^BEE\u0004"));
            }
            Files.deleteIfExists(path2);
            f_AI.info(c_lC.m_fE((Object)"wK\\MU\u0004RIZC^\u0004\u001c_F\u0003\u001b@^H^P^@\u001bBIKV\u0004]MWAH]HP^I\u001b\fRB\u001bMO\u0004^\\RWOA_\r\u0015"), a2);
            return;
        }
        catch (IOException a2) {
            f_AI.error(MenuDto.m_AK((Object)"nXYEY\nDIH_YXNN\u000b]CCGO\u000bNNFN^BDL\nGELCE\nBGJMN\nMCGO\u0011\nPW"), (Object)a, (Object)a2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public c_qd(FileInfoRepository fileInfoRepository, ModelUpdater modelUpdater, @Value(value="${ins.files.path}") String string) {
        void modelUpdater2;
        void fileInfoRepository2;
        c_qd a;
        c_qd c_qd2 = object;
        Object object = string;
        c_qd c_qd3 = a = c_qd2;
        a.f_FI = fileInfoRepository2;
        c_qd3.f_yg = modelUpdater2;
        c_qd3.f_vH = object;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public FileInfo m_gM(FileInfo fileInfo) {
        FileInfo fileInfo2;
        c_qd a = fileInfo;
        c_qd a2 = this;
        Object object = a.getId() != null ? a2.m_yn(a.getId()) : (fileInfo2 = StringUtils.hasText((String)a.getName()) ? a2.m_Jo(a.getName()) : null);
        if (fileInfo2 != null) {
            a2.f_yg.copyForUpdate((Object)a, (SpaceBaseModel)fileInfo2, new String[3 ^ 3]);
            return fileInfo2;
        }
        return (FileInfo)a2.f_FI.save((Object)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_IN(String string) {
        Object a = string;
        c_qd a2 = this;
        return a2.f_FI.findById(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_Jo(String string) {
        Object a = string;
        c_qd a2 = this;
        return a2.f_FI.findOneByName((String)a);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_FILE')")
    public FileInfo m_RM(String string, MultipartFile multipartFile, FileInfo fileInfo) {
        String string2;
        String string3;
        void a;
        int n;
        Object object;
        c_qd a2;
        void a3;
        c_qd c_qd2;
        block12: {
            int n2;
            void v2;
            void a222;
            c_qd2 = this;
            Objects.requireNonNull(a3, c_lC.m_fE((Object)"qK@ZP^@\u001bI^PZ@ZPZ\u0004\u0013bRH^mUBT\r\u001bKYN^GO\u0004XEUJTP\u001bF^\u0004UQWH\u0015"));
            a2 = c_qd2.m_PN((String)a222);
            String[] stringArray = new String[4 ^ 5];
            stringArray[5 >> 3] = a2.getSpace().getName();
            object = Path.of(c_qd2.f_vH, stringArray).toAbsolutePath().normalize();
            Path path = object.resolve(a2.getRelativePath()).normalize();
            int n3 = n = a != null && !a.isEmpty() ? 3 & 5 : 0;
            if (n != 0) {
                string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a.getOriginalFilename(), MenuDto.m_AK((Object)"f_G^BZJX_lBFN\nDXBMBDJF\u000bLBFNDJGN\nHKEDD^\u000bHN\nE_GF\u000b]COE\nYO[FJIBDL\nHEE^ND_\u0004")));
                v2 = a3;
            } else {
                string3 = a2.getFileName();
                v2 = a3;
            }
            String string4 = StringUtils.hasText((String)v2.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3.getTargetSubdirectory()) : (string2 = StringUtils.hasText((String)a2.getTargetSubdirectory()) ? a2.getTargetSubdirectory() : f_mG);
            if (string3.contains(c_lC.m_fE((Object)"\n\u0015")) || string2.contains(MenuDto.m_AK((Object)"\u0005\u0004"))) {
                throw new FileStorageException(c_lC.m_fE((Object)"rJMEWM_\u0004KEOL\u001bWKAXM]M^@\u001bMU\u0004NT_EOA\u001bV^UNAHP\u0015"));
            }
            Path path2 = object.resolve(string2).normalize();
            if (!path2.startsWith((Path)object)) {
                f_AI.warn(MenuDto.m_AK((Object)"zJ^C\n_XJ\\NXXKG\nJ^_OFZ_\u0004\u000bdN]\u000b^JXLO_\nX_INBXNI_EYS\u000b\rPW\f\nYOXEG\\NY\u000bE^^XCOO\u000bY[KHO\u000bXDE_\n\fQV\r"), (Object)string2, object);
                throw new FileStorageException(c_lC.m_fE((Object)"rJMEWM_\u0004_MIAXPTVB\u0004KEOL\u001bWKAXM]M^@\u0015"));
            }
            Path path3 = path2.resolve(string3).normalize();
            if (!path3.startsWith(path2)) {
                f_AI.warn(MenuDto.m_AK((Object)"zJ^C\n_XJ\\NXXKG\nJ^_OFZ_\n]CJ\nEO\\\nMCGOEKFO\u0005\nmCGOEKFO\u000b\rPW\f\nBD\u000bNBXNI_EYS\u000b\rPW\f\nYOXEG\\NY\u000bE^^XCOO"), (Object)string3, (Object)path2);
                throw new FileStorageException(c_lC.m_fE((Object)"rJMEWM_\u0004]MWAUEVA\u001bWKAXM]M^@\u0015"));
            }
            int n4 = n2 = !((String)(object = object.relativize(path3).toString().replace(MenuDto.m_AK((Object)"v"), c_lC.m_fE((Object)"\u0014")))).equals(a2.getRelativePath()) ? 4 ^ 5 : 0;
            if (n2 != 0 && c_qd2.f_FI.existsByRelativePathAndIdNot((String)object, (String)a222)) {
                throw new FileStorageException(MenuDto.m_AK((Object)"j\nMCGO\u000b]B^C\n_BBY\u000bDJGN\nJFYOJNR\nNRBY_Y\u000bK_\n_BN\n_KYMN^\u000bFDIJ^BEE\u0004"));
            }
            try {
                if (n != 0) {
                    if (Files.exists(path, new LinkOption[5 >> 3])) {
                        Files.deleteIfExists(path);
                        f_AI.info(c_lC.m_fE((Object)"kW@\u001bBRH^\u0004XKUP^JO\u0004_AWAOA_\u0004]VTI\u001bBRH^WBWOAV\u001e\u001b_F"), (Object)path);
                    }
                    Files.createDirectories(path2, new FileAttribute[2 & 5]);
                    CopyOption[] copyOptionArray = new CopyOption[--1];
                    copyOptionArray[3 >> 2] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a.getInputStream(), path3, copyOptionArray);
                    f_AI.info(MenuDto.m_AK((Object)"eO\\\nMCGO\u000bIDD_OE^\u000bLDX\u000b\rPW\f\nX_HINYXL^FGS\u000b]YC_^ND\u000b^D\nMCGOXSX^NG\u000bK_\n\fQV\r"), (Object)string3, (Object)path3);
                    break block12;
                }
                if (n2 == 0) break block12;
                if (Files.exists(path, new LinkOption[3 >> 2])) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(path, path3, copyOptionArray);
                    f_AI.info(c_lC.m_fE((Object)"bRH^\u0004VKMA_\u0004]VTI\u001b_F\u0004OK\u001b_F"), (Object)path, (Object)path3);
                    break block12;
                }
                f_AI.warn(MenuDto.m_AK((Object)"dFO\nMCGO\u000bDD^\u000bLD_EN\u000bK_\nPW\u000bLDX\u000bGD\\N\nDZNXJ^BEE\u0006\u000bH^^\u000bGN^JNJ^J\nNRBY_OO\u0004"), (Object)path);
                throw new NotFoundException(c_lC.m_fE((Object)"bRH^\u0004UKO\u0004]KNJ_\u0004]KI\u0004NT_EOA\u001bKKAIEOMTJ\u0015"));
            }
            catch (IOException a222) {
                f_AI.error(MenuDto.m_AK((Object)"iD_GN\u000bDD^\u000b_[NJ^N\nMCGO\u000b\rPW\f\nO_N\n_E\u000bcdoSINZ_CDD"), (Object)a2.getFileName(), (Object)a222);
                throw new FileStorageException(c_lC.m_fE((Object)"gTQW@\u001bJTP\u001bQK@ZP^\u0004OL^\u0004]MWA\u0015\u0004kH^EHA\u001bPI]\u001bE\\ERJ\u0015"));
            }
        }
        c_qd c_qd3 = a2;
        c_qd c_qd4 = a2;
        c_qd4.setName(a3.getName());
        c_qd4.setDsc(a3.getDsc());
        c_qd3.setFileName(string3);
        c_qd3.setTargetSubdirectory(string2);
        a2.setRelativePath((String)object);
        if (n != 0) {
            c_qd c_qd5 = a2;
            c_qd5.setFileSize(Long.valueOf(a.getSize()));
            c_qd5.setFileType(StringUtils.hasText((String)a.getContentType()) ? a.getContentType() : MenuDto.m_AK((Object)"JZ[FBIJ^BEE\u0005DI_O_\u0007X^YOJG"));
        }
        return (FileInfo)c_qd2.f_FI.save((Object)a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('VIEW_FILE') and hasAuthority('CREATE_FILE')")
    public FileInfo m_AN(String string) {
        FileInfo a;
        c_qd c_qd2 = this;
        Objects.requireNonNull(a, c_lC.m_fE((Object)"kIM\\MUEW\u0004]MWA\u001bm\u007f\u0004XEUJTP\u001bF^\u0004UQWH\u0015"));
        a = c_qd2.m_PN((String)a);
        long l = System.currentTimeMillis();
        String string2 = a.getFileName();
        Object a22 = "";
        String string3 = string2;
        int n = string3.lastIndexOf(0x7E & 0x2F);
        if (n > 0) {
            String string4 = string2;
            string3 = string4.substring(5 >> 3, n);
            a22 = string4.substring(n);
        }
        if ((string2 = StringUtils.cleanPath((String)(string3 + "_clone_" + l + (String)a22))).contains(MenuDto.m_AK((Object)"\u0005\u0004"))) {
            throw new FileStorageException(c_lC.m_fE((Object)"|AUAIEOA_\u0004]MWAUEVA\u001bGTJOERJH\u0004RJMEWM_\u0004KEOL\u001bW^UNAUG^\u0004\u001c\n\u0015\u0003\u0015"));
        }
        a22 = Objects.requireNonNull(SpaceContext.getActiveSpace(), MenuDto.m_AK((Object)"kH^B\\N\nXZJIN\nBY\u000bXN[^CYOO\n_E\u000bIGEEO\u000bK\u000bLBFN\u0004"));
        String[] stringArray = new String[3 >> 1];
        stringArray[2 & 5] = a22.getName();
        a22 = Path.of(c_qd2.f_vH, stringArray).toAbsolutePath().normalize();
        Path path = a22.resolve(string3 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? a.getTargetSubdirectory() : f_mG).normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException("Generated filename results in path traversal: " + string2);
        }
        String string5 = a22.relativize(path2).toString().replace(c_lC.m_fE((Object)"g"), MenuDto.m_AK((Object)"\u0005"));
        if (c_qd2.f_FI.existsByRelativePath(string5)) {
            throw new FileStorageException("A file already exists at generated path: " + string5);
        }
        a22 = a22.resolve(a.getRelativePath()).normalize();
        try {
            Files.createDirectories(path, new FileAttribute[3 >> 2]);
            CopyOption[] copyOptionArray = new CopyOption[--1];
            copyOptionArray[3 ^ 3] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy((Path)a22, path2, copyOptionArray);
            f_AI.info(c_lC.m_fE((Object)"}MWA\u001bGWKUA_\u0004]VTI\u001b\u0003@Y\u001c\u0004OK\u001b\u0003@Y\u001c"), a22, (Object)path2);
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not clone file: " + a.getFileName(), (Throwable)a22);
        }
        a22 = a.getName() + "_clone_" + l;
        Path path3 = path = new FileInfo();
        path3.setName((String)a22);
        path3.setDsc("Clone of " + a.getName());
        Path path4 = path;
        FileInfo fileInfo = a;
        Path path5 = path;
        path5.setFileName(string2);
        path5.setRelativePath(string5);
        path.setFileSize(fileInfo.getFileSize());
        path4.setFileType(fileInfo.getFileType());
        path4.setTargetSubdirectory(string3);
        return (FileInfo)c_qd2.f_FI.save((Object)path);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE')")
    public FileInfo m_rO(MultipartFile multipartFile, FileInfo fileInfo) {
        String string;
        c_qd c_qd2;
        String string2;
        void a22;
        c_qd a = fileInfo;
        c_qd a3 = this;
        void v0 = a22;
        Objects.requireNonNull(a, c_lC.m_fE((Object)"}MWArJ]K\u001bKYN^GO\u0004XEUJTP\u001bF^\u0004UQWH\u0015"));
        Objects.requireNonNull(v0, MenuDto.m_AK((Object)"g^F_C[KY^mCGO\u000bIJDEE_\nIO\u000bD^FG\u0004"));
        if (v0.isEmpty()) {
            throw new FileStorageException(c_lC.m_fE((Object)"xEUJTP\u001bWOKIA\u001bEU\u0004^IKPB\u0004]MWA\u0015"));
        }
        String string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), MenuDto.m_AK((Object)"g^F_C[KY^mCGO\u000bEYCLCEKG\nMCGOEKFO\u000bIJDEE_\nIO\u000bD^FG\u0004")));
        String string4 = string2 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a.getTargetSubdirectory()) : f_mG;
        if (string3.contains(c_lC.m_fE((Object)"\n\u0015")) || string2.contains(MenuDto.m_AK((Object)"\u0005\u0004"))) {
            throw new FileStorageException(c_lC.m_fE((Object)"mURZHR@\u001bBRH^\u0004KEOL\u001bWKAXM]M^@\u0015"));
        }
        Space space = Objects.requireNonNull(SpaceContext.getActiveSpace(), MenuDto.m_AK((Object)"jI_C]O\u000bY[KHO\u000bCX\nYOZ_BXNN\u000b^D\n^ZGEJN\u000bK\u000bLBFN\u0004"));
        String[] stringArray = new String[5 >> 2];
        stringArray[3 ^ 3] = space.getName();
        Path path = Path.of(a3.f_vH, stringArray).toAbsolutePath().normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string2;
            objectArray[2 ^ 3] = path;
            objectArray[5 >> 1] = space.getName();
            f_AI.warn(c_lC.m_fE((Object)"tZPS\u0004OVZR^VHEW\u0004ZPOAVTO\n\u001bqKHTE_\u0004OK\u001b@^VRR^@\u001b@RV^GOKI]\u001b\u0003@Y\u001c\u0004IAHKWR^W\u001bKNPHM_A\u001bWKEXA\u001bVTKO\u0004\u001c_F\u0003\u001bBTV\u001bWKEXA\u001b\u0003@Y\u001c"), objectArray);
            throw new FileStorageException(MenuDto.m_AK((Object)"cE\\JFBN\u000bNBXNI_EYS\u000bZJ^C\nXZNIBLBOO\u0004"));
        }
        Path path3 = path2.resolve(string3).normalize();
        if (!path3.startsWith(path2)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = string3;
            objectArray[5 >> 2] = path2;
            objectArray[--2] = space.getName();
            f_AI.warn(c_lC.m_fE((Object)"tZPS\u0004OVZR^VHEW\u0004ZPOAVTO\u0004MMZ\u0004]MWAUEVA\u0015\u0004}MWAUEVA\u001b\u0003@Y\u001c\u0004RJ\u001b@RV^GOKI]\u001b\u0003@Y\u001c\u0004IAHKWR^W\u001bKNPHM_A\u001bBTV\u001bWKEXA\u001b\u0003@Y\u001c"), objectArray);
            throw new FileStorageException(MenuDto.m_AK((Object)"cE\\JFBN\u000bLBFNDJGN\nXZNIBLBOO\u0004"));
        }
        String string5 = path.relativize(path3).toString().replace(c_lC.m_fE((Object)"g"), MenuDto.m_AK((Object)"\u0005"));
        if (a3.f_FI.existsByRelativePath(string5)) {
            throw new FileStorageException(c_lC.m_fE((Object)"e\u001bBRH^\u0004LMOL\u001bPSMH\u0004UEVA\u001bEWV^E_]\u001bACMHPH\u0004RJ\u001bPSA\u001bPZV\\AO\u0004WKXEOMTJ\u0015"));
        }
        try {
            Files.createDirectories(path2, new FileAttribute[3 ^ 3]);
            CopyOption[] copyOptionArray = new CopyOption[3 >> 1];
            copyOptionArray[3 >> 2] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path3, copyOptionArray);
            f_AI.info(MenuDto.m_AK((Object)"mCGO\u000b\rPW\f\nX_HINYXL^FGS\u000b]YC_^ND\u000b^D\nMCGOXSX^NG\u000bK_\n\fQV\r"), (Object)string3, (Object)path3);
            c_qd c_qd3 = a;
            a.setFileName(string3);
            c_qd3.setRelativePath(string5);
            c_qd3.setFileSize(Long.valueOf(a22.getSize()));
            c_qd2 = a;
            string = StringUtils.hasText((String)a22.getContentType()) ? a22.getContentType() : c_lC.m_fE((Object)"EKTWMXEOMTJ\u0014KXP^P\u0016WOV^EV");
        }
        catch (IOException a22) {
            f_AI.error(MenuDto.m_AK((Object)"hE^FO\nEE_\nX^DXN\nMCGO\u000b\rPW\f\nO_N\n_E\u000bcdoSINZ_CDD"), (Object)string3, (Object)a22);
            throw new FileStorageException(c_lC.m_fE((Object)"gTQW@\u001bJTP\u001bWOKIA\u001bPSA\u001bQKHTE_A_\u0004]MWA\u0015\u0004kH^EHA\u001bPI]\u001bE\\ERJ\u0015"));
        }
        {
            c_qd2.setFileType(string);
            a.setTargetSubdirectory(string2);
            return (FileInfo)a3.f_FI.save((Object)a);
        }
    }

    private static /* synthetic */ NotFoundException m_kO(String a) {
        return new NotFoundException("File info not found with id: " + a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileDownloadResult m_km(String string) {
        Path path;
        block3: {
            c_qd a;
            Object a2 = string;
            c_qd c_qd2 = a = this;
            a2 = c_qd2.m_bo((String)a2);
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = a2.getSpace().getName();
            path = Path.of(c_qd2.f_vH, stringArray).resolve(a2.getRelativePath()).normalize();
            try {
                UrlResource urlResource = new UrlResource(path.toUri());
                if (!urlResource.exists() || !urlResource.isReadable()) break block3;
                return new FileDownloadResult((Resource)urlResource, (FileInfo)a2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NotFoundException(MenuDto.m_AK((Object)"lBFN\nEE_\nME^DO\n\u0003GJFMEYGNN\u000b\u007fyf\u0002\u0004"));
            }
        }
        f_AI.error(MenuDto.m_AK((Object)"mCGO\u000bGN^JNJ^J\nNRBY_Y\u000bLDX\u000b\rPW\f\nI__\nMCGO\u000bCX\nFCXYBDL\nDD\u000bNBY@\u0004"), (Object)path);
        throw new NotFoundException(c_lC.m_fE((Object)"bRH^\u0004UKO\u0004]KNJ_"));
    }
}

