/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_hj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_l;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.s.c_JJ;
import com.inscada.mono.communication.base.s.c_Yk;
import com.inscada.mono.communication.base.services.c_Ej;
import com.inscada.mono.communication.base.services.c_Jh;
import com.inscada.mono.communication.base.services.c_nH;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.s.c_Rc;
import com.inscada.mono.datatransfer.services.c_gb;
import com.inscada.mono.datatransfer.services.c_yc;
import com.inscada.mono.datatransfer.v.c_jc;
import com.inscada.mono.datatransfer.v.c_vc;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.job.s.c_pb;
import com.inscada.mono.log.v.c_ZC;
import com.inscada.mono.project.model.ConnectionClone;
import com.inscada.mono.project.v.c_m;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.SpaceContext;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_m {
    public static final short f_wi = 407;
    private final Lock f_Sg;
    public static final short f_nI = 406;
    public static final short f_VG = 403;
    private final c_l f_Vi;
    private final c_pb f_zg;
    public static final short f_Rh = 404;
    private final c_Ej f_Ci;
    private final c_yc f_dI;
    private final c_nH f_lh;
    public static final short f_FG = 405;
    private final c_hj f_UG;
    private final c_Jh f_Tg;
    public static final short f_dG = 402;
    private final JedisPooled f_Nh;
    private static final String f_nG = "scheduledDataTransfers";
    private static final Logger f_BH = LoggerFactory.getLogger(DataTransferManager.class);
    private final Map<String, Job> f_ih;
    public static final short f_ZG = 401;
    private final c_ZC f_KG;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_Yk c_Yk2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x6F & 0x1D, 5 >> 3);
        ((Calendar)object).set(0x5E & 0x2F, 5 >> 3);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_gb.f_kh[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x5C & 0x2F, 3 & 4);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x3B & 0x4F, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x7F & 0xB, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0xC & 0x7F, 2 & 5);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x3F & 0x4B, 3 & 4);
                ((Calendar)object4).set(0x2F & 0x5C, 5 >> 3);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 5 >> 3);
                ((Calendar)object5).set(0x4D & 0x3E, 3 & 4);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 2 & 5);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(5 >> 1, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(SpaceContext.m_Xf((Object)"h9X/M2^#X3\u001d%\\9Z2\u001d#D'X"));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.debug(SpaceContext.m_Xf((Object)"q\u0012|\u0013x\u0005\u0007w~6S4X;Q>S0\u001d6Q;\u001d3\\#\\wI%\\9N1X%Nw[8OwM%R=X4IwF*\u001d;R4\\;Q.\u0013"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"8E8':O7N3XL*$o\u0007\u007f\u0013y\u0002c\u0018mVf\u0013k\u0012o\u0004*\u0002eVi\u0017d\u0015o\u001a*\u0017f\u001a*\u0012k\u0002kV~\u0004k\u0018y\u0010o\u0004yVl\u0019xVz\u0004e\u001co\u0015~Vq\u000b$"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_Vi.m_Aa(Short.valueOf((short)(0xFFF & 0x7195)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_Yk c_Yk2) {
        DataTransferManager a = c_Yk2;
        DataTransferManager a2 = this;
        switch (c_gb.f_kh[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_Rc getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_dI.m_um((String)a2, (String)a)) == null) {
            return c_Rc.f_oG;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return ConnectionClone.m_ul((Object)"\u0012k\u0002k[~\u0004k\u0018y\u0010o\u00040\u001ak\u0005~[i\u0017f\u0015'\u0002c\u001boL|\u0017x\u001fk\u0014f\u00130SyL/\u00050Sy").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_Ci.m_xba((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_Tg.m_UBa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_dI.m_UN((String)a, (String)a3).getId());
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return SpaceContext.m_Xf((Object)"Y6I6\u0010#O6S$[2OmN#\\#NmK6O>\\5Q2\u0007rNm\u0018$\u0007rN").formatted(objectArray);
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_UG.m_kEa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_dI.m_gO((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(ConnectionClone.m_ul((Object)"|\u0017f\u0003o"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_ih.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_BH.info(SpaceContext.m_Xf((Object)"\u0013\\#\\\u0003O6S$[2O\u001a\\9\\0X%\u001d\u007fs8Iwq2\\3X%\u001d,@~\u0007w~6S4X;Q>S0\u001d;R4\\;\u001d=R5\u001d1R%\u001d3\\#\\wI%\\9N1X%\u001d\u001eym\u001d,@"), (Object)a3, (Object)a);
                dataTransferManager.f_zg.m_LM((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[5 >> 2] = a;
                objectArray[1 ^ 3] = a22.getMessage();
                objectArray[--3] = a22;
                f_BH.error(ConnectionClone.m_ul((Object)"N\u0017~\u0017^\u0004k\u0018y\u0010o\u0004G\u0017d\u0017m\u0013xV\"8e\u0002*:o\u0017n\u0013xVq\u000b#L*3x\u0004e\u0004*\u0015k\u0018i\u0013f\u001ac\u0018mVf\u0019i\u0017fV`\u0019hVl\u0019xVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xVC2*\rwL*\rw"), objectArray);
            }
        }
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Sg.lock();
        try {
            Job job = (Job)a2.f_ih.get(a.getId());
            if (job != null) {
                a2.f_zg.m_LM(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_ih.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = a.getId();
            dataTransferManager.f_Nh.srem(f_nG, stringArray);
            return;
        }
        finally {
            a2.f_Sg.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_Rc> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.debug(SpaceContext.m_Xf((Object)"\u001bx\u0016y\u0012om\u001d\u0010X#I>S0\u001d6Q;\u001d3\\#\\wI%\\9N1X%\u001d$I6I\"N2Nw[8OwM%R=X4IwF*\u001d;R4\\;Q.\u0013"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"8E8':O7N3XL*$o\u0007\u007f\u0013y\u0002c\u0018mVf\u0013k\u0012o\u0004*\u0010e\u0004*\u0017f\u001a*\u0012k\u0002kV~\u0004k\u0018y\u0010o\u0004*\u0005~\u0017~\u0003y\u0013yVl\u0019xVz\u0004e\u001co\u0015~Vq\u000b$"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_Vi.m_Aa(Short.valueOf((short)(0x37D7 & 0x49BF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_dI.m_UN((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_Ci.m_xba((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_Tg.m_UBa(object);
        a3 = dataTransferManager2.f_Tg.m_UBa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_Nh.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return (2 & 5) != 0;
        }
        return true;
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_dI.m_oO((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_JJ[] c_JJArray = (c_JJ[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_JJ[]::new);
        a4 = a7.f_lh.m_Uaa(stringArray, (Date)a5, (Date)((Object)a4), c_JJArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_Nh.setex(a5, (long)n, String.valueOf(d));
            a4.f_Nh.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(ConnectionClone.m_ul((Object)"|\u0017f\u0003o"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_UG.m_kEa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Sg.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a.getName();
            PeriodicJob periodicJob = a2.f_zg.m_dN(a.getProject(), ConnectionClone.m_ul((Object)"SyVN\u0017~\u0017*\"x\u0017d\u0005l\u0013x").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_ih.put(a.getId(), periodicJob);
            String[] stringArray = new String[5 >> 2];
            stringArray[5 >> 3] = a.getId();
            dataTransferManager.f_Nh.sadd(f_nG, stringArray);
            return;
        }
        finally {
            a2.f_Sg.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_dI.m_An((String)a2));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.debug(SpaceContext.m_Xf((Object)"\u001bx\u0016y\u0012om\u001d\u0004^?X3H;T9ZwY6I6\u001d#O6S$[2OwF*\u001d;R4\\;Q.\u0013"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"D9D[F3K2O$0VX\u0013{\u0003o\u0005~\u001fd\u0011*\u001ao\u0017n\u0013xV~\u0019*\u0005i\u001eo\u0012\u007f\u001aoVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xVq\u000b$"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_Vi.m_Aa(Short.valueOf((short)(0x4FB5 & 0x31DB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_Rc> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_dI.m_nn((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Vi.m_ca();
        f_BH.info(ConnectionClone.m_ul((Object)"2k\u0002k\"x\u0017d\u0005l\u0013x;k\u0018k\u0011o\u00040V^\u001ec\u0005*\u0018e\u0012oV\"\rw_*\u001ek\u0005*\u0014o\u0015e\u001boV~\u001eoVF3K2O$$VX\u0013y\u0002e\u0004c\u0018mVy\u0015b\u0013n\u0003f\u0013nVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013x\u0005$X$"), a);
        dataTransferManager2.f_Sg.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_Nh.smembers(f_nG));
            if (hashSet.isEmpty()) {
                f_BH.info(SpaceContext.m_Xf((Object)"y6I6i%\\9N1X%p6S6Z2Ow\u0015\u001bX6Y2OwF*\u0014m\u001d\u0019RwN4U2Y\"Q2YwY6I6\u001d#O6S$[2O$\u001d1R\"S3\u001d>Swo2Y>NwI8\u001d%X$I8O2\u0013"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_BH.info(ConnectionClone.m_ul((Object)"N\u0017~\u0017^\u0004k\u0018y\u0010o\u0004G\u0017d\u0017m\u0013xV\":o\u0017n\u0013xVq\u000b#L*0e\u0003d\u0012*\rwVy\u0015b\u0013n\u0003f\u0013nVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xVC2yVc\u0018*$o\u0012c\u0005*\u0002eVx\u0013y\u0002e\u0004oL*\rw"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[4 ^ 5];
            stringArray[2 & 5] = SpaceContext.m_Xf((Object)"\u0001t\u0012j\by\u0016i\u0016b\u0003o\u0016s\u0004{\u0012o");
            dataTransferManager.f_UG.m_Qda(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_dI.m_Fo((Set)a2));
            }, stringArray);
            f_BH.info(ConnectionClone.m_ul((Object)"N\u0017~\u0017^\u0004k\u0018y\u0010o\u0004G\u0017d\u0017m\u0013xV\":o\u0017n\u0013xVq\u000b#L*7~\u0002o\u001bz\u0002c\u0018mV~\u0019*\u0004o\u0005~\u0019x\u0013*\rwVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013x\u0005$"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_Vi.m_ca();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 >> 2] = SpaceContext.m_Xf((Object)"\u0004~\u001fx\u0013h\u001bx\by\u0016i\u0016b\u0003o\u0016s\u0004{\u0012o");
                stringArray[--1] = ConnectionClone.m_ul((Object)"5K8I3F)N7^7U\"X7D%L3X");
                dataTransferManager2.f_UG.m_Nea(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_BH.info(SpaceContext.m_Xf((Object)"\u0013\\#\\\u0003O6S$[2O\u001a\\9\\0X%\u001d\u007fq2\\3X%\u001d,@~\u0007w{>S>N?X3\u001d3\\#\\wI%\\9N1X%\u001d%X$I8O6I>R9\u001d'O8^2N$\u0013"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[--2] = exception;
            f_BH.error(ConnectionClone.m_ul((Object)"N\u0017~\u0017^\u0004k\u0018y\u0010o\u0004G\u0017d\u0017m\u0013xV\":o\u0017n\u0013xVq\u000b#L*3x\u0004e\u0004*\u0012\u007f\u0004c\u0018mVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xVx\u0013y\u0002e\u0004k\u0002c\u0019dVz\u0004e\u0015o\u0005yL*\rw"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_Sg.unlock();
        }
    }

    protected c_Rc getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ih.containsKey(a)) {
            return c_Rc.f_xH;
        }
        return c_Rc.f_oG;
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.info(SpaceContext.m_Xf((Object)"\u001bx\u0016y\u0012om\u001d\u001f\\9Y;T9Zwm%R=X4I\u0013X6^#T!\\#X\u0012K2S#\u001d1R%\u001d'O8W2^#\u001d\u001eym\u001d,@"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"8E8':O7N3XL*?m\u0018e\u0004c\u0018mVZ\u0004e\u001co\u0015~2o\u0017i\u0002c\u0000k\u0002o3|\u0013d\u0002*\u0010e\u0004*\u0006x\u0019`\u0013i\u0002*?NL*\rw"), a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.debug(SpaceContext.m_Xf((Object)"q\u0012|\u0013x\u0005\u0007wn4U2Y\"Q>S0\u001d6Q;\u001d3\\#\\wI%\\9N1X%Nw[8OwM%R=X4IwF*\u001d;R4\\;Q.\u0013"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"8E8':O7N3XL*$o\u0007\u007f\u0013y\u0002c\u0018mVf\u0013k\u0012o\u0004*\u0002eVy\u0015b\u0013n\u0003f\u0013*\u0017f\u001a*\u0012k\u0002kV~\u0004k\u0018y\u0010o\u0004yVl\u0019xVz\u0004e\u001co\u0015~Vq\u000b$"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_Vi.m_Aa(Short.valueOf((short)(0x3D96 & 0x43FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_BH.info(SpaceContext.m_Xf((Object)"y6I6i%\\9N1X%p6S6Z2Ow\u0015\u001bX6Y2OwF*\u0014m\u001d\u0005X$I8O>S0\u001d3\\#\\wI%\\9N1X%\u0007wF*\u001d\u007ft\u0013\u0007wF*\u0014"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_KG.m_dJ(a2.getProject()).m_R("Data Transfer Restore (Leader " + (String)a + ")", ConnectionClone.m_ul((Object)"SyV\"?NL*Sy_*\u0010k\u001ff\u0013nV~\u0019*\u0004o\u0005~\u0019x\u0013$VI\u0017\u007f\u0005oL*Sy").formatted(objectArray));
            try {
                f_BH.warn(SpaceContext.m_Xf((Object)"y6I6i%\\9N1X%p6S6Z2Ow\u0015\u001bX6Y2OwF*\u0014m\u001d\u0016I#X:M#T9ZwI8\u001d4\\9^2QwY6I6\u001d#O6S$[2OwF*\u001d6[#X%\u001d%X$I8O6I>R9\u001d1\\>Q\"O2\u0013"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[2 ^ 3] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_BH.error(ConnectionClone.m_ul((Object)"2k\u0002k\"x\u0017d\u0005l\u0013x;k\u0018k\u0011o\u0004*^F\u0013k\u0012o\u0004*\rw_0VL\u0017c\u001ao\u0012*\u0002eVi\u0017d\u0015o\u001a*\u0012k\u0002kV~\u0004k\u0018y\u0010o\u0004*\rwVk\u0010~\u0013xVx\u0013y\u0002e\u0004k\u0002c\u0019dVl\u0017c\u001a\u007f\u0004oL*\rw"), objectArray2);
                return;
            }
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[3 >> 1];
            classArray[5 >> 3] = String.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x5397 & 0x2DF9), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionClone.m_ul((Object)"\u0005i\u001eo\u0012\u007f\u001ao2k\u0002k\"x\u0017d\u0005l\u0013x?d\u0002o\u0004d\u0017f"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[3 >> 2] = String.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x4DD6 & 0x33BB), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SpaceContext.m_Xf((Object)"4\\9^2Q\u0013\\#\\\u0003O6S$[2O\u001eS#X%S6Q"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[2 & 5] = String.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x61D3 & 0x1FBF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionClone.m_ul((Object)"m\u0013~2k\u0002k\"x\u0017d\u0005l\u0013x%~\u0017~\u0003y?d\u0002o\u0004d\u0017f"), classArray3));
            Class[] classArray4 = new Class[3 >> 1];
            classArray4[5 >> 3] = String.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x4DD6 & 0x33BD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SpaceContext.m_Xf((Object)"$^?X3H;X\u0013\\#\\\u0003O6S$[2O$\u007f.m%R=X4I\u001eY\u001eS#X%S6Q"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 ^ 3] = String.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x3B5 & 0x7DDF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionClone.m_ul((Object)"\u0015k\u0018i\u0013f2k\u0002k\"x\u0017d\u0005l\u0013x\u0005H\u000fZ\u0004e\u001co\u0015~?n?d\u0002o\u0004d\u0017f"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x57DE & 0x29B7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SpaceContext.m_Xf((Object)"0X#y6I6i%\\9N1X%n#\\#H$X$\u007f.t3N\u001eS#X%S6Q"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_Vi.m_Fa((short)(0x6BBF & 0x15D7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionClone.m_ul((Object)"\u0011o\u0002N\u0017~\u0017^\u0004k\u0018y\u0010o\u0004Y\u0002k\u0002\u007f\u0005o\u0005H\u000fZ\u0004e\u001co\u0015~?n?d\u0002o\u0004d\u0017f"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(SpaceContext.m_Xf((Object)"\u0011\\>Q2YwI8\u001d%X0T$I2Owy6I6i%\\9N1X%p6S6Z2Owo\u0007~wP2I?R3N"), a);
        }
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Vi.m_ca();
        f_BH.info(SpaceContext.m_Xf((Object)"y6I6i%\\9N1X%p6S6Z2Om\u001d\u0003U>NwS8Y2\u001d\u007fF*\u0014wT$\u001d\u0019rwq\u0018s\u0010x\u0005\u001d\u0003u\u0012\u001d\u001bx\u0016y\u0012oy\u001d\u0014\\9^2Q;T9Zw\\;QwQ8^6QwY6I6\u001d#O6S$[2OwW8_$\u0013y\u0013"), a);
        dataTransferManager2.f_Sg.lock();
        try {
            new ArrayList(dataTransferManager.f_ih.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_ih.clear();
            f_BH.info(ConnectionClone.m_ul((Object)"2k\u0002k\"x\u0017d\u0005l\u0013x;k\u0018k\u0011o\u0004*^D\u0019~VF\u0013k\u0012o\u0004*\rw_0VK\u001afVf\u0019i\u0017fVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xV`\u0019h\u0005*\u001ek\u0000oVh\u0013o\u0018*\u0004o\u0007\u007f\u0013y\u0002o\u0012*\u0002eVi\u0017d\u0015o\u001a*\u0017d\u0012*\u0015f\u0013k\u0004o\u0012*\u0010x\u0019gVf\u0019i\u0017fV~\u0004k\u0015a\u001fd\u0011$"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[--2] = exception;
            f_BH.error(SpaceContext.m_Xf((Object)"\u0013\\#\\\u0003O6S$[2O\u001a\\9\\0X%\u001d\u007fs8Iwq2\\3X%\u001d,@~\u0007wx%O8OwY\"O>S0\u001d'O8^2N$\u001d8[w^6S4X;Q>S0\u001d;R4\\;\u001d3\\#\\wI%\\9N1X%\u001d=R5Nm\u001d,@"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_Sg.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_Rc> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Vi.m_La()) {
            f_BH.debug(ConnectionClone.m_ul((Object)"F3K2O$0VM\u0013~\u0002c\u0018mVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xVy\u0002k\u0002\u007f\u0005o\u0005*\u0010e\u0004*\rwVC2yVf\u0019i\u0017f\u001asL*\rw"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_BH.debug(SpaceContext.m_Xf((Object)"s\u0018szq\u0012|\u0013x\u0005\u0007wo2L\"X$I>S0\u001d;X6Y2Ow[8OwY6I6\u001d#O6S$[2OwN#\\#H$X$\u001d1R%\u001d,@wt\u0013Nm\u001d,@"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = new ArrayList(a);
            return (Map)a2.f_Vi.m_Aa(Short.valueOf((short)(0x259E & 0x5BF7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ConnectionClone.m_ul((Object)"&"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(SpaceContext.m_Xf((Object)"K6Q\"X"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_dI.m_gm((String)a2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return --1 != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_Nh.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return 3 >> 1;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_gb.f_kh[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x5B & 0x2F) != calendar.get(0x5B & 0x2F)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(7 & 0x7E) != calendar.get(0x46 & 0x3F)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(1 ^ 3) != calendar.get(5 >> 1)) {
                    n2 = 2 ^ 3;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(5 >> 2) != calendar.get(5 >> 2) ? 3 >> 1 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[--2];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_Nh.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(SpaceContext.m_Xf((Object)"~\"O%X9I"))) {
            return false;
        }
        int a222 = switch (c_gb.f_kh[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3E & 0x7D) * (0x33FE & 0x4FE9));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return (2 ^ 3) != 0;
        }
        return false;
    }

    @TransactionalEventListener(value={c_vc.class})
    public void handleRescheduleEvent(c_vc c_vc2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Vi.m_La()) {
            DataTransferManager a = a.m_Kr();
            f_BH.info(SpaceContext.m_Xf((Object)"q\u0012|\u0013x\u0005\u0007wu6S3Q>S0\u001d\u0005X$^?X3H;X\u0012K2S#\u001d1R%\u001d3\\#\\wI%\\9N1X%\u0007wF*\u001d\u007ft\u0013\u0007wF*\u0014"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_Rc.f_xH) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_BH.debug(ConnectionClone.m_ul((Object)"8E8':O7N3XL*?m\u0018e\u0004c\u0018mVX\u0013y\u0015b\u0013n\u0003f\u0013O\u0000o\u0018~Vl\u0019xVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xL*\rw"), (Object)a.m_Kr().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_jc.class})
    public void handleCancelEvent(c_jc c_jc2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Vi.m_La()) {
            DataTransferManager a2 = a.m_Iq();
            f_BH.info(SpaceContext.m_Xf((Object)"q\u0012|\u0013x\u0005\u0007wu6S3Q>S0\u001d\u0014\\9^2Q\u0012K2S#\u001d1R%\u001d3\\#\\wI%\\9N1X%\u0007wF*\u001d\u007ft\u0013\u0007wF*\u0014"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"8E8':O7N3XL*?m\u0018e\u0004c\u0018mVI\u0017d\u0015o\u001aO\u0000o\u0018~Vl\u0019xVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xL*\rw"), (Object)a.m_Iq().getId());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_JJ c_JJ2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_gb.f_sG[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_Tg.m_vBa(a.getProjectId(), (Map)a2);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_Vi.m_Q((ClusterNodeListener)a);
        f_BH.info(SpaceContext.m_Xf((Object)"\u0013\\#\\\u0003O6S$[2O\u001a\\9\\0X%\u001d>S>I>\\;T-X3\u001d6S3\u001d%X0T$I2O2Yw\\$\u001d\u0014Q\"N#X%s8Y2q>N#X9X%\u0013"));
    }

    protected Map<String, c_Rc> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_yc c_yc2, c_Ej c_Ej2, c_Jh c_Jh2, c_nH c_nH2, c_pb c_pb2, JedisPooled jedisPooled, c_ZC c_ZC2, c_l c_l2, c_hj c_hj2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_hj2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_Sg = new ReentrantLock();
        dataTransferManager7.f_ih = new ConcurrentHashMap();
        dataTransferManager7.f_dI = a9;
        dataTransferManager6.f_Ci = a8;
        dataTransferManager6.f_Tg = a7;
        dataTransferManager5.f_lh = a6;
        dataTransferManager5.f_zg = a5;
        dataTransferManager4.f_KG = a4;
        dataTransferManager4.f_Nh = a3;
        dataTransferManager3.f_Vi = a2;
        dataTransferManager3.f_UG = a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_Rc getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.debug(ConnectionClone.m_ul((Object)":O7N3XL*1o\u0002~\u001fd\u0011*\u0012k\u0002kV~\u0004k\u0018y\u0010o\u0004*\u0005~\u0017~\u0003yVl\u0019xVC20Vq\u000b*\u001ae\u0015k\u001af\u000f$"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_BH.debug(SpaceContext.m_Xf((Object)"\u0019r\u0019\u0010\u001bx\u0016y\u0012om\u001d\u0005X&H2N#T9ZwQ2\\3X%\u001d1R%\u001d3\\#\\wI%\\9N1X%\u001d$I6I\"Nw[8Owt\u0013\u0007wF*\u0013"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            return (c_Rc)a2.f_Vi.m_Aa(Short.valueOf((short)(0x79B7 & 0x7DB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Vi.m_La()) {
            f_BH.debug(SpaceContext.m_Xf((Object)"\u001bx\u0016y\u0012om\u001d\u0014\\9^2Q;T9ZwY6I6\u001d#O6S$[2OwF*\u001d;R4\\;Q.\u0013"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_BH.debug(ConnectionClone.m_ul((Object)"D9D[F3K2O$0VX\u0013{\u0003o\u0005~\u001fd\u0011*\u001ao\u0017n\u0013xV~\u0019*\u0015k\u0018i\u0013fVn\u0017~\u0017*\u0002x\u0017d\u0005l\u0013xVq\u000b$"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            a2.f_Vi.m_Aa(Short.valueOf((short)(0x39E & 0x7DF3)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }
}

