/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.communication.base.s.c_JJ;
import com.inscada.mono.communication.base.s.c_Yk;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="data_transfer_detail")
@AttributeOverride(name="id", column=@Column(name="data_transfer_detail_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"dataTransferId", "dataTransfer"}), @CheckAtLeastOneNotNull(fieldNames={"sourceVariableId", "sourceVariable"}), @CheckAtLeastOneNotNull(fieldNames={"targetVariableId", "targetVariable"})})
public class DataTransferDetail
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="data_transfer_id")
    private DataTransfer dataTransfer;
    @Column(name="calc_type")
    private c_JJ calcType;
    @Column(name="threshold")
    private Double threshold;
    @Column(name="source_var_id")
    @NotBlank
    private String sourceVariableId;
    @Column(name="range_type")
    private c_Yk rangeType;
    @Column(name="data_transfer_id", insertable=false, updatable=false)
    private String dataTransferId;
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="target_var_id", insertable=false, updatable=false)
    private VariableView targetVariable;
    @Column(name="target_var_id")
    @NotBlank
    private String targetVariableId;
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="source_var_id", insertable=false, updatable=false)
    private VariableView sourceVariable;

    public DataTransfer getDataTransfer() {
        DataTransferDetail a;
        return a.dataTransfer;
    }

    public void setTargetVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.targetVariableId = a.getId();
            variable2.targetVariable = VariableView.from(a);
            return;
        }
        a2.targetVariableId = null;
        a2.targetVariable = null;
    }

    public VariableView getTargetVariable() {
        DataTransferDetail a;
        return a.targetVariable;
    }

    @JsonSetter
    public void setSourceVariable(VariableView variableView) {
        DataTransferDetail a = variableView;
        DataTransferDetail a2 = this;
        a2.sourceVariable = a;
        if (a2.sourceVariable != null) {
            a2.sourceVariableId = a.getId();
            return;
        }
        a2.sourceVariableId = null;
    }

    public c_JJ getCalcType() {
        DataTransferDetail a;
        return a.calcType;
    }

    public DataTransferDetail() {
        DataTransferDetail a;
    }

    public void setSourceVariableId(String string) {
        Object a = string;
        DataTransferDetail a2 = this;
        a2.sourceVariableId = a;
    }

    public VariableView getSourceVariable() {
        DataTransferDetail a;
        return a.sourceVariable;
    }

    public Double getThreshold() {
        DataTransferDetail a;
        return a.threshold;
    }

    public void setRangeType(c_Yk c_Yk2) {
        DataTransferDetail a = c_Yk2;
        DataTransferDetail a2 = this;
        a2.rangeType = a;
    }

    public String getDataTransferId() {
        DataTransferDetail a;
        return a.dataTransferId;
    }

    public c_Yk getRangeType() {
        DataTransferDetail a;
        return a.rangeType;
    }

    public void setDataTransfer(DataTransfer dataTransfer) {
        DataTransferDetail a;
        DataTransferDetail a2 = dataTransfer;
        DataTransferDetail dataTransferDetail = a = this;
        dataTransferDetail.dataTransfer = a2;
        dataTransferDetail.dataTransferId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setCalcType(c_JJ c_JJ2) {
        DataTransferDetail a = c_JJ2;
        DataTransferDetail a2 = this;
        a2.calcType = a;
    }

    @JsonSetter
    public void setTargetVariable(VariableView variableView) {
        DataTransferDetail a = variableView;
        DataTransferDetail a2 = this;
        a2.targetVariable = a;
        if (a2.targetVariable != null) {
            a2.targetVariableId = a.getId();
            return;
        }
        a2.targetVariableId = null;
    }

    public void setSourceVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.sourceVariableId = a.getId();
            variable2.sourceVariable = VariableView.from(a);
            return;
        }
        a2.sourceVariableId = null;
        a2.sourceVariable = null;
    }

    public void setTargetVariableId(String string) {
        Object a = string;
        DataTransferDetail a2 = this;
        a2.targetVariableId = a;
    }

    public void setDataTransferId(String string) {
        Object a = string;
        DataTransferDetail a2 = this;
        a2.dataTransferId = a;
    }

    public String getTargetVariableId() {
        DataTransferDetail a;
        return a.targetVariableId;
    }

    public String getSourceVariableId() {
        DataTransferDetail a;
        return a.sourceVariableId;
    }

    public void setThreshold(Double d) {
        Object a = d;
        DataTransferDetail a2 = this;
        a2.threshold = a;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void a;
        DataTransferDetail dataTransferDetail = this;
        if (dataTransferDetail == a) {
            return 5 >> 2;
        }
        if (!(a instanceof DataTransferDetail)) {
            return false;
        }
        DataTransferDetail a2 = (DataTransferDetail)a;
        if (!super.equals((Object)a)) {
            return (2 & 5) != 0;
        }
        if (dataTransferDetail.getDataTransferId().equals(a2.getDataTransferId()) && dataTransferDetail.getSourceVariableId().equals(a2.getSourceVariableId()) && dataTransferDetail.getTargetVariableId().equals(a2.getTargetVariableId())) {
            return --1 != 0;
        }
        return false;
    }

    public int hashCode() {
        DataTransferDetail a;
        Object[] objectArray = new Object[--4];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[3 >> 1] = a.getDataTransferId();
        objectArray[5 >> 1] = a.getSourceVariableId();
        objectArray[--3] = a.getTargetVariableId();
        return Objects.hash(objectArray);
    }
}

