/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.s.c_Tl;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaConnection;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaFrame;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_device")
public class OpcUaDevice
extends Device<OpcUaConnection, OpcUaFrame> {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="conn_id")
    protected OpcUaConnection connection;
    @NotNull
    @Column(name="scan_type")
    private c_Tl scanType;
    @Column(name="base_path")
    private String basePath;
    @JsonIgnore
    @OneToMany(mappedBy="device")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaFrame> frames;
    @NotNull
    @Min(value=1L)
    @Column(name="scan_time")
    private Integer scanTime;

    public void setBasePath(String string) {
        Object a = string;
        OpcUaDevice a2 = this;
        a2.basePath = a;
    }

    public void setFrames(Set<OpcUaFrame> set) {
        Object a = set;
        OpcUaDevice a2 = this;
        a2.frames = a;
    }

    public String getBasePath() {
        OpcUaDevice a;
        return a.basePath;
    }

    public void setScanType(c_Tl c_Tl2) {
        OpcUaDevice a = c_Tl2;
        OpcUaDevice a2 = this;
        a2.scanType = a;
    }

    public void setScanTime(Integer n) {
        Object a = n;
        OpcUaDevice a2 = this;
        a2.scanTime = a;
    }

    public void setConnection(OpcUaConnection opcUaConnection) {
        OpcUaDevice a;
        OpcUaDevice a2 = opcUaConnection;
        OpcUaDevice opcUaDevice = a = this;
        opcUaDevice.connection = a2;
        opcUaDevice.connectionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public OpcUaConnection getConnection() {
        OpcUaDevice a;
        return a.connection;
    }

    public Set<OpcUaFrame> getFrames() {
        OpcUaDevice a;
        return a.frames;
    }

    public OpcUaDevice() {
        OpcUaDevice a;
        OpcUaDevice opcUaDevice = a;
        opcUaDevice.frames = new HashSet();
    }

    public c_Tl getScanType() {
        OpcUaDevice a;
        return a.scanType;
    }

    public Integer getScanTime() {
        OpcUaDevice a;
        return a.scanTime;
    }
}

