/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_hj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_l;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.s.c_wj;
import com.inscada.mono.communication.base.services.c_D;
import com.inscada.mono.communication.base.services.c_cJ;
import com.inscada.mono.communication.base.services.c_lH;
import com.inscada.mono.communication.base.services.c_vD;
import com.inscada.mono.communication.base.v.c_bl;
import com.inscada.mono.communication.base.v.c_eK;
import com.inscada.mono.license.v.c_bB;
import com.inscada.mono.log.v.c_ZC;
import com.inscada.mono.project.v.c_m;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.system.v.c_oa;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_m {
    private static final Logger f_CS = LoggerFactory.getLogger(ConnectionManager.class);
    private final c_ZC f_Tu;
    private final c_cJ f_tS;
    public static final short f_Lt = 206;
    private final c_l f_mT;
    private final c_lH<C, V> f_Xt;
    private final c_bB f_ks;
    public static final short f_uu = 209;
    public static final short f_os = 201;
    public static final short f_TR = 203;
    public static final short f_gT = 202;
    private static final String f_GS = "activeConnections";
    public static final short f_AT = 205;
    public static final short f_WT = 210;
    public static final short f_rT = 204;
    public static final short f_DT = 208;
    private final Lock f_oR;
    public static final short f_bU = 207;
    private final JedisPooled f_Qu;
    private final c_hj f_Ds;

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"!W,V(@W2>f\f`\u0019{\u0003uMs\u0001~Mq\u0002|\u0003w\u000ef\u0004}\u0003aMt\u0002`Mb\u001f}\u0007w\u000efMi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"#]#?!W,V(@W2?w\u001cg\ba\u0019{\u0003uM~\bs\tw\u001f2\u0019}Ma\u0019s\u001ffMs\u0001~Mq\u0002|\u0003w\u000ef\u0004}\u0003aMt\u0002`Mb\u001f}\u0007w\u000efMi\u0010<"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_mT.m_Aa(Short.valueOf((short)(0x6AEE & 0x15DF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_tS.m_mda((String)a);
        return connectionManager2.f_Ds.m_Pfa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"^(S)W?(MA\u0019}\u001db\u0004|\n2\u000e}\u0003|\bq\u0019{\u0002|Mi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"#]#?!W,V(@W2?w\u001cg\ba\u0019{\u0003uM~\bs\tw\u001f2\u0019}Ma\u0019}\u001d2\u000e}\u0003|\bq\u0019{\u0002|Mi\u0010<"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_mT.m_Aa(Short.valueOf((short)(0x7DFB & 0x2CE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_vD c_vD2 = a2.f_Xt.m_cBa(a.getConnectionId());
        if (c_vD2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_vD2.m_ws(a);
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_tS.m_wAa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"!W,V(@W2=w\u001ft\u0002`\u0000{\u0003uMp\u001f}\u001aa\b2\u0002b\b`\ff\u0004}\u00032\u000b}\u001f2\u000e}\u0003|\bq\u0019{\u0002|Mi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_CS.debug(c_oa.m_BE((Object)"#]#?!W,V(@W2?w\u001cg\ba\u0019{\u0003uM~\bs\tw\u001f2\u0019}Mb\b`\u000b}\u001f\u007fMp\u001f}\u001aa\b2\u0002b\b`\ff\u0004}\u00032\u000b}\u001f2\u000e}\u0003|\bq\u0019{\u0002|Mi\u0010<"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            return a2.f_mT.m_Aa(Short.valueOf((short)(0x48FE & 0x37D3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_oa.m_BE((Object)">w\u0019D\f~\u0018w?w\u001cg\ba\u00192\u000es\u0003|\u0002fMp\b2\u0003g\u0001~")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002|$vM{\u00032>w\u0019D\f~\u0018w?w\u001cg\ba\u00192\u000es\u0003|\u0002fMp\b2\u0003g\u0001~")));
        if (a3.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"^(S)W?(MA\bf\u0019{\u0003uMi\u00102\u001bs\u001f{\fp\u0001wMd\f~\u0018w\u001e2\u0001}\u000es\u0001~\u0014<"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"#]#?!W,V(@W2?w\u001cg\ba\u0019{\u0003uM~\bs\tw\u001f2\u0019}Ma\bfMi\u00102\u001bs\u001f{\fp\u0001wMd\f~\u0018w\u001e<"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = new ArrayList(a22);
            a3.f_mT.m_Aa(Short.valueOf((short)(0x64CF & 0x1BFD)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(c_oa.m_BE((Object)"T\f{\u0001w\t2\u0019}M@=QMa\bfMd\f`\u0004s\u000f~\b2\u001bs\u0001g\ba"), (Throwable)a22);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_Xt.m_cBa((String)a)) != null) {
                void a3;
                a.m_pW((List)a3);
            }
        });
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.info(c_oa.m_BE((Object)"!W,V(@W2%s\u0003v\u0001{\u0003uMB\u001f}\u0007w\u000ef)w\fq\u0019{\u001bs\u0019w(d\b|\u00192\u000b}\u001f2\u001d`\u0002x\bq\u00192$VW2\u0016o"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"#]#?!W,V(@W2$u\u0003}\u001f{\u0003uMB\u001f}\u0007w\u000ef)w\fq\u0019{\u001bs\u0019w(d\b|\u00192\u000b}\u001f2\u001d`\u0002x\bq\u00192$VW2\u0016o"), a);
    }

    protected Map<String, c_wj> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_wj> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"^(S)W?(MU\bf\u0019{\u0003uMq\u0002|\u0003w\u000ef\u0004}\u00032\u001ef\ff\u0018a\baMt\u0002`Mi\u00102$V\u001e2\u0001}\u000es\u0001~\u0014<"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M@\bc\u0018w\u001ef\u0004|\n2\u0001w\fv\b`Mt\u0002`Mq\u0002|\u0003w\u000ef\u0004}\u00032\u001ef\ff\u0018a\baMt\u0002`Mi\u00102$V\u001e<"), (Object)a.length);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a;
            return (Map)a2.f_mT.m_Aa(Short.valueOf((short)(0x36F1 & 0x49DF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_mT.m_ca();
        String[] stringArray = new String[--3];
        stringArray[3 ^ 3] = c_oa.m_BE((Object)">F,@9M.]#\\(Q9[\"\\");
        stringArray[3 >> 1] = c_oa.m_BE((Object)"A9]=M.]#\\(Q9[\"\\");
        stringArray[--2] = c_oa.m_BE((Object)";[(E2Q\"\\#W.F$]#M$F(_");
        connectionManager2.f_Ds.m_Nea(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_cJ c_cJ2, c_bB c_bB2, c_ZC c_ZC2, c_lH<C, V> c_lH2, JedisPooled jedisPooled, c_l c_l2, c_hj c_hj2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_hj2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_oR = new ReentrantLock();
        a8.f_tS = a7;
        connectionManager5.f_ks = a6;
        connectionManager5.f_Tu = a5;
        connectionManager4.f_Xt = a4;
        connectionManager4.f_Qu = a3;
        connectionManager3.f_mT = a2;
        connectionManager3.f_Ds = a;
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_tS.m_mda((String)a2));
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Ds.m_kEa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_oR.lock();
            try {
                c_vD c_vD2 = a2.f_Xt.m_cBa(a.getId());
                if (c_vD2 != null) {
                    c_vD2.m_ES();
                    a2.f_Xt.m_bCa(a.getId(), c_vD2);
                }
                String[] stringArray = new String[5 >> 2];
                stringArray[3 ^ 3] = a.getId();
                a2.f_Qu.srem(f_GS, stringArray);
                return;
            }
            finally {
                a2.f_oR.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_bl.class})
    public void handleRestartEvent(c_bl c_bl2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_mT.m_La()) {
            ConnectionManager a2 = a.m_Xba();
            f_CS.info(c_oa.m_BE((Object)"^(S)W?(MZ\f|\t~\u0004|\n2?w\u001ef\f`\u0019W\u001bw\u0003fMt\u0002`Mq\u0002|\u0003w\u000ef\u0004}\u0003(Mi\u00102E[)(Mi\u0010;"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_oR.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_wj.f_nu) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_oR.unlock();
            }
        }
        f_CS.debug(c_oa.m_BE((Object)"#]#?!W,V(@W2$u\u0003}\u001f{\u0003uM@\ba\u0019s\u001ff(d\b|\u00192\u000b}\u001f2\u000e}\u0003|\bq\u0019{\u0002|W2\u0016o"), (Object)a.m_Xba().getId());
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_tS.m_Lca((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[3 >> 1];
            classArray[2 & 5] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x5CFB & 0x23CD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"a\u0019s\u001ff.}\u0003|\bq\u0019{\u0002|$|\u0019w\u001f|\f~"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[5 >> 3] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x2BCE & 0x54FB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"\u001ef\u0002b.}\u0003|\bq\u0019{\u0002|$|\u0019w\u001f|\f~"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[2 & 5] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x71EF & 0xEDB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"u\bf.}\u0003|\bq\u0019{\u0002|>f\ff\u0018a$|\u0019w\u001f|\f~"), classArray3));
            Class[] classArray4 = new Class[4 ^ 5];
            classArray4[3 & 4] = SetValueRequest.class;
            connectionManager.f_mT.m_Fa((short)(0x46EC & 0x39DF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"\u001ew\u0019D\f`\u0004s\u000f~\bD\f~\u0018w$|\u0019w\u001f|\f~"), classArray4));
            Class[] classArray5 = new Class[5 >> 2];
            classArray5[3 >> 2] = Collection.class;
            connectionManager.f_mT.m_Fa((short)(0x36DF & 0x49ED), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"a\bf;s\u001f{\fp\u0001w;s\u0001g\ba$|\u0019w\u001f|\f~"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x1BEF & 0x64DE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"a\u0019s\u001ff.}\u0003|\bq\u0019{\u0002|\u001eP\u0014B\u001f}\u0007w\u000ef$v$|\u0019w\u001f|\f~"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x37FF & 0x48CF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"\u001ef\u0002b.}\u0003|\bq\u0019{\u0002|\u001eP\u0014B\u001f}\u0007w\u000ef$v$|\u0019w\u001f|\f~"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x61DE & 0x1EF1), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"\nw\u0019Q\u0002|\u0003w\u000ef\u0004}\u0003A\u0019s\u0019g\u001ew\u001eP\u0014B\u001f}\u0007w\u000ef$v$|\u0019w\u001f|\f~"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_mT.m_Fa((short)(0x79F3 & 0x6DD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"\nw\u0019Q\u0002|\u0003w\u000ef\u0004}\u0003A\u0019s\u0019g\u001ew\u001eP\u0014[\ta$|\u0019w\u001f|\f~"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_mT.m_Fa((short)(0x73F2 & 0xCDF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_oa.m_BE((Object)"\u000f`\u0002e\u001ew.}\u0003|\bq\u0019{\u0002|$|\u0019w\u001f|\f~"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_oa.m_BE((Object)"+s\u0004~\bvMf\u00022\u001fw\n{\u001ef\b`MQ\u0002|\u0003w\u000ef\u0004}\u0003_\f|\fu\b`M@=QM\u007f\bf\u0005}\ta"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_CS.info(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2E^\bs\tw\u001f2\u0016oD(M@\ba\u0019}\u001f{\u0003uMq\u0002|\u0003w\u000ef\u0004}\u0003(Mi\u00102E[)(Mi\u0010;"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[3 & 5] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Tu.m_dJ(a2.getProject()).m_R("Connection Restore (Leader " + (String)a + ")", c_oa.m_BE((Object)"HaM:$VW2HaD2\u000bs\u0004~\bvMf\u00022\u001fw\u001ef\u0002`\b<MQ\fg\u001ewW2Ha").formatted(objectArray));
            try {
                f_CS.warn(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2E^\bs\tw\u001f2\u0016oD(MS\u0019f\b\u007f\u001df\u0004|\n2\u0019}Ma\u0019}\u001d2\u000e}\u0003|\bq\u0019{\u0002|Mi\u00102\ft\u0019w\u001f2\u001fw\u001ef\u0002`\ff\u0004}\u00032\u000bs\u0004~\u0018`\b<"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[3 & 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_CS.error(c_oa.m_BE((Object)"Q\u0002|\u0003w\u000ef\u0004}\u0003_\f|\fu\b`M:!w\fv\b`Mi\u0010;W2+s\u0004~\bvMf\u00022\u001ef\u0002bMq\u0002|\u0003w\u000ef\u0004}\u00032\u0016oMs\u000bf\b`M`\ba\u0019}\u001fs\u0019{\u0002|Mt\f{\u0001g\u001fwW2\u0016o"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_wj getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_tS.m_aBa((String)a2, (String)a)) == null) {
            return c_wj.f_JT;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_tS.m_RBa((String)a, (String)a3).getId());
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_mT.m_ca();
        f_CS.info(c_oa.m_BE((Object)"Q\u0002|\u0003w\u000ef\u0004}\u0003_\f|\fu\b`W29z\u0004aM|\u0002v\b2Ei\u0010;M{\u001e2#]M^\"\\*W?29Z(2!W,V(@C2>f\u0002b\u001d{\u0003uMs\u0001~M~\u0002q\f~Mq\u0002|\u0003w\u000ef\u0002`\u001e<C<"), a);
        connectionManager2.f_oR.lock();
        try {
            connectionManager.f_Xt.m_vca();
            f_CS.info(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2E\\\u0002fM^\bs\tw\u001f2\u0016oD(MS\u0001~M~\u0002q\f~Mq\u0002|\u0003w\u000ef\u0002`\u001e2\u0005s\u001bwMp\bw\u00032\u001fw\u001cg\ba\u0019w\t2\u0019}Ma\u0019}\u001d2\f|\t2\u000e~\bs\u001fw\t2\u000b`\u0002\u007fM~\u0002q\f~Mf\u001fs\u000ey\u0004|\n<"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_CS.error(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2E\\\u0002fM^\bs\tw\u001f2\u0016oD(MW\u001f`\u0002`Mv\u0018`\u0004|\n2\u001d`\u0002q\ba\u001e2\u0002tMa\u0019}\u001db\u0004|\n2\u0001}\u000es\u00012\u000e}\u0003|\bq\u0019}\u001faW2\u0016o"), objectArray);
            return;
        }
        finally {
            connectionManager.f_oR.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_eK.class})
    public void handleDeleteEvent(c_eK c_eK2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_mT.m_La()) {
            ConnectionManager a2 = a.m_WCa();
            f_CS.info(c_oa.m_BE((Object)"!W,V(@W2%s\u0003v\u0001{\u0003uMV\b~\bf\bW\u001bw\u0003fMt\u0002`Mq\u0002|\u0003w\u000ef\u0004}\u0003(Mi\u00102E[)(Mi\u0010;"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M[\n|\u0002`\u0004|\n2)w\u0001w\u0019w(d\b|\u00192\u000b}\u001f2\u000e}\u0003|\bq\u0019{\u0002|W2\u0016o"), (Object)a.m_WCa().getId());
    }

    protected c_wj getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Xt.m_cBa((String)a)) != null && a.m_EU()) {
            return c_wj.f_nu;
        }
        return c_wj.f_JT;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_tS.m_RBa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_wj getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"^(S)W?(MU\bf\u0019{\u0003uMq\u0002|\u0003w\u000ef\u0004}\u00032\u001ef\ff\u0018aMt\u0002`Mi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M@\bc\u0018w\u001ef\u0004|\n2\u0001w\fv\b`Mt\u0002`Mq\u0002|\u0003w\u000ef\u0004}\u00032\u001ef\ff\u0018aMt\u0002`Mi\u0010<"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (c_wj)a2.f_mT.m_Aa(Short.valueOf((short)(0x64CF & 0x1BFB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_tS.m_wAa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_wj> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"^(S)W?(MU\bf\u0019{\u0003uMs\u0001~Mq\u0002|\u0003w\u000ef\u0004}\u00032\u001ef\ff\u0018a\baMt\u0002`Mb\u001f}\u0007w\u000efMi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M@\bc\u0018w\u001ef\u0004|\n2\u0001w\fv\b`Mt\u0002`Ms\u0001~Mq\u0002|\u0003w\u000ef\u0004}\u00032\u001ef\ff\u0018a\baMt\u0002`Mb\u001f}\u0007w\u000efMi\u0010<"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_mT.m_Aa(Short.valueOf((short)(0x19D4 & 0x66FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, c_oa.m_BE((Object)">w\u0019D\f~\u0018w?w\u001cg\ba\u00192\u000es\u0003|\u0002fMp\b2\u0003g\u0001~"));
        Objects.requireNonNull(a.getConnectionId(), c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002|$vM{\u00032>w\u0019D\f~\u0018w?w\u001cg\ba\u00192\u000es\u0003|\u0002fMp\b2\u0003g\u0001~"));
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"!W,V(@W2>w\u0019f\u0004|\n2\u001bs\u001f{\fp\u0001wMd\f~\u0018wMt\u0002`Mq\u0002|\u0003w\u000ef\u0004}\u00032\u0016oM~\u0002q\f~\u0001kW2\u0016o"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M@\bc\u0018w\u001ef\u0004|\n2\u0001w\fv\b`Mf\u00022\u001ew\u00192\u001bs\u001f{\fp\u0001wMd\f~\u0018wMt\u0002`Mq\u0002|\u0003w\u000ef\u0004}\u00032\u0016oW2\u0016o"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_mT.m_Aa(Short.valueOf((short)(0x74CD & 0xBFE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_mT.m_Q((ClusterNodeListener)a);
        f_CS.info(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2\u0004|\u0004f\u0004s\u0001{\u0017w\t2\f|\t2\u001fw\n{\u001ef\b`\bvMs\u001e2.~\u0018a\u0019w\u001f\\\u0002v\b^\u0004a\u0019w\u0003w\u001f<"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_mT.m_ca();
        f_CS.info(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f(MF\u0005{\u001e2\u0003}\twM:\u0016oD2\u0005s\u001e2\u000fw\u000e}\u0000wMf\u0005wM^(S)W?<M@\ba\u0019}\u001f{\u0003uMs\u000ef\u0004d\b2\u000e}\u0003|\bq\u0019{\u0002|\u001e<C<"), a);
        connectionManager2.f_oR.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_Qu.smembers(f_GS));
            if (hashSet.isEmpty()) {
                f_CS.info(c_oa.m_BE((Object)"Q\u0002|\u0003w\u000ef\u0004}\u0003_\f|\fu\b`M:!w\fv\b`Mi\u0010;W2#}Ms\u000ef\u0004d\b2\u000e}\u0003|\bq\u0019{\u0002|\u001e2\u000b}\u0018|\t2\u0004|M@\bv\u0004aMf\u00022\u001fw\u001ef\u0002`\b<"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_CS.info(c_oa.m_BE((Object)"Q\u0002|\u0003w\u000ef\u0004}\u0003_\f|\fu\b`M:!w\fv\b`Mi\u0010;W2+}\u0018|\t2\u0016oMs\u000ef\u0004d\b2\u000e}\u0003|\bq\u0019{\u0002|M[)aM{\u00032?w\t{\u001e2\u0019}M`\ba\u0019}\u001fwW2\u0016o"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[3 >> 1];
            stringArray[3 >> 2] = c_oa.m_BE((Object)";[(E2Q\"\\#W.F$]#M$F(_");
            connectionManager.f_Ds.m_Qda(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_tS.m_cAa((Set)a2));
            }, stringArray);
            f_CS.info(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2E^\bs\tw\u001f2\u0016oD(MS\u0019f\b\u007f\u001df\u0004|\n2\u0019}M`\ba\u0019}\u001fwMi\u00102\u000e}\u0003|\bq\u0019{\u0002|\u001e<"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_CS.info(c_oa.m_BE((Object)"Q\u0002|\u0003w\u000ef\u0004}\u0003_\f|\fu\b`M:!w\fv\b`Mi\u0010;W2+{\u0003{\u001ez\bvMq\u0002|\u0003w\u000ef\u0004}\u00032\u001fw\u001ef\u0002`\ff\u0004}\u00032\u001d`\u0002q\ba\u001e<"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_CS.error(c_oa.m_BE((Object)".}\u0003|\bq\u0019{\u0002| s\u0003s\nw\u001f2E^\bs\tw\u001f2\u0016oD(MW\u001f`\u0002`Mv\u0018`\u0004|\n2\u000e}\u0003|\bq\u0019{\u0002|M`\ba\u0019}\u001fs\u0019{\u0002|Mb\u001f}\u000ew\u001eaW2\u0016o"), objectArray);
            return;
        }
        finally {
            connectionManager.f_oR.unlock();
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_tS.m_MAa(a.getId());
    }

    protected Map<String, c_wj> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_tS.m_Fca((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"!W,V(@W2>f\u0002b\u001d{\u0003uMs\u0001~Mq\u0002|\u0003w\u000ef\u0004}\u0003aMt\u0002`Mb\u001f}\u0007w\u000efMi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M@\bc\u0018w\u001ef\u0004|\n2\u0001w\fv\b`Mf\u00022\u001ef\u0002bMs\u0001~Mq\u0002|\u0003w\u000ef\u0004}\u0003aMt\u0002`Mb\u001f}\u0007w\u000efMi\u0010<"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_mT.m_Aa(Short.valueOf((short)(0x20CF & 0x5FFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Ds.m_kEa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_oR.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_ks.m_Ol();
                connectionManager.f_Xt.m_Eca((Connection)a).m_LU();
                String[] stringArray = new String[3 >> 1];
                stringArray[3 & 4] = a.getId();
                connectionManager.f_Qu.sadd(f_GS, stringArray);
                return;
            }
            finally {
                a2.f_oR.unlock();
            }
        }, a);
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Xt.m_cBa((String)a)) instanceof c_D) {
            return ((c_D)a).m_Y();
        }
        throw new BrowseOperationException(c_oa.m_BE((Object)"/`\u0002e\u001ewM}\u001dw\u001fs\u0019{\u0002|M|\u0002fMa\u0018b\u001d}\u001ff\bv"));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_mT.m_La()) {
            f_CS.debug(c_oa.m_BE((Object)"^(S)W?(MA\u0019s\u001ff\u0004|\n2\u000e}\u0003|\bq\u0019{\u0002|Mi\u00102\u0001}\u000es\u0001~\u0014<"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_CS.debug(c_oa.m_BE((Object)"\\\"\\@^(S)W?(M@\bc\u0018w\u001ef\u0004|\n2\u0001w\fv\b`Mf\u00022\u001ef\f`\u00192\u000e}\u0003|\bq\u0019{\u0002|Mi\u0010<"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            a2.f_mT.m_Aa(Short.valueOf((short)(0x76DF & 0x9E9)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }
}

