/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.repositories;

import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface AnimationRepository
extends BaseJpaRepository<Animation> {
    @Query(value="SELECT DISTINCT a FROM Animation a LEFT JOIN FETCH a.animationScripts")
    public List<Animation> findAll();

    @Query(value="SELECT DISTINCT a FROM Animation a LEFT JOIN FETCH a.animationScripts WHERE a.projectId = :projectId AND a.name = :name")
    public Optional<Animation> findOneByProjectIdAndName(@Param(value="projectId") String var1, @Param(value="name") String var2);

    @Query(value="SELECT DISTINCT a FROM Animation a LEFT JOIN FETCH a.animationScripts WHERE a.id = :id")
    public Optional<Animation> findById(@Param(value="id") String var1);

    @Query(value="SELECT DISTINCT a FROM Animation a LEFT JOIN FETCH a.animationScripts WHERE a.projectId = :projectId AND a.name IN :names")
    public List<Animation> findByProjectIdAndNameIn(@Param(value="projectId") String var1, @Param(value="names") Set<String> var2);

    @Query(value="SELECT DISTINCT a FROM Animation a LEFT JOIN FETCH a.animationScripts WHERE a.projectId = :projectId")
    public List<Animation> findByProjectId(@Param(value="projectId") String var1);

    @Query(value="SELECT DISTINCT a FROM Animation a LEFT JOIN FETCH a.animationScripts INNER JOIN a.project prj WHERE prj.name = :projectName AND a.name = :name")
    public Optional<Animation> findOneByProjectNameAndName(@Param(value="projectName") String var1, @Param(value="name") String var2);
}

