/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.s.c_jj;
import com.inscada.mono.alarm.services.c_GL;
import com.inscada.mono.alarm.services.c_Jk;
import com.inscada.mono.alarm.services.c_KJ;
import com.inscada.mono.alarm.services.c_Sj;
import com.inscada.mono.alarm.v.c_Ak;
import com.inscada.mono.alarm.v.c_Al;
import com.inscada.mono.alarm.v.c_WL;
import com.inscada.mono.alarm.v.c_dJ;
import com.inscada.mono.alarm.v.c_yk;
import com.inscada.mono.auth.c_hj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_l;
import com.inscada.mono.log.v.c_ZC;
import com.inscada.mono.project.v.c_m;
import com.inscada.mono.script.model.ScriptApiCallDto;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_m {
    public static final short f_iU = 102;
    private final c_ZC f_mx;
    public static final short f_hV = 105;
    public static final short f_bw = 108;
    public static final short f_yV = 104;
    public static final short f_UV = 106;
    private static final String f_Vx = "activeAlarmGroups";
    private static final Logger f_rw = LoggerFactory.getLogger(AlarmManager.class);
    public static final short f_rx = 103;
    public static final short f_fx = 107;
    public static final short f_dV = 101;
    private final c_hj f_GU;
    private final c_GL f_Ax;
    private final Lock f_Yw;
    private final c_Sj f_LW;
    private final c_l f_oW;
    private final JedisPooled f_vw;
    private final c_KJ f_IV;
    public static final short f_NW = 109;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_jj getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jy/J>W$Yj_&_8SjM>_>K9\u001e,Q8\u001e1CjR%]+R&Gd"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lI)j9~?o%u+; ~-\u007f)il}#ilz z>vlh8z8n?;*t>;7fb"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (c_jj)a2.f_oW.m_Aa(Short.valueOf((short)(0x7F & 0x67)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_jj> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_LW.m_oha((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_jj getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_IV.m_qha((String)a2, (String)a)) == null) {
            return c_jj.f_by;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_GU.m_kEa(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    protected c_jj getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_jj.f_by;
        }
        AlarmManager a2 = alarmManager.f_Ax.m_tIa(a.getGroup().getId());
        if (a2 != null && a2.m_tHa() && a2.m_iGa(a.getId())) {
            return c_jj.f_UZ;
        }
        return c_jj.f_by;
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_oW.m_ca();
        f_rw.info(InscadaException.m_sA((Object)"Z z>v\u0001z\"z+~>!lO$r?;\"t(~l37fe;%hlU\u0003;\u0000T\u0002\\\tIlO\u0004^lW\tZ\b^\u001e5lH8t<k%u+;-w ; t/z ;-w-i!;%u?k)x8t>hb5b"), a);
        alarmManager2.f_Yw.lock();
        try {
            alarmManager.f_Ax.m_Fha();
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u000bR+L's+P+Y/Lj\u0016\u0004Q>\u001e\u0006[+Z/LjE7\u0017p\u001e\u000bR&\u001e&Q)_&\u001e+R+L'\u001e#P9N/]>W%PjJ+M!MjV+H/\u001e([/PjL/O?[9J/ZjJ%\u001e9J%Nd"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_rw.error(InscadaException.m_sA((Object)"\rw-i!V-u-|)il3\u0002t8;\u0000~-\u007f)il`12v;\ti>t>;(n>r\"|lk>t/~?hlt*;?o#k<r\"|lw#x-wlz z>vlr\"h<~/o#i?!l`1"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Yw.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_oW.m_Q((ClusterNodeListener)a);
        f_rw.info(InscadaException.m_sA((Object)"\rw-i!V-u-|)ilr\"r8r-w%a)\u007flz\"\u007fli)|%h8~>~(;-hlX n?o)i\u0002t(~\u0000r?o)u)ib"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 & 5] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u007f&_8S\u0007_$_-[8\u001ebr/_.[8\u001e1Cc\u0004jl/M>Q8W$Yj_&_8SjY8Q?Np\u001e1Cj\u0016\u0003zp\u001e1Cc"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_mx.m_dJ(a2.getProject()).m_R("Alarm Group Restore (Leader " + (String)a + ")", InscadaException.m_sA((Object)">?;dR\b!l>?2l}-r ~(;8tli)h8t>~b;\u000fz9h)!l>?").formatted(objectArray));
            try {
                f_rw.warn(ScriptApiCallDto.m_GI((Object)"\u007f&_8S\u0007_$_-[8\u001ebr/_.[8\u001e1Cc\u0004j\u007f>J/S:J#P-\u001e>QjZ/_)J#H+J/\u001e+R+L'\u001e-L%K:\u001e1Cj_,J/LjL/M>Q8_>W%PjX+W&K8[d"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_rw.error(InscadaException.m_sA((Object)"\rw-i!V-u-|)il3\u0000~-\u007f)il`12v;\nz%w)\u007flo#;(~-x8r:z8~lz z>vl|>t9kl`1;-}8~>;>~?o#i-o%t\";*z%w9i)!l`1"), objectArray2);
                return;
            }
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_LW.m_iga((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_jj> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"\u0006{\u000bz\u000flp\u001e\r[>J#P-\u001e+R+L'\u001e9J+J?M/MjX%LjE7\u001e\u0003z9\u001e&Q)_&R3\u0004jE7"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_rw.debug(InscadaException.m_sA((Object)"\u0002T\u00026\u0000^\r_\tIv;\u001e~=n)h8r\"|lw)z(~>;*t>;-w-i!;?o-o9h)hl}#il`1;\u0005_?!l`1"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_oW.m_Aa(Short.valueOf((short)(0x7F & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_jj> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jy/J>W$Yj_&Rj_&_8SjY8Q?NjM>_>K9[9\u001e,Q8\u001e:L%T/]>\u001e1CjR%]+R&Gd"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lI)j9~?o%u+; ~-\u007f)il}#ilz wlz z>vl|>t9klh8z8n?~?;*t>;<i#q)x8;7fb"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_oW.m_Aa(Short.valueOf((short)(0x7E & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"\u0006{\u000bz\u000flp\u001e\u000b]>W<_>W$Yj_&Rj_&_8SjY8Q?N9\u001e,Q8\u001e:L%T/]>\u001e1CjR%]+R&Gd"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lI)j9~?o%u+; ~-\u007f)ilo#;-x8r:z8~lz wlz z>vl|>t9k?;*t>;<i#q)x8;7fb"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_oW.m_Aa(Short.valueOf((short)(0x7C & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Yw.lock();
        try {
            c_Jk c_Jk2 = a2.f_Ax.m_tIa(a.getId());
            if (c_Jk2 != null) {
                c_Jk2.m_wHa();
                a2.f_Ax.m_kGa(a.getId(), c_Jk2);
            }
            String[] stringArray = new String[5 >> 2];
            stringArray[3 & 4] = a.getId();
            a2.f_vw.srem(f_Vx, stringArray);
            return;
        }
        finally {
            a2.f_Yw.unlock();
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_GU.m_kEa(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004j\u007f)J#H+J#P-\u001e+R+L'\u001e-L%K:\u001e1CjR%]+R&Gd"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_rw.debug(InscadaException.m_sA((Object)"\u0002T\u00026\u0000^\r_\tIv;\u001e~=n)h8r\"|lw)z(~>;8tlz/o%m-o);-w-i!;+i#n<;7fb"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            a2.f_oW.m_Aa(Short.valueOf((short)(0x6D & 0x77)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_LW.m_EHa((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_LW.m_eGa((String)a, (String)a3).getId());
    }

    @TransactionalEventListener(value={c_WL.class})
    public void handleAlarmDeleteEvent(c_WL c_WL2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_oW.m_La()) {
            AlarmManager a = a.m_nHa();
            f_rw.info(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jv+P.R#P-\u001e\u000bR+L'z/R/J/{<[$JjX%Lj_&_8Sjw\u000e\u0004jE7\u0012jy8Q?Njw\u000e\u0004jE7"), (Object)a.getId(), (Object)a.getGroupId());
            c_Jk c_Jk2 = alarmManager.f_Ax.m_tIa(a.getGroupId());
            if (c_Jk2 != null && c_Jk2.m_tHa()) {
                c_Jk2.m_tGa((Alarm)a);
                return;
            }
        } else {
            f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lR+u#i%u+;\rw-i!_)w)o)^:~\"ol}#ilz z>vlR\b!l`1"), (Object)a.m_nHa().getId());
        }
    }

    protected c_jj getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_Ax.m_tIa((String)a)) != null && a.m_tHa()) {
            return c_jj.f_UZ;
        }
        return c_jj.f_by;
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_KJ c_KJ2, c_Sj c_Sj2, c_GL c_GL2, c_ZC c_ZC2, JedisPooled jedisPooled, c_l c_l2, c_hj c_hj2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_hj2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_Yw = new ReentrantLock();
        a8.f_IV = a7;
        alarmManager5.f_LW = a6;
        alarmManager5.f_Ax = a5;
        alarmManager4.f_mx = a4;
        alarmManager4.f_vw = a3;
        alarmManager3.f_oW = a2;
        alarmManager3.f_GU = a;
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.info(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jv+P.R#P-\u001e\u001aL%T/]>z/_)J#H+J/{<[$JjX%LjN8Q [)Jjw\u000e\u0004jE7"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lR+u#i%u+;\u001ci#q)x8_)z/o%m-o)^:~\"ol}#ilk>t&~/olR\b!l`1"), a);
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"\u0006{\u000bz\u000flp\u001e\u000e[+]>W<_>W$Yj_&Rj_&_8SjY8Q?N9\u001e,Q8\u001e:L%T/]>\u001e1CjR%]+R&Gd"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lI)j9~?o%u+; ~-\u007f)ilo#;(~-x8r:z8~lz wlz z>vl|>t9k?;*t>;<i#q)x8;7fb"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = a;
            a2.f_oW.m_Aa(Short.valueOf((short)(0x6F & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_LW.m_iga((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[2 & 5] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x7F & 0x65), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptApiCallDto.m_GI((Object)"_)J#H+J/\u007f&_8S\rL%K:w$J/L$_&"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 ^ 3] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x6E & 0x77), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(InscadaException.m_sA((Object)"\u007f)z/o%m-o)Z z>v\u000bi#n<R\"o)i\"z "), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[3 & 4] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x7F & 0x67), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptApiCallDto.m_GI((Object)"Y/J\u000bR+L'm>_>K9w$J/L$_&"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 ^ 3] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x7F & 0x68), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(InscadaException.m_sA((Object)"+~8Z z>v\u000bi#n<H8z8n?R\"o)i\"z "), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[3 & 4] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x6D & 0x7B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptApiCallDto.m_GI((Object)"-[>\u007f&_8S\u0019J+J?M/M\bG\u001aL%T/]>w.w$J/L$_&"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x6A & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(InscadaException.m_sA((Object)"|)o\rw-i!\\>t9k\u001fo-o9h)h\u000eb\u001ci#q)x8R(R\"o)i\"z "), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_oW.m_Fa((short)(0x6F & 0x7B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptApiCallDto.m_GI((Object)"Y/J\u000bR+L'm>_>K9[9w$J/L$_&"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x7E & 0x6D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(InscadaException.m_sA((Object)"z/o%m-o)Z z>v\u000bi#n<h\u000eb\u001ci#q)x8R(R\"o)i\"z "), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_oW.m_Fa((short)(0x7D & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptApiCallDto.m_GI((Object)"Z/_)J#H+J/\u007f&_8S\rL%K:M\bG\u001aL%T/]>w.w$J/L$_&"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(InscadaException.m_sA((Object)"\nz%w)\u007flo#;>~+r?o)ilZ z>v\u0001z\"z+~>;\u001eK\u000f;!~8s#\u007f?"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_jj> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jy/J>W$Yj_&Rj_&_8SjM>_>K9[9\u001e,Q8\u001e:L%T/]>\u001e1CjR%]+R&Gd"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lI)j9~?o%u+; ~-\u007f)il}#ilz wlz z>vlh8z8n?~?;*t>;<i#q)x8;7fb"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            return (Map)a2.f_oW.m_Aa(Short.valueOf((short)(0x6B & 0x7D)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_jj getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_IV.m_uga((String)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_oW.m_ca();
        f_rw.info(ScriptApiCallDto.m_GI((Object)"\u007f&_8S\u0007_$_-[8\u0004jj\"W9\u001e$Q.[j\u00161Cc\u001e\"_9\u001e([)Q'[jJ\"[jr\u000f\u007f\u000e{\u0018\u0010jl/M>Q8W$Yj_)J#H/\u001e+R+L'Md\u0010d"), a);
        alarmManager2.f_Yw.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_vw.smembers(f_Vx));
            if (hashSet.isEmpty()) {
                f_rw.info(InscadaException.m_sA((Object)"\rw-i!V-u-|)il3\u0000~-\u007f)il`12v;\u0002tlz/o%m);-w-i!;+i#n<hl}#n\"\u007flr\";\u001e~(r?;8tli)h8t>~b"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[5 >> 2] = hashSet.size();
            objectArray[--2] = hashSet;
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u000bR+L's+P+Y/Lj\u0016\u0006[+Z/LjE7\u0017p\u001e\fQ?P.\u001e1Cj_)J#H/\u001e+R+L'\u001e-L%K:\u001e\u0003z9\u001e#Pjl/Z#MjJ%\u001e8[9J%L/\u0004jE7"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = InscadaException.m_sA((Object)"M\u0005^\u001bD\rW\rI\u0001D\u000bI\u0003N\u001c");
            alarmManager.f_GU.m_Qda(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_LW.m_TGa((Set)a2));
            }, stringArray);
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u007f&_8S\u0007_$_-[8\u001ebr/_.[8\u001e1Cc\u0004j\u007f>J/S:J#P-\u001e>QjL/M>Q8[jE7\u001e+R+L'\u001e-L%K:Md"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_oW.m_ca();
                String[] stringArray = new String[--2];
                stringArray[2 & 5] = InscadaException.m_sA((Object)"Z\u000fO\u0005M\rO\tD\rW\rI\u0001");
                stringArray[2 ^ 3] = ScriptApiCallDto.m_GI((Object)"z\u000f\u007f\tj\u0003h\u000bj\u000fa\u000br\u000bl\u0007");
                alarmManager2.f_GU.m_Nea(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_rw.info(InscadaException.m_sA((Object)"\rw-i!V-u-|)il3\u0000~-\u007f)il`12v;\nr\"r?s)\u007flz z>vli)h8t>z8r#ulk>t/~?hb"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_rw.error(ScriptApiCallDto.m_GI((Object)"\u007f&_8S\u0007_$_-[8\u001ebr/_.[8\u001e1Cc\u0004j{8L%LjZ?L#P-\u001e+R+L'\u001e8[9J%L+J#Q$\u001e:L%]/M9\u0004jE7"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Yw.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jz/_)J#H+J#P-\u001e+R+L'\u001e-L%K:\u001e1CjR%]+R&Gd"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_rw.debug(InscadaException.m_sA((Object)"\u0002T\u00026\u0000^\r_\tIv;\u001e~=n)h8r\"|lw)z(~>;8tl\u007f)z/o%m-o);-w-i!;+i#n<;7fb"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_oW.m_Aa(Short.valueOf((short)(0x66 & 0x7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Yw.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_Jk c_Jk2 = a2.f_Ax.m_Fia((AlarmGroup)a);
            c_Jk2.m_KHa();
            if (c_Jk2.m_tHa()) {
                String[] stringArray = new String[3 & 5];
                stringArray[3 & 4] = a.getId();
                a2.f_vw.sadd(f_Vx, stringArray);
            }
            return;
        }
        finally {
            a2.f_Yw.unlock();
        }
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_LW.m_EHa((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_jj getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.debug(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jy/J>W$Yj_&_8SjY8Q?NjM>_>K9\u001e,Q8\u001e1CjR%]+R&Gd"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lI)j9~?o%u+; ~-\u007f)il}#ilz z>vl|>t9klh8z8n?;*t>;7fb"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            return (c_jj)a2.f_oW.m_Aa(Short.valueOf((short)(0x7F & 0x68)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_Ak.class})
    public void handleAlarmAddEvent(c_Ak c_Ak2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_oW.m_La()) {
            c_Jk c_Jk2;
            AlarmManager a = a.m_Cha();
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u0006{\u000bz\u000flp\u001e\u0002_$Z&W$Yj\u007f&_8S\u000bZ.{<[$JjX%Lj_&_8Sjw\u000e\u0004jE7\u0012jy8Q?Njw\u000e\u0004jE7"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_Jk2 = alarmManager.f_Ax.m_tIa(a.getGroupId())) != null && c_Jk2.m_tHa()) {
                c_Jk2.m_OHa((Alarm)a);
                return;
            }
        } else {
            f_rw.debug(InscadaException.m_sA((Object)"\u0002T\u00026\u0000^\r_\tIv;\u0005|\"t>r\"|lZ z>v\r\u007f(^:~\"ol}#ilz z>vlR\b!l`1"), (Object)a.m_Cha().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_jj getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_LW.m_Jga((String)a2, (String)a)) == null) {
            return c_jj.f_by;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    protected Map<String, c_jj> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_IV.m_iia((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={c_Al.class})
    public void handleAlarmChangeEvent(c_Al c_Al2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_oW.m_La()) {
            AlarmManager a = a.m_tha();
            f_rw.info(ScriptApiCallDto.m_GI((Object)"r\u000f\u007f\u000e{\u0018\u0004jv+P.R#P-\u001e\u000bR+L'}\"_$Y/{<[$JjX%Lj_&_8Sjw\u000e\u0004jE7\u0012jy8Q?Njw\u000e\u0004jE7"), (Object)a.getId(), (Object)a.getGroupId());
            c_Jk c_Jk2 = alarmManager.f_Ax.m_tIa(a.getGroupId());
            if (c_Jk2 != null && c_Jk2.m_tHa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_Jk2.m_OHa((Alarm)a);
                    return;
                }
                c_Jk2.m_tGa((Alarm)a);
                return;
            }
        } else {
            f_rw.debug(InscadaException.m_sA((Object)"U\u0003UaW\tZ\b^\u001e!lR+u#i%u+;\rw-i!X$z\"|)^:~\"ol}#ilz z>vlR\b!l`1"), (Object)a.m_tha().getId());
        }
    }

    protected Map<String, c_jj> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={c_dJ.class})
    public void handleAlarmGroupDeleteEvent(c_dJ c_dJ2) {
        AlarmManager a = c_dJ2;
        AlarmManager a2 = this;
        if (a2.f_oW.m_La()) {
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u0006{\u000bz\u000flp\u001e\u0002_$Z&W$Yj\u007f&_8S\rL%K:z/R/J/{<[$JjX%LjY8Q?Njw\u000e\u0004jE7"), (Object)a.m_HGa().getId());
            a2.deactivateAlarmGroupInternal(a.m_HGa().getId());
            return;
        }
        f_rw.debug(InscadaException.m_sA((Object)"\u0002T\u00026\u0000^\r_\tIv;\u0005|\"t>r\"|lZ z>v\u000bi#n<_)w)o)^:~\"ol}#il|>t9klR\b!l`1"), (Object)a.m_HGa().getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_yk.class})
    public void handleAlarmGroupChangeEvent(c_yk c_yk2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_oW.m_La()) {
            f_rw.info(ScriptApiCallDto.m_GI((Object)"\u0006{\u000bz\u000flp\u001e\u0002_$Z&W$Yj\u007f&_8S\rL%K:}\"_$Y/{<[$JjX%LjY8Q?Njw\u000e\u0004jE7"), (Object)a.m_qHa().getId());
            alarmManager.f_Yw.lock();
            try {
                Object a2 = a.m_qHa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_jj.f_UZ) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_Yw.unlock();
            }
        }
        f_rw.debug(InscadaException.m_sA((Object)"\u0002T\u00026\u0000^\r_\tIv;\u0005|\"t>r\"|lZ z>v\u000bi#n<X$z\"|)^:~\"ol}#il|>t9klR\b!l`1"), (Object)a.m_qHa().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_LW.m_eGa((String)a, (String)a3).getId());
    }
}

