/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.s.c_ZJ;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="digital_alarm")
@CheckAtLeastOneNotNull(fieldNames={"variableAId", "variableA"})
public class DigitalAlarm
extends Alarm {
    @Column(name="variable_A_inverted")
    private Boolean variableAInverted;
    @Column(name="variable_B_id")
    private String variableBId;
    @Column(name="variable_B_inverted")
    private Boolean variableBInverted;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_A_id", insertable=false, updatable=false)
    private VariableView variableA;
    @Column(name="variable_A_id")
    private String variableAId;
    @Min(value=0L)
    @Max(value=63L)
    @Column(name="variable_A_bit_offset")
    private Integer variableABitOffset;
    @Min(value=0L)
    @Max(value=63L)
    @Column(name="variable_B_bit_offset")
    private Integer variableBBitOffset;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_B_id", insertable=false, updatable=false)
    private VariableView variableB;
    @Column(name="and_calc")
    private Boolean andCalc;

    public String getVariableAId() {
        DigitalAlarm a;
        return a.variableAId;
    }

    public void setVariableBInverted(Boolean bl) {
        Object a = bl;
        DigitalAlarm a2 = this;
        a2.variableBInverted = a;
    }

    public Boolean getAndCalc() {
        DigitalAlarm a;
        return a.andCalc;
    }

    public void setVariableB(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableBId = a.getId();
            variable2.variableB = VariableView.from(a);
            return;
        }
        a2.variableBId = null;
        a2.variableB = null;
    }

    @JsonSetter
    public void setVariableB(VariableView variableView) {
        DigitalAlarm a = variableView;
        DigitalAlarm a2 = this;
        a2.variableB = a;
        if (a2.variableB != null) {
            a2.variableBId = a.getId();
            return;
        }
        a2.variableBId = null;
    }

    public VariableView getVariableA() {
        DigitalAlarm a;
        return a.variableA;
    }

    public Boolean getVariableAInverted() {
        DigitalAlarm a;
        return a.variableAInverted;
    }

    public void setAndCalc(Boolean bl) {
        Object a = bl;
        DigitalAlarm a2 = this;
        a2.andCalc = a;
    }

    public void setVariableAId(String string) {
        Object a = string;
        DigitalAlarm a2 = this;
        a2.variableAId = a;
    }

    public c_ZJ getType() {
        return c_ZJ.f_fX;
    }

    public void setVariableAInverted(Boolean bl) {
        Object a = bl;
        DigitalAlarm a2 = this;
        a2.variableAInverted = a;
    }

    @JsonSetter
    public void setVariableA(VariableView variableView) {
        DigitalAlarm a = variableView;
        DigitalAlarm a2 = this;
        a2.variableA = a;
        if (a2.variableA != null) {
            a2.variableAId = a.getId();
            return;
        }
        a2.variableAId = null;
    }

    public String getVariableBId() {
        DigitalAlarm a;
        return a.variableBId;
    }

    public DigitalAlarm() {
        DigitalAlarm a;
    }

    public void setVariableBId(String string) {
        Object a = string;
        DigitalAlarm a2 = this;
        a2.variableBId = a;
    }

    public void setVariableA(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableAId = a.getId();
            variable2.variableA = VariableView.from(a);
            return;
        }
        a2.variableAId = null;
        a2.variableA = null;
    }

    public void setVariableABitOffset(Integer n) {
        Object a = n;
        DigitalAlarm a2 = this;
        a2.variableABitOffset = a;
    }

    public VariableView getVariableB() {
        DigitalAlarm a;
        return a.variableB;
    }

    public Integer getVariableBBitOffset() {
        DigitalAlarm a;
        return a.variableBBitOffset;
    }

    public Boolean getVariableBInverted() {
        DigitalAlarm a;
        return a.variableBInverted;
    }

    public void setVariableBBitOffset(Integer n) {
        Object a = n;
        DigitalAlarm a2 = this;
        a2.variableBBitOffset = a;
    }

    public Integer getVariableABitOffset() {
        DigitalAlarm a;
        return a.variableABitOffset;
    }
}

