/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="alarm_group")
@AttributeOverride(name="id", column=@Column(name="alarm_group_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class AlarmGroup
extends OwnedSpaceBaseModel {
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="on_script_id")
    private RepeatableScript onScript;
    @Size(max=255)
    private String dsc;
    @Column(name="print_when_off")
    private Boolean printWhenOff;
    @Size(max=7)
    @Column(name="off_ack_color")
    private String offAckColor;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @Column(name="hidden_on_monitor")
    private Boolean hiddenOnMonitor;
    @JsonIgnore
    @OneToMany(mappedBy="group")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Alarm> alarms;
    @NotBlank
    @Size(max=100)
    private String name;
    @NotNull
    @Max(value=255L)
    @Min(value=1L)
    private Short priority;
    @NotNull
    @Min(value=100L)
    @Column(name="scan_time")
    private Integer scanTimeInMillis;
    @Column(name="on_script_id", insertable=false, updatable=false)
    private String onScriptId;
    @Size(max=7)
    @Column(name="off_no_ack_color")
    private String offNoAckColor;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="off_script_id")
    private RepeatableScript offScript;
    @Column(name="print_when_ack")
    private Boolean printWhenAck;
    @Size(max=15)
    @Column(name="printer_ip")
    private String printerIp;
    @Size(max=7)
    @Column(name="on_ack_color")
    private String onAckColor;
    @Column(name="print_when_on")
    private Boolean printWhenOn;
    @Size(max=7)
    @Column(name="on_no_ack_color")
    private String onNoAckColor;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Column(name="ack_script_id", insertable=false, updatable=false)
    private String ackScriptId;
    @Min(value=0L)
    @Column(name="printer_port")
    private Short printerPort;
    @Column(name="off_script_id", insertable=false, updatable=false)
    private String offScriptId;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="ack_script_id")
    private RepeatableScript ackScript;

    public AlarmGroup() {
        AlarmGroup a;
    }

    public void setProject(Project project) {
        AlarmGroup a;
        AlarmGroup a2 = project;
        AlarmGroup alarmGroup = a = this;
        alarmGroup.project = a2;
        alarmGroup.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setOnScriptId(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.onScriptId = a;
    }

    public Boolean getPrintWhenOn() {
        AlarmGroup a;
        return a.printWhenOn;
    }

    public String getOnNoAckColor() {
        AlarmGroup a;
        return a.onNoAckColor;
    }

    public Boolean getPrintWhenAck() {
        AlarmGroup a;
        return a.printWhenAck;
    }

    public RepeatableScript getOnScript() {
        AlarmGroup a;
        return a.onScript;
    }

    public void setProjectId(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.projectId = a;
    }

    public void setOffScriptId(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.offScriptId = a;
    }

    public String getPrinterIp() {
        AlarmGroup a;
        return a.printerIp;
    }

    public void setAlarms(Set<Alarm> set) {
        Object a = set;
        AlarmGroup a2 = this;
        a2.alarms = a;
    }

    public boolean equals(Object object) {
        AlarmGroup a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof AlarmGroup)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 3 >> 1;
        }
        return false;
    }

    public String getOnScriptId() {
        AlarmGroup a;
        return a.onScriptId;
    }

    public void setOnNoAckColor(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.onNoAckColor = a;
    }

    public Boolean getHiddenOnMonitor() {
        AlarmGroup a;
        return a.hiddenOnMonitor;
    }

    public Set<Alarm> getAlarms() {
        AlarmGroup a;
        return a.alarms;
    }

    public void setPriority(Short s) {
        Object a = s;
        AlarmGroup a2 = this;
        a2.priority = a;
    }

    public void setPrintWhenOn(Boolean bl) {
        Object a = bl;
        AlarmGroup a2 = this;
        a2.printWhenOn = a;
    }

    public void setPrintWhenAck(Boolean bl) {
        Object a = bl;
        AlarmGroup a2 = this;
        a2.printWhenAck = a;
    }

    public String getName() {
        AlarmGroup a;
        return a.name;
    }

    public void setOnScript(RepeatableScript repeatableScript) {
        AlarmGroup a;
        AlarmGroup a2 = repeatableScript;
        AlarmGroup alarmGroup = a = this;
        alarmGroup.onScript = a2;
        alarmGroup.onScriptId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Project getProject() {
        AlarmGroup a;
        return a.project;
    }

    public void setDsc(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.dsc = a;
    }

    public void setOnAckColor(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.onAckColor = a;
    }

    public void setAckScriptId(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.ackScriptId = a;
    }

    public String getOffScriptId() {
        AlarmGroup a;
        return a.offScriptId;
    }

    public void setPrintWhenOff(Boolean bl) {
        Object a = bl;
        AlarmGroup a2 = this;
        a2.printWhenOff = a;
    }

    public void setOffScript(RepeatableScript repeatableScript) {
        AlarmGroup a;
        AlarmGroup a2 = repeatableScript;
        AlarmGroup alarmGroup = a = this;
        alarmGroup.offScript = a2;
        alarmGroup.offScriptId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public RepeatableScript getAckScript() {
        AlarmGroup a;
        return a.ackScript;
    }

    public void setHiddenOnMonitor(Boolean bl) {
        Object a = bl;
        AlarmGroup a2 = this;
        a2.hiddenOnMonitor = a;
    }

    public void setOffNoAckColor(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.offNoAckColor = a;
    }

    public String getAckScriptId() {
        AlarmGroup a;
        return a.ackScriptId;
    }

    public Short getPriority() {
        AlarmGroup a;
        return a.priority;
    }

    public Integer getScanTimeInMillis() {
        AlarmGroup a;
        return a.scanTimeInMillis;
    }

    public void setPrinterIp(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.printerIp = a;
    }

    public String getProjectId() {
        AlarmGroup a;
        return a.projectId;
    }

    public String getDsc() {
        AlarmGroup a;
        return a.dsc;
    }

    public void setName(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.name = a;
    }

    public void setScanTimeInMillis(Integer n) {
        Object a = n;
        AlarmGroup a2 = this;
        a2.scanTimeInMillis = a;
    }

    public RepeatableScript getOffScript() {
        AlarmGroup a;
        return a.offScript;
    }

    public void setOffAckColor(String string) {
        Object a = string;
        AlarmGroup a2 = this;
        a2.offAckColor = a;
    }

    public String getOffNoAckColor() {
        AlarmGroup a;
        return a.offNoAckColor;
    }

    public void setAckScript(RepeatableScript repeatableScript) {
        AlarmGroup a;
        AlarmGroup a2 = repeatableScript;
        AlarmGroup alarmGroup = a = this;
        alarmGroup.ackScript = a2;
        alarmGroup.ackScriptId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getOffAckColor() {
        AlarmGroup a;
        return a.offAckColor;
    }

    public Boolean getPrintWhenOff() {
        AlarmGroup a;
        return a.printWhenOff;
    }

    public String getOnAckColor() {
        AlarmGroup a;
        return a.onAckColor;
    }

    public Short getPrinterPort() {
        AlarmGroup a;
        return a.printerPort;
    }

    public int hashCode() {
        AlarmGroup a;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = super.hashCode();
        objectArray[--1] = a.getProjectId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setPrinterPort(Short s) {
        Object a = s;
        AlarmGroup a2 = this;
        a2.printerPort = a;
    }
}

