/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.repositories;

import com.inscada.mono.communication.base.model.FrameSummary;
import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.shared.u.c_dc;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class BaseJpaRepositoryImpl<T extends BaseModel>
extends SimpleJpaRepository<T, String>
implements BaseJpaRepository<T> {
    private final EntityManager entityManager;
    private final AuditorAware<String> auditorAware;
    private final int batchSize;

    @Transactional
    public void deleteAll() {
        BaseJpaRepositoryImpl a;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = a;
        baseJpaRepositoryImpl.deleteAll((Iterable)baseJpaRepositoryImpl.findAll());
    }

    @Transactional
    public void hardDelete(T t) {
        Object a = t;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)FrameSummary.m_hW((Object)"e ThT&E!E1\u0011%D;Eh_'EhS-\u0011&D$]i"));
        a2.findByIdIncludingDeleted(object.getId()).ifPresent(baseModel -> {
            BaseJpaRepositoryImpl a = baseModel;
            BaseJpaRepositoryImpl a2 = this;
            a2.hardDeleteById(a.getId());
        });
    }

    @Transactional
    public void restore(T t) {
        Object a = t;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)a, (String)FrameSummary.m_hW((Object)"e ThT&E!E1\u0011%D;Eh_'EhS-\u0011&D$]i"));
        object.setDeletedDate(null);
        object.setDeletedBy(null);
        a2.save(object);
    }

    @Transactional
    public void deleteInBatch(Iterable<T> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        a2.deleteAll((Iterable)a);
    }

    @Transactional
    public void deleteAllByIdInBatch(Iterable<String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        a2.deleteAllById((Iterable)a);
    }

    private /* synthetic */ List<T> findAllByIdIncludingDeleted(Iterable<String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        return super.findAllById((Iterable)a);
    }

    @Transactional
    public void hardDeleteAllByIdInBatch(Iterable<String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)FrameSummary.m_hW((Object)"e ThV!G-_hx<T:P*]-\u0011'Whx,\u0016;\u0011%D;Eh_'EhS-\u0011&D$]i"));
        a = new ArrayList();
        object.forEach(arg_0 -> a.add(arg_0));
        if (a.isEmpty()) {
            return;
        }
        if (!(a = a2.findAllByIdIncludingDeleted((Iterable)a)).isEmpty()) {
            a = a.stream().map(BaseModel::getId).collect(Collectors.toList());
            CriteriaDelete criteriaDelete = a2.entityManager.getCriteriaBuilder().createCriteriaDelete(a2.getDomainClass());
            criteriaDelete.where((Expression)criteriaDelete.from(a2.getDomainClass()).get(FileDownloadResult.m_wM((Object)"7\r")).in((Collection)a));
            a2.entityManager.createQuery(criteriaDelete).executeUpdate();
        }
    }

    public Optional<T> findByIdIncludingDeleted(String string) {
        Object a = string;
        BaseJpaRepositoryImpl a2 = this;
        return super.findById(a);
    }

    public List<String> findExistingIdsIncludingDeleted(Collection<String> collection) {
        Collection<String> a = collection;
        BaseJpaRepositoryImpl a2 = this;
        if (a == null || a.isEmpty()) {
            return new ArrayList<String>();
        }
        return a2.entityManager.createQuery("SELECT e.id FROM " + a2.getDomainClass().getSimpleName() + " e WHERE e.id IN :ids", String.class).setParameter(FileDownloadResult.m_wM((Object)"\u0000:\u001a"), (Object)a).getResultList();
    }

    /*
     * WARNING - void declaration
     */
    public BaseJpaRepositoryImpl(Class<T> clazz, EntityManager entityManager) {
        void a;
        BaseJpaRepositoryImpl a2;
        BaseJpaRepositoryImpl a3 = entityManager;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = a2 = this;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl2 = a3;
        super((Class)a, (EntityManager)baseJpaRepositoryImpl2);
        baseJpaRepositoryImpl.entityManager = baseJpaRepositoryImpl2;
        baseJpaRepositoryImpl.batchSize = Integer.parseInt(a3.getEntityManagerFactory().getProperties().get(FileDownloadResult.m_wM((Object)"\u00017\u000b;\u001b0\b*\fp\u0003:\u000b=G<\b*\n66-\u0000$\f")).toString());
        BaseJpaRepositoryImpl baseJpaRepositoryImpl3 = a2;
        baseJpaRepositoryImpl.auditorAware = new c_dc();
    }

    @Transactional
    public void deleteById(String string) {
        Object a = string;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)FileDownloadResult.m_wM((Object)"\n\u0001;I9\u0000(\f0I7\r~\u0004+\u001a*I0\u0006*I<\f~\u0007+\u00052H"));
        a2.findById(object).ifPresent(arg_0 -> a2.delete(arg_0));
    }

    @Transactional
    public void hardDeleteById(String string) {
        Object a = string;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)FileDownloadResult.m_wM((Object)"\n\u0001;I9\u0000(\f0I7\r~\u0004+\u001a*I0\u0006*I<\f~\u0007+\u00052H"));
        a2.findByIdIncludingDeleted((String)object).ifPresent(arg_0 -> a2.lambda$hardDeleteById$1((String)a, arg_0));
    }

    @Transactional
    public void delete(T t) {
        Object a = t;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)FileDownloadResult.m_wM((Object)"\n\u0001;I;\u0007*\u0000*\u0010~\u0004+\u001a*I0\u0006*I<\f~\u0007+\u00052H"));
        Object object2 = a;
        object.setDeletedDate(new Date());
        object.setDeletedBy(a2.auditorAware.getCurrentAuditor().orElse(FrameSummary.m_hW((Object)"=_#_'F&")));
        a2.save(a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ T persistOrMerge(T t, Set<String> set) {
        void a;
        Object a2 = t;
        BaseJpaRepositoryImpl a3 = this;
        if (a2.getId() == null || !a.contains(a2.getId())) {
            a3.entityManager.persist(a2);
            return (T)a2;
        }
        return (T)((BaseModel)a3.entityManager.merge(a2));
    }

    @Transactional
    public void deleteAllInBatch(Iterable<T> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        a2.deleteAll((Iterable)a);
    }

    @Transactional
    public void deleteAllById(Iterable<? extends String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)FileDownloadResult.m_wM((Object)"\n\u0001;I9\u0000(\f0I\u0017\u001d;\u001b?\u000b2\f~\u00068I\u0017\ry\u001a~\u0004+\u001a*I0\u0006*I<\f~\u0007+\u00052H"));
        a = new ArrayList();
        object.forEach(arg_0 -> a.add(arg_0));
        if (a.isEmpty()) {
            return;
        }
        if (!(a = a2.findAllById((Iterable)a)).isEmpty()) {
            a2.deleteAll((Iterable)a);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BaseJpaRepositoryImpl(JpaEntityInformation<T, ?> jpaEntityInformation, EntityManager entityManager) {
        void a;
        BaseJpaRepositoryImpl a2;
        BaseJpaRepositoryImpl a3 = entityManager;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = a2 = this;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl2 = a3;
        super((JpaEntityInformation)a, (EntityManager)baseJpaRepositoryImpl2);
        baseJpaRepositoryImpl.entityManager = baseJpaRepositoryImpl2;
        baseJpaRepositoryImpl.batchSize = Integer.parseInt(a3.getEntityManagerFactory().getProperties().get(FrameSummary.m_hW((Object)" X*T:_)E-\u001f\"U*RfS)E+Y\u0017B!K-")).toString());
        BaseJpaRepositoryImpl baseJpaRepositoryImpl3 = a2;
        baseJpaRepositoryImpl.auditorAware = new c_dc();
    }

    public Collection<T> bulkSave(Collection<T> collection) {
        Object a = collection;
        BaseJpaRepositoryImpl a2 = this;
        ArrayList<BaseModel> arrayList = new ArrayList<BaseModel>(a.size());
        int n = 2 & 5;
        Set set = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        set = new HashSet(a2.findExistingIdsIncludingDeleted(set));
        a = a.iterator();
        while (a.hasNext()) {
            BaseModel baseModel = (BaseModel)a.next();
            arrayList.add(a2.persistOrMerge(baseModel, set));
            if (++n % a2.batchSize != 0) continue;
            BaseJpaRepositoryImpl baseJpaRepositoryImpl = a2;
            baseJpaRepositoryImpl.entityManager.flush();
            baseJpaRepositoryImpl.entityManager.clear();
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$hardDeleteById$1(String string, BaseModel baseModel) {
        void a;
        BaseJpaRepositoryImpl a2;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = this;
        CriteriaBuilder a3 = baseJpaRepositoryImpl.entityManager.getCriteriaBuilder();
        BaseJpaRepositoryImpl baseJpaRepositoryImpl2 = a2 = a3.createCriteriaDelete(baseJpaRepositoryImpl.getDomainClass());
        baseJpaRepositoryImpl2.where((Expression)a3.equal((Expression)baseJpaRepositoryImpl2.from(baseJpaRepositoryImpl.getDomainClass()).get(FrameSummary.m_hW((Object)"X,")), (Object)a));
        baseJpaRepositoryImpl.entityManager.createQuery((CriteriaDelete)a2).executeUpdate();
    }

    public List<T> findAllIncludingDeleted() {
        BaseJpaRepositoryImpl a;
        return super.findAll();
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> iterable) {
        Iterable<? extends T> a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        Iterable<? extends T> iterable2 = a;
        Assert.notNull((Object)iterable2, (String)FrameSummary.m_hW((Object)"\u001cY-\u0011/X>T&\u0011\u0001E-C)S$Th^.\u0011-_<X<X-Bh_'EhS-\u0011&D$]i"));
        iterable2.forEach(arg_0 -> a2.delete(arg_0));
    }
}

