/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.f4b6a3.uuid.UuidCreator;
import com.inscada.mono.space.restcontrollers.SpaceController;
import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
@FilterDef(name="softDeleteFilter", defaultCondition="deleted_dttm IS NULL")
@Filter(name="softDeleteFilter")
public abstract class BaseModel {
    public static final String SOFT_DELETE_FILTER_NAME = "softDeleteFilter";
    public static final String SOFT_DELETE_FILTER_DEFAULT_CONDITION = "deleted_dttm IS NULL";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedBy
    @Column(name="insert_user", updatable=false)
    protected String createdBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Version
    @Column(name="version")
    private Long version;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_user")
    private String deletedBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedBy
    @Column(name="version_user")
    protected String lastModifiedBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @Id
    @Column(name="id", updatable=false, nullable=false, length=36)
    protected String id;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedDate
    @Column(name="insert_dttm", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date creationDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedDate
    @Column(name="version_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastModifiedDate;

    public Date getCreationDate() {
        BaseModel a;
        return a.creationDate;
    }

    public Long getVersion() {
        BaseModel a;
        return a.version;
    }

    protected BaseModel() {
        BaseModel a;
    }

    public String getDeletedBy() {
        BaseModel a;
        return a.deletedBy;
    }

    public String getId() {
        BaseModel a;
        return a.id;
    }

    @PreRemove
    private /* synthetic */ void preventHardDelete() {
        throw new UnsupportedOperationException(SpaceController.m_Yd((Object)"-~\u0017{E{\u0000s\u0000k\u0000?\flEq\nkE~\ts\nh\u0000{K?5s\u0000~\u0016zEj\u0016zEk\rzEm\u0000o\nl\fk\nm\u001c8\u0016?\u0001z\tz\u0011zEr\u0000k\rp\u0001?\u0003p\u0017?\u0016p\u0003kE{\u0000s\u0000k\fp\u000b1"));
    }

    public void setCreationDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.creationDate = a;
    }

    public static String m_yA(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a = n - --1;
        char[] cArray = new char[n];
        int n2 = --5 << --4 ^ (5 >> 1 ^ --5) << (2 ^ 3);
        int cfr_ignored_0 = --4 << --3 ^ --5;
        int n3 = a;
        int n4 = --5 << --4 ^ --5 << (3 & 5);
        while (n3 >= 0) {
            int n5 = a--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a < 0) break;
            int n6 = a--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a;
        }
        return new String(cArray);
    }

    public String getLastModifiedBy() {
        BaseModel a;
        return a.lastModifiedBy;
    }

    public void setLastModifiedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.lastModifiedDate = a;
    }

    public void setLastModifiedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.lastModifiedBy = a;
    }

    @PrePersist
    protected void onCreate() {
        BaseModel a;
        if (a.id == null) {
            a.id = UuidCreator.getTimeOrdered().toString();
        }
    }

    public void setVersion(Long l) {
        Object a = l;
        BaseModel a2 = this;
        a2.version = a;
    }

    public Date getLastModifiedDate() {
        BaseModel a;
        return a.lastModifiedDate;
    }

    public void setDeletedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.deletedBy = a;
    }

    public void setDeletedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.deletedDate = a;
    }

    public String getCreatedBy() {
        BaseModel a;
        return a.createdBy;
    }

    public Date getDeletedDate() {
        BaseModel a;
        return a.deletedDate;
    }

    public void setId(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.id = a;
    }

    public void setCreatedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.createdBy = a;
    }
}

