/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.auth.security.h.c_rL;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import com.inscada.mono.tracking.restcontrollers.MapVariableController;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String FILE_STORAGE_ERROR = "File Storage Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String SETTINGS_ERROR = "Settings Error";
    private final Environment environment;
    private static final String DATABASE_ERROR = "Database Error";
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return c_rL.m_nfa((Object)"\n\u0019\u000e\u0010U\r\u0014\u0013\u0014\u0017\r\u0016");
        }
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(c_rL.m_nfa((Object)"9\u0017\u0014\u000b\u000e\n\u001b\u0011\u0014\fZ\u000e\u0013\u0017\u0016\u0019\u000e\u0011\u0015\u0016@X\u0001\u0005"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : c_rL.m_nfa((Object)"=\u0002\u001b\u001f\b\u000e\u0011\u0015\u0016");
        Object object2 = a6.isDevelopment() ? a3 : MapVariableController.m_gg((Object)"Ttcic");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return 5 >> 3;
        }
        return Arrays.asList(a).contains(c_rL.m_nfa((Object)"\u001c\u001f\u000e"));
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)MapVariableController.m_gg((Object)"*1"), (Iterable)a.getValue())).collect(Collectors.joining(MapVariableController.m_gg((Object)"1z1")));
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return MapVariableController.m_gg((Object)"Ccbidtrc1g}ttgu\u007f1ciobrb");
        }
        if (a2 instanceof FileStorageException) {
            return c_rL.m_nfa((Object)">\u0013\u0014\u001fX\u0015\b\u001f\n\u001b\f\u0013\u0017\u0014X\u001c\u0019\u0013\u0014\u001f\u001c");
        }
        if (a2 instanceof MismatchException) {
            return MapVariableController.m_gg((Object)"Ccbidtrc1kxu|geey");
        }
        if (a2 instanceof NotActiveException) {
            return c_rL.m_nfa((Object)"(\u001d\t\u0017\u000f\n\u0019\u001dZ\u0011\tX\u0014\u0017\u000eX\u001b\u001b\u000e\u0011\f\u001d");
        }
        if (a2 instanceof NotFoundException) {
            return MapVariableController.m_gg((Object)"Ttu~scet&\u007fie&widhu");
        }
        if (a2 instanceof RelationExistsException) {
            return c_rL.m_nfa((Object)"*\u001f\u0014\u001b\f\u001f\u001cZ\n\u001f\u000b\u0015\r\b\u001b\u001fX\u001f\u0000\u0013\u000b\u000e\u000b");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return MapVariableController.m_gg((Object)"Ttu~scet&fgb&dvugecu&s\u007f1g\u007fientt1sbcc");
        }
        if (a2 instanceof SmsProviderException) {
            return c_rL.m_nfa((Object)")5)X\t\u001d\b\u000e\u0013\u001b\u001fX\u0015\b\u001f\n\u001b\f\u0013\u0017\u0014X\u001c\u0019\u0013\u0014\u001f\u001c");
        }
        if (a2 instanceof SettingsException) {
            return MapVariableController.m_gg((Object)"Gav}orgeo~h1utreo\u007fab&ttcic");
        }
        if (a2 instanceof ParsingException) {
            return c_rL.m_nfa((Object)"1\u0014\u000e\u001b\u0014\u0013\u001cZ\u001c\u001b\f\u001bX\u001c\u0017\b\u0015\u001b\f");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return MapVariableController.m_gg((Object)"Xhecchpj1ppjxbprxi\u007f&ri\u007f`xadtprxi\u007f&ttcic");
        }
        if (a2 instanceof BrowseOperationException) {
            return c_rL.m_nfa((Object)"9\u0014X\u001f\n\b\u0017\bX\u0015\u001b\u0019\r\b\n\u001f\u001cZ\u001c\u000f\n\u0013\u0016\u001dX\u001bX\u0018\n\u0015\u000f\t\u001dZ\u0017\n\u001d\b\u0019\u000e\u0011\u0015\u0016");
        }
        if (a2 instanceof SetValueException) {
            return MapVariableController.m_gg((Object)"Ph1cct~t1iredtccu&fnxjt&bcerxhv&p&gg}st");
        }
        if (a2 instanceof CommunicationException) {
            return c_rL.m_nfa((Object)";\u0015\u0015\u0017\r\u0014\u0011\u0019\u0019\u000e\u0011\u0015\u0016Z\u001b\u0015\u0016\u001c\u0011\u001d\r\b\u0019\u000e\u0011\u0015\u0016Z\u001d\b\n\u0015\n");
        }
        if (a2 instanceof RunAsExecutionException) {
            return MapVariableController.m_gg((Object)"Ph1o\u007frtt\u007fg}&~vttprxi\u007f&wgxjtb1bdtxhv&t~tedrxi\u007f");
        }
        if (a2 instanceof SpaceOperationException) {
            return c_rL.m_nfa((Object)"+\n\u0019\u0019\u001dZ\u0017\n\u001d\b\u0019\u000e\u0011\u0015\u0016Z\u001e\u001b\u0011\u0016\u001d\u001eX\u001e\r\u001fX\u000e\u0017Z\u0019Z\u001a\u000f\u000b\u0013\u0016\u001f\u000b\tX\b\r\u0016\u001dZ\u000e\u0013\u0017\u0016\u0019\u000e\u0011\u0015\u0016");
        }
        if (a2 instanceof ImportExportException) {
            return MapVariableController.m_gg((Object)"Ph1cct~t1iredtccu&usco\u007fa1bprp&xkaicr>civ~te");
        }
        if (a2 instanceof ReportGenerationException) {
            return c_rL.m_nfa((Object)";\u0016Z\u001d\b\n\u0015\nZ\u0017\u0019\u001b\u000f\n\b\u001d\u001eX\u001e\r\b\u0011\u0014\u001fZ\n\u001f\b\u0015\n\u000eX\u001d\u001d\u0014\u001d\b\u0019\u000e\u0011\u0015\u0016");
        }
        if (a2 instanceof ReportSchedulingException) {
            return MapVariableController.m_gg((Object)"G\u007f&ttcic&~erscttb1bdtxhv&ccaicr1urntbdjxhv");
        }
        if (a2 instanceof BroadcastOperationException) {
            return c_rL.m_nfa((Object)";\u0016Z\u001d\b\n\u0015\nZ\u0017\u0019\u001b\u000f\n\b\u001d\u001eX\u001e\r\b\u0011\u0014\u001fZ\u0019Z\u001a\b\u0017\u001b\u001c\u0019\u0019\t\fZ\u0017\n\u001d\b\u0019\u000e\u0011\u0015\u0016");
        }
        if (a2 instanceof AuthTokenException) {
            return MapVariableController.m_gg((Object)"G\u007f&psentheorgeo~h1r~mth1cct~t1iredtccu");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return c_rL.m_nfa((Object)"<\u001b\f\u001b\u001a\u001b\u000b\u001fX\u0019\u0017\u0014\u000b\u000e\n\u001b\u0011\u0014\fZ\u000e\u0013\u0017\u0016\u0019\u000e\u0011\u0015\u0016");
        }
        if (a2 instanceof TransactionSystemException) {
            return MapVariableController.m_gg((Object)"Bprpdput&etphbgrrxi\u007f&ttcic");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return c_rL.m_nfa((Object)".\u0011\u0017\u001dZ\u000b\u001f\n\u0013\u001d\tX\u001e\u0019\u000e\u0019\u0018\u0019\t\u001dZ\u001d\b\n\u0015\n");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return MapVariableController.m_gg((Object)"Percbu1bthxcu");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return c_rL.m_nfa((Object)"1\u0014\u000e\u001b\u0014\u0013\u001cZ\u0011\u0014\b\u000f\f");
        }
        if (a2 instanceof ConstraintViolationException) {
            return MapVariableController.m_gg((Object)"Gg}ougeo~h1e~hbrcgxhe&go~jprxi\u007f");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return c_rL.m_nfa((Object)"3\u0016\f\u0019\u0016\u0011\u001eX\b\u001d\u000b\r\u001f\u000b\u000eX\u001c\u0017\b\u0015\u001b\f");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return MapVariableController.m_gg((Object)"Kxubo\u007fa1ttwdoccu&agcg|cecc");
        }
        if (a2 instanceof IllegalStateException) {
            return c_rL.m_nfa((Object)"1\u0014\u000e\u001b\u0014\u0013\u001cZ\u0019\n\b\u0016\u0011\u0019\u0019\u000e\u0011\u0015\u0016Z\u000b\u000e\u0019\u000e\u001d");
        }
        return MapVariableController.m_gg((Object)"G\u007f&dht~acrrtb1cct~t1iredtccu");
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_rL.m_nfa((Object)"4\u0017Z\u0015\u001f\u000b\t\u0019\u001d\u001dZ\u0019\f\u0019\u0013\u0014\u001b\u001a\u0016\u001d");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_rL.m_nfa((Object)"4\u0017Z\u0015\u001f\u000b\t\u0019\u001d\u001dZ\u0019\f\u0019\u0013\u0014\u001b\u001a\u0016\u001d");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(MapVariableController.m_gg((Object)"a}isg}"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(c_rL.m_nfa((Object)",\u0019\u0016\u0011\u001e\u0019\u000e\u0011\u0015\u0016Z\u001d\b\n\u0015\n@X\u0001\u0005"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(MapVariableController.m_gg((Object)"O\u007frtt\u007fg}&ttcic<1}l"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getName();
        objectArray[3 >> 1] = a.getValue();
        objectArray[5 >> 1] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : c_rL.m_nfa((Object)"\r\u0014\u0013\u0014\u0017\r\u0016");
        String string = MapVariableController.m_gg((Object)"Vptpktrtt1!4u6&foen1ppjdc1!4u6&ridju&\u007fie&sc1e~hgccrtb1r~&e\u007fac1!4u6").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, MapVariableController.m_gg((Object)"Ryob&ccricb1qpu1sabprtb1dh&ph~rycc&dutt?&Ajtgbc1tt`ccbn1\u007f~sc&ugeg1g\u007fb1rc\u007f1gvgxh?"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[--2];
        objectArray[2 & 5] = generalExceptionHandler2.getParameterName();
        objectArray[3 >> 1] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, MapVariableController.m_gg((Object)"Cc`sxttb1vptpktrtt1!4u6&~`1rhvt&6#b!1ob&|obuxhv").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(c_rL.m_nfa((Object)"5\u0013\u000b\t\u0011\u0014\u001fZ\b\u001b\n\u001b\u0015\u001f\f\u001f\n@X\u0001\u0005"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        void status;
        GeneralExceptionHandler generalExceptionHandler = object2;
        Object object2 = object;
        GeneralExceptionHandler body = generalExceptionHandler;
        object2 = body.createExceptionDetails((HttpStatusCode)status, ex.getMessage(), (Exception)ex, UNKNOWN_ERROR);
        log.error(c_rL.m_nfa((Object)"3\u0016\u000e\u001d\b\u0016\u001b\u0014Z\u001d\b\n\u0015\n@X\u0001\u0005"), object2, (Object)ex);
        return new ResponseEntity(object2, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(MapVariableController.m_gg((Object)"Ktubgvc1h~r1ttgugsjt<1}l"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

