/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.script.v.c_bC;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="script")
@AttributeOverride(name="id", column=@Column(name="script_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class RepeatableScript
extends OwnedSpaceBaseModel {
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @NotBlank
    @Size(max=100)
    private String name;
    @NotBlank
    private String code;
    @Min(value=100L)
    private Integer period;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Size(max=255)
    private String dsc;
    @Min(value=0L)
    @Max(value=59L)
    @Column(name="off_set")
    private Integer offset;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm")
    @Temporal(value=TemporalType.TIME)
    @Column(name="sch_time")
    private Date time;
    @Min(value=0L)
    private Integer delay;
    @NotNull
    @Column(name="sch_type")
    private c_bC type;
    @NotNull
    @Column(name="log_flag")
    private Boolean log;

    public int hashCode() {
        RepeatableScript a;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = super.hashCode();
        objectArray[3 >> 1] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getProjectId() {
        RepeatableScript a;
        return a.projectId;
    }

    public void setTime(Date date) {
        Object a = date;
        RepeatableScript a2 = this;
        a2.time = a;
    }

    public String getName() {
        RepeatableScript a;
        return a.name;
    }

    public Date getTime() {
        RepeatableScript a;
        return a.time;
    }

    public void setName(String string) {
        Object a = string;
        RepeatableScript a2 = this;
        a2.name = a;
    }

    public void setLog(Boolean bl) {
        Object a = bl;
        RepeatableScript a2 = this;
        a2.log = a;
    }

    public RepeatableScript() {
        RepeatableScript a;
    }

    public void setDelay(Integer n) {
        Object a = n;
        RepeatableScript a2 = this;
        a2.delay = a;
    }

    public Project getProject() {
        RepeatableScript a;
        return a.project;
    }

    public void setDsc(String string) {
        Object a = string;
        RepeatableScript a2 = this;
        a2.dsc = a;
    }

    public c_bC getType() {
        RepeatableScript a;
        return a.type;
    }

    public void setCode(String string) {
        Object a = string;
        RepeatableScript a2 = this;
        a2.code = a;
    }

    public Integer getPeriod() {
        RepeatableScript a;
        return a.period;
    }

    public String getCode() {
        RepeatableScript a;
        return a.code;
    }

    public void setOffset(Integer n) {
        Object a = n;
        RepeatableScript a2 = this;
        a2.offset = a;
    }

    public Integer getDelay() {
        RepeatableScript a;
        return a.delay;
    }

    public void setType(c_bC c_bC2) {
        RepeatableScript a = c_bC2;
        RepeatableScript a2 = this;
        a2.type = a;
    }

    public String getDsc() {
        RepeatableScript a;
        return a.dsc;
    }

    public Integer getOffset() {
        RepeatableScript a;
        return a.offset;
    }

    public boolean equals(Object object) {
        RepeatableScript a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof RepeatableScript)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public void setProjectId(String string) {
        Object a = string;
        RepeatableScript a2 = this;
        a2.projectId = a;
    }

    public Boolean getLog() {
        RepeatableScript a;
        return a.log;
    }

    public void setProject(Project project) {
        RepeatableScript a;
        RepeatableScript a2 = project;
        RepeatableScript repeatableScript = a = this;
        repeatableScript.project = a2;
        repeatableScript.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setPeriod(Integer n) {
        Object a = n;
        RepeatableScript a2 = this;
        a2.period = a;
    }
}

