/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_SK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_i;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_Fj;
import com.inscada.mono.communication.base.services.c_Hi;
import com.inscada.mono.communication.base.services.c_Yi;
import com.inscada.mono.communication.base.v.c_PK;
import com.inscada.mono.communication.base.v.c_nL;
import com.inscada.mono.datatransfer.h.c_Mb;
import com.inscada.mono.datatransfer.h.c_aA;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.services.c_KC;
import com.inscada.mono.datatransfer.services.c_wb;
import com.inscada.mono.datatransfer.v.c_jc;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.job.v.c_XA;
import com.inscada.mono.log.h.c_qA;
import com.inscada.mono.project.h.c_E;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.tracking.restcontrollers.MapVariableController;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_E {
    public static final short f_jH = 404;
    private final c_XA f_sh;
    public static final short f_DG = 406;
    private final JedisPooled f_Ch;
    private final c_Hi f_wH;
    private final c_SK f_yg;
    private final Lock f_cj;
    public static final short f_xI = 401;
    private static final Logger f_dI = LoggerFactory.getLogger(DataTransferManager.class);
    private final Map<String, Job> f_Dh;
    public static final short f_uh = 407;
    private final c_Yi f_Xh;
    public static final short f_bh = 402;
    private final c_Fj f_FH;
    private static final String f_cI = "scheduledDataTransfers";
    public static final short f_QH = 403;
    public static final short f_zh = 405;
    private final c_qA f_nh;
    private final c_KC f_nG;
    private final c_i f_Hi;

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return MapVariableController.m_gg((Object)"ugeg<rcg\u007fuwcc<brprb<ggcopd}c+#b<4u+#b").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Mb.class})
    public void handleCancelEvent(c_Mb c_Mb2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Hi.m_X()) {
            DataTransferManager a2 = a.m_sq();
            f_dI.info(MapVariableController.m_gg((Object)"]CPBTT+&Yg\u007fb}o\u007fa1Ephrc}Cgc\u007fr1`~t1bprp&etphb`tt+&j{1.XB+&j{8"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"vzv\u0018tpyq}g\u0002\u0015qRVZJ\\VR\u0018vY[[PTpNPVA\u0018SWG\u0018QYAY\u0015LGY[KS]G\u0002\u0015CH"), (Object)a.m_sq().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_Ch.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return (3 & 4) != 0;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_dI.info(MapVariableController.m_gg((Object)"UgegEtphb`tt\\g\u007fgvcc&9Jtgucc&j{8<1Ttueico\u007fa1bprp&etphb`tt+&j{1.XB+&j{8"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[5 >> 2] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_nh.m_KL(a2.getProject()).m_x("Data Transfer Restore (Leader " + (String)a + ")", SetValueRequest.m_Sba((Object)"\u001dF\u0018\u001dqq\u0002\u0015\u001dF\u0011\u0015^TQY]Q\u0018AW\u0015JPKAWG]\u001b\u0018vY@KP\u0002\u0015\u001dF").formatted(objectArray));
            try {
                f_dI.warn(MapVariableController.m_gg((Object)"UgegEtphb`tt\\g\u007fgvcc&9Jtgucc&j{8<1Gertkarxhv&ei1ephrc}&ugeg1rcg\u007fuwcc&j{1gwrtt1ttueicgeo~h1`po}scc?"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_dI.error(SetValueRequest.m_Sba((Object)"|TLTlGY[KS]GuTVT_PJ\u0015\u0010y]T\\PJ\u0015CH\u0011\u000f\u0018sY\\TP\\\u0015LZ\u0018VY[[PT\u0015\\TLT\u0018AJTVF^PJ\u0015CH\u0018T^A]G\u0018G]FLZJTL\\W[\u0018SY\\T@JP\u0002\u0015CH"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_Xh.m_QBa(a.getProjectId(), (Map)a2);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_jc> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.debug(MapVariableController.m_gg((Object)"JTGUCC<1Atreo\u007fa1g}j1bprp&etphb`tt1uegesbcb&wic&at~ltee&j{1j~epj}\u007f?"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"vzv\u0018tpyq}g\u0002\u0015jPI@]FL\\VR\u0018Y]T\\PJ\u0015^ZJ\u0015YYT\u0015\\TLT\u0018AJTVF^PJ\u0015KAYAMF]F\u0018SWG\u0018EJZRP[A\u0018NE\u001b"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            return (Map)a2.f_Hi.m_ea(Short.valueOf((short)(0x73D7 & 0xDBF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_yg.m_afa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_nG.m_yM((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(MapVariableController.m_gg((Object)"gg}st"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_nL c_nL2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_wb.f_lI[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_jc getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_nG.m_om((String)a2, (String)a)) == null) {
            return c_jc.f_rh;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_nG.m_KM((String)a, (String)a3).getId());
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_nG.m_dN((String)a2));
    }

    @TransactionalEventListener(value={c_aA.class})
    public void handleRescheduleEvent(c_aA c_aA2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Hi.m_X()) {
            DataTransferManager a = a.m_HQ();
            f_dI.info(MapVariableController.m_gg((Object)"]CPBTT+&Yg\u007fb}o\u007fa1TturntbdjtCgc\u007fr1`~t1bprp&etphb`tt+&j{1.XB+&j{8"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_jc.f_Ti) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_dI.debug(SetValueRequest.m_Sba((Object)"vzv\u0018tpyq}g\u0002\u0015qRVZJ\\VR\u0018g]F[]]QMY]pNPVA\u0018SWG\u0018QYAY\u0015LGY[KS]G\u0002\u0015CH"), (Object)a.m_HQ().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_nL[] c_nLArray = (c_nL[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_nL[]::new);
        a4 = a7.f_wH.m_bCa(stringArray, (Date)a5, (Date)((Object)a4), c_nLArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[3 >> 1];
            classArray[3 >> 2] = String.class;
            dataTransferManager.f_Hi.m_ma((short)(0xDB7 & 0x73D9), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_Sba((Object)"KVPP\\@TP|TLTlGY[KS]Gq[LPJ[YY"), classArray));
            Class[] classArray2 = new Class[4 ^ 5];
            classArray2[3 ^ 3] = String.class;
            dataTransferManager.f_Hi.m_ma((short)(0x3793 & 0x49FE), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MapVariableController.m_gg((Object)"ephrc}BprpRcg\u007fuwccO\u007frtt\u007fg}"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[3 ^ 3] = String.class;
            dataTransferManager.f_Hi.m_ma((short)(0x7FBB & 0x1D7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_Sba((Object)"R]A|TLTlGY[KS]GkAYAMFq[LPJ[YY"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 >> 2] = String.class;
            dataTransferManager.f_Hi.m_ma((short)(0x659D & 0x1BF6), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MapVariableController.m_gg((Object)"urntbdjtBprpRcg\u007fuwccuS\u007fAt~lteeOuO\u007frtt\u007fg}"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 >> 2] = String.class;
            dataTransferManager.f_Hi.m_ma((short)(0x73BF & 0xDD5), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_Sba((Object)"[TVV]Y|TLTlGY[KS]GKwAeJZRP[AqQq[LPJ[YY"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_Hi.m_ma((short)(0x3F9E & 0x41F7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MapVariableController.m_gg((Object)"atrUgegEtphb`ttBrprdutuS\u007fXbbO\u007frtt\u007fg}"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_Hi.m_ma((short)(0x1DBF & 0x63D7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SetValueRequest.m_Sba((Object)"_PLqYAYaJTVF^PJfLTL@KPKwAeJZRP[AqQq[LPJ[YY"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(MapVariableController.m_gg((Object)"@po}cu&ei1ttaxuecc&UgegEtphb`tt\\g\u007fgvcc&CVR&|cen~bb"), a);
        }
    }

    protected c_jc getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Dh.containsKey(a)) {
            return c_jc.f_Ti;
        }
        return c_jc.f_rh;
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_Hi.m_N((ClusterNodeListener)a);
        f_dI.info(MapVariableController.m_gg((Object)"BprpRcg\u007fuwccKphpatt1o\u007foeopjx|tb1g\u007fb1ttaxuecccu&pu1E}sbrtt_iuc]obrthtt?"));
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_cj.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a.getName();
            PeriodicJob periodicJob = a2.f_sh.m_sJ(a.getProject(), SetValueRequest.m_Sba((Object)"\u001dF\u0018qYAY\u0015lGY[KS]G").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_Dh.put(a.getId(), periodicJob);
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 ^ 3] = a.getId();
            dataTransferManager.f_Ch.sadd(f_cI, stringArray);
            return;
        }
        finally {
            a2.f_cj.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.debug(MapVariableController.m_gg((Object)"]CPBTT+&Rg\u007fetj}o\u007fa1g}j1bprp&etphb`ttb&wic&at~ltee&j{1j~epj}\u007f?"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"vzv\u0018tpyq}g\u0002\u0015jPI@]FL\\VR\u0018Y]T\\PJ\u0015LZ\u0018VY[[PT\u0015YYT\u0015\\TLT\u0018AJTVF^PJF\u0018SWG\u0018EJZRP[A\u0018NE\u001b"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_Hi.m_ea(Short.valueOf((short)(0x49BD & 0x37D7)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_PK c_PK2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x7F & 0xD, 5 >> 3);
        ((Calendar)object).set(0x6F & 0x1E, 5 >> 3);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_wb.f_TG[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x4C & 0x3F, 5 >> 3);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x3B & 0x4F, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x5B & 0x2F, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x4C & 0x3F, 5 >> 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x7F & 0xB, 3 & 4);
                ((Calendar)object4).set(0x5C & 0x2F, 3 ^ 3);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 2 & 5);
                ((Calendar)object5).set(0x1E & 0x6D, 3 >> 2);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 2 & 5);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(MapVariableController.m_gg((Object)"Dht~acrrtb1tphvc1rhvt"));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.debug(MapVariableController.m_gg((Object)"JTGUCC<1Ephrc}jxhv&ugeg1rcg\u007fuwcc&j{1j~epj}\u007f?"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"{w{\u0015y}t|pj\u000f\u0018g]DMPKAQ[_\u0015TPYQ]G\u0018AW\u0015[TVV]Y\u0018QYAY\u0015LGY[KS]G\u0018NE\u001b"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            a2.f_Hi.m_ea(Short.valueOf((short)(0x3FF & 0x7D92)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(SetValueRequest.m_Sba((Object)"CYYMP"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_jc> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Hi.m_X()) {
            f_dI.debug(SetValueRequest.m_Sba((Object)"y}t|pj\u000f\u0018r]AL\\VR\u0018QYAY\u0015LGY[KS]G\u0018FLTL@KPK\u0015^ZJ\u0015CH\u0018||F\u0018YWVYYTL\u0002\u0015CH"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_dI.debug(MapVariableController.m_gg((Object)"_I_+]CPBTT+&Cc`stueo\u007fa1jtgucc&wic&ugeg1rcg\u007fuwcc&brprdutu1`~t1}l&XBb<1}l"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_Hi.m_ea(Short.valueOf((short)(0x29DF & 0x57B6)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(SetValueRequest.m_Sba((Object)"\u0019"))), (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_yg.m_afa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    protected Map<String, c_jc> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_PK c_PK2) {
        DataTransferManager a = c_PK2;
        DataTransferManager a2 = this;
        switch (c_wb.f_TG[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Hi.m_Ga();
        f_dI.info(MapVariableController.m_gg((Object)"UgegEtphb`tt\\g\u007fgvcc<1Ryob&\u007fiuc1.j{8&xu1H^&]I_ATT1RYC1JTGUCC(1Ephrc}jxhv&pj}&}irg}&ugeg1rcg\u007fuwcc&{isu?(?"), a);
        dataTransferManager2.f_cj.lock();
        try {
            new ArrayList(dataTransferManager.f_Dh.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_Dh.clear();
            f_dI.info(SetValueRequest.m_Sba((Object)"|TLTlGY[KS]GuTVT_PJ\u0015\u0010{WA\u0018y]T\\PJ\u0015CH\u0011\u000f\u0018tTY\u0018YWVYY\u0018QYAY\u0015LGY[KS]G\u0018_WWK\u0015PTNP\u0018W]PV\u0015JPI@]FLP\\\u0015LZ\u0018VY[[PT\u0015Y[\\\u0015[Y]TJP\\\u0015^GWX\u0018YWVYY\u0018AJT[^Q[_\u001b"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[--2] = exception;
            f_dI.error(MapVariableController.m_gg((Object)"BprpRcg\u007fuwccKphpatt1._ie&]cpbtt1}l/+&Ttcic&usco\u007fa1vcircbu1iw&rg\u007fetj}o\u007fa1j~epj1bprp&etphb`tt1l~db<1}l"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_cj.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_FH.m_kCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_Xh.m_aAa(object);
        a3 = dataTransferManager2.f_Xh.m_aAa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    protected Map<String, c_jc> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_nG.m_Qo((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return SetValueRequest.m_Sba((Object)"\\TLT\u0015AJTVF^PJ\u000fTTKA\u0015VYY[\u0018L\\UP\u0002CYGQTZY]\u000f\u001dF\u0002\u0010K\u000f\u001dF").formatted(objectArray);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.debug(MapVariableController.m_gg((Object)"JTGUCC<1Urntbdjxhv&ugeg1rcg\u007fuwcc&j{1j~epj}\u007f?"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"{w{\u0015y}t|pj\u000f\u0018g]DMPKAQ[_\u0015TPYQ]G\u0018AW\u0015KVPP\\@TP\u0018QYAY\u0015LGY[KS]G\u0018NE\u001b"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            a2.f_Hi.m_ea(Short.valueOf((short)(0x43FD & 0x3D93)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Hi.m_Ga();
        f_dI.info(SetValueRequest.m_Sba((Object)"|TLTlGY[KS]GuTVT_PJ\u000f\u0018aP\\K\u0015VZ\\P\u0018\u001dCH\u0011\u0015PTK\u0015ZP[ZUP\u0018APP\u0018y}t|pj\u001b\u0018g]FLZJ\\VR\u0018F[]]QMY]Q\u0018QYAY\u0015LGY[KS]GK\u001b\u0016\u001b"), a);
        dataTransferManager2.f_cj.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_Ch.smembers(f_cI));
            if (hashSet.isEmpty()) {
                f_dI.info(MapVariableController.m_gg((Object)"UgegEtphb`tt\\g\u007fgvcc&9Jtgucc&j{8<1H~&beycus}cu&ugeg1rcg\u007fuwccu1`~s\u007fb1o\u007f&Ccuob&ei1ttueicc?"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_dI.info(SetValueRequest.m_Sba((Object)"qYAYaJTVF^PJxY[YR]G\u0018\u001dtPYQ]G\u0018NE\u001c\u0002\u0015~ZM[\\\u0015CH\u0018F[]]QMY]Q\u0018QYAY\u0015LGY[KS]G\u0018||F\u0018\\V\u0015jP\\\\K\u0015LZ\u0018G]FLZJP\u0002\u0015CH"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[3 & 5];
            stringArray[3 ^ 3] = MapVariableController.m_gg((Object)"PXCFYUGEGNRCG_UWCC");
            dataTransferManager.f_yg.m_Nda(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_nG.m_Ro((Set)a2));
            }, stringArray);
            f_dI.info(SetValueRequest.m_Sba((Object)"qYAYaJTVF^PJxY[YR]G\u0018\u001dtPYQ]G\u0018NE\u001c\u0002\u0015yALPUEL\\VR\u0018AW\u0015JPKAWG]\u0015CH\u0018QYAY\u0015LGY[KS]GK\u001b"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_Hi.m_Ga();
                String[] stringArray = new String[5 >> 1];
                stringArray[3 ^ 3] = MapVariableController.m_gg((Object)"URNTBDJTYUGEGNRCG_UWCC");
                stringArray[4 ^ 5] = SetValueRequest.m_Sba((Object)"{tvv}ygqyayjlgy{ks}g");
                dataTransferManager2.f_yg.m_mDa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_dI.info(MapVariableController.m_gg((Object)"BprpRcg\u007fuwccKphpatt1.]cpbtt1}l/+&Wo\u007fobntb1bprp&etphb`tt1ttueicgeo~h1vcircbu?"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_dI.error(SetValueRequest.m_Sba((Object)"qYAYaJTVF^PJxY[YR]G\u0018\u001dtPYQ]G\u0018NE\u001c\u0002\u0015}GJZJ\u0015\\@J\\VR\u0018QYAY\u0015LGY[KS]G\u0018G]FLZJTL\\W[\u0018EJZ[PKF\u0002\u0015CH"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_cj.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_jc getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.debug(SetValueRequest.m_Sba((Object)"tpyq}g\u0002\u0015\u007fPLAQ[_\u0015\\TLT\u0018AJTVF^PJ\u0015KAYAMF\u0018SWG\u0018||\u000f\u0018NE\u0015TZ[TTYA\u001b"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_dI.debug(MapVariableController.m_gg((Object)"H^H<JTGUCC<1Ttwdcbrxhv&}cpbtt1`~t1bprp&etphb`tt1uegesb&wic&XB+&j{?"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (c_jc)a2.f_Hi.m_ea(Short.valueOf((short)(0x49F3 & 0x379F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.debug(MapVariableController.m_gg((Object)"]CPBTT+&Beycus}o\u007fa1g}j1bprp&etphb`ttb&wic&at~ltee&j{1j~epj}\u007f?"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"vzv\u0018tpyq}g\u0002\u0015jPI@]FL\\VR\u0018Y]T\\PJ\u0015LZ\u0018F[]]QMY]\u0015YYT\u0015\\TLT\u0018AJTVF^PJF\u0018SWG\u0018EJZRP[A\u0018NE\u001b"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[2 & 5] = a;
            a2.f_Hi.m_ea(Short.valueOf((short)(0x4D96 & 0x33FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return (3 & 5) != 0;
        }
        return false;
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_cj.lock();
        try {
            Job job = (Job)a2.f_Dh.get(a.getId());
            if (job != null) {
                a2.f_sh.m_qn(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_Dh.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = a.getId();
            dataTransferManager.f_Ch.srem(f_cI, stringArray);
            return;
        }
        finally {
            a2.f_cj.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_FH.m_kCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_Xh.m_aAa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_nG.m_WN((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_Dh.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_dI.info(MapVariableController.m_gg((Object)"BprpRcg\u007fuwccKphpatt1._ie&]cpbtt1}l/+&Rg\u007fetj}o\u007fa1j~epj1l~d1`~t1bprp&etphb`tt1OU<1}l"), (Object)a3, (Object)a);
                dataTransferManager.f_sh.m_qn((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 >> 2] = a3;
                objectArray[3 & 5] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_dI.error(SetValueRequest.m_Sba((Object)"qYAYaJTVF^PJxY[YR]G\u0018\u001dvZL\u0015tPYQ]G\u0018NE\u001c\u0002\u0015}GJZJ\u0015[TVV]YT\\VR\u0018YWVYY\u0018_WW\u0018SWG\u0018QYAY\u0015LGY[KS]G\u0018||\u0015CH\u0002\u0015CH"), objectArray);
            }
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (2 ^ 3) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_Ch.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return 5 >> 2;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_wb.f_TG[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x2F & 0x5B) != calendar.get(0x1F & 0x6B)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x46 & 0x3F) != calendar.get(0x57 & 0x2E)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(5 >> 1) != calendar.get(1 ^ 3)) {
                    n2 = 2 ^ 3;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(--1) != calendar.get(--1) ? 3 >> 1 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[1 ^ 3];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_Ch.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(MapVariableController.m_gg((Object)"Rsctthe"))) {
            return false;
        }
        int a222 = switch (c_wb.f_TG[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3E & 0x7D) * (0x7FFB & 0x3EC));
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_nG.m_bO((String)a2));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Hi.m_X()) {
            f_dI.info(MapVariableController.m_gg((Object)"JTGUCC<1Nphujxhv&At~lteeBtgrrxpprtCgc\u007fr1`~t1vci{crr1OU<1}l"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_dI.debug(SetValueRequest.m_Sba((Object)"vzv\u0018tpyq}g\u0002\u0015qRVZJ\\VR\u0018eJZRP[A|PYVL\\NTLP}C][L\u0015^ZJ\u0015HGW_]VL\u0015qq\u0002\u0015CH"), a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_nG.m_KM((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_KC c_KC2, c_Fj c_Fj2, c_Yi c_Yi2, c_Hi c_Hi2, c_XA c_XA2, JedisPooled jedisPooled, c_qA c_qA2, c_i c_i2, c_SK c_SK2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_SK2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_cj = new ReentrantLock();
        dataTransferManager7.f_Dh = new ConcurrentHashMap();
        dataTransferManager7.f_nG = a9;
        dataTransferManager6.f_FH = a8;
        dataTransferManager6.f_Xh = a7;
        dataTransferManager5.f_wH = a6;
        dataTransferManager5.f_sh = a5;
        dataTransferManager4.f_nh = a4;
        dataTransferManager4.f_Ch = a3;
        dataTransferManager3.f_Hi = a2;
        dataTransferManager3.f_yg = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_Ch.setex(a5, (long)n, String.valueOf(d));
            a4.f_Ch.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(SetValueRequest.m_Sba((Object)"CYYMP"), d);
                a6.put(a.getName(), a3);
            }
        }
    }
}

