/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.mqtt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.mqtt.model.MqttDevice;
import com.inscada.mono.shared.converters.c_FB;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="mqtt_connection")
public class MqttConnection
extends Connection<MqttDevice> {
    @Column(name="clean_session")
    private Boolean cleanSession;
    @Size(max=50)
    private String username;
    @Positive
    @Column(name="initial_delay")
    private Integer initialDelayInMs;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<MqttDevice> devices;
    @Max(value=65535000L)
    @PositiveOrZero
    @Column(name="keep_alive")
    private Integer keepAliveInMs;
    @Column(name="use_ssl")
    private Boolean useSsl;
    @Size(max=23)
    private String identifier;
    @Size(max=50)
    @Convert(converter=c_FB.class)
    private String password;
    @PositiveOrZero
    @Column(name="max_delay")
    private Integer maxDelayInMs;
    @Positive
    @Column(name="pool_size")
    private Integer poolSize;

    public Integer getPoolSize() {
        MqttConnection a;
        return a.poolSize;
    }

    public void setIdentifier(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.identifier = a;
    }

    public void setInitialDelayInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.initialDelayInMs = a;
    }

    public void setCleanSession(Boolean bl) {
        Object a = bl;
        MqttConnection a2 = this;
        a2.cleanSession = a;
    }

    public MqttConnection() {
        MqttConnection a;
        MqttConnection mqttConnection = a;
        mqttConnection.devices = new HashSet();
    }

    public void setMaxDelayInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.maxDelayInMs = a;
    }

    public void setUsername(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.username = a;
    }

    public Integer getMaxDelayInMs() {
        MqttConnection a;
        return a.maxDelayInMs;
    }

    public void setDevices(Set<MqttDevice> set) {
        Object a = set;
        MqttConnection a2 = this;
        a2.devices = a;
    }

    public void setKeepAliveInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.keepAliveInMs = a;
    }

    public void setPoolSize(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.poolSize = a;
    }

    public Integer getKeepAliveInMs() {
        MqttConnection a;
        return a.keepAliveInMs;
    }

    public void setUseSsl(Boolean bl) {
        Object a = bl;
        MqttConnection a2 = this;
        a2.useSsl = a;
    }

    public String getIdentifier() {
        MqttConnection a;
        return a.identifier;
    }

    public void setPassword(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.password = a;
    }

    public Set<MqttDevice> getDevices() {
        MqttConnection a;
        return a.devices;
    }

    public Integer getInitialDelayInMs() {
        MqttConnection a;
        return a.initialDelayInMs;
    }

    public Boolean getUseSsl() {
        MqttConnection a;
        return a.useSsl;
    }

    public String getUsername() {
        MqttConnection a;
        return a.username;
    }

    public Boolean getCleanSession() {
        MqttConnection a;
        return a.cleanSession;
    }

    public String getPassword() {
        MqttConnection a;
        return a.password;
    }
}

