/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.dnp3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.v.c_oj;
import com.inscada.mono.communication.protocols.dnp3.model.Dnp3Connection;
import com.inscada.mono.communication.protocols.dnp3.model.Dnp3Frame;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="dnp3_device")
public class Dnp3Device
extends Device<Dnp3Connection, Dnp3Frame> {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="conn_id")
    protected Dnp3Connection connection;
    @NotNull
    @Min(value=0L)
    @Column(name="remote_address")
    private Integer remoteAddress;
    @Min(value=1L)
    @Column(name="max_controls_per_request")
    private Short maxControlsPerRequest;
    @Min(value=1L)
    @Column(name="event_scan_time")
    private Integer eventScanTime;
    @Column(name="unsolicited_events_flag")
    private Boolean unsolicitedEventsFlag;
    @JsonIgnore
    @OneToMany(mappedBy="device")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<Dnp3Frame> frames;
    @Column(name="disable_unsolicited_on_startup_flag")
    private Boolean disableUnsolicitedOnStartup;
    @Column(name="integrity_on_event_overflow_iin_flag")
    private Boolean integrityOnEventOverflowIIN;
    @NotNull
    @Column(name="scan_type")
    private c_oj scanType;
    @Min(value=1L)
    @Column(name="unsolicited_retry_timeout")
    private Integer unsolRetryTimeout;
    @Min(value=1L)
    @Column(name="solicited_confirm_timeout")
    private Integer solConfirmTimeoutInMs;
    @Column(name="startup_integrity_flag")
    private Boolean startupIntegrityFlag;
    @Min(value=1L)
    @Column(name="response_timeout")
    private Integer responseTimeoutInMs;
    @Min(value=1L)
    @Column(name="integrity_scan_time")
    private Integer integrityScanTime;
    @Min(value=1L)
    @Column(name="select_timeout")
    private Integer selectTimeoutInMs;
    @NotNull
    @Min(value=0L)
    @Column(name="local_address")
    private Integer localAddress;

    public void setSelectTimeoutInMs(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.selectTimeoutInMs = a;
    }

    public Integer getSelectTimeoutInMs() {
        Dnp3Device a;
        return a.selectTimeoutInMs;
    }

    public Integer getEventScanTime() {
        Dnp3Device a;
        return a.eventScanTime;
    }

    public Integer getUnsolRetryTimeout() {
        Dnp3Device a;
        return a.unsolRetryTimeout;
    }

    public void setSolConfirmTimeoutInMs(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.solConfirmTimeoutInMs = a;
    }

    public Integer getIntegrityScanTime() {
        Dnp3Device a;
        return a.integrityScanTime;
    }

    public void setFrames(Set<Dnp3Frame> set) {
        Object a = set;
        Dnp3Device a2 = this;
        a2.frames = a;
    }

    public void setDisableUnsolicitedOnStartup(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.disableUnsolicitedOnStartup = a;
    }

    public void setRemoteAddress(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.remoteAddress = a;
    }

    public Set<Dnp3Frame> getFrames() {
        Dnp3Device a;
        return a.frames;
    }

    public Integer getResponseTimeoutInMs() {
        Dnp3Device a;
        return a.responseTimeoutInMs;
    }

    public void setIntegrityOnEventOverflowIIN(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.integrityOnEventOverflowIIN = a;
    }

    public void setMaxControlsPerRequest(Short s) {
        Object a = s;
        Dnp3Device a2 = this;
        a2.maxControlsPerRequest = a;
    }

    public Dnp3Device() {
        Dnp3Device a;
        Dnp3Device dnp3Device = a;
        dnp3Device.frames = new HashSet();
    }

    public void setStartupIntegrityFlag(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.startupIntegrityFlag = a;
    }

    public Boolean getIntegrityOnEventOverflowIIN() {
        Dnp3Device a;
        return a.integrityOnEventOverflowIIN;
    }

    public void setUnsolRetryTimeout(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.unsolRetryTimeout = a;
    }

    public c_oj getScanType() {
        Dnp3Device a;
        return a.scanType;
    }

    public void setResponseTimeoutInMs(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.responseTimeoutInMs = a;
    }

    public Short getMaxControlsPerRequest() {
        Dnp3Device a;
        return a.maxControlsPerRequest;
    }

    public Dnp3Connection getConnection() {
        Dnp3Device a;
        return a.connection;
    }

    public void setScanType(c_oj c_oj2) {
        Dnp3Device a = c_oj2;
        Dnp3Device a2 = this;
        a2.scanType = a;
    }

    public void setConnection(Dnp3Connection dnp3Connection) {
        Dnp3Device a;
        Dnp3Device a2 = dnp3Connection;
        Dnp3Device dnp3Device = a = this;
        dnp3Device.connection = a2;
        dnp3Device.connectionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Integer getRemoteAddress() {
        Dnp3Device a;
        return a.remoteAddress;
    }

    public Boolean getStartupIntegrityFlag() {
        Dnp3Device a;
        return a.startupIntegrityFlag;
    }

    public Boolean getUnsolicitedEventsFlag() {
        Dnp3Device a;
        return a.unsolicitedEventsFlag;
    }

    public void setLocalAddress(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.localAddress = a;
    }

    public void setUnsolicitedEventsFlag(Boolean bl) {
        Object a = bl;
        Dnp3Device a2 = this;
        a2.unsolicitedEventsFlag = a;
    }

    public Integer getLocalAddress() {
        Dnp3Device a;
        return a.localAddress;
    }

    public Boolean getDisableUnsolicitedOnStartup() {
        Dnp3Device a;
        return a.disableUnsolicitedOnStartup;
    }

    public void setIntegrityScanTime(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.integrityScanTime = a;
    }

    public void setEventScanTime(Integer n) {
        Object a = n;
        Dnp3Device a2 = this;
        a2.eventScanTime = a;
    }

    public Integer getSolConfirmTimeoutInMs() {
        Dnp3Device a;
        return a.solConfirmTimeoutInMs;
    }
}

