/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_SK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_i;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.h.c_IJ;
import com.inscada.mono.communication.base.h.c_tj;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_NJ;
import com.inscada.mono.communication.base.services.c_Nf;
import com.inscada.mono.communication.base.services.c_Oh;
import com.inscada.mono.communication.base.services.c_j;
import com.inscada.mono.communication.base.v.c_Zk;
import com.inscada.mono.license.h.c_ld;
import com.inscada.mono.log.h.c_qA;
import com.inscada.mono.project.h.c_E;
import com.inscada.mono.settings.restcontrollers.MapSettingsController;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.system.repositories.SystemRequestRepository;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_E {
    public static final short f_JT = 203;
    private static final Logger f_xt = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_Us = 204;
    private final c_i f_Is;
    public static final short f_Dt = 209;
    private final c_NJ f_Vs;
    public static final short f_qt = 205;
    private final c_ld f_AT;
    public static final short f_rt = 207;
    private final c_Oh<C, V> f_gS;
    public static final short f_nS = 201;
    private final JedisPooled f_St;
    private static final String f_bU = "activeConnections";
    public static final short f_gs = 208;
    private final Lock f_ES;
    private final c_SK f_GT;
    public static final short f_oS = 202;
    public static final short f_eu = 210;
    public static final short f_Wu = 206;
    private final c_qA f_FS;

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Nf c_Nf2 = a2.f_gS.m_Bca(a.getConnectionId());
        if (c_Nf2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Nf2.m_dt(a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"Qo\\nXx'\nN^|XiCsM=IrDsO~^tEs\nfW=FrI|FqS3"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"9\u001d9\u007f;\u00176\u00162\u0000Mr%7\u0006'\u0012!\u0003;\u00195W>\u00123\u00137\u0005r\u0003=W!\u00033\u0005&W1\u0018<\u00197\u0014&\u001e=\u0019r\f/Y"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_Is.m_ea(Short.valueOf((short)(0x1FCB & 0x60FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_Vs.m_RCa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Zk> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"Qo\\nXx'\nZOi^tDz\n|Fq\n~EsDxIiCrD=YiKi_nOn\n{Eo\nmXr@xIi\nfW=FrI|FqS3"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"9\u001d9\u007f;\u00176\u00162\u0000Mr%7\u0006'\u0012!\u0003;\u00195W>\u00123\u00137\u0005r\u0011=\u0005r\u0016>\u001br\u0014=\u0019<\u00121\u0003;\u0018<W!\u00033\u0003'\u00047\u0004r\u0011=\u0005r\u0007 \u00188\u00121\u0003r\f/Y"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            return (Map)a2.f_Is.m_ea(Short.valueOf((short)(0xBF6 & 0x74D9)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_Is.m_Ga();
        f_xt.info(SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001f\u0016<\u00165\u0012 Mr#:\u001e!W<\u00186\u0012r_)\n{W:\u0016!W0\u00121\u0018?\u0012r\u0003:\u0012r;\u00176\u00162\u0000Yr%7\u0004&\u0018 \u001e<\u0010r\u00161\u0003;\u00017W1\u0018<\u00197\u0014&\u001e=\u0019!Y|Y"), a);
        connectionManager2.f_ES.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_St.smembers(f_bU));
            if (hashSet.isEmpty()) {
                f_xt.info(MapSettingsController.m_Je((Object)"^EsDxIiCrDPKsKzOo\n5fxKyOo\nfW4\u0010=dr\n|IiCkO=IrDsO~^tEsY=Lr_sN=Cs\nOOyCn\niE=XxYiEoO3"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[4 ^ 5] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_xt.info(SystemRequestRepository.m_jf((Object)"4=\u0019<\u00121\u0003;\u0018<:3\u00193\u00107\u0005r_\u001e\u00123\u00137\u0005r\f/^hW\u0014\u0018'\u00196W)\nr\u00161\u0003;\u00017W1\u0018<\u00197\u0014&\u001e=\u0019r>\u0016\u0004r\u001e<W\u0000\u00126\u001e!W&\u0018r\u00057\u0004&\u0018 \u0012hW)\n"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[3 & 5];
            stringArray[3 ^ 3] = MapSettingsController.m_Je((Object)"|ToJu^eSdXiIcRdBcIoP");
            connectionManager.f_GT.m_Nda(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_Vs.m_zba((Set)a2));
            }, stringArray);
            f_xt.info(SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001f\u0016<\u00165\u0012 Wz;7\u00166\u0012 W)\n{Mr6&\u00037\u001a\"\u0003;\u00195W&\u0018r\u00057\u0004&\u0018 \u0012r\f/W1\u0018<\u00197\u0014&\u001e=\u0019!Y"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_xt.info(MapSettingsController.m_Je((Object)"^EsDxIiCrDPKsKzOo\n5fxKyOo\nfW4\u0010=ltDtYuOy\n~EsDxIiCrD=XxYiEoKiCrD=ZoE~OnY3"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_xt.error(SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001f\u0016<\u00165\u0012 Wz;7\u00166\u0012 W)\n{Mr2 \u0005=\u0005r\u0013'\u0005;\u00195W1\u0018<\u00197\u0014&\u001e=\u0019r\u00057\u0004&\u0018 \u0016&\u001e=\u0019r\u0007 \u00181\u0012!\u0004hW)\n"), objectArray);
            return;
        }
        finally {
            connectionManager.f_ES.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"Qo\\nXx'\nN^rZmCsM=IrDsO~^tEs\nfW=FrI|FqS3"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"\u001c8\u001cZ\u001e2\u00133\u0017%hW\u0000\u0012#\u00027\u0004&\u001e<\u0010r\u001b7\u00166\u0012 W&\u0018r\u0004&\u0018\"W1\u0018<\u00197\u0014&\u001e=\u0019r\f/Y"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            a2.f_Is.m_ea(Short.valueOf((short)(0x15FE & 0x6ACB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Zk> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"Qo\\nXx'\nZOi^tDz\n~EsDxIiCrD=YiKi_nOn\n{Eo\nfW=cYY=FrI|FqS3"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"9\u001d9\u007f;\u00176\u00162\u0000Mr%7\u0006'\u0012!\u0003;\u00195W>\u00123\u00137\u0005r\u0011=\u0005r\u0014=\u0019<\u00121\u0003;\u0018<W!\u00033\u0003'\u00047\u0004r\u0011=\u0005r\f/W\u001b3!Y"), (Object)a.length);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_Is.m_ea(Short.valueOf((short)(0x7ADB & 0x5F5)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Zk getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_Vs.m_Gba((String)a2, (String)a)) == null) {
            return c_Zk.f_qu;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    protected Map<String, c_Zk> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Vs.m_Wca((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_Is.m_N((ClusterNodeListener)a);
        f_xt.info(SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001f\u0016<\u00165\u0012 W;\u0019;\u0003;\u0016>\u001e(\u00126W3\u00196W \u00125\u001e!\u00037\u00057\u0013r\u0016!W\u0011\u001b'\u0004&\u0012 9=\u00137;;\u0004&\u0012<\u0012 Y"));
    }

    protected Map<String, c_Zk> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"fXkYoO\u0010=yiEmZtDz\n|Fq\n~EsDxIiCrDn\n{Eo\nmXr@xIi\nfW=FrI|FqS3"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"9\u001d9\u007f;\u00176\u00162\u0000Mr%7\u0006'\u0012!\u0003;\u00195W>\u00123\u00137\u0005r\u0003=W!\u0003=\u0007r\u0016>\u001br\u0014=\u0019<\u00121\u0003;\u0018<\u0004r\u0011=\u0005r\u0007 \u00188\u00121\u0003r\f/Y"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            a2.f_Is.m_ea(Short.valueOf((short)(0x4FF & 0x7BCF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"fXkYoO\u0010=yiKo^tDz\n|Fq\n~EsDxIiCrDn\n{Eo\nmXr@xIi\nfW=FrI|FqS3"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"\u001c8\u001cZ\u001e2\u00133\u0017%hW\u0000\u0012#\u00027\u0004&\u001e<\u0010r\u001b7\u00166\u0012 W&\u0018r\u0004&\u0016 \u0003r\u0016>\u001br\u0014=\u0019<\u00121\u0003;\u0018<\u0004r\u0011=\u0005r\u0007 \u00188\u00121\u0003r\f/Y"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            a2.f_Is.m_ea(Short.valueOf((short)(0x3AFF & 0x45CE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.info(SystemRequestRepository.m_jf((Object)"\u001e2\u00133\u0017%hW\u001a\u0016<\u0013>\u001e<\u0010r' \u00188\u00121\u0003\u0016\u00123\u0014&\u001e$\u0016&\u0012\u0017\u00017\u0019&W4\u0018 W\"\u0005=\u001d7\u0014&W\u001b3hW)\n"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_xt.debug(MapSettingsController.m_Je((Object)"dRd0fXkYoO\u0010=czDrXtDz\nMXr@xIinxK~^t\\|^xokOs^=LrX=ZoEwO~^=cY\u0010=Q`"), a);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, MapSettingsController.m_Je((Object)"yx^KKq_xxx[hOn^=I|DsEi\n\u007fO=DhFq")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001b\u0013r\u001e<W\u0001\u0012&!3\u001b'\u0012\u0000\u0012#\u00027\u0004&W1\u0016<\u0019=\u0003r\u00157W<\u0002>\u001b")));
        if (a3.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"Qo\\nXx'\nNOi^tDz\nfW=\\|XtK\u007fFx\nkKq_xY=FrI|FqS3"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"\u001c8\u001cZ\u001e2\u00133\u0017%hW\u0000\u0012#\u00027\u0004&\u001e<\u0010r\u001b7\u00166\u0012 W&\u0018r\u00047\u0003r\f/W$\u0016 \u001e3\u0015>\u0012r\u00013\u001b'\u0012!Y"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = new ArrayList(a22);
            a3.f_Is.m_ea(Short.valueOf((short)(0x42FD & 0x3DCF)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(MapSettingsController.m_Je((Object)"[KtFxN=^r\nOz^\nnOi\nkKoC|HqO=\\|FhOn"), (Throwable)a22);
        }
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_gS.m_Bca((String)a)) instanceof c_j) {
            return ((c_j)a).m_n();
        }
        throw new BrowseOperationException(SystemRequestRepository.m_jf((Object)"\u0010\u0005=\u0000!\u0012r\u0018\"\u0012 \u0016&\u001e=\u0019r\u0019=\u0003r\u0004'\u0007\"\u0018 \u00037\u0013"));
    }

    protected c_Zk getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_gS.m_Bca((String)a)) != null && a.m_Dt()) {
            return c_Zk.f_eT;
        }
        return c_Zk.f_qu;
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_Vs.m_jCa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, MapSettingsController.m_Je((Object)"yx^KKq_xxx[hOn^=I|DsEi\n\u007fO=DhFq"));
        Objects.requireNonNull(a.getConnectionId(), SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001b\u0013r\u001e<W\u0001\u0012&!3\u001b'\u0012\u0000\u0012#\u00027\u0004&W1\u0016<\u0019=\u0003r\u00157W<\u0002>\u001b"));
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"fXkYoO\u0010=yx^iCsM=\\|XtK\u007fFx\nkKq_x\n{Eo\n~EsDxIiCrD=Q`\nqE~KqFd\u0010=Q`"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"9\u001d9\u007f;\u00176\u00162\u0000Mr%7\u0006'\u0012!\u0003;\u00195W>\u00123\u00137\u0005r\u0003=W!\u0012&W$\u0016 \u001e3\u0015>\u0012r\u00013\u001b'\u0012r\u0011=\u0005r\u0014=\u0019<\u00121\u0003;\u0018<W)\nhW)\n"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_Is.m_ea(Short.valueOf((short)(0x8FD & 0x77CE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_Is.m_Ga();
        String[] stringArray = new String[--3];
        stringArray[5 >> 3] = MapSettingsController.m_Je((Object)"yIkO~BiRdSo^~TeS");
        stringArray[2 ^ 3] = SystemRequestRepository.m_jf((Object)"$\u00068\u0002(\u00118\u001c9\u00174\u0006>\u001d9");
        stringArray[1 ^ 3] = MapSettingsController.m_Je((Object)"|ToJu^eSdXiIcRdBcIoP");
        connectionManager2.f_GT.m_mDa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_Vs.m_RCa((String)a, (String)a3).getId());
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_Is.m_Ga();
        f_xt.info(SystemRequestRepository.m_jf((Object)"4=\u0019<\u00121\u0003;\u0018<:3\u00193\u00107\u0005hW\u0006\u001f;\u0004r\u0019=\u00137Wz\f/^r\u001e!W\u001c8r;\u001d9\u00152\u0000W\u0006?\u0017W\u001e2\u00133\u0017%|W\u0001\u0003=\u0007\"\u001e<\u0010r\u0016>\u001br\u001b=\u00143\u001br\u0014=\u0019<\u00121\u0003=\u0005!Y|Y"), a);
        connectionManager2.f_ES.lock();
        try {
            connectionManager.f_gS.m_GCa();
            f_xt.info(MapSettingsController.m_Je((Object)"irDsO~^tEsg|D|MxX=\u0002SEi\nQO|NxX=Q`\u0003'\n\\Fq\nqE~Kq\n~EsDxIiEoY=B|\\x\n\u007fOxD=Xx[hOn^xN=^r\nn^rZ=KsN=IqO|XxN=LoEp\nqE~Kq\niX|IvCsM3"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_xt.error(SystemRequestRepository.m_jf((Object)"\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001f\u0016<\u00165\u0012 Wz9=\u0003r;7\u00166\u0012 W)\n{Mr2 \u0005=\u0005r\u0013'\u0005;\u00195W\"\u0005=\u00147\u0004!W=\u0011r\u0004&\u0018\"\u0007;\u00195W>\u00181\u0016>W1\u0018<\u00197\u0014&\u0018 \u0004hW)\n"), objectArray);
            return;
        }
        finally {
            connectionManager.f_ES.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_xt.info(MapSettingsController.m_Je((Object)"irDsO~^tEsg|D|MxX=\u0002QO|NxX=Q`\u0003'\nOOn^rXtDz\n~EsDxIiCrD'\nfW=\u0002Tn'\nfW4"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_FS.m_KL(a2.getProject()).m_x("Connection Restore (Leader " + (String)a + ")", SystemRequestRepository.m_jf((Object)"w\u0004r_\u001b3hWw\u0004{W4\u0016;\u001b7\u0013r\u0003=W \u0012!\u0003=\u00057Yr43\u0002!\u0012hWw\u0004").formatted(objectArray));
            try {
                f_xt.warn(MapSettingsController.m_Je((Object)"irDsO~^tEsg|D|MxX=\u0002QO|NxX=Q`\u0003'\n\\^iOpZiCsM=^r\nn^rZ=IrDsO~^tEs\nfW=K{^xX=XxYiEoKiCrD=L|Cq_oO3"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_xt.error(SystemRequestRepository.m_jf((Object)"4=\u0019<\u00121\u0003;\u0018<:3\u00193\u00107\u0005r_\u001e\u00123\u00137\u0005r\f/^hW\u0014\u0016;\u001b7\u0013r\u0003=W!\u0003=\u0007r\u0014=\u0019<\u00121\u0003;\u0018<W)\nr\u00164\u00037\u0005r\u00057\u0004&\u0018 \u0016&\u001e=\u0019r\u00113\u001e>\u0002 \u0012hW)\n"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_IJ.class})
    public void handleDeleteEvent(c_IJ c_IJ2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_Is.m_X()) {
            ConnectionManager a2 = a.m_Xba();
            f_xt.info(SystemRequestRepository.m_jf((Object)"\u001e2\u00133\u0017%hW\u001a\u0016<\u0013>\u001e<\u0010r37\u001b7\u000372$\u0012<\u0003r\u0011=\u0005r\u0014=\u0019<\u00121\u0003;\u0018<Mr\f/Wz>\u0016Mr\f/^"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_xt.debug(MapSettingsController.m_Je((Object)"SeS\u0007Qo\\nXx'\nTMsEoCsM=nxFx^xokOs^=LrX=IrDsO~^tEs\u0010=Q`"), (Object)a.m_Xba().getId());
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Vs.m_CBa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_GT.m_afa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_ES.lock();
            try {
                c_Nf c_Nf2 = a2.f_gS.m_Bca(a.getId());
                if (c_Nf2 != null) {
                    c_Nf2.m_kS();
                    a2.f_gS.m_oba(a.getId(), c_Nf2);
                }
                String[] stringArray = new String[3 & 5];
                stringArray[5 >> 3] = a.getId();
                a2.f_St.srem(f_bU, stringArray);
                return;
            }
            finally {
                a2.f_ES.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_NJ c_NJ2, c_ld c_ld2, c_qA c_qA2, c_Oh<C, V> c_Oh2, JedisPooled jedisPooled, c_i c_i2, c_SK c_SK2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_SK2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_ES = new ReentrantLock();
        a8.f_Vs = a7;
        connectionManager5.f_AT = a6;
        connectionManager5.f_FS = a5;
        connectionManager4.f_gS = a4;
        connectionManager4.f_St = a3;
        connectionManager3.f_Is = a2;
        connectionManager3.f_GT = a;
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_Vs.m_ICa((String)a2));
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Vs.m_CBa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_Vs.m_ICa((String)a);
        return connectionManager2.f_GT.m_Pea(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_tj.class})
    public void handleRestartEvent(c_tj c_tj2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_Is.m_X()) {
            ConnectionManager a2 = a.m_lba();
            f_xt.info(SystemRequestRepository.m_jf((Object)";\u00176\u00162\u0000Mr?3\u00196\u001b;\u00195W\u0000\u0012!\u00033\u0005&2$\u0012<\u0003r\u0011=\u0005r\u0014=\u0019<\u00121\u0003;\u0018<Mr\f/Wz>\u0016Mr\f/^"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_ES.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_Zk.f_eT) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_ES.unlock();
            }
        }
        f_xt.debug(MapSettingsController.m_Je((Object)"dRd0fXkYoO\u0010=czDrXtDz\nOOn^|XiokOs^=LrX=IrDsO~^tEs\u0010=Q`"), (Object)a.m_lba().getId());
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[5 >> 3] = String.class;
            connectionManager.f_Is.m_ma((short)(0x13FD & 0x6CCB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapSettingsController.m_Je((Object)"n^|XiirDsO~^tEscs^xXsKq"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[3 >> 2] = String.class;
            connectionManager.f_Is.m_ma((short)(0x49CF & 0x36FA), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SystemRequestRepository.m_jf((Object)"!\u0003=\u0007\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001b\u0019&\u0012 \u00193\u001b"), classArray2));
            Class[] classArray3 = new Class[3 >> 1];
            classArray3[2 & 5] = String.class;
            connectionManager.f_Is.m_ma((short)(0x23EB & 0x5CDF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapSettingsController.m_Je((Object)"zOiirDsO~^tEsyiKi_ncs^xXsKq"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[3 & 4] = SetValueRequest.class;
            connectionManager.f_Is.m_ma((short)(0x1ACE & 0x65FD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SystemRequestRepository.m_jf((Object)"!\u0012&!3\u0005;\u00160\u001b7!3\u001b'\u0012\u001b\u0019&\u0012 \u00193\u001b"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[5 >> 3] = Collection.class;
            connectionManager.f_Is.m_ma((short)(0x3FCF & 0x40FD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapSettingsController.m_Je((Object)"nOi||XtK\u007fFx||FhOncs^xXsKq"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_Is.m_ma((short)(0x28DF & 0x57EE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SystemRequestRepository.m_jf((Object)"\u0004&\u0016 \u0003\u0011\u0018<\u00197\u0014&\u001e=\u0019!5+' \u00188\u00121\u0003\u001b\u0013\u001b\u0019&\u0012 \u00193\u001b"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_Is.m_ma((short)(0x41CF & 0x3EFF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapSettingsController.m_Je((Object)"YiEmirDsO~^tEsY_SMXr@xIicycs^xXsKq"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_Is.m_ma((short)(0x54D9 & 0x2BF6), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SystemRequestRepository.m_jf((Object)"5\u0012&4=\u0019<\u00121\u0003;\u0018<$&\u0016&\u0002!\u0012!5+' \u00188\u00121\u0003\u001b\u0013\u001b\u0019&\u0012 \u00193\u001b"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_Is.m_ma((short)(0x22D7 & 0x5DF9), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapSettingsController.m_Je((Object)"Mx^^EsDxIiCrDN^|^hYxY_STNncs^xXsKq"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_Is.m_ma((short)(0x47DB & 0x38F6), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SystemRequestRepository.m_jf((Object)"0\u0005=\u0000!\u0012\u0011\u0018<\u00197\u0014&\u001e=\u0019\u001b\u0019&\u0012 \u00193\u001b"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(MapSettingsController.m_Je((Object)"l|CqOy\niE=XxMtYiOo\n^EsDxIiCrDPKsKzOo\nOz^\npOiBrNn"), a);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_Vs.m_ECa(a.getId());
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_gS.m_Bca((String)a)) != null) {
                void a3;
                a.m_Zt((List)a3);
            }
        });
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Zk getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"Qo\\nXx'\nZOi^tDz\n~EsDxIiCrD=YiKi_n\n{Eo\nfW=FrI|FqS3"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"9\u001d9\u007f;\u00176\u00162\u0000Mr%7\u0006'\u0012!\u0003;\u00195W>\u00123\u00137\u0005r\u0011=\u0005r\u0014=\u0019<\u00121\u0003;\u0018<W!\u00033\u0003'\u0004r\u0011=\u0005r\f/Y"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (c_Zk)a2.f_Is.m_ea(Short.valueOf((short)(0x60FB & 0x1FCF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_GT.m_afa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_ES.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_AT.m_gl();
                connectionManager.f_gS.m_Vca((Connection)a).m_pt();
                String[] stringArray = new String[--1];
                stringArray[3 & 4] = a.getId();
                connectionManager.f_St.sadd(f_bU, stringArray);
                return;
            }
            finally {
                a2.f_ES.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Is.m_X()) {
            f_xt.debug(MapSettingsController.m_Je((Object)"fXkYoO\u0010=zxX{EoGtDz\n\u007fXr]nO=EmOoKiCrD=LrX=IrDsO~^tEs\nfW=FrI|FqS3"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_xt.debug(SystemRequestRepository.m_jf((Object)"\u001c8\u001cZ\u001e2\u00133\u0017%hW\u0000\u0012#\u00027\u0004&\u001e<\u0010r\u001b7\u00166\u0012 W&\u0018r\u00077\u00054\u0018 \u001ar\u0015 \u0018%\u00047W=\u00077\u00053\u0003;\u0018<W4\u0018 W1\u0018<\u00197\u0014&\u001e=\u0019r\f/Y"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            return a2.f_Is.m_ea(Short.valueOf((short)(0x8DE & 0x77F3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }
}

