/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.HasDevice;
import com.inscada.mono.communication.base.model.HasVariables;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="frame_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"deviceId", "device"})
public class Frame<TDevice extends Device<?, ?>, TVariable extends Variable<?, ?, ?>>
extends SpaceBaseModel
implements HasVariables<TVariable>,
HasDevice<TDevice> {
    @Column(name="scan_time_factor")
    protected Integer scanTimeFactor;
    @Size(max=255)
    protected String dsc;
    @Column(name="device_id", insertable=false, updatable=false)
    protected String deviceId;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @Column(name="minutes_offset")
    protected Integer minutesOffset;
    @NotBlank
    @Size(max=100)
    protected String name;
    @NotNull
    @Column(name="readable_flag", nullable=false)
    protected Boolean isReadable;

    public void setScanTimeFactor(Integer n) {
        Object a = n;
        Frame a2 = this;
        a2.scanTimeFactor = a;
    }

    public Integer getMinutesOffset() {
        Frame a;
        return a.minutesOffset;
    }

    public void setDsc(String string) {
        Object a = string;
        Frame a2 = this;
        a2.dsc = a;
    }

    public Integer getScanTimeFactor() {
        Frame a;
        return a.scanTimeFactor;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        Frame a2 = this;
        a2.isWritable = a;
    }

    public void setMinutesOffset(Integer n) {
        Object a = n;
        Frame a2 = this;
        a2.minutesOffset = a;
    }

    public void setIsReadable(Boolean bl) {
        Object a = bl;
        Frame a2 = this;
        a2.isReadable = a;
    }

    public String getDeviceId() {
        Frame a;
        return a.deviceId;
    }

    public Boolean getIsReadable() {
        Frame a;
        return a.isReadable;
    }

    public boolean equals(Object object) {
        Frame a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof Frame)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 5 >> 3;
        }
        if (a.getDeviceId().equals(object2.getDeviceId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public String getName() {
        Frame a;
        return a.name;
    }

    public void setName(String string) {
        Object a = string;
        Frame a2 = this;
        a2.name = a;
    }

    public Frame() {
        Frame a;
    }

    public void setDeviceId(String string) {
        Object a = string;
        Frame a2 = this;
        a2.deviceId = a;
    }

    public int hashCode() {
        Frame a;
        Object[] objectArray = new Object[--3];
        objectArray[3 & 4] = super.hashCode();
        objectArray[--1] = a.getDeviceId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public Boolean getIsWritable() {
        Frame a;
        return a.isWritable;
    }

    public String getDsc() {
        Frame a;
        return a.dsc;
    }
}

