/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.v.c_LL;
import com.inscada.mono.animation.v.c_Vk;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="animation_element")
@AttributeOverride(name="id", column=@Column(name="anim_element_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"animationId", "animation"})
public class AnimationElement
extends SpaceBaseModel {
    @NotBlank
    private String expression;
    @NotNull
    @Column(name="expression_type")
    private c_LL expressionType;
    @Column(name="animation_id", insertable=false, updatable=false)
    private String animationId;
    @NotNull
    private c_Vk type;
    @NotBlank
    private String props;
    @NotBlank
    @Size(max=100)
    @Column(name="dom_id")
    private String domId;
    @Size(max=255)
    private String dsc;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="animation_id", updatable=false)
    private Animation animation;
    @Size(max=255)
    private String name;

    public void setType(c_Vk c_Vk2) {
        AnimationElement a = c_Vk2;
        AnimationElement a2 = this;
        a2.type = a;
    }

    public int hashCode() {
        AnimationElement a;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = super.hashCode();
        objectArray[--1] = a.getAnimationId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getName() {
        AnimationElement a;
        return a.name;
    }

    public void setAnimationId(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.animationId = a;
    }

    public void setExpression(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.expression = a;
    }

    public void setProps(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.props = a;
    }

    public c_Vk getType() {
        AnimationElement a;
        return a.type;
    }

    public void setDomId(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.domId = a;
    }

    public String getDomId() {
        AnimationElement a;
        return a.domId;
    }

    public void setName(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.name = a;
    }

    public String getDsc() {
        AnimationElement a;
        return a.dsc;
    }

    public AnimationElement() {
        AnimationElement a;
    }

    public void setExpressionType(c_LL c_LL2) {
        AnimationElement a = c_LL2;
        AnimationElement a2 = this;
        a2.expressionType = a;
    }

    public Animation getAnimation() {
        AnimationElement a;
        return a.animation;
    }

    public void setDsc(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.dsc = a;
    }

    public void setAnimation(Animation animation) {
        AnimationElement a;
        AnimationElement a2 = animation;
        AnimationElement animationElement = a = this;
        animationElement.animation = a2;
        animationElement.animationId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getProps() {
        AnimationElement a;
        return a.props;
    }

    public boolean equals(Object object) {
        AnimationElement a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof AnimationElement)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        if (a.getAnimationId().equals(object2.getAnimationId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public c_LL getExpressionType() {
        AnimationElement a;
        return a.expressionType;
    }

    public String getAnimationId() {
        AnimationElement a;
        return a.animationId;
    }

    public String getExpression() {
        AnimationElement a;
        return a.expression;
    }
}

