/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="animation")
@AttributeOverride(name="id", column=@Column(name="animation_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"svgFileId", "svgFile"})})
public class Animation
extends SpaceBaseModel {
    @Size(max=7)
    private String color;
    @NotBlank
    @Size(max=100)
    private String name;
    @OneToMany(mappedBy="animation")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<AnimationScript> animationScripts;
    @NotNull
    @Column(name="main_flag")
    private Boolean mainFlag;
    @Size(max=255)
    private String dsc;
    @Column(name="anim_join_id")
    private String animJoinId;
    @Column(name="post_anim_code")
    private String postAnimCode;
    @Column(name="pre_anim_code")
    private String preAnimCode;
    @NotNull
    @Min(value=1L)
    @Column(name="play_order")
    private Short playOrder;
    @Column(name="svg_file_id", updatable=false, insertable=false)
    private String svgFileId;
    private String placeholders;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    private String alignment;
    @JsonIgnore
    @OneToOne(optional=false)
    @JoinColumn(name="svg_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo svgFile;
    private String configs;
    @NotNull
    @Min(value=100L)
    private Integer duration;
    @JsonIgnore
    @OneToMany(mappedBy="animation")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<AnimationElement> animationElements;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;

    public void setAnimJoinId(String string) {
        Object a = string;
        Animation a2 = this;
        a2.animJoinId = a;
    }

    public void addScript(AnimationScript animationScript) {
        Animation a;
        Animation a2 = animationScript;
        Animation animation = a = this;
        a2.setAnimation(animation);
        animation.animationScripts.add(a2);
    }

    public void setMainFlag(Boolean bl) {
        Object a = bl;
        Animation a2 = this;
        a2.mainFlag = a;
    }

    public String getAlignment() {
        Animation a;
        return a.alignment;
    }

    public Boolean getMainFlag() {
        Animation a;
        return a.mainFlag;
    }

    public void setProject(Project project) {
        Animation a;
        Animation a2 = project;
        Animation animation = a = this;
        animation.project = a2;
        animation.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Project getProject() {
        Animation a;
        return a.project;
    }

    public String getAnimJoinId() {
        Animation a;
        return a.animJoinId;
    }

    public void removeElement(String string) {
        Object a = string;
        Animation a2 = this;
        a2.animationElements.removeIf(arg_0 -> Animation.lambda$removeElement$0((String)a, arg_0));
    }

    public void setAnimationElements(Set<AnimationElement> set) {
        Object a = set;
        Animation a2 = this;
        a2.animationElements = a;
    }

    public void setPlayOrder(Short s) {
        Object a = s;
        Animation a2 = this;
        a2.playOrder = a;
    }

    public String getDsc() {
        Animation a;
        return a.dsc;
    }

    public Integer getDuration() {
        Animation a;
        return a.duration;
    }

    public void setPostAnimCode(String string) {
        Object a = string;
        Animation a2 = this;
        a2.postAnimCode = a;
    }

    public int hashCode() {
        Animation a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[--1] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getPreAnimCode() {
        Animation a;
        return a.preAnimCode;
    }

    public void removeScript(String string) {
        Object a = string;
        Animation a2 = this;
        a2.animationScripts.removeIf(arg_0 -> Animation.lambda$removeScript$1((String)a, arg_0));
    }

    public void setDuration(Integer n) {
        Object a = n;
        Animation a2 = this;
        a2.duration = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Animation a2 = this;
        a2.dsc = a;
    }

    public void setSvgFileId(String string) {
        Object a = string;
        Animation a2 = this;
        a2.svgFileId = a;
    }

    public String getPostAnimCode() {
        Animation a;
        return a.postAnimCode;
    }

    public void setColor(String string) {
        Object a = string;
        Animation a2 = this;
        a2.color = a;
    }

    public void setAnimationScripts(Set<AnimationScript> set) {
        Object a = set;
        Animation a2 = this;
        a2.animationScripts = a;
    }

    public void setPlaceholders(String string) {
        Object a = string;
        Animation a2 = this;
        a2.placeholders = a;
    }

    public String getSvgFileId() {
        Animation a;
        return a.svgFileId;
    }

    public String getName() {
        Animation a;
        return a.name;
    }

    public void setPreAnimCode(String string) {
        Object a = string;
        Animation a2 = this;
        a2.preAnimCode = a;
    }

    public void setConfigs(String string) {
        Object a = string;
        Animation a2 = this;
        a2.configs = a;
    }

    public Short getPlayOrder() {
        Animation a;
        return a.playOrder;
    }

    public Animation() {
        Animation a;
        Animation animation = a;
        a.animationElements = new HashSet();
        animation.animationScripts = new HashSet();
    }

    public FileInfo getSvgFile() {
        Animation a;
        return a.svgFile;
    }

    public void addElement(AnimationElement animationElement) {
        Animation a;
        Animation a2 = animationElement;
        Animation animation = a = this;
        a2.setAnimation(animation);
        animation.animationElements.add(a2);
    }

    public Set<AnimationElement> getAnimationElements() {
        Animation a;
        return a.animationElements;
    }

    public void setProjectId(String string) {
        Object a = string;
        Animation a2 = this;
        a2.projectId = a;
    }

    public String getColor() {
        Animation a;
        return a.color;
    }

    private static /* synthetic */ boolean lambda$removeScript$1(String string, AnimationScript animationScript) {
        String a = animationScript;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public void setName(String string) {
        Object a = string;
        Animation a2 = this;
        a2.name = a;
    }

    private static /* synthetic */ boolean lambda$removeElement$0(String string, AnimationElement animationElement) {
        String a = animationElement;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public String getPlaceholders() {
        Animation a;
        return a.placeholders;
    }

    public void setSvgFile(FileInfo fileInfo) {
        Animation a;
        Animation a2 = fileInfo;
        Animation animation = a = this;
        animation.svgFile = a2;
        animation.svgFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Set<AnimationScript> getAnimationScripts() {
        Animation a;
        return a.animationScripts;
    }

    public String getConfigs() {
        Animation a;
        return a.configs;
    }

    public boolean equals(Object object) {
        Animation a = this;
        Object a2 = object;
        if (a == a2) {
            return 5 >> 2;
        }
        if (!(a2 instanceof Animation)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public void setAlignment(String string) {
        Object a = string;
        Animation a2 = this;
        a2.alignment = a;
    }

    public String getProjectId() {
        Animation a;
        return a.projectId;
    }
}

