/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.h.c_Nl;
import com.inscada.mono.alarm.h.c_RL;
import com.inscada.mono.alarm.h.c_fl;
import com.inscada.mono.alarm.h.c_tk;
import com.inscada.mono.alarm.h.c_zJ;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.services.c_FK;
import com.inscada.mono.alarm.services.c_ik;
import com.inscada.mono.alarm.services.c_pj;
import com.inscada.mono.alarm.services.c_yl;
import com.inscada.mono.alarm.v.c_wK;
import com.inscada.mono.auth.c_SK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_i;
import com.inscada.mono.log.h.c_qA;
import com.inscada.mono.log.model.LogEntryDto;
import com.inscada.mono.project.h.c_E;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.sms.model.SmsRequest;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_E {
    public static final short f_Fw = 106;
    public static final short f_QW = 104;
    private static final Logger f_VU = LoggerFactory.getLogger(AlarmManager.class);
    private final c_yl f_mU;
    public static final short f_Zw = 101;
    public static final short f_wU = 109;
    private final c_ik f_gV;
    private static final String f_Vv = "activeAlarmGroups";
    public static final short f_bx = 102;
    private final Lock f_ww;
    public static final short f_lU = 108;
    private final c_SK f_rU;
    private final c_FK f_cV;
    public static final short f_Bw = 105;
    private final c_qA f_MV;
    public static final short f_xU = 103;
    private final JedisPooled f_Ow;
    public static final short f_ew = 107;
    private final c_i f_UV;

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_rU.m_afa(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"OgBfFp9\u0002BAwKuCwKmE#CoCqO#EqMvR#Y~\u0002oM`CoNz\f"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"`G`%bMoLkZ\u0014(|m_}K{Za@o\u000edKiJm\\(Zg\u000eiM|G~O|K(OdOzC(IzA}^(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_UV.m_ea(Short.valueOf((short)(0x65 & 0x7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_gV.m_cHa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_UV.m_Ga();
        f_VU.info(SmsRequest.m_tF((Object)"BNbPnobLbEfP9\u0002WJjQ#LlFf\u0002+Y~\u000b#JbQ#@fAlOf\u0002wJf\u0002OgBfFp-\u0002QGpVlPjLd\u0002bAwKuG#CoCqOp\f-\f"), a);
        alarmManager2.f_ww.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_Ow.smembers(f_Vv));
            if (hashSet.isEmpty()) {
                f_VU.info(LogEntryDto.m_Pl((Object)"odOzCEOfOoKz\u000e bmOlKz\u000esS!\u0014(`g\u000eiM|G~K(OdOzC(IzA}^{\u000enA}@l\u000ea@(|mJa](Zg\u000ezK{Zg\\m\u0000"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_VU.info(SmsRequest.m_tF((Object)"coCqONCmCdGq\u0002+nfCgGq\u0002x_*\u0018#dlWmF#Y~\u0002bAwKuG#CoCqO#EqMvR#kGQ#Km\u0002QGgKp\u0002wM#PfQwMqG9\u0002x_"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[5 >> 3] = LogEntryDto.m_Pl((Object)"^gMyWoDoZcWiZa]~");
            alarmManager.f_rU.m_Nda(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_gV.m_bia((Set)a2));
            }, stringArray);
            f_VU.info(SmsRequest.m_tF((Object)"BNbPnobLbEfP#\nOGbFfP#Y~\u000b9\u0002BVwGnRwKmE#Vl\u0002qGpVlPf\u0002x_#CoCqO#EqMvRp\f"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_UV.m_Ga();
                String[] stringArray = new String[--2];
                stringArray[3 ^ 3] = LogEntryDto.m_Pl((Object)"Im\\g^o\\kWoDoZc");
                stringArray[2 ^ 3] = SmsRequest.m_tF((Object)"GgBaWkUcWg\\cOcQo");
                alarmManager2.f_rU.m_mDa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_VU.info(LogEntryDto.m_Pl((Object)"odOzCEOfOoKz\u000e bmOlKz\u000esS!\u0014(ha@a]`Kl\u000eiBi\\e\u000ezK{Zg\\iZaAf\u000ex\\gMm]{\u0000"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_VU.error(SmsRequest.m_tF((Object)"BNbPnobLbEfP#\nOGbFfP#Y~\u000b9\u0002FPqMq\u0002gWqKmE#CoCqO#PfQwMqCwKlL#RqM`GpQ9\u0002x_"), objectArray);
            return;
        }
        finally {
            alarmManager.f_ww.unlock();
        }
    }

    protected c_wK getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_cV.m_LGa((String)a)) != null && a.m_sHa()) {
            return c_wK.f_fY;
        }
        return c_wK.f_zY;
    }

    @TransactionalEventListener(value={c_RL.class})
    public void handleAlarmGroupDeleteEvent(c_RL c_RL2) {
        AlarmManager a = c_RL2;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.info(SmsRequest.m_tF((Object)"nFcGgQ\u0018#jbLgNjLd\u0002BNbPneqMvRGGoGwGFTfLw\u0002eMq\u0002dPlWs\u0002Jf9\u0002x_"), (Object)a.m_WGa().getId());
            a2.deactivateAlarmGroupInternal(a.m_WGa().getId());
            return;
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"`G`%bMoLkZ\u0014(go@g\\a@o\u000eIBi\\eizA}^LKdK|KMXm@|\u000enAz\u000eo\\g[x\u000eAj2\u000esS"), (Object)a.m_WGa().getId());
    }

    @TransactionalEventListener(value={c_tk.class})
    public void handleAlarmDeleteEvent(c_tk c_tk2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_UV.m_X()) {
            AlarmManager a = a.m_rHa();
            f_VU.info(SmsRequest.m_tF((Object)"OgBfFp9\u0002KCmFoKmE#coCqOGGoGwGFTfLw\u0002eMq\u0002bNbPn\u0002Jf9\u0002x_/\u0002DPlWs\u0002Jf9\u0002x_"), (Object)a.getId(), (Object)a.getGroupId());
            c_pj c_pj2 = alarmManager.f_cV.m_LGa(a.getGroupId());
            if (c_pj2 != null && c_pj2.m_sHa()) {
                c_pj2.m_nHa((Alarm)a);
                return;
            }
        } else {
            f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eAIfAzGfI(odOzCLKdK|KMXm@|\u000enAz\u000eiBi\\e\u000eAj2\u000esS"), (Object)a.m_rHa().getId());
        }
    }

    protected Map<String, c_wK> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_gV.m_sGa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"OgBfFp9\u0002GGbAwKuCwKmE#CoCqO#EqMvR#Y~\u0002oM`CoNz\f"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"`G`%bMoLkZ\u0014(|m_}K{Za@o\u000edKiJm\\(Zg\u000elKiM|G~O|K(OdOzC(IzA}^(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a;
            a2.f_UV.m_ea(Short.valueOf((short)(0x67 & 0x7E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_gV.m_qha((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    protected Map<String, c_wK> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"nFcGgQ\u0018#ffC`VjTbVjLd\u0002bNo\u0002bNbPn\u0002dPlWsQ#DlP#RqMiG`V#Y~\u0002oM`CoNz\f"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eZKy[m]|GfI(BmOlKz\u000e|A(JmOkZaXiZm\u000eiBd\u000eiBi\\e\u000eo\\g[x](Hg\\(^zAbKkZ(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            a2.f_UV.m_ea(Short.valueOf((short)(0x6D & 0x7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_wK getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_mU.m_CGa((String)a2));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"nFcGgQ\u0018#c`VjTbVjLd\u0002bNo\u0002bNbPn\u0002dPlWsQ#DlP#RqMiG`V#Y~\u0002oM`CoNz\f"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eZKy[m]|GfI(BmOlKz\u000e|A(OkZaXiZm\u000eiBd\u000eiBi\\e\u000eo\\g[x](Hg\\(^zAbKkZ(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = a;
            a2.f_UV.m_ea(Short.valueOf((short)(0x7C & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_wK getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_gV.m_dHa((String)a2, (String)a)) == null) {
            return c_wK.f_zY;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_rU.m_afa(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.info(SmsRequest.m_tF((Object)"OgBfFp9\u0002KCmFoKmE#rqMiG`VGGbAwKuCwGFTfLw\u0002eMq\u0002sPlHfAw\u0002Jf9\u0002x_"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eAIfAzGfI(~zAbKkZLKiM|G~O|KMXm@|\u000enAz\u000ex\\gDmM|\u000eAj2\u000esS"), a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_wK> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"OgBfFp9\u0002DGwVjLd\u0002bNo\u0002bNbPn\u0002dPlWs\u0002pVbVvQfQ#DlP#RqMiG`V#Y~\u0002oM`CoNz\f"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eZKy[m]|GfI(BmOlKz\u000enAz\u000eiBd\u000eiBi\\e\u000eo\\g[x\u000e{ZiZ}]m](Hg\\(^zAbKkZ(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_UV.m_ea(Short.valueOf((short)(0x6B & 0x7E)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_UV.m_Ga();
        f_VU.info(LogEntryDto.m_Pl((Object)"IBi\\eci@iIm\\2\u000e\\Fa](@gJm\u000e Uu\u0007(G{\u000eFa(bG`OkZ\u000e\\fM\u000eDkIjM|&\u000e[Zg^xGfI(OdB(BgMiB(OdOzC(Gf]xKkZg\\{\u0000&\u0000"), a);
        alarmManager2.f_ww.lock();
        try {
            alarmManager.f_cV.m_pia();
            f_VU.info(SmsRequest.m_tF((Object)"coCqONCmCdGq\u0002+llV#nfCgGq\u0002x_*\u0018#coN#NlAbN#CoCqO#KmQsG`VjMm\u0002wCpIp\u0002kCuG#@fGm\u0002qGrWfQwGg\u0002wM#QwMs\f"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[--2] = exception;
            f_VU.error(LogEntryDto.m_Pl((Object)"odOzCEOfOoKz\u000e `gZ(bmOlKz\u000esS!\u0014(kz\\g\\(J}\\a@o\u000ex\\gMm]{\u000egH(]|Ax^a@o\u000edAkOd\u000eiBi\\e\u000ea@{^mM|Az]2\u000esS"), objectArray);
            return;
        }
        finally {
            alarmManager.f_ww.unlock();
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_ww.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_pj c_pj2 = a2.f_cV.m_Iia((AlarmGroup)a);
            c_pj2.m_iga();
            if (c_pj2.m_sHa()) {
                String[] stringArray = new String[3 & 5];
                stringArray[5 >> 3] = a.getId();
                a2.f_Ow.sadd(f_Vv, stringArray);
            }
            return;
        }
        finally {
            a2.f_ww.unlock();
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[3 >> 1];
            classArray[3 >> 2] = String.class;
            alarmManager.f_UV.m_ma((short)(0x67 & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SmsRequest.m_tF((Object)"bAwKuCwGBNbPneqMvRJLwGqLbN"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[5 >> 3] = String.class;
            alarmManager.f_UV.m_ma((short)(0x6E & 0x77), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogEntryDto.m_Pl((Object)"lKiM|G~O|KIBi\\eizA}^A@|Kz@iB"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 & 4] = String.class;
            alarmManager.f_UV.m_ma((short)(0x7F & 0x67), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SmsRequest.m_tF((Object)"dGwcoCqOPVbVvQJLwGqLbN"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[3 >> 2] = String.class;
            alarmManager.f_UV.m_ma((short)(0x6C & 0x7B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogEntryDto.m_Pl((Object)"ImZIBi\\eizA}^[ZiZ}]A@|Kz@iB"), classArray4));
            Class[] classArray5 = new Class[--1];
            classArray5[2 & 5] = String.class;
            alarmManager.f_UV.m_ma((short)(0x7D & 0x6B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SmsRequest.m_tF((Object)"EfVBNbPnqwCwWpGp`zrqMiG`VJFJLwGqLbN"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_UV.m_ma((short)(0x6F & 0x7A), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogEntryDto.m_Pl((Object)"oK|odOzCO\\g[x}|O|[{K{lq~zAbKkZAJA@|Kz@iB"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_UV.m_ma((short)(0x6B & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SmsRequest.m_tF((Object)"dGwcoCqOPVbVvQfQJLwGqLbN"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_UV.m_ma((short)(0x6E & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogEntryDto.m_Pl((Object)"iM|G~O|KIBi\\eizA}^{lq~zAbKkZAJA@|Kz@iB"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_UV.m_ma((short)(0x7F & 0x6D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SmsRequest.m_tF((Object)"gGbAwKuCwGBNbPneqMvRp`zrqMiG`VJFJLwGqLbN"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(LogEntryDto.m_Pl((Object)"hiGdKl\u000e|A(\\mIa]|Kz\u000eIBi\\eci@iIm\\(|Xm(CmZ`Al]"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_zJ.class})
    public void handleAlarmGroupChangeEvent(c_zJ c_zJ2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_UV.m_X()) {
            f_VU.info(SmsRequest.m_tF((Object)"nFcGgQ\u0018#jbLgNjLd\u0002BNbPneqMvR@JbLdGFTfLw\u0002eMq\u0002dPlWs\u0002Jf9\u0002x_"), (Object)a.m_Rga().getId());
            alarmManager.f_ww.lock();
            try {
                Object a2 = a.m_Rga().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_wK.f_fY) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_ww.unlock();
            }
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"`G`%bMoLkZ\u0014(go@g\\a@o\u000eIBi\\eizA}^KFi@oKMXm@|\u000enAz\u000eo\\g[x\u000eAj2\u000esS"), (Object)a.m_Rga().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_wK> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"nFcGgQ\u0018#efVwKmE#CoCqO#QwCwWpGp\u0002eMq\u0002x_#kGQ#NlAbNo[9\u0002x_"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"`G`%bMoLkZ\u0014(|m_}K{Za@o\u000edKiJm\\(Hg\\(OdOzC(]|O|[{K{\u000enAz\u000esS(gL]2\u000esS"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = new ArrayList(a);
            return (Map)a2.f_UV.m_ea(Short.valueOf((short)(0x6F & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_yl c_yl2, c_ik c_ik2, c_FK c_FK2, c_qA c_qA2, JedisPooled jedisPooled, c_i c_i2, c_SK c_SK2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_SK2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_ww = new ReentrantLock();
        a8.f_mU = a7;
        alarmManager5.f_gV = a6;
        alarmManager5.f_cV = a5;
        alarmManager4.f_MV = a4;
        alarmManager4.f_Ow = a3;
        alarmManager3.f_UV = a2;
        alarmManager3.f_rU = a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_wK getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"OgBfFp9\u0002DGwVjLd\u0002bNbPn\u0002pVbVvQ#DlP#Y~\u0002oM`CoNz\f"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eZKy[m]|GfI(BmOlKz\u000enAz\u000eiBi\\e\u000e{ZiZ}](Hg\\(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            return (c_wK)a2.f_UV.m_ea(Short.valueOf((short)(0x77 & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_wK getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_mU.m_tHa((String)a2, (String)a)) == null) {
            return c_wK.f_zY;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_gV.m_jga((String)a2));
    }

    @TransactionalEventListener(value={c_Nl.class})
    public void handleAlarmChangeEvent(c_Nl c_Nl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_UV.m_X()) {
            AlarmManager a = a.m_bHa();
            f_VU.info(SmsRequest.m_tF((Object)"OgBfFp9\u0002KCmFoKmE#coCqO@JbLdGFTfLw\u0002eMq\u0002bNbPn\u0002Jf9\u0002x_/\u0002DPlWs\u0002Jf9\u0002x_"), (Object)a.getId(), (Object)a.getGroupId());
            c_pj c_pj2 = alarmManager.f_cV.m_LGa(a.getGroupId());
            if (c_pj2 != null && c_pj2.m_sHa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_pj2.m_pHa((Alarm)a);
                    return;
                }
                c_pj2.m_nHa((Alarm)a);
                return;
            }
        } else {
            f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eAIfAzGfI(odOzCKFi@oKMXm@|\u000enAz\u000eiBi\\e\u000eAj2\u000esS"), (Object)a.m_bHa().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_wK> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"OgBfFp9\u0002DGwVjLd\u0002bNo\u0002bNbPn\u0002pVbVvQfQ#DlP#RqMiG`V#Y~\u0002oM`CoNz\f"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eZKy[m]|GfI(BmOlKz\u000enAz\u000eiBd\u000eiBi\\e\u000e{ZiZ}]m](Hg\\(^zAbKkZ(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a;
            return (Map)a2.f_UV.m_ea(Short.valueOf((short)(0x6B & 0x7D)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_gV.m_jga((String)a2));
    }

    protected Map<String, c_wK> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_mU.m_uGa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_ww.lock();
        try {
            c_pj c_pj2 = a2.f_cV.m_LGa(a.getId());
            if (c_pj2 != null) {
                c_pj2.m_tha();
                a2.f_cV.m_Tia(a.getId(), c_pj2);
            }
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = a.getId();
            a2.f_Ow.srem(f_Vv, stringArray);
            return;
        }
        finally {
            a2.f_ww.unlock();
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_gV.m_qha((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 & 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_VU.info(SmsRequest.m_tF((Object)"BNbPnobLbEfP#\nOGbFfP#Y~\u000b9\u0002QGpVlPjLd\u0002bNbPn\u0002dPlWs\u0018#Y~\u0002+kG\u0018#Y~\u000b"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[3 & 5] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_MV.m_KL(a2.getProject()).m_x("Alarm Group Restore (Leader " + (String)a + ")", LogEntryDto.m_Pl((Object)"-](\u0006Aj2\u000e-]!\u000enOaBmJ(Zg\u000ezK{Zg\\m\u0000(mi[{K2\u000e-]").formatted(objectArray));
            try {
                f_VU.warn(SmsRequest.m_tF((Object)"BNbPnobLbEfP#\nOGbFfP#Y~\u000b9\u0002BVwGnRwKmE#Vl\u0002gGbAwKuCwG#CoCqO#EqMvR#Y~\u0002bDwGq\u0002qGpVlPbVjMm\u0002eCjNvPf\f"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_VU.error(LogEntryDto.m_Pl((Object)"odOzCEOfOoKz\u000e bmOlKz\u000esS!\u0014(hiGdKl\u000e|A(JmOkZaXiZm\u000eiBi\\e\u000eo\\g[x\u000esS(OnZm\\(\\m]|AzO|Gg@(HiGd[zK2\u000esS"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_wK getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_UV.m_X()) {
            f_VU.debug(SmsRequest.m_tF((Object)"OgBfFp9\u0002DGwVjLd\u0002bNbPn\u0002dPlWs\u0002pVbVvQ#DlP#Y~\u0002oM`CoNz\f"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_VU.debug(LogEntryDto.m_Pl((Object)"FaF\u0003DkIjM|2\u000eZKy[m]|GfI(BmOlKz\u000enAz\u000eiBi\\e\u000eo\\g[x\u000e{ZiZ}](Hg\\(Uu\u0000"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (c_wK)a2.f_UV.m_ea(Short.valueOf((short)(0x6F & 0x78)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_fl.class})
    public void handleAlarmAddEvent(c_fl c_fl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_UV.m_X()) {
            c_pj c_pj2;
            AlarmManager a = a.m_tia();
            f_VU.info(SmsRequest.m_tF((Object)"nFcGgQ\u0018#jbLgNjLd\u0002BNbPncgFFTfLw\u0002eMq\u0002bNbPn\u0002Jf9\u0002x_/\u0002DPlWs\u0002Jf9\u0002x_"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_pj2 = alarmManager.f_cV.m_LGa(a.getGroupId())) != null && c_pj2.m_sHa()) {
                c_pj2.m_pHa((Alarm)a);
                return;
            }
        } else {
            f_VU.debug(LogEntryDto.m_Pl((Object)"`G`%bMoLkZ\u0014(go@g\\a@o\u000eIBi\\eolJMXm@|\u000enAz\u000eiBi\\e\u000eAj2\u000esS"), (Object)a.m_tia().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_gV.m_cHa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    protected c_wK getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_wK.f_zY;
        }
        AlarmManager a2 = alarmManager.f_cV.m_LGa(a.getGroup().getId());
        if (a2 != null && a2.m_sHa() && a2.m_CHa(a.getId())) {
            return c_wK.f_fY;
        }
        return c_wK.f_zY;
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_UV.m_N((ClusterNodeListener)a);
        f_VU.info(LogEntryDto.m_Pl((Object)"odOzCEOfOoKz\u000ea@aZaOdGrKl\u000ei@l\u000ezKoG{Zm\\mJ(O{\u000eKB}]|Kz`gJmba]|KfKz\u0000"));
    }
}

