/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.repositories;

import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.user.model.Role;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface RoleRepository
extends BaseJpaRepository<Role> {
    @DisableSpaceFilter
    @Query(value="SELECT r FROM Role r JOIN r.users u WHERE u.id = :userId")
    public List<Role> findByUsersIdInAllSpaces(@Param(value="userId") String var1);

    @DisableSpaceFilter
    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.menus WHERE r.id IN :ids")
    public List<Role> findByIdInWithMenusInAllSpaces(@Param(value="ids") Iterable<String> var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE r.name = :name AND NOT EXISTS (SELECT p FROM r.permissions p WHERE p.isGlobal = true) AND NOT EXISTS (SELECT m FROM r.menus m WHERE m.isGlobal = true)")
    public Optional<Role> findSpaceRoleByName(@Param(value="name") String var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE r.name = :name")
    public Optional<Role> findOneByName(@Param(value="name") String var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE r.space.id = :spaceId")
    public List<Role> findBySpaceId(@Param(value="spaceId") String var1);

    @DisableSpaceFilter
    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions WHERE r.id IN :ids")
    public List<Role> findByIdInWithPermissionsInAllSpaces(@Param(value="ids") Iterable<String> var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE (r.id IN :roleIds OR r.name IN :roleNames) AND NOT EXISTS (SELECT p FROM r.permissions p WHERE p.isGlobal = true) AND NOT EXISTS (SELECT m FROM r.menus m WHERE m.isGlobal = true)")
    public List<Role> findSpaceRoleByIdInOrNameIn(@Param(value="roleIds") Set<String> var1, @Param(value="roleNames") Set<String> var2);

    @Query(value="SELECT r FROM Role r LEFT JOIN FETCH r.permissions WHERE r.id = :roleId")
    public Optional<Role> findByIdWithPermissions(@Param(value="roleId") String var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE NOT EXISTS (SELECT p FROM r.permissions p WHERE p.isGlobal = true) AND NOT EXISTS (SELECT m FROM r.menus m WHERE m.isGlobal = true)")
    public List<Role> findAllSpaceRoles();

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE r.id = :id AND NOT EXISTS (SELECT p FROM r.permissions p WHERE p.isGlobal = true) AND NOT EXISTS (SELECT m FROM r.menus m WHERE m.isGlobal = true)")
    public Optional<Role> findSpaceRole(@Param(value="id") String var1);

    @Query(value="SELECT r FROM Role r LEFT JOIN FETCH r.menus WHERE r.id = :roleId")
    public Optional<Role> findByIdWithMenus(@Param(value="roleId") String var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE r.id in :roleIds AND NOT EXISTS (SELECT p FROM r.permissions p WHERE p.isGlobal = true) AND NOT EXISTS (SELECT m FROM r.menus m WHERE m.isGlobal = true)")
    public List<Role> findAllSpaceRolesByIds(@Param(value="roleIds") Set<String> var1);

    @Query(value="SELECT DISTINCT r FROM Role r LEFT JOIN FETCH r.permissions LEFT JOIN FETCH r.menus WHERE r.id IN :roleIds OR r.name IN :roleNames")
    public List<Role> findByIdInOrNameIn(@Param(value="roleIds") Set<String> var1, @Param(value="roleNames") Set<String> var2);
}

