/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.user.model.Role;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="permissions")
@AttributeOverride(name="id", column=@Column(name="permission_id", length=36, nullable=false, updatable=false))
public class Permission
extends SpaceBaseModel {
    @Column(nullable=false)
    private String name;
    @Column(name="is_global", nullable=false)
    private Boolean isGlobal = 3 >> 2;
    @JsonIgnore
    @ManyToMany(mappedBy="permissions")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Role> roles;

    public Set<Role> getRoles() {
        Permission a;
        return a.roles;
    }

    public void setName(String string) {
        Object a = string;
        Permission a2 = this;
        a2.name = a;
    }

    public void setIsGlobal(Boolean bl) {
        Object a = bl;
        Permission a2 = this;
        a2.isGlobal = a;
    }

    public String getName() {
        Permission a;
        return a.name;
    }

    @JsonIgnore
    public boolean isSpaceScoped() {
        Permission a;
        if (!a.isGlobal() && a.getSpace() != null) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public int hashCode() {
        Permission a;
        Object[] objectArray = new Object[5 >> 1];
        objectArray[2 & 5] = super.hashCode();
        objectArray[2 ^ 3] = a.getName();
        return Objects.hash(objectArray);
    }

    @JsonIgnore
    public boolean isGlobal() {
        Permission a;
        return Boolean.TRUE.equals(a.isGlobal);
    }

    public Permission() {
        Permission a;
        Permission permission = a;
        a.roles = new HashSet();
    }

    public Boolean getIsGlobal() {
        Permission a;
        return a.isGlobal;
    }

    public void setRoles(Set<Role> set) {
        Object a = set;
        Permission a2 = this;
        a2.roles = a;
    }

    public boolean equals(Object object) {
        Permission a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof Permission)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        return Objects.equals(a.name, object2.name);
    }
}

