/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.auth.model.AuthAttemptFilter;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.datasource.sql.restcontrollers.CustomSqlDatabaseController;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String FILE_STORAGE_ERROR = "File Storage Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String DATABASE_ERROR = "Database Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String SETTINGS_ERROR = "Settings Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private final Environment environment;
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String INSCADA_ERROR = "Inscada Error";

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)AuthAttemptFilter.m_efa((Object)"}}"), (Iterable)a.getValue())).collect(Collectors.joining(AuthAttemptFilter.m_efa((Object)"}-}")));
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getName();
        objectArray[2 ^ 3] = a.getValue();
        objectArray[5 >> 1] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : CustomSqlDatabaseController.m_Nq((Object)"&q8q<h=");
        String string = AuthAttemptFilter.m_efa((Object)"\u0001<#<<8%8#}vx\"zq*8)9}'<=(4}vx\"zq>>(=9q3>)q?4}22?+4/%85}%2q)(-4}vx\"z").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(AuthAttemptFilter.m_efa((Object)"\u00183%8#301q8#/>/k}* "), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return CustomSqlDatabaseController.m_Nq((Object)"o2k;0&q8q<h=");
        }
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return CustomSqlDatabaseController.m_Nq((Object)"Q<?>z l2x6?2i2v?~1s6");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return CustomSqlDatabaseController.m_Nq((Object)"Q<?>z l2x6?2i2v?~1s6");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(AuthAttemptFilter.m_efa((Object)"61>?01"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(CustomSqlDatabaseController.m_Nq((Object)"I2s:{2k:p=?6m!p!%sd."), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return 5 >> 3;
        }
        return Arrays.asList(a).contains(CustomSqlDatabaseController.m_Nq((Object)"7z%"));
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[3 ^ 3] = generalExceptionHandler2.getParameterName();
        objectArray[3 >> 1] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, AuthAttemptFilter.m_efa((Object)"\u000f4,$4#85}!<#<<8%8#}vx\"zq27}%$!8qzt.v}8.q08.\"4?:").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(CustomSqlDatabaseController.m_Nq((Object)"\u001ev l:q4?#~!~>z'z!%sd."), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return AuthAttemptFilter.m_efa((Object)"\u000f4.>(#>4}01#809(}4%8.%.");
        }
        if (a2 instanceof FileStorageException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u0015v?zsp#z!~'v<qsy2v?z7");
        }
        if (a2 instanceof MismatchException) {
            return AuthAttemptFilter.m_efa((Object)"\u000f4.>(#>4}<4\"00)25");
        }
        if (a2 instanceof NotActiveException) {
            return CustomSqlDatabaseController.m_Nq((Object)"M6l<j!|6?:lsq<ks~0k:i6");
        }
        if (a2 instanceof NotFoundException) {
            return AuthAttemptFilter.m_efa((Object)"\u00038\"2$/28q3>)q;>(?9");
        }
        if (a2 instanceof RelationExistsException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u0001z?~'z7?!z p&m0zsz+v k ");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return AuthAttemptFilter.m_efa((Object)"\u00038\"2$/28q*0.q(!90)49q?(}03>)98#}$.4/");
        }
        if (a2 instanceof SmsProviderException) {
            return CustomSqlDatabaseController.m_Nq((Object)"L\u001eLsl6m%v0zsp#z!~'v<qsy2v?z7");
        }
        if (a2 instanceof SettingsException) {
            return AuthAttemptFilter.m_efa((Object)"\u0010-!18>0)82?}\"8%)836.q8#/>/");
        }
        if (a2 instanceof ParsingException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u001aq%~?v7?7~'~sy<m>~'");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return AuthAttemptFilter.m_efa((Object)"\u0014?)4/?<=}'<=45<%4>3q>>3746(#<%4>3q8#/>/");
        }
        if (a2 instanceof BrowseOperationException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u0012qsz!m<msp0|&m!z7?7j!v=xs~s}!p$l6?<o6m2k:p=");
        }
        if (a2 instanceof SetValueException) {
            return AuthAttemptFilter.m_efa((Object)"\u001c?}4/#2#}>>2(#/49q*94=8q.4)%4?:q<q+01$8");
        }
        if (a2 instanceof CommunicationException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u0010p>r&q:|2k:p=?0p=y:x&m2k:p=?6m!p!");
        }
        if (a2 instanceof RunAsExecutionException) {
            return AuthAttemptFilter.m_efa((Object)"\u001c?}83%8#301q2!8#<%4>3q;04=85}5(#4?:q8)82(%4>3");
        }
        if (a2 instanceof SpaceOperationException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u0000o2|6?<o6m2k:p=?5~:s6{s{&zsk<?2?1j v=z lsm&s6?%v<s2k:p=");
        }
        if (a2 instanceof ImportExportException) {
            return AuthAttemptFilter.m_efa((Object)"\u001c?}4/#2#}>>2(#/49q9$/836}5<%<q4<->/%r4%!2#)");
        }
        if (a2 instanceof ReportGenerationException) {
            return CustomSqlDatabaseController.m_Nq((Object)"^=?6m!p!?<|0j!m6{s{&m:q4?!z#p!ksx6q6m2k:p=");
        }
        if (a2 instanceof ReportSchedulingException) {
            return AuthAttemptFilter.m_efa((Object)"\u00103q8#/>/q22>$/#85}5(#4?:q/4->/%}\">985(=4?:");
        }
        if (a2 instanceof BroadcastOperationException) {
            return CustomSqlDatabaseController.m_Nq((Object)"^=?6m!p!?<|0j!m6{s{&m:q4?2?1m<~7|2l'?<o6m2k:p=");
        }
        if (a2 instanceof AuthTokenException) {
            return AuthAttemptFilter.m_efa((Object)"\u00103q<$)98?)8>0)82?}%2:8?}4/#2#}>>2(#/49");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u0017~'~1~ zs|<q k!~:q'?%v<s2k:p=");
        }
        if (a2 instanceof TransactionSystemException) {
            return AuthAttemptFilter.m_efa((Object)"\u0015<%<3<\"8q)#<?.0>%4>3q8#/>/");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return CustomSqlDatabaseController.m_Nq((Object)"K:r6? z!v6ls{2k2}2l6?6m!p!");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return AuthAttemptFilter.m_efa((Object)"\u001c2>4.\"}58?449");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u001aq%~?v7?:q#j'");
        }
        if (a2 instanceof ConstraintViolationException) {
            return AuthAttemptFilter.m_efa((Object)"\u000b01890)82?}22?.%/04?)q+82=<%4>3");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return CustomSqlDatabaseController.m_Nq((Object)"V=i2s:{sm6n&z ksy<m>~'");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return AuthAttemptFilter.m_efa((Object)"\u001c4\".836}#8 (8/49q-0/004)4/");
        }
        if (a2 instanceof IllegalStateException) {
            return CustomSqlDatabaseController.m_Nq((Object)"\u001aq%~?v7?2o#s:|2k:p=? k2k6");
        }
        return AuthAttemptFilter.m_efa((Object)"\u00103q(?8)-4>%85}4/#2#}>>2(#/49");
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(AuthAttemptFilter.m_efa((Object)"\u001c8\".0:4}?2%}#8090?=8k}* "), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        void status;
        GeneralExceptionHandler generalExceptionHandler = object2;
        Object object2 = object;
        GeneralExceptionHandler body = generalExceptionHandler;
        object2 = body.createExceptionDetails((HttpStatusCode)status, ex.getMessage(), (Exception)ex, UNKNOWN_ERROR);
        log.error(CustomSqlDatabaseController.m_Nq((Object)"V=k6m=~??6m!p!%sd."), object2, (Object)ex);
        return new ResponseEntity(object2, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : CustomSqlDatabaseController.m_Nq((Object)"\u0016g0z#k:p=");
        Object object2 = a6.isDevelopment() ? a3 : AuthAttemptFilter.m_efa((Object)"\u0018#/>/");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, AuthAttemptFilter.m_efa((Object)"\u000558.q/4>>/5}&<\"}$-5<%85}3$q<?2%54/q(\"8#sq\r=80.4}#87/4.9}(2$/q90)0}035}%/(}0:04?s"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(CustomSqlDatabaseController.m_Nq((Object)"\\<q k!~:q'?%v<s2k:p=%sd."), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }
}

