/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.auth.c_hJ;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.job.m.c_Sc;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.log.o.c_nA;
import com.inscada.mono.project.o.c_D;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.report.m.c_TB;
import com.inscada.mono.report.m.c_aA;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSummary;
import com.inscada.mono.report.o.c_FC;
import com.inscada.mono.report.o.c_hd;
import com.inscada.mono.report.services.c_Qb;
import com.inscada.mono.report.services.c_vC;
import com.inscada.mono.settings.restcontrollers.MapSettingsController;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
implements ClusterNodeListener,
c_D {
    public static final short f_RF = 502;
    private final c_Qb f_OF;
    public static final short f_zF = 507;
    public static final short f_Kf = 501;
    private static final Logger f_HE = LoggerFactory.getLogger(ReportManager.class);
    private static final String f_hg = "scheduledReports";
    private final c_hJ f_vf;
    public static final short f_Ge = 505;
    private final c_Sc f_NF;
    public static final short f_de = 506;
    public static final short f_mD = 504;
    private final c_vC f_zd;
    private final Map<String, List<Job>> f_nF;
    private final c_nA f_ae;
    private final JedisPooled f_NE;
    private final c_K f_iD;
    public static final short f_vC = 503;
    private final Lock f_OC;

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_NF.m_xo(a.getProject(), "Report Mail - " + a.getName(), () -> a2.lambda$scheduleDailyMailReportJob$8((Report)a), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    protected void scheduleReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_vf.m_Ifa(() -> a2.lambda$scheduleReportInternal$4((Report)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$4(Report var1_2) {
        a = var1_2;
        a = this;
        a.f_OC.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal((Report)a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new NotActiveException("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_TB.f_bD ? a.scheduleMonthlyPrintReportJob((Report)a) : a.scheduleDailyPrintReportJob((Report)a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.f_NF.m_yj(var5_7);
                            }
                            throw new ReportSchedulingException(FileDownloadResult.m_wN((Object)"(}\u0007p\u000bxNh\u0001<\u001d\u007f\u0006y\ni\u0002yNn\u000bl\u0001n\u001a"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_TB.f_bD) break block12;
                    v1 = a.scheduleMonthlyMailReportJob((Report)a);
                    ** GOTO lbl30
                }
                v1 = a.scheduleDailyMailReportJob((Report)a);
lbl30:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.f_nF.put(a.getId(), var2_3);
            v3 = new String[3 >> 1];
            v3[2 & 5] = a.getId();
            v2.f_NE.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.f_OC.unlock();
        }
    }

    @TransactionalEventListener(value={c_hd.class})
    public void handleRescheduleEvent(c_hd c_hd2) {
        ReportManager reportManager = this;
        if (reportManager.f_iD.m_Ka()) {
            ReportManager a = a.m_kL();
            f_HE.info(FileDownloadResult.m_wN((Object)"P+]*Y<&NT\u000fr\np\u0007r\t<<y\u001d\u007f\u0006y\ni\u0002y+j\u000br\u001a<\bs\u001c<\u001cy\u001es\u001chT<\u0015aN4'XT<\u0015aG"), (Object)a.getName(), (Object)a.getId());
            if (reportManager.getReportStatusInternal(a.getId()) == c_aA.f_hf) {
                reportManager.scheduleReportInternal(a.getId());
                return;
            }
        } else {
            f_HE.debug(MapSettingsController.m_VD((Object)"7\u00077e5\r8\f<\u001aCh0/\u0017'\u000b!\u0017/Y\u001a\u001c;\u001a \u001c,\f$\u001c\r\u000f-\u0017<Y.\u0016:Y:\u001c8\u0016:\rrY3\u0004"), (Object)a.m_kL().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyPrintReportJob$7(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0x3F & 0x4B, a.getReportTime().getHours());
        ((Calendar)object2).set(0xE & 0x7D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x5F & 0x2D, a.getReportTime().getSeconds());
        calendar.set(0x7E & 0xF, 3 & 4);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_OF.m_bj(a.getId(), date, (Date)a2, 3 >> 1, a.getLang());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(FileDownloadResult.m_wN((Object)"\"Y/X+NT<=\u007f\u0006y\ni\u0002u\u0000{Nn\u000bl\u0001n\u001a<\u0015aNp\u0001\u007f\u000fp\u0002e@"), a);
            a2.scheduleReportInternal((String)a);
            return;
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"\u00066\u0006T\u0004<\t=\r+rY\u001a\u001c9\f-\n<\u0010&\u001eh\u0015-\u0018,\u001c:Y<\u0016h\n+\u0011-\u001d=\u0015-Y:\u001c8\u0016:\rh\u00025W"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = a;
            a2.f_iD.m_v(Short.valueOf((short)(0x77F7 & 0x9FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule report " + (String)a, (Throwable)exception);
        }
    }

    protected c_aA getReportStatusInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_nF.containsKey(a)) {
            return c_aA.f_hf;
        }
        return c_aA.f_wF;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyPrintReportJob$5(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x1B & 0x6F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x1F & 0x6C, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x7D & 0xF, a.getReportTime().getSeconds());
        calendar.set(0x4F & 0x3E, 3 ^ 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(5 >> 1, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_OF.m_bj(a.getId(), date, (Date)a2, (2 ^ 3) != 0, a.getLang());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_aA getReportStatus(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(MapSettingsController.m_VD((Object)"5\r8\f<\u001aCh>-\r<\u0010&\u001eh\u000b-\t'\u000b<Y;\r)\r=\nh\u001f'\u000bh0\fCh\u00025Y$\u0016+\u0018$\u00151W"), a);
            return a2.getReportStatusInternal((String)a);
        }
        f_HE.debug(FileDownloadResult.m_wN((Object)" S 1\"Y/X+NT<<y\u001fi\u000bo\u001au\u0000{Np\u000b}\ny\u001c<\bs\u001c<\u001cy\u001es\u001chNo\u001a}\u001ai\u001d<\bs\u001c<'XT<\u0015a@"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (c_aA)a2.f_iD.m_v(Short.valueOf((short)(0x3FF7 & 0x41FF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report transfer status for " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(FileDownloadResult.m_wN((Object)"P+]*Y<&N_\u000fr\ry\u0002p\u0007r\t<\u000fp\u0002<\u001cy\u001es\u001ch\u001d<\bs\u001c<\u001en\u0001v\u000b\u007f\u001a<\u0015aNp\u0001\u007f\u000fp\u0002e@"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"7\u00077e5\r8\f<\u001aCh+-\b=\u001c;\r!\u0017/Y$\u001c)\u001d-\u000bh\r'Y+\u0018&\u001a-\u0015h\u0018$\u0015h\u000b-\t'\u000b<\nh\u001f'\u000bh\t:\u0016\"\u001c+\rh\u00025W"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_iD.m_v(Short.valueOf((short)(0x67FB & 0x19FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel reports for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(FileDownloadResult.m_wN((Object)"\"Y/X+NT<-}\u0000\u007f\u000bp\u0002u\u0000{Nn\u000bl\u0001n\u001a<\u0015aNp\u0001\u007f\u000fp\u0002e@"), a);
            a2.cancelReportInternal((String)a);
            return;
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"\u00066\u0006T\u0004<\t=\r+rY\u001a\u001c9\f-\n<\u0010&\u001eh\u0015-\u0018,\u001c:Y<\u0016h\u001a)\u0017+\u001c$Y:\u001c8\u0016:\rh\u00025W"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            a2.f_iD.m_v(Short.valueOf((short)(0x23F6 & 0x5DFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel report " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyMailReportJob$8(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0x7F & 0xB, a.getReportTime().getHours());
        ((Calendar)object2).set(0x3C & 0x4F, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x5D & 0x2F, a.getReportTime().getSeconds());
        calendar.set(0x4E & 0x3F, 3 >> 2);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_OF.m_Ei(a.getId(), date, (Date)a2, --1 != 0, a.getLang());
    }

    protected void scheduleReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.scheduleReportInternal(reportManager.f_zd.m_uH((String)a2));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ReportManager reportManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[5 >> 3] = String.class;
            reportManager.f_iD.m_t((short)(0x5F5 & 0x7BFF), (Object)reportManager, ReportManager.class.getDeclaredMethod(MapSettingsController.m_VD((Object)";\u001a \u001c,\f$\u001c\u001a\u001c8\u0016:\r\u0001\u0017<\u001c:\u0017)\u0015"), classArray));
            Class[] classArray2 = new Class[4 ^ 5];
            classArray2[3 & 4] = String.class;
            reportManager.f_iD.m_t((short)(0x4DFE & 0x33F7), (Object)reportManager, ReportManager.class.getDeclaredMethod(FileDownloadResult.m_wN((Object)"\u007f\u000fr\ry\u0002N\u000bl\u0001n\u001aU\u0000h\u000bn\u0000}\u0002"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 & 4] = String.class;
            reportManager.f_iD.m_t((short)(0x31FF & 0x4FF7), (Object)reportManager, ReportManager.class.getDeclaredMethod(MapSettingsController.m_VD((Object)"\u001e-\r\u001a\u001c8\u0016:\r\u001b\r)\r=\n\u0001\u0017<\u001c:\u0017)\u0015"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 & 4] = String.class;
            reportManager.f_iD.m_t((short)(0x29FF & 0x57F8), (Object)reportManager, ReportManager.class.getDeclaredMethod(FileDownloadResult.m_wN((Object)"o\rt\u000bx\u001bp\u000bN\u000bl\u0001n\u001ao,e>n\u0001v\u000b\u007f\u001aU\nU\u0000h\u000bn\u0000}\u0002"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 ^ 3] = String.class;
            reportManager.f_iD.m_t((short)(0x7DFD & 0x3FB), (Object)reportManager, ReportManager.class.getDeclaredMethod(MapSettingsController.m_VD((Object)"+\u0018&\u001a-\u0015\u001a\u001c8\u0016:\r;;1):\u0016\"\u001c+\r\u0001\u001d\u0001\u0017<\u001c:\u0017)\u0015"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            reportManager.f_iD.m_t((short)(0x69FB & 0x17FE), (Object)reportManager, ReportManager.class.getDeclaredMethod(FileDownloadResult.m_wN((Object)"{\u000bh<y\u001es\u001ch=h\u000fh\u001bo\u000bo,e'x\u001dU\u0000h\u000bn\u0000}\u0002"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            reportManager.f_iD.m_t((short)(0x1FB & Short.MAX_VALUE), (Object)reportManager, ReportManager.class.getDeclaredMethod(MapSettingsController.m_VD((Object)"/\u001c<+-\t'\u000b<*<\u0018<\f;\u001c;;1):\u0016\"\u001c+\r\u0001\u001d\u0001\u0017<\u001c:\u0017)\u0015"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(FileDownloadResult.m_wN((Object)"Z\u000fu\u0002y\n<\u001asNn\u000b{\u0007o\u001ay\u001c<<y\u001es\u001ch#}\u0000}\ty\u001c<<L-<\u0003y\u001at\u0001x\u001d"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_aA> getReportStatuses(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(FileDownloadResult.m_wN((Object)"\"Y/X+NT<)y\u001ah\u0007r\t<\u000fp\u0002<\u001cy\u001es\u001chNo\u001a}\u001ai\u001dy\u001d<\bs\u001c<\u001en\u0001v\u000b\u007f\u001a<\u0015aNp\u0001\u007f\u000fp\u0002e@"), a);
            return a2.getReportStatusesByProjectIdInternal((String)a);
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"7\u00077e5\r8\f<\u001aCh+-\b=\u001c;\r!\u0017/Y$\u001c)\u001d-\u000bh\u001f'\u000bh\u0018$\u0015h\u000b-\t'\u000b<Y;\r)\r=\n-\nh\u001f'\u000bh\t:\u0016\"\u001c+\rh\u00025W"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_iD.m_v(Short.valueOf((short)(0x1DFF & 0x63FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.cancelReport(reportManager.f_zd.m_oH((String)a, (String)a3).getId());
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_NF.m_co(a.getProject(), "Report Print - " + a.getName(), () -> a2.lambda$scheduleMonthlyPrintReportJob$5((Report)a), (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_iD.m_La();
        f_HE.info(MapSettingsController.m_VD((Object)"+-\t'\u000b<4)\u0017)\u001e-\u000brY\u001c\u0011!\nh\u0017'\u001d-Y`\u00025Ph\u0011)\nh\u001b-\u001a'\u0014-Y<\u0011-Y\u0004<\t=\r+fY\u001a\u001c;\r'\u000b!\u0017/Y;\u001a \u001c,\f$\u001c,Y:\u001c8\u0016:\r;WfW"), a);
        reportManager2.f_OC.lock();
        try {
            HashSet hashSet = new HashSet(reportManager.f_NE.smembers(f_hg));
            if (hashSet.isEmpty()) {
                f_HE.info(FileDownloadResult.m_wN((Object)"N\u000bl\u0001n\u001aQ\u000fr\u000f{\u000bnN4\"y\u000fx\u000bnNg\u00135T< sNo\rt\u000bx\u001bp\u000bxNn\u000bl\u0001n\u001aoNz\u0001i\u0000xNu\u0000<<y\nu\u001d<\u001asNn\u000bo\u001as\u001cy@"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_HE.info(MapSettingsController.m_VD((Object)"\u001a\u001c8\u0016:\r\u0005\u0018&\u0018/\u001c:Y`5-\u0018,\u001c:Y3\u0004aCh?'\f&\u001dh\u00025Y;\u001a \u001c,\f$\u001c,Y:\u001c8\u0016:\rh0\f\nh\u0010&Y\u001a\u001c,\u0010;Y<\u0016h\u000b-\n<\u0016:\u001crY3\u0004"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[3 >> 2] = FileDownloadResult.m_wN((Object)"J'Y9C<Y>S<H1U:Y#");
            reportManager.f_vf.m_nDa(() -> {
                void a;
                Object a2 = hashSet;
                ReportManager a3 = this;
                a.addAll(a3.f_zd.m_uh((Set)a2));
            }, stringArray);
            f_HE.info(MapSettingsController.m_VD((Object)"\u001a\u001c8\u0016:\r\u0005\u0018&\u0018/\u001c:Y`5-\u0018,\u001c:Y3\u0004aCh8<\r-\u00148\r!\u0017/Y<\u0016h\u000b-\n<\u0016:\u001ch\u00025Y:\u001c8\u0016:\r;W"), a, (Object)arrayList.size());
            arrayList.forEach(report -> {
                void a;
                ReportManager reportManager;
                ReportManager reportManager2 = reportManager = this;
                Object a2 = reportManager2.f_iD.m_La();
                String[] stringArray = new String[--2];
                stringArray[3 ^ 3] = FileDownloadResult.m_wN((Object)"=_&Y*I\"Y1N+L!N:");
                stringArray[5 >> 2] = MapSettingsController.m_VD((Object)":\t7\u000b<\u0004&\u001a<\u00186\u001a-");
                reportManager2.f_vf.m_oda(() -> reportManager.lambda$restoreSingleReportOnLeader$1((String)a2, (Report)a), a.getSpace(), stringArray);
            });
            f_HE.info(FileDownloadResult.m_wN((Object)"<y\u001es\u001ch#}\u0000}\ty\u001c<FP\u000b}\ny\u001c<\u0015aG&NZ\u0007r\u0007o\u0006y\n<\u001cy\u001es\u001chNn\u000bo\u001as\u001c}\u001au\u0001rNl\u001cs\ry\u001do@"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_HE.error(MapSettingsController.m_VD((Object)"\u001a\u001c8\u0016:\r\u0005\u0018&\u0018/\u001c:Y`5-\u0018,\u001c:Y3\u0004aCh<:\u000b'\u000bh\u001d=\u000b!\u0017/Y:\u001c8\u0016:\rh\u000b-\n<\u0016:\u0018<\u0010'\u0017h\t:\u0016+\u001c;\nrY3\u0004"), objectArray);
            return;
        }
        finally {
            reportManager.f_OC.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleReportOnLeader$1(String string, Report report) {
        void a;
        ReportManager a2 = report;
        ReportManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[2 ^ 3] = a2.getName();
            objectArray[--2] = a2.getId();
            f_HE.info(MapSettingsController.m_VD((Object)"\u001a\u001c8\u0016:\r\u0005\u0018&\u0018/\u001c:Y`5-\u0018,\u001c:Y3\u0004aCh+-\n<\u0016:\u0010&\u001eh\u000b-\t'\u000b<Ch\u00025Y`0\fCh\u00025P"), objectArray);
            a3.scheduleReportInternal((Report)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a2.getName();
            objectArray[5 >> 2] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_ae.m_IL(a2.getProject()).m_q("Report Restore (Leader " + (String)a + ")", FileDownloadResult.m_wN((Object)"9\u001d<FU*&N9\u001d5Nz\u000fu\u0002y\n<\u001asNn\u000bo\u001as\u001cy@<-}\u001bo\u000b&N9\u001d").formatted(objectArray));
            try {
                f_HE.warn(MapSettingsController.m_VD((Object)"\u001a\u001c8\u0016:\r\u0005\u0018&\u0018/\u001c:Y`5-\u0018,\u001c:Y3\u0004aCh8<\r-\u00148\r!\u0017/Y<\u0016h\u001a)\u0017+\u001c$Y:\u001c8\u0016:\rh\u00025Y)\u001f<\u001c:Y:\u001c;\r'\u000b)\r!\u0016&Y.\u0018!\u0015=\u000b-W"), (Object)a, (Object)a2.getId());
                a3.cancelReportInternal((Report)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[2 ^ 3] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_HE.error(FileDownloadResult.m_wN((Object)"<y\u001es\u001ch#}\u0000}\ty\u001c<FP\u000b}\ny\u001c<\u0015aG&NZ\u000fu\u0002y\n<\u001asN\u007f\u000fr\ry\u0002<\u001cy\u001es\u001chNg\u0013<\u000fz\u001ay\u001c<\u001cy\u001dh\u0001n\u000fh\u0007s\u0000<\b}\u0007p\u001bn\u000b&Ng\u0013"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReportManager(c_vC c_vC2, c_Sc c_Sc2, c_Qb c_Qb2, c_nA c_nA2, JedisPooled jedisPooled, c_K c_K2, c_hJ c_hJ2) {
        ReportManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReportManager a8;
        ReportManager reportManager = reportManager2;
        ReportManager reportManager2 = c_hJ2;
        ReportManager reportManager3 = a8 = reportManager;
        ReportManager reportManager4 = a8;
        ReportManager reportManager5 = a8;
        ReportManager reportManager6 = a8;
        ReportManager reportManager7 = a8;
        reportManager6.f_OC = new ReentrantLock();
        reportManager6.f_nF = new ConcurrentHashMap();
        reportManager6.f_zd = a7;
        reportManager5.f_NF = a6;
        reportManager5.f_OF = a5;
        reportManager4.f_ae = a4;
        reportManager4.f_NE = a3;
        reportManager3.f_iD = a2;
        reportManager3.f_vf = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyMailReportJob$6(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x2F & 0x5B, a.getReportTime().getHours());
        ((Calendar)object2).set(0x7F & 0xC, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x3F & 0x4D, a.getReportTime().getSeconds());
        calendar.set(0xE & 0x7F, 2 & 5);
        a2 = ((Calendar)object).getTime();
        calendar.add(--2, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_OF.m_Ei(a.getId(), date, (Date)a2, (2 ^ 3) != 0, a.getLang());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(FileDownloadResult.m_wN((Object)"P+]*Y<&NO\rt\u000bx\u001bp\u0007r\t<\u000fp\u0002<\u001cy\u001es\u001ch\u001d<\bs\u001c<\u001en\u0001v\u000b\u007f\u001a<\u0015aNp\u0001\u007f\u000fp\u0002e@"), a);
            a2.scheduleReportsByProjectIdInternal((String)a);
            return;
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"7\u00077e5\r8\f<\u001aCh+-\b=\u001c;\r!\u0017/Y$\u001c)\u001d-\u000bh\r'Y;\u001a \u001c,\f$\u001ch\u0018$\u0015h\u000b-\t'\u000b<\nh\u001f'\u000bh\t:\u0016\"\u001c+\rh\u00025W"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_iD.m_v(Short.valueOf((short)(0x75FA & 0xBFD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule reports for project " + (String)a, (Throwable)exception);
        }
    }

    protected void cancelReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.cancelReportInternal(reportManager.f_zd.m_uH((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ReportManager reportManager = this;
        List a22 = (List)reportManager.f_nF.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_HE.info(MapSettingsController.m_VD((Object)"+-\t'\u000b<4)\u0017)\u001e-\u000bhQ\u0006\u0016<Y\u0004\u001c)\u001d-\u000bh\u00025PrY\u000b\u0018&\u001a-\u0015$\u0010&\u001eh\u0015'\u001a)\u0015h\u0013'\u001bh\u001f'\u000bh\u000b-\t'\u000b<Y\u0001=rY3\u0004"), (Object)a3, (Object)a);
                a22.forEach(arg_0 -> ((c_Sc)reportManager.f_NF).m_yj(arg_0));
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[4 ^ 5] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_HE.error(FileDownloadResult.m_wN((Object)"N\u000bl\u0001n\u001aQ\u000fr\u000f{\u000bnN4 s\u001a<\"y\u000fx\u000bnNg\u00135T<+n\u001cs\u001c<\r}\u0000\u007f\u000bp\u0002u\u0000{Np\u0001\u007f\u000fpNv\u0001~Nz\u0001nNn\u000bl\u0001n\u001a<'XNg\u0013&Ng\u0013"), objectArray);
            }
        }
    }

    protected Map<String, c_aA> getReportStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.scheduleReport(reportManager.f_zd.m_oH((String)a, (String)a3).getId());
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_NF.m_co(a.getProject(), "Report Mail - " + a.getName(), () -> a2.lambda$scheduleMonthlyMailReportJob$6((Report)a), (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    protected void cancelReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_zd.m_BI((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    protected Map<String, c_aA> getReportStatusesByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_zd.m_Ji((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ReportSummary::getId, reportSummary -> {
            ReportManager a = reportSummary;
            ReportManager a2 = this;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_iD.m_Ka()) {
            f_HE.info(FileDownloadResult.m_wN((Object)"P+]*Y<&NT\u000fr\np\u0007r\t<>n\u0001v\u000b\u007f\u001aX\u000b}\rh\u0007j\u000fh\u000bY\u0018y\u0000hNz\u0001nNl\u001cs\u0004y\rhNU*&Ng\u0013"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"\u00066\u0006T\u0004<\t=\r+rY\u0001\u001e&\u0016:\u0010&\u001eh):\u0016\"\u001c+\r\f\u001c)\u001a<\u0010>\u0018<\u001c\r\u000f-\u0017<Y.\u0016:Y8\u000b'\u0013-\u001a<Y\u0001=rY3\u0004"), a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_aA> getReportStatuses(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_iD.m_Ka()) {
            f_HE.debug(MapSettingsController.m_VD((Object)"\u0004<\t=\r+rY\u000f\u001c<\r!\u0017/Y:\u001c8\u0016:\rh\n<\u0018<\f;\u001c;Y.\u0016:Y3\u0004h0\f\nh\u0015'\u001a)\u0015$\u0000rY3\u0004"), (Object)a.size(), (Object)a);
            return a2.getReportStatusesByIdsInternal((List)a);
        }
        f_HE.debug(FileDownloadResult.m_wN((Object)"R!RCP+]*Y<&NN\u000bm\u001by\u001dh\u0007r\t<\u0002y\u000fx\u000bnNz\u0001nNn\u000bl\u0001n\u001a<\u001dh\u000fh\u001bo\u000boNz\u0001nNg\u0013<'X\u001d&Ng\u0013"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = new ArrayList(a);
            return (Map)a2.f_iD.m_v(Short.valueOf((short)(0x35FE & 0x4BFB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(MapSettingsController.m_VD((Object)"U"))), (Throwable)exception);
        }
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_NF.m_xo(a.getProject(), "Report Print - " + a.getName(), () -> a2.lambda$scheduleDailyPrintReportJob$7((Report)a), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    public void notLeader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_iD.m_La();
        f_HE.info(FileDownloadResult.m_wN((Object)"N\u000bl\u0001n\u001aQ\u000fr\u000f{\u000bnT<:t\u0007oNr\u0001x\u000b<Fg\u00135Nu\u001d< SNP!R)Y<<:T+<\"Y/X+N@<-}\u0000\u007f\u000bp\u0002u\u0000{N}\u0002pNp\u0001\u007f\u000fpNn\u000bl\u0001n\u001a<\u0004s\fo@2@"), a);
        reportManager2.f_OC.lock();
        try {
            new ArrayList(reportManager.f_nF.keySet()).forEach(arg_0 -> reportManager.lambda$notLeader$2((String)a, arg_0));
            reportManager.f_nF.clear();
            f_HE.info(MapSettingsController.m_VD((Object)"+-\t'\u000b<4)\u0017)\u001e-\u000bhQ\u0006\u0016<Y\u0004\u001c)\u001d-\u000bh\u00025PrY\t\u0015$Y$\u0016+\u0018$Y:\u001c8\u0016:\rh\u0013'\u001b;Y \u0018>\u001ch\u001b-\u001c&Y:\u001c9\f-\n<\u001c,Y<\u0016h\u001a)\u0017+\u001c$Y)\u0017,Y+\u0015-\u0018:\u001c,Y.\u000b'\u0014h\u0015'\u001a)\u0015h\r:\u0018+\u0012!\u0017/W"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[--2] = exception;
            f_HE.error(FileDownloadResult.m_wN((Object)"<y\u001es\u001ch#}\u0000}\ty\u001c<FR\u0001hNP\u000b}\ny\u001c<\u0015aG&NY\u001cn\u0001nNx\u001bn\u0007r\t<\u001en\u0001\u007f\u000bo\u001d<\u0001zN\u007f\u000fr\ry\u0002p\u0007r\t<\u0002s\r}\u0002<\u001cy\u001es\u001chNv\u0001~\u001d&Ng\u0013"), objectArray);
            return;
        }
        finally {
            reportManager.f_OC.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        ReportManager reportManager = a;
        reportManager.registerRemoteCallsWithClusterNode();
        reportManager.f_iD.m_ba((ClusterNodeListener)a);
        f_HE.info(FileDownloadResult.m_wN((Object)"N\u000bl\u0001n\u001aQ\u000fr\u000f{\u000bnNu\u0000u\u001au\u000fp\u0007f\u000bxN}\u0000xNn\u000b{\u0007o\u001ay\u001cy\n<\u000foN_\u0002i\u001dh\u000bn s\ny\"u\u001dh\u000br\u000bn@"));
    }

    protected void scheduleReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_zd.m_BI((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    protected void cancelReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_vf.m_Ifa(() -> a2.lambda$cancelReportInternal$9((Report)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$cancelReportInternal$9(Report report) {
        ReportManager reportManager = this;
        reportManager.f_OC.lock();
        try {
            void a;
            Object a2 = (List)reportManager.f_nF.get(a.getId());
            if (a2 != null) {
                Object object = a2 = a2.iterator();
                while (object.hasNext()) {
                    Job job = (Job)a2.next();
                    object = a2;
                    reportManager.f_NF.m_yj(job);
                }
            }
            ReportManager reportManager2 = reportManager;
            reportManager2.f_nF.remove(a.getId());
            String[] stringArray = new String[3 & 5];
            stringArray[2 & 5] = a.getId();
            reportManager2.f_NE.srem(f_hg, stringArray);
            return;
        }
        finally {
            reportManager.f_OC.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_aA getReportStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ReportManager a3 = this;
        if ((a2 = a3.f_zd.m_WI((String)a2, (String)a)) == null) {
            return c_aA.f_wF;
        }
        return a3.getReportStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_FC.class})
    public void handleCancelEvent(c_FC c_FC2) {
        void a;
        ReportManager reportManager = this;
        if (reportManager.f_iD.m_Ka()) {
            ReportManager a2 = a.m_MK();
            f_HE.info(FileDownloadResult.m_wN((Object)"P+]*Y<&NT\u000fr\np\u0007r\t<-}\u0000\u007f\u000bp+j\u000br\u001a<\bs\u001c<\u001cy\u001es\u001chT<\u0015aN4'XT<\u0015aG"), (Object)a2.getName(), (Object)a2.getId());
            reportManager.cancelReportInternal((Report)a2);
            return;
        }
        f_HE.debug(MapSettingsController.m_VD((Object)"7\u00077e5\r8\f<\u001aCh0/\u0017'\u000b!\u0017/Y\u000b\u0018&\u001a-\u0015\r\u000f-\u0017<Y.\u0016:Y:\u001c8\u0016:\rrY3\u0004"), (Object)a.m_MK().getId());
    }
}

