/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.model.ReportVariable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="report_subgroup")
@AttributeOverride(name="id", column=@Column(name="report_subgroup_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"groupId", "reportGroup"})
public class ReportSubgroup
extends SpaceBaseModel {
    @NotNull
    @Min(value=1L)
    @Column(name="subgroup_order")
    private Short subgroupOrder;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="report_group_id")
    private ReportGroup reportGroup;
    @Size(max=255)
    @Column
    private String dsc;
    @JsonIgnore
    @OneToMany(mappedBy="reportSubgroup")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<ReportVariable> reportVariables;
    @Column(name="report_group_id", updatable=false, insertable=false)
    private String groupId;
    @NotBlank
    @Size(max=100)
    private String name;

    public Set<ReportVariable> getReportVariables() {
        ReportSubgroup a;
        return a.reportVariables;
    }

    public void setName(String string) {
        Object a = string;
        ReportSubgroup a2 = this;
        a2.name = a;
    }

    public Short getSubgroupOrder() {
        ReportSubgroup a;
        return a.subgroupOrder;
    }

    public void setReportGroup(ReportGroup reportGroup) {
        ReportSubgroup a;
        ReportSubgroup a2 = reportGroup;
        ReportSubgroup reportSubgroup = a = this;
        reportSubgroup.reportGroup = a2;
        reportSubgroup.groupId = a2 != null ? a2.getId() : null;
    }

    public String getName() {
        ReportSubgroup a;
        return a.name;
    }

    public ReportGroup getReportGroup() {
        ReportSubgroup a;
        return a.reportGroup;
    }

    public void setGroupId(String string) {
        Object a = string;
        ReportSubgroup a2 = this;
        a2.groupId = a;
    }

    public boolean equals(Object object) {
        ReportSubgroup a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof ReportSubgroup)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        if (a.getName().equals(object2.getName()) && a.getGroupId().equals(object2.getGroupId())) {
            return 5 >> 2;
        }
        return false;
    }

    public String getDsc() {
        ReportSubgroup a;
        return a.dsc;
    }

    public String getGroupId() {
        ReportSubgroup a;
        return a.groupId;
    }

    public ReportSubgroup() {
        ReportSubgroup a;
        ReportSubgroup reportSubgroup = a;
        reportSubgroup.reportVariables = new HashSet();
    }

    public void setReportVariables(Set<ReportVariable> set) {
        Object a = set;
        ReportSubgroup a2 = this;
        a2.reportVariables = a;
    }

    public void setDsc(String string) {
        Object a = string;
        ReportSubgroup a2 = this;
        a2.dsc = a;
    }

    public void setSubgroupOrder(Short s) {
        Object a = s;
        ReportSubgroup a2 = this;
        a2.subgroupOrder = a;
    }

    public int hashCode() {
        ReportSubgroup a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[4 ^ 5] = a.getName();
        objectArray[--2] = a.getGroupId();
        return Objects.hash(objectArray);
    }
}

