/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.job.model;

import com.inscada.mono.job.model.Job;
import com.inscada.mono.project.model.Project;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;

public abstract class Job {
    private final AtomicLong successCounter;
    private final Runnable runnable;
    private final AtomicLong failedCounter;
    private final DescriptiveStatistics durationStatistics;
    private final Project project;
    private final AtomicLong requestCounter;
    private final String name;

    public double getPercentageFailed() {
        Job a;
        if (a.requestCounter.get() == 0L) {
            return 0.0;
        }
        return (double)a.failedCounter.get() / (double)a.requestCounter.get() * 100.0;
    }

    public double getPercentageAboveThresholdDuration(long a) {
        Job a2;
        return a2.durationStatistics.apply((UnivariateStatistic)new PercentageAboveThreshold((double)a * 1000000.0));
    }

    public void succeed(long a) {
        Job a2;
        a2.successCounter.incrementAndGet();
        a2.durationStatistics.addValue((double)a);
    }

    public double getMinDuration() {
        Job a;
        return a.durationStatistics.getMin() * 1.0E-6;
    }

    public void requested() {
        Job a;
        a.requestCounter.incrementAndGet();
    }

    public long getRequestCount() {
        Job a;
        return a.requestCounter.get();
    }

    public Runnable getRunnable() {
        Job a;
        return a.runnable;
    }

    public void failed() {
        Job a;
        a.failedCounter.incrementAndGet();
    }

    public double getMaxDuration() {
        Job a;
        return a.durationStatistics.getMax() * 1.0E-6;
    }

    /*
     * WARNING - void declaration
     */
    protected Job(Project project, String string, Runnable runnable) {
        void a;
        void a2;
        Job a3;
        Object a4 = runnable;
        Job job = a3 = this;
        Job job2 = a3;
        Job job3 = a3;
        a3.requestCounter = new AtomicLong(0L);
        job3.successCounter = new AtomicLong(0L);
        job2.failedCounter = new AtomicLong(0L);
        job2.durationStatistics = new DescriptiveStatistics(0xFEB & 0x73FC);
        job2.project = a2;
        job.name = a;
        job.runnable = a4;
    }

    public String getName() {
        Job a;
        return a.name;
    }

    public Project getProject() {
        Job a;
        return a.project;
    }

    public long getFailCount() {
        Job a;
        return a.failedCounter.get();
    }

    public abstract String getType();

    public abstract String getSchedule();

    public double getMeanDuration() {
        Job a;
        return a.durationStatistics.getMean() * 1.0E-6;
    }

    public long getSuccessCount() {
        Job a;
        return a.successCounter.get();
    }
}

