/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_hJ;
import com.inscada.mono.auth.security.model.AuthDetails;
import com.inscada.mono.auth.services.otp.m.o.c_OJ;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.communication.base.m.c_VJ;
import com.inscada.mono.communication.base.m.c_uj;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_Aj;
import com.inscada.mono.communication.base.services.c_Ki;
import com.inscada.mono.communication.base.services.c_kh;
import com.inscada.mono.datatransfer.m.c_vc;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.o.c_Gd;
import com.inscada.mono.datatransfer.o.c_UA;
import com.inscada.mono.datatransfer.services.c_ib;
import com.inscada.mono.datatransfer.services.c_wA;
import com.inscada.mono.job.m.c_Sc;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.o.c_nA;
import com.inscada.mono.project.o.c_D;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_D {
    public static final short f_cI = 407;
    private final c_hJ f_Bi;
    private static final Logger f_ai = LoggerFactory.getLogger(DataTransferManager.class);
    private final c_Aj f_ej;
    private final c_Ki f_LG;
    private final c_ib f_MG;
    private final c_K f_Ji;
    public static final short f_UG = 404;
    private final c_kh f_vH;
    private final c_Sc f_Vh;
    public static final short f_ii = 403;
    public static final short f_ci = 402;
    private static final String f_mi = "scheduledDataTransfers";
    private final JedisPooled f_IG;
    private final Map<String, Job> f_bG;
    public static final short f_ah = 405;
    private final Lock f_YG;
    private final c_nA f_tH;
    public static final short f_Ki = 401;
    public static final short f_rh = 406;

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Ji.m_La();
        f_ai.info(AuthDetails.m_zda((Object)"V8f8F+s7a?w+_8|8u<`c2\rz0ay|6v<2qi$;y{*2\u0017]y^\u0016\\\u001eW\u000b2\rZ\u001c2\u0015W\u0018V\u001c@w2\u001as7q<~5{7uys5~y~6q8~yv8f82-`8|*t<`yx6p*<w<"), a);
        dataTransferManager2.f_YG.lock();
        try {
            new ArrayList(dataTransferManager.f_bG.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_bG.clear();
            f_ai.info(c_OJ.m_Xda((Object)"O+\u007f+_8j$x,n8F+e+l/yj#\u0004d>+\u0006n+o/yjp7\"p+\u000bg&+&d)j&+.j>jj\u007f8j$x,n8+ d(xjc+}/+(n/ejy/z?n9\u007f/oj\u007f%+)j$h/gjj$ojh&n+y/ojm8d'+&d)j&+>y+h!b$ld"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_ai.error(AuthDetails.m_zda((Object)"\u001ds-s\r`8|*t<`\u0014s7s>w+2q\\6fy^<s=w+2\"op(yW+`6`yv,`0|>2)`6q<a*26tyq8|:w5~0|>25}:s52=s-syf+s7a?w+23};ac2\"o"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_YG.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_OJ.m_Xda((Object)"<j&~/"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.info(AuthDetails.m_zda((Object)"\u0015W\u0018V\u001c@c2\u0011s7v5{7uyB+}3w:f\u001dw8q-{/s-w\u001cd<|-2?}+2)`6x<q-2\u0010Vc2\"o"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_ai.debug(c_OJ.m_Xda((Object)"E\u0005EgG\u000fJ\u000eN\u00181jB-e%y#e-+\u001ay%a/h>O/j)\u007f#}+\u007f/N<n$\u007fjm%yj{8d n)\u007fjB\u000e1jp7"), a);
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_MG.m_Cm((String)a2));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(AuthDetails.m_zda((Object)"^\u001cS\u001dW\u000b(yQ8|:w5~0|>28~52=s-syf+s7a?w+ayt6`yb+}3w:fyi$25}:s5~ <"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_ai.debug(c_OJ.m_Xda((Object)"E\u0005EgG\u000fJ\u000eN\u00181jY/z?n9\u007f#e-+&n+o/yj\u007f%+)j$h/gjj&gjo+\u007f++>y+e9m/y9+,d8+:y%a/h>+1vd"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            a2.f_Ji.m_v(Short.valueOf((short)(0x4BB5 & 0x35DF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_Ji.m_ba((ClusterNodeListener)a);
        f_ai.info(AuthDetails.m_zda((Object)"\u001ds-s\r`8|*t<`\u0014s7s>w+20|0f0s5{#w=28|=2+w>{*f<`<vys*2\u001a~,a-w+\\6v<^0a-w7w+<"));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_MG.m_Jm((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_bG.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_ai.info(AuthDetails.m_zda((Object)"\u001ds-s\r`8|*t<`\u0014s7s>w+2q\\6fy^<s=w+2\"op(yQ8|:w5~0|>25}:s523};2?}+2=s-syf+s7a?w+2\u0010Vc2\"o"), (Object)a3, (Object)a);
                dataTransferManager.f_Vh.m_yj((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 & 4] = a3;
                objectArray[5 >> 2] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_ai.error(c_OJ.m_Xda((Object)"\u000ej>j\u001ey+e9m/y\u0007j$j-n8+bE%\u007fjG/j.n8+1vc1jN8y%yjh+e)n&g#e-+&d)j&+ d(+,d8+.j>jj\u007f8j$x,n8+\u0003Ojp71jp7"), objectArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Gd.class})
    public void handleCancelEvent(c_Gd c_Gd2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Ji.m_Ka()) {
            DataTransferManager a2 = a.m_Zr();
            f_ai.info(AuthDetails.m_zda((Object)"^\u001cS\u001dW\u000b(yZ8|=~0|>2\u001as7q<~\u001cd<|-2?}+2=s-syf+s7a?w+(yi$2q[\u001d(yi$;"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_ai.debug(c_OJ.m_Xda((Object)"E\u0005EgG\u000fJ\u000eN\u00181jB-e%y#e-+\tj$h/g\u000f}/e>+,d8+.j>jj\u007f8j$x,n81jp7"), (Object)a.m_Zr().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Ji.m_La();
        f_ai.info(c_OJ.m_Xda((Object)"O+\u007f+_8j$x,n8F+e+l/yp+\u001ec#xje%o/+bp7\"jc+xji/h%f/+>c/+\u0006N\u000bO\u000fYd+\u0018n9\u007f%y#e-+9h\"n.~&n.+.j>jj\u007f8j$x,n8xd%d"), a);
        dataTransferManager2.f_YG.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_IG.smembers(f_mi));
            if (hashSet.isEmpty()) {
                f_ai.info(AuthDetails.m_zda((Object)"V8f8F+s7a?w+_8|8u<`y:\u0015w8v<`yi$;c2\u0017}ya:z<v,~<vyv8f82-`8|*t<`*2?},|=20|y@<v0ayf62+w*f6`<<"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_ai.info(c_OJ.m_Xda((Object)"\u000ej>j\u001ey+e9m/y\u0007j$j-n8+bG/j.n8+1vc1jM%~$ojp7+9h\"n.~&n.+.j>jj\u007f8j$x,n8+\u0003O9+#ejY/o#xj\u007f%+8n9\u007f%y/1jp7"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[2 & 5] = AuthDetails.m_zda((Object)"\u000f[\u001cE\u0006V\u0018F\u0018M\r@\u0018\\\nT\u001c@");
            dataTransferManager.f_Bi.m_nDa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_MG.m_jM((Set)a2));
            }, stringArray);
            f_ai.info(c_OJ.m_Xda((Object)"\u000ej>j\u001ey+e9m/y\u0007j$j-n8+bG/j.n8+1vc1jJ>\u007f/f:\u007f#e-+>djy/x>d8njp7+.j>jj\u007f8j$x,n8xd"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_Ji.m_La();
                String[] stringArray = new String[--2];
                stringArray[5 >> 3] = AuthDetails.m_zda((Object)"\nQ\u0011W\u001dG\u0015W\u0006V\u0018F\u0018M\r@\u0018\\\nT\u001c@");
                stringArray[5 >> 2] = c_OJ.m_Xda((Object)"H\u000bE\tN\u0006T\u000eJ\u001eJ\u0015_\u0018J\u0004X\fN\u0018");
                dataTransferManager2.f_Bi.m_oda(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_ai.info(AuthDetails.m_zda((Object)"\u001ds-s\r`8|*t<`\u0014s7s>w+2q^<s=w+2\"op(yT0|0a1w=2=s-syf+s7a?w+2+w*f6`8f0}72)`6q<a*<"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_ai.error(c_OJ.m_Xda((Object)"\u000ej>j\u001ey+e9m/y\u0007j$j-n8+bG/j.n8+1vc1jN8y%yjo?y#e-+.j>jj\u007f8j$x,n8+8n9\u007f%y+\u007f#d$+:y%h/x91jp7"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_YG.unlock();
        }
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_MG.m_lm((String)a2));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(AuthDetails.m_zda((Object)"\u0015W\u0018V\u001c@c2\nq1w=g5{7uyv8f82-`8|*t<`yi$25}:s5~ <"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_ai.debug(c_OJ.m_Xda((Object)"\u0004D\u0004&\u0006N\u000bO\u000fYp+\u0018n;~/x>b$ljg/j.n8+>djx)c/o?g/+.j>jj\u007f8j$x,n8+1vd"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_Ji.m_v(Short.valueOf((short)(0x65BF & 0x1BD1)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_YG.lock();
        try {
            Job job = (Job)a2.f_bG.get(a.getId());
            if (job != null) {
                a2.f_Vh.m_yj(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_bG.remove(a.getId());
            String[] stringArray = new String[3 >> 1];
            stringArray[3 ^ 3] = a.getId();
            dataTransferManager.f_IG.srem(f_mi, stringArray);
            return;
        }
        finally {
            a2.f_YG.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_VJ[] c_VJArray = (c_VJ[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_VJ[]::new);
        a4 = a7.f_ej.m_bba(stringArray, (Date)a5, (Date)((Object)a4), c_VJArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_vc getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_MG.m_DO((String)a2, (String)a)) == null) {
            return c_vc.f_zi;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_uj c_uj2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x5D & 0x2F, 2 & 5);
        ((Calendar)object).set(0x5F & 0x2E, 3 >> 2);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_wA.f_Rg[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x4E & 0x3D, 5 >> 3);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x4F & 0x3B, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x6F & 0x1B, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x2D & 0x5E, 5 >> 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0xF & 0x7B, 2 & 5);
                ((Calendar)object4).set(0x7C & 0xF, 5 >> 3);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 >> 2);
                ((Calendar)object5).set(0xC & 0x7F, 3 >> 2);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 2 & 5);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(AuthDetails.m_zda((Object)"G7w!b<q-w=2+s7u<2-k)w"));
    }

    protected Map<String, c_vc> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_MG.m_qM((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_MG.m_uN((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_IG.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return (2 & 5) != 0;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(AuthDetails.m_zda((Object)"d8~,w"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_vc getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(c_OJ.m_Xda((Object)"G\u000fJ\u000eN\u00181jL/\u007f>b$ljo+\u007f++>y+e9m/yjx>j>~9+,d8+\u0003Op+1vjg%h+g&rd"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_ai.debug(AuthDetails.m_zda((Object)"\u0017]\u0017?\u0015W\u0018V\u001c@c2\u000bw(g<a-{7uy~<s=w+2?}+2=s-syf+s7a?w+2*f8f,ayt6`y[\u001d(yi$<"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            return (c_vc)a2.f_Ji.m_v(Short.valueOf((short)(0x3F7 & 0x7D9B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_UA.class})
    public void handleRescheduleEvent(c_UA c_UA2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Ji.m_Ka()) {
            DataTransferManager a = a.m_ur();
            f_ai.info(AuthDetails.m_zda((Object)"^\u001cS\u001dW\u000b(yZ8|=~0|>2\u000bw*q1w=g5w\u001cd<|-2?}+2=s-syf+s7a?w+(yi$2q[\u001d(yi$;"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_vc.f_ZG) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_ai.debug(c_OJ.m_Xda((Object)"E\u0005EgG\u000fJ\u000eN\u00181jB-e%y#e-+\u0018n9h\"n.~&n\u000f}/e>+,d8+.j>jj\u007f8j$x,n81jp7"), (Object)a.m_ur().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_ib c_ib2, c_kh c_kh2, c_Ki c_Ki2, c_Aj c_Aj2, c_Sc c_Sc2, JedisPooled jedisPooled, c_nA c_nA2, c_K c_K2, c_hJ c_hJ2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_hJ2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_YG = new ReentrantLock();
        dataTransferManager7.f_bG = new ConcurrentHashMap();
        dataTransferManager7.f_MG = a9;
        dataTransferManager6.f_vH = a8;
        dataTransferManager6.f_LG = a7;
        dataTransferManager5.f_ej = a6;
        dataTransferManager5.f_Vh = a5;
        dataTransferManager4.f_tH = a4;
        dataTransferManager4.f_IG = a3;
        dataTransferManager3.f_Ji = a2;
        dataTransferManager3.f_Bi = a;
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Bi.m_Ifa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[3 ^ 3] = String.class;
            dataTransferManager.f_Ji.m_t((short)(0x61D7 & 0x1FB9), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_OJ.m_Xda((Object)"x)c/o?g/O+\u007f+_8j$x,n8B$\u007f/y$j&"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[5 >> 3] = String.class;
            dataTransferManager.f_Ji.m_t((short)(0x3D3 & 0x7DBE), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(AuthDetails.m_zda((Object)":s7q<~\u001ds-s\r`8|*t<`\u0010|-w+|8~"), classArray2));
            Class[] classArray3 = new Class[2 ^ 3];
            classArray3[5 >> 3] = String.class;
            dataTransferManager.f_Ji.m_t((short)(0x419B & 0x3FF7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_OJ.m_Xda((Object)"-n>O+\u007f+_8j$x,n8X>j>~9B$\u007f/y$j&"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[2 & 5] = String.class;
            dataTransferManager.f_Ji.m_t((short)(0x1B6 & 0x7FDD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(AuthDetails.m_zda((Object)"*q1w=g5w\u001ds-s\r`8|*t<`*P B+}3w:f\u0010v\u0010|-w+|8~"), classArray4));
            Class[] classArray5 = new Class[--1];
            classArray5[2 & 5] = String.class;
            dataTransferManager.f_Ji.m_t((short)(0x39B7 & 0x47DD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_OJ.m_Xda((Object)"h+e)n&O+\u007f+_8j$x,n8x\br\u001ay%a/h>B.B$\u007f/y$j&"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_Ji.m_t((short)(0x1FD6 & 0x61BF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(AuthDetails.m_zda((Object)">w-V8f8F+s7a?w+A-s-g*w*P [=a\u0010|-w+|8~"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_Ji.m_t((short)(0x1597 & 0x6BFF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_OJ.m_Xda((Object)"l/\u007f\u000ej>j\u001ey+e9m/y\u0019\u007f+\u007f?x/x\br\u001ay%a/h>B.B$\u007f/y$j&"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(AuthDetails.m_zda((Object)"\u001fs0~<vyf62+w>{*f<`yV8f8F+s7a?w+_8|8u<`y@\tQy\u007f<f1}=a"), a);
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return c_OJ.m_Xda((Object)"o+\u007f+&>y+e9m/ypg+x>&)j&hg\u007f#f/1<j8b+i&np.91oxp.9").formatted(objectArray);
    }

    protected Map<String, c_vc> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_vH.m_Hba((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_LG.m_Nba((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_MG.m_Jm((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return --1 != 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_LG.m_wBa(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_ai.info(AuthDetails.m_zda((Object)"V8f8F+s7a?w+_8|8u<`y:\u0015w8v<`yi$;c2\u000bw*f6`0|>2=s-syf+s7a?w+(yi$2q[\u001d(yi$;"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_tH.m_IL(a2.getProject()).m_q("Data Transfer Restore (Leader " + (String)a + ")", c_OJ.m_Xda((Object)".9+bB\u000e1j.9\"jm+b&n.+>djy/x>d8nd+\tj?x/1j.9").formatted(objectArray));
            try {
                f_ai.warn(AuthDetails.m_zda((Object)"V8f8F+s7a?w+_8|8u<`y:\u0015w8v<`yi$;c2\u0018f-w4b-{7uyf62:s7q<~yv8f82-`8|*t<`yi$28t-w+2+w*f6`8f0}72?s0~,`<<"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_ai.error(c_OJ.m_Xda((Object)"O+\u007f+_8j$x,n8F+e+l/yj#\u0006n+o/yjp7\"p+\fj#g/oj\u007f%+)j$h/gjo+\u007f++>y+e9m/yjp7++m>n8+8n9\u007f%y+\u007f#d$+,j#g?y/1jp7"), objectArray2);
                return;
            }
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_MG.m_oO((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_IG.setex(a5, (long)n, String.valueOf(d));
            a4.f_IG.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_OJ.m_Xda((Object)"<j&~/"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 & 4] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return AuthDetails.m_zda((Object)"v8f8?-`8|*t<`ca-s-acd8`0s;~<(|ac7*(|a").formatted(objectArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_vc> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(c_OJ.m_Xda((Object)"\u0006N\u000bO\u000fYp+\rn>\u007f#e-+.j>jj\u007f8j$x,n8+9\u007f+\u007f?x/xjm%yjp7+\u0003O9+&d)j&g31jp7"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_ai.debug(AuthDetails.m_zda((Object)"\\\u0016\\t^\u001cS\u001dW\u000b(y@<c,w*f0|>25w8v<`yt6`yv8f82-`8|*t<`ya-s-g*w*2?}+2\"oy[\u001dac2\"o"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = new ArrayList(a);
            return (Map)a2.f_Ji.m_v(Short.valueOf((short)(0x75B6 & 0xBDF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_OJ.m_Xda((Object)"f"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return --1 != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_IG.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return --1 != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_wA.f_Rg[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x4F & 0x3B) != calendar.get(0x5B & 0x2F)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x37 & 0x4E) != calendar.get(0x37 & 0x4E)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(1 ^ 3) != calendar.get(5 >> 1)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(--1) != calendar.get(3 & 5) ? --1 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[--2];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_IG.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(AuthDetails.m_zda((Object)"Q,`+w7f"))) {
            return false;
        }
        int a222 = switch (c_wA.f_Rg[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3F & 0x7C) * (0x67FF & 0x1BE8));
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_YG.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a.getName();
            PeriodicJob periodicJob = a2.f_Vh.m_jK(a.getProject(), c_OJ.m_Xda((Object)".9+\u000ej>jj_8j$x,n8").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_bG.put(a.getId(), periodicJob);
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_IG.sadd(f_mi, stringArray);
            return;
        }
        finally {
            a2.f_YG.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_uj c_uj2) {
        DataTransferManager a = c_uj2;
        DataTransferManager a2 = this;
        switch (c_wA.f_Rg[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(AuthDetails.m_zda((Object)"\u0015W\u0018V\u001c@c2\u001as7q<~5{7uyv8f82-`8|*t<`yi$25}:s5~ <"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_ai.debug(c_OJ.m_Xda((Object)"\u0004D\u0004&\u0006N\u000bO\u000fYp+\u0018n;~/x>b$ljg/j.n8+>djh+e)n&+.j>jj\u007f8j$x,n8+1vd"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_Ji.m_v(Short.valueOf((short)(0x599E & 0x27F3)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_vH.m_Hba((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_LG.m_Nba(object);
        a3 = dataTransferManager2.f_LG.m_Nba((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    protected c_vc getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_bG.containsKey(a)) {
            return c_vc.f_ZG;
        }
        return c_vc.f_zi;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_VJ c_VJ2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_wA.f_sg[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_vc> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(AuthDetails.m_zda((Object)"\u0015W\u0018V\u001c@c2\u001ew-f0|>28~52=s-syf+s7a?w+2*f8f,a<ayt6`yb+}3w:fyi$25}:s5~ <"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_ai.debug(c_OJ.m_Xda((Object)"E\u0005EgG\u000fJ\u000eN\u00181jY/z?n9\u007f#e-+&n+o/yjm%yjj&gjo+\u007f++>y+e9m/yjx>j>~9n9+,d8+:y%a/h>+1vd"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_Ji.m_v(Short.valueOf((short)(0x13D7 & 0x6DBF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Bi.m_Ifa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ji.m_Ka()) {
            f_ai.debug(AuthDetails.m_zda((Object)"^\u001cS\u001dW\u000b(yA:z<v,~0|>28~52=s-syf+s7a?w+ayt6`yb+}3w:fyi$25}:s5~ <"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_ai.debug(c_OJ.m_Xda((Object)"E\u0005EgG\u000fJ\u000eN\u00181jY/z?n9\u007f#e-+&n+o/yj\u007f%+9h\"n.~&njj&gjo+\u007f++>y+e9m/y9+,d8+:y%a/h>+1vd"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_Ji.m_v(Short.valueOf((short)(0x13B7 & 0x6DDC)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }
}

