/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.communication.base.m.c_VJ;
import com.inscada.mono.communication.base.m.c_uj;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="data_transfer_detail")
@AttributeOverride(name="id", column=@Column(name="data_transfer_detail_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"dataTransferId", "dataTransfer"}), @CheckAtLeastOneNotNull(fieldNames={"sourceVariableId", "sourceVariable"}), @CheckAtLeastOneNotNull(fieldNames={"targetVariableId", "targetVariable"})})
public class DataTransferDetail
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="data_transfer_id")
    private DataTransfer dataTransfer;
    @Column(name="data_transfer_id", insertable=false, updatable=false)
    private String dataTransferId;
    @Column(name="threshold")
    private Double threshold;
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="source_var_id", insertable=false, updatable=false)
    private VariableView sourceVariable;
    @Column(name="range_type")
    private c_uj rangeType;
    @Column(name="source_var_id")
    @NotBlank
    private String sourceVariableId;
    @Column(name="calc_type")
    private c_VJ calcType;
    @Column(name="target_var_id")
    @NotBlank
    private String targetVariableId;
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="target_var_id", insertable=false, updatable=false)
    private VariableView targetVariable;

    public String getSourceVariableId() {
        DataTransferDetail a;
        return a.sourceVariableId;
    }

    public void setSourceVariableId(String string) {
        Object a = string;
        DataTransferDetail a2 = this;
        a2.sourceVariableId = a;
    }

    @JsonSetter
    public void setSourceVariable(VariableView variableView) {
        DataTransferDetail a = variableView;
        DataTransferDetail a2 = this;
        a2.sourceVariable = a;
        if (a2.sourceVariable != null) {
            a2.sourceVariableId = a.getId();
            return;
        }
        a2.sourceVariableId = null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void a;
        DataTransferDetail dataTransferDetail = this;
        if (dataTransferDetail == a) {
            return (3 & 5) != 0;
        }
        if (!(a instanceof DataTransferDetail)) {
            return false;
        }
        DataTransferDetail a2 = (DataTransferDetail)a;
        if (!super.equals((Object)a)) {
            return 5 >> 3;
        }
        if (dataTransferDetail.getDataTransferId().equals(a2.getDataTransferId()) && dataTransferDetail.getSourceVariableId().equals(a2.getSourceVariableId()) && dataTransferDetail.getTargetVariableId().equals(a2.getTargetVariableId())) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public VariableView getTargetVariable() {
        DataTransferDetail a;
        return a.targetVariable;
    }

    public DataTransfer getDataTransfer() {
        DataTransferDetail a;
        return a.dataTransfer;
    }

    public void setCalcType(c_VJ c_VJ2) {
        DataTransferDetail a = c_VJ2;
        DataTransferDetail a2 = this;
        a2.calcType = a;
    }

    public void setThreshold(Double d) {
        Object a = d;
        DataTransferDetail a2 = this;
        a2.threshold = a;
    }

    public void setRangeType(c_uj c_uj2) {
        DataTransferDetail a = c_uj2;
        DataTransferDetail a2 = this;
        a2.rangeType = a;
    }

    public DataTransferDetail() {
        DataTransferDetail a;
    }

    public c_uj getRangeType() {
        DataTransferDetail a;
        return a.rangeType;
    }

    public int hashCode() {
        DataTransferDetail a;
        Object[] objectArray = new Object[--4];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[--1] = a.getDataTransferId();
        objectArray[1 ^ 3] = a.getSourceVariableId();
        objectArray[--3] = a.getTargetVariableId();
        return Objects.hash(objectArray);
    }

    public void setTargetVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.targetVariableId = a.getId();
            variable2.targetVariable = VariableView.from(a);
            return;
        }
        a2.targetVariableId = null;
        a2.targetVariable = null;
    }

    public c_VJ getCalcType() {
        DataTransferDetail a;
        return a.calcType;
    }

    public void setDataTransferId(String string) {
        Object a = string;
        DataTransferDetail a2 = this;
        a2.dataTransferId = a;
    }

    public String getDataTransferId() {
        DataTransferDetail a;
        return a.dataTransferId;
    }

    public Double getThreshold() {
        DataTransferDetail a;
        return a.threshold;
    }

    public String getTargetVariableId() {
        DataTransferDetail a;
        return a.targetVariableId;
    }

    public void setTargetVariableId(String string) {
        Object a = string;
        DataTransferDetail a2 = this;
        a2.targetVariableId = a;
    }

    public void setSourceVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.sourceVariableId = a.getId();
            variable2.sourceVariable = VariableView.from(a);
            return;
        }
        a2.sourceVariableId = null;
        a2.sourceVariable = null;
    }

    public void setDataTransfer(DataTransfer dataTransfer) {
        DataTransferDetail a;
        DataTransferDetail a2 = dataTransfer;
        DataTransferDetail dataTransferDetail = a = this;
        dataTransferDetail.dataTransfer = a2;
        dataTransferDetail.dataTransferId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public VariableView getSourceVariable() {
        DataTransferDetail a;
        return a.sourceVariable;
    }

    @JsonSetter
    public void setTargetVariable(VariableView variableView) {
        DataTransferDetail a = variableView;
        DataTransferDetail a2 = this;
        a2.targetVariable = a;
        if (a2.targetVariable != null) {
            a2.targetVariableId = a.getId();
            return;
        }
        a2.targetVariableId = null;
    }
}

