/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_hJ;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.m.c_mJ;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.o.c_MJ;
import com.inscada.mono.communication.base.o.c_zL;
import com.inscada.mono.communication.base.services.c_Eg;
import com.inscada.mono.communication.base.services.c_H;
import com.inscada.mono.communication.base.services.c_Wj;
import com.inscada.mono.communication.base.services.c_iH;
import com.inscada.mono.license.o.c_Id;
import com.inscada.mono.log.o.c_nA;
import com.inscada.mono.mail.model.MailFilter;
import com.inscada.mono.project.o.c_D;
import com.inscada.mono.settings.restcontrollers.MailSettingsController;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_D {
    private final c_iH<C, V> f_eu;
    public static final short f_FT = 204;
    private final c_hJ f_ps;
    private final Lock f_Su;
    public static final short f_Wt = 203;
    public static final short f_ls = 206;
    public static final short f_lu = 205;
    public static final short f_Zt = 201;
    private final c_K f_QT;
    public static final short f_WS = 207;
    private final c_nA f_SR;
    public static final short f_IS = 202;
    public static final short f_oS = 210;
    private static final String f_Ct = "activeConnections";
    private final c_Id f_zu;
    private final c_Wj f_wt;
    private static final Logger f_Uu = LoggerFactory.getLogger(ConnectionManager.class);
    private final JedisPooled f_xu;
    public static final short f_ju = 209;
    public static final short f_pt = 208;

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"/e\"d&rY\u00000T\fP\u0013I\rGCA\u000fLCC\fN\rE\u0000T\nO\rSCF\fRCP\u0011O\tE\u0000TC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"\u00042\u0004P\u00068\u000b9\u000f/p]\u0018\u0018;\b/\u000e>\u0014$\u001aj\u0011/\u001c.\u00188]>\u0012j\u000e>\u0012:]+\u0011&])\u0012$\u0013/\u001e>\u0014%\u00139],\u00128]:\u000f%\u0017/\u001e>]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_QT.m_v(Short.valueOf((short)(0x10CF & 0x6FFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_zL.class})
    public void handleDeleteEvent(c_zL c_zL2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_QT.m_Ka()) {
            ConnectionManager a2 = a.m_EAa();
            f_Uu.info(MailFilter.m_Qj((Object)"1\u000f<\u000e8\u0018Gj5+\u0013.\u0011#\u0013-]\u000e\u0018&\u0018>\u0018\u000f\u000b/\u0013>],\u00128])\u0012$\u0013/\u001e>\u0014%\u0013p]1\u0000jU\u00039p]1\u0000c"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_Uu.debug(MailSettingsController.m_ND((Object)"n,nNl&a'e1\u001aCi\u0004N\fR\nN\u0004\u0000'E\u000fE\u0017E&V\u0006N\u0017\u0000\u0005O\u0011\u0000\u0000O\rN\u0006C\u0017I\fNY\u0000\u0018]"), (Object)a.m_EAa().getId());
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_ps.m_Ifa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Su.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_zu.m_EK();
                connectionManager.f_eu.m_gBa((Connection)a).m_QR();
                String[] stringArray = new String[3 >> 1];
                stringArray[5 >> 3] = a.getId();
                connectionManager.f_xu.sadd(f_Ct, stringArray);
                return;
            }
            finally {
                a2.f_Su.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"/e\"d&rY\u00003E\u0011F\fR\u000eI\rGCB\u0011O\u0014S\u0006\u0000\fP\u0006R\u0002T\nO\r\u0000\u0005O\u0011\u0000\u0000O\rN\u0006C\u0017I\fNC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"3\u00053g1\u000f<\u000e8\u0018Gj//\f?\u00189\t#\u0013-]&\u0018+\u0019/\u000fj\t%]:\u00188\u001b%\u000f'](\u000f%\n9\u0018j\u0012:\u00188\u001c>\u0014%\u0013j\u001b%\u000fj\u001e%\u0013$\u0018)\t#\u0012$]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return a2.f_QT.m_v(Short.valueOf((short)(0x79D7 & 0x6FA)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_wt.m_Waa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 >> 2] = String.class;
            connectionManager.f_QT.m_t((short)(0x44F9 & 0x3BCF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailSettingsController.m_ND((Object)"S\u0017A\u0011T O\rN\u0006C\u0017I\fN*N\u0017E\u0011N\u0002L"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 ^ 3] = String.class;
            connectionManager.f_QT.m_t((short)(0x6EEF & 0x11DA), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailFilter.m_Qj((Object)"\u000e>\u0012:>%\u0013$\u0018)\t#\u0012$4$\t/\u000f$\u001c&"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[3 ^ 3] = String.class;
            connectionManager.f_QT.m_t((short)(0x56DF & 0x29EB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailSettingsController.m_ND((Object)"G\u0006T O\rN\u0006C\u0017I\fN0T\u0002T\u0016S*N\u0017E\u0011N\u0002L"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[3 ^ 3] = SetValueRequest.class;
            connectionManager.f_QT.m_t((short)(0x17FD & 0x68CE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailFilter.m_Qj((Object)"\u000e/\t\u001c\u001c8\u0014+\u001f&\u0018\u001c\u001c&\b/4$\t/\u000f$\u001c&"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[2 & 5] = Collection.class;
            connectionManager.f_QT.m_t((short)(0x71ED & 0xEDF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailSettingsController.m_ND((Object)"S\u0006T5A\u0011I\u0002B\u000fE5A\u000fU\u0006S*N\u0017E\u0011N\u0002L"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_QT.m_t((short)(0x2BFE & 0x54CF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailFilter.m_Qj((Object)"9\t+\u000f>>%\u0013$\u0018)\t#\u0012$\u000e\b\u0004\u001a\u000f%\u0017/\u001e>4.4$\t/\u000f$\u001c&"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_QT.m_t((short)(0x57FF & 0x28CF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailSettingsController.m_ND((Object)"\u0010T\fP O\rN\u0006C\u0017I\fN\u0010b\u001ap\u0011O\tE\u0000T*D*N\u0017E\u0011N\u0002L"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_QT.m_t((short)(0x56F8 & 0x29D7), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailFilter.m_Qj((Object)"\u001a/\t\t\u0012$\u0013/\u001e>\u0014%\u0013\u0019\t+\t?\u000e/\u000e\b\u0004\u001a\u000f%\u0017/\u001e>4.4$\t/\u000f$\u001c&"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_QT.m_t((short)(0x10D3 & 0x6FFD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailSettingsController.m_ND((Object)"\u0004E\u0017c\fN\rE\u0000T\nO\rs\u0017A\u0017U\u0010E\u0010b\u001ai\u0007S*N\u0017E\u0011N\u0002L"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_QT.m_t((short)(0x2BF7 & 0x54DA), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MailFilter.m_Qj((Object)"\u001f8\u0012=\u000e/>%\u0013$\u0018)\t#\u0012$4$\t/\u000f$\u001c&"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(MailSettingsController.m_ND((Object)"%A\nL\u0006DCT\f\u0000\u0011E\u0004I\u0010T\u0006RCc\fN\rE\u0000T\nO\rm\u0002N\u0002G\u0006RCr3cCM\u0006T\u000bO\u0007S"), a);
        }
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_eu.m_Fba((String)a)) instanceof c_H) {
            return ((c_H)a).m_R();
        }
        throw new BrowseOperationException(MailFilter.m_Qj((Object)"?8\u0012=\u000e/]%\r/\u000f+\t#\u0012$]$\u0012>]9\b:\r%\u000f>\u0018."));
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_eu.m_Fba((String)a)) != null) {
                void a3;
                a.m_vS((List)a3);
            }
        });
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_wt.m_rAa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"/e\"d&rY\u00000T\u0002R\u0017I\rGCA\u000fLCC\fN\rE\u0000T\nO\rSCF\fRCP\u0011O\tE\u0000TC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"3\u00053g1\u000f<\u000e8\u0018Gj//\f?\u00189\t#\u0013-]&\u0018+\u0019/\u000fj\t%]9\t+\u000f>]+\u0011&])\u0012$\u0013/\u001e>\u0014%\u00139],\u00128]:\u000f%\u0017/\u001e>]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_QT.m_v(Short.valueOf((short)(0x1EEF & 0x61DE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_mJ> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_wt.m_oCa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_mJ> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"l&a'e1\u001aCg\u0006T\u0017I\rGCC\fN\rE\u0000T\nO\r\u0000\u0010T\u0002T\u0016S\u0006SCF\fRC[\u001e\u0000*d\u0010\u0000\u000fO\u0000A\u000fL\u001a\u000e"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"\u00042\u0004P\u00068\u000b9\u000f/p]\u0018\u0018;\b/\u000e>\u0014$\u001aj\u0011/\u001c.\u00188],\u00128])\u0012$\u0013/\u001e>\u0014%\u0013j\u000e>\u001c>\b9\u00189],\u00128]1\u0000j4\u000e\u000ed"), (Object)a.length);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_QT.m_v(Short.valueOf((short)(0x1ED1 & 0x61FF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.info(MailFilter.m_Qj((Object)"1\u000f<\u000e8\u0018Gj5+\u0013.\u0011#\u0013-]\u001a\u000f%\u0017/\u001e>9/\u001c)\t#\u000b+\t/8<\u0018$\tj\u001b%\u000fj\r8\u0012 \u0018)\tj4\u000eGj\u00067"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Uu.debug(MailSettingsController.m_ND((Object)"-o-\r/e\"d&rY\u0000*G\rO\u0011I\rGCp\u0011O\tE\u0000T'E\u0002C\u0017I\u0015A\u0017E&V\u0006N\u0017\u0000\u0005O\u0011\u0000\u0013R\fJ\u0006C\u0017\u0000*dY\u0000\u0018]"), a);
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_wt.m_SCa(a.getId());
    }

    protected c_mJ getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_eu.m_Fba((String)a)) != null && a.m_Zs()) {
            return c_mJ.f_Dt;
        }
        return c_mJ.f_zT;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_QT.m_La();
        String[] stringArray = new String[--3];
        stringArray[3 >> 2] = MailSettingsController.m_ND((Object)"0t\"r7\u007f o-n&c7i,n");
        stringArray[3 & 5] = MailFilter.m_Qj((Object)"\u0019)\u0005-\u0015>\u00053\u00048\t)\u00032\u0004");
        stringArray[1 ^ 3] = MailSettingsController.m_ND((Object)"5i&w<c,n-e t*o-\u007f*t&m");
        connectionManager2.f_ps.m_oda(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_wt.m_yaa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_wt.m_VCa((String)a);
        return connectionManager2.f_ps.m_Rfa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_QT.m_ba((ClusterNodeListener)a);
        f_Uu.info(MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$0+\u0013+\u001a/\u000fj\u0014$\u0014>\u0014+\u0011#\u0007/\u0019j\u001c$\u0019j\u000f/\u001a#\u000e>\u00188\u0018.]+\u000ej>&\b9\t/\u000f\u0004\u0012.\u0018\u0006\u00149\t/\u0013/\u000fd"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_mJ> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"l&a'e1\u001aCg\u0006T\u0017I\rGCA\u000fLCC\fN\rE\u0000T\nO\r\u0000\u0010T\u0002T\u0016S\u0006SCF\fRCP\u0011O\tE\u0000TC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"\u00042\u0004P\u00068\u000b9\u000f/p]\u0018\u0018;\b/\u000e>\u0014$\u001aj\u0011/\u001c.\u00188],\u00128]+\u0011&])\u0012$\u0013/\u001e>\u0014%\u0013j\u000e>\u001c>\b9\u00189],\u00128]:\u000f%\u0017/\u001e>]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            return (Map)a2.f_QT.m_v(Short.valueOf((short)(0x22F8 & 0x5DD7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_wt.m_yaa((String)a, (String)a3).getId());
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_wt.m_VCa((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_Wj c_Wj2, c_Id c_Id2, c_nA c_nA2, c_iH<C, V> c_iH2, JedisPooled jedisPooled, c_K c_K2, c_hJ c_hJ2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_hJ2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_Su = new ReentrantLock();
        a8.f_wt = a7;
        connectionManager5.f_zu = a6;
        connectionManager5.f_SR = a5;
        connectionManager4.f_eu = a4;
        connectionManager4.f_xu = a3;
        connectionManager3.f_QT = a2;
        connectionManager3.f_ps = a;
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"l&a'e1\u001aCs\u0017O\u0013P\nN\u0004\u0000\u0000O\rN\u0006C\u0017I\fNC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"3\u00053g1\u000f<\u000e8\u0018Gj//\f?\u00189\t#\u0013-]&\u0018+\u0019/\u000fj\t%]9\t%\rj\u001e%\u0013$\u0018)\t#\u0012$]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            a2.f_QT.m_v(Short.valueOf((short)(0x4ADE & 0x35EB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_QT.m_La();
        f_Uu.info(MailFilter.m_Qj((Object)"\t\u0012$\u0013/\u001e>\u0014%\u0013\u0007\u001c$\u001c-\u00188Gj)\"\u00149]$\u0012.\u0018jU1\u0000c]#\u000ej3\u0005]\u00062\u0004:\u000f/j)\u00028j1\u000f<\u000e8\u0018Sj.>\u0012:\r#\u0013-]+\u0011&]&\u0012)\u001c&])\u0012$\u0013/\u001e>\u00128\u000edSd"), a);
        connectionManager2.f_Su.lock();
        try {
            connectionManager.f_eu.m_Yaa();
            f_Uu.info(MailSettingsController.m_ND((Object)" O\rN\u0006C\u0017I\fN.A\rA\u0004E\u0011\u0000Kn\fTCl\u0006A\u0007E\u0011\u0000\u0018]J\u001aCa\u000fLCL\fC\u0002LCC\fN\rE\u0000T\fR\u0010\u0000\u000bA\u0015ECB\u0006E\r\u0000\u0011E\u0012U\u0006S\u0017E\u0007\u0000\u0017OCS\u0017O\u0013\u0000\u0002N\u0007\u0000\u0000L\u0006A\u0011E\u0007\u0000\u0005R\fMCL\fC\u0002LCT\u0011A\u0000K\nN\u0004\u000e"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Uu.error(MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$0+\u0013+\u001a/\u000fjU\u0004\u0012>]\u0006\u0018+\u0019/\u000fj\u00067Tp]\u000f\u000f8\u00128].\b8\u0014$\u001aj\r8\u0012)\u00189\u000ej\u0012,]9\t%\r:\u0014$\u001aj\u0011%\u001e+\u0011j\u001e%\u0013$\u0018)\t%\u000f9Gj\u00067"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Su.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_Uu.info(MailSettingsController.m_ND((Object)" O\rN\u0006C\u0017I\fN.A\rA\u0004E\u0011\u0000Kl\u0006A\u0007E\u0011\u0000\u0018]J\u001aCr\u0006S\u0017O\u0011I\rGCC\fN\rE\u0000T\nO\r\u001aC[\u001e\u0000Ki'\u001aC[\u001e\t"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_SR.m_IL(a2.getProject()).m_q("Connection Restore (Leader " + (String)a + ")", MailFilter.m_Qj((Object)"X9]b4\u000eGjX9Tj\u001b+\u0014&\u0018.]>\u0012j\u000f/\u000e>\u00128\u0018d]\t\u001c?\u000e/GjX9").formatted(objectArray));
            try {
                f_Uu.warn(MailSettingsController.m_ND((Object)" O\rN\u0006C\u0017I\fN.A\rA\u0004E\u0011\u0000Kl\u0006A\u0007E\u0011\u0000\u0018]J\u001aCa\u0017T\u0006M\u0013T\nN\u0004\u0000\u0017OCS\u0017O\u0013\u0000\u0000O\rN\u0006C\u0017I\fNC[\u001e\u0000\u0002F\u0017E\u0011\u0000\u0011E\u0010T\fR\u0002T\nO\r\u0000\u0005A\nL\u0016R\u0006\u000e"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Uu.error(MailFilter.m_Qj((Object)"\t\u0012$\u0013/\u001e>\u0014%\u0013\u0007\u001c$\u001c-\u00188]b1/\u001c.\u00188]1\u0000cGj;+\u0014&\u0018.]>\u0012j\u000e>\u0012:])\u0012$\u0013/\u001e>\u0014%\u0013j\u00067]+\u001b>\u00188]8\u00189\t%\u000f+\t#\u0012$],\u001c#\u0011?\u000f/Gj\u00067"), objectArray2);
                return;
            }
        }
    }

    protected Map<String, c_mJ> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_mJ getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_wt.m_JCa((String)a2, (String)a)) == null) {
            return c_mJ.f_zT;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_mJ getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"l&a'e1\u001aCg\u0006T\u0017I\rGCC\fN\rE\u0000T\nO\r\u0000\u0010T\u0002T\u0016SCF\fRC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"\u00042\u0004P\u00068\u000b9\u000f/p]\u0018\u0018;\b/\u000e>\u0014$\u001aj\u0011/\u001c.\u00188],\u00128])\u0012$\u0013/\u001e>\u0014%\u0013j\u000e>\u001c>\b9],\u00128]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            return (c_mJ)a2.f_QT.m_v(Short.valueOf((short)(0x6CCB & 0x13FF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_wt.m_rAa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"l&a'e1\u001aCs\u0017A\u0011T\nN\u0004\u0000\u0000O\rN\u0006C\u0017I\fNC[\u001e\u0000\u000fO\u0000A\u000fL\u001a\u000e"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"\u00042\u0004P\u00068\u000b9\u000f/p]\u0018\u0018;\b/\u000e>\u0014$\u001aj\u0011/\u001c.\u00188]>\u0012j\u000e>\u001c8\tj\u001e%\u0013$\u0018)\t#\u0012$]1\u0000d"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            a2.f_QT.m_v(Short.valueOf((short)(0x2AED & 0x55DB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Eg c_Eg2 = a2.f_eu.m_Fba(a.getConnectionId());
        if (c_Eg2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Eg2.m_AT(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_QT.m_La();
        f_Uu.info(MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$0+\u0013+\u001a/\u000fp]\u001e\u0015#\u000ej\u0013%\u0019/]b\u00067Tj\u0015+\u000ej\u001f/\u001e%\u0010/]>\u0015/]\u00068\u000b9\u000f/d]\u0018\u00189\t%\u000f#\u0013-]+\u001e>\u0014<\u0018j\u001e%\u0013$\u0018)\t#\u0012$\u000edSd"), a);
        connectionManager2.f_Su.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_xu.smembers(f_Ct));
            if (hashSet.isEmpty()) {
                f_Uu.info(MailSettingsController.m_ND((Object)"c\fN\rE\u0000T\nO\rm\u0002N\u0002G\u0006RC\b/E\u0002D\u0006RC[\u001e\tY\u0000-OCA\u0000T\nV\u0006\u0000\u0000O\rN\u0006C\u0017I\fN\u0010\u0000\u0005O\u0016N\u0007\u0000\nNCr\u0006D\nSCT\f\u0000\u0011E\u0010T\fR\u0006\u000e"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_Uu.info(MailFilter.m_Qj((Object)"\t\u0012$\u0013/\u001e>\u0014%\u0013\u0007\u001c$\u001c-\u00188]b1/\u001c.\u00188]1\u0000cGj;%\b$\u0019j\u00067]+\u001e>\u0014<\u0018j\u001e%\u0013$\u0018)\t#\u0012$]\u000399]#\u0013j//\u0019#\u000ej\t%]8\u00189\t%\u000f/Gj\u00067"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = MailSettingsController.m_ND((Object)"5i&w<c,n-e t*o-\u007f*t&m");
            connectionManager.f_ps.m_nDa(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_wt.m_sCa((Set)a2));
            }, stringArray);
            f_Uu.info(MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$0+\u0013+\u001a/\u000fjU\u0006\u0018+\u0019/\u000fj\u00067Tp]\u000b\t>\u0018'\r>\u0014$\u001aj\t%]8\u00189\t%\u000f/]1\u0000j\u001e%\u0013$\u0018)\t#\u0012$\u000ed"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_Uu.info(MailSettingsController.m_ND((Object)"c\fN\rE\u0000T\nO\rm\u0002N\u0002G\u0006RC\b/E\u0002D\u0006RC[\u001e\tY\u0000%I\rI\u0010H\u0006DCC\fN\rE\u0000T\nO\r\u0000\u0011E\u0010T\fR\u0002T\nO\r\u0000\u0013R\fC\u0006S\u0010\u000e"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_Uu.error(MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$0+\u0013+\u001a/\u000fjU\u0006\u0018+\u0019/\u000fj\u00067Tp]\u000f\u000f8\u00128].\b8\u0014$\u001aj\u001e%\u0013$\u0018)\t#\u0012$]8\u00189\t%\u000f+\t#\u0012$]:\u000f%\u001e/\u000e9Gj\u00067"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Su.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, MailSettingsController.m_ND((Object)"0E\u0017v\u0002L\u0016E1E\u0012U\u0006S\u0017\u0000\u0000A\rN\fTCB\u0006\u0000\rU\u000fL")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$4.]#\u0013j./\t\u001c\u001c&\b///\f?\u00189\tj\u001e+\u0013$\u0012>](\u0018j\u0013?\u0011&")));
        if (a3.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"l&a'e1\u001aCs\u0006T\u0017I\rGC[\u001e\u0000\u0015A\u0011I\u0002B\u000fECV\u0002L\u0016E\u0010\u0000\u000fO\u0000A\u000fL\u001a\u000e"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"3\u00053g1\u000f<\u000e8\u0018Gj//\f?\u00189\t#\u0013-]&\u0018+\u0019/\u000fj\t%]9\u0018>]1\u0000j\u000b+\u000f#\u001c(\u0011/]<\u001c&\b/\u000ed"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = new ArrayList(a22);
            a3.f_QT.m_v(Short.valueOf((short)(0x2EF & 0x7DDD)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(MailSettingsController.m_ND((Object)"f\u0002I\u000fE\u0007\u0000\u0017OCr3cCS\u0006TCV\u0002R\nA\u0001L\u0006\u0000\u0015A\u000fU\u0006S"), (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, MailSettingsController.m_ND((Object)"0E\u0017v\u0002L\u0016E1E\u0012U\u0006S\u0017\u0000\u0000A\rN\fTCB\u0006\u0000\rU\u000fL"));
        Objects.requireNonNull(a.getConnectionId(), MailFilter.m_Qj((Object)">%\u0013$\u0018)\t#\u0012$4.]#\u0013j./\t\u001c\u001c&\b///\f?\u00189\tj\u001e+\u0013$\u0012>](\u0018j\u0013?\u0011&"));
        if (a2.f_QT.m_Ka()) {
            f_Uu.debug(MailSettingsController.m_ND((Object)"/e\"d&rY\u00000E\u0017T\nN\u0004\u0000\u0015A\u0011I\u0002B\u000fECV\u0002L\u0016ECF\fRCC\fN\rE\u0000T\nO\r\u0000\u0018]CL\fC\u0002L\u000fYY\u0000\u0018]"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_Uu.debug(MailFilter.m_Qj((Object)"\u00042\u0004P\u00068\u000b9\u000f/p]\u0018\u0018;\b/\u000e>\u0014$\u001aj\u0011/\u001c.\u00188]>\u0012j\u000e/\tj\u000b+\u000f#\u001c(\u0011/]<\u001c&\b/],\u00128])\u0012$\u0013/\u001e>\u0014%\u0013j\u00067Gj\u00067"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_QT.m_v(Short.valueOf((short)(0x3FFE & 0x40CD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_MJ.class})
    public void handleRestartEvent(c_MJ c_MJ2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_QT.m_Ka()) {
            ConnectionManager a2 = a.m_fca();
            f_Uu.info(MailFilter.m_Qj((Object)"\u00068\u000b9\u000f/p]\u0002\u001c$\u0019&\u0014$\u001aj//\u000e>\u001c8\t\u000f\u000b/\u0013>],\u00128])\u0012$\u0013/\u001e>\u0014%\u0013p]1\u0000jU\u00039p]1\u0000c"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_Su.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_mJ.f_Dt) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_Su.unlock();
            }
        }
        f_Uu.debug(MailSettingsController.m_ND((Object)"-o-\r/e\"d&rY\u0000*G\rO\u0011I\rGCr\u0006S\u0017A\u0011T&V\u0006N\u0017\u0000\u0005O\u0011\u0000\u0000O\rN\u0006C\u0017I\fNY\u0000\u0018]"), (Object)a.m_fca().getId());
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_ps.m_Ifa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Su.lock();
            try {
                c_Eg c_Eg2 = a2.f_eu.m_Fba(a.getId());
                if (c_Eg2 != null) {
                    c_Eg2.m_Wt();
                    a2.f_eu.m_Sca(a.getId(), c_Eg2);
                }
                String[] stringArray = new String[--1];
                stringArray[3 >> 2] = a.getId();
                a2.f_xu.srem(f_Ct, stringArray);
                return;
            }
            finally {
                a2.f_Su.unlock();
            }
        }, a);
    }
}

