/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.replication;

import com.inscada.mono.auth.c_hJ;
import com.inscada.mono.auth.security.o.c_SJ;
import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.shared.aspects.SpaceFilterAspect;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.util.SafeEncoder;

@Component
@ConditionalOnProperty(value={"ins.cluster.redis.replication.enabled"}, havingValue="true")
public class RedisReplicator
implements ClusterNodeListener {
    private final Logger f_Kt;
    private final c_hJ f_Ds;
    private final JedisPooled f_It;
    private final c_K f_yT;
    private final Integer f_GS;
    private final String f_wR;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicator redisReplicator;
        RedisReplicator redisReplicator2 = redisReplicator = this;
        redisReplicator.f_Kt.info(SpaceFilterAspect.m_Ae((Object)"eJXQ\u0011L^FT\u0002XQ\u0011l~v\u0011ntcugc\f\u0011cEVTOAVXLV\u0002EM\u0011A^LWKVWCG\u0011N^APN\u0011pTFXQ\u0011\nJ_\u000bYL\u000b\u0011CB\u0002BNPTT\f"), (Object)redisReplicator2.f_wR, (Object)redisReplicator2.f_GS);
        try {
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = c_SJ.m_Rea((Object)"rWaI{]hKwJaL{Mp_pKw");
            Optional optional = (Optional)redisReplicator.f_Ds.m_Pda(() -> {
                RedisReplicator a;
                return a.f_yT.m_ha().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            }, stringArray);
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = (ClusterNodeInfo)optional.get();
                String string = clusterNodeInfo.getHost();
                String a = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a == null || n == null) {
                    Object[] objectArray = new Object[--4];
                    objectArray[3 >> 2] = clusterNodeInfo.getNodeId();
                    objectArray[5 >> 2] = string;
                    objectArray[5 >> 1] = redisReplicator.f_wR;
                    objectArray[--3] = redisReplicator.f_GS;
                    redisReplicator.f_Kt.error(SpaceFilterAspect.m_Ae((Object)"}GPFTP\u0011L^FT\u0002J_\u0011\n{eCMDRB\u0002yMBV\u000b\u0002J_\u0018\u0002FCB\u0002XFTLEKWKTF\u001d\u0002SWE\u0002XVB\u0002BRTAXDXA\u0011pTFXQ\u0011J^QE\rAMCV\u0011KB\u0002\\KBQXLV\u0002XL\u0011a]WBVTP\u007fMUGxLWM\u001f\u0002rC_L^V\u0011A^LWKVWCG\u0011N^APN\u0011pTFXQ\u0011\nJ_\u000bYL\u000b\u0011CB\u0002BNPTT\f\u0011n^APN\u0011pTFXQ\u0011PTOPK_Q\u0011K_\u0002XVB\u0002RWCPTLE\u0002CGANXAPVXM_\u0002BVPVT\f"), objectArray);
                    return;
                }
                if (a.equals(redisReplicator.f_wR) && n.equals(redisReplicator.f_GS)) {
                    Object[] objectArray = new Object[--4];
                    objectArray[2 & 5] = a;
                    objectArray[3 & 5] = n;
                    objectArray[1 ^ 3] = redisReplicator.f_wR;
                    objectArray[--3] = redisReplicator.f_GS;
                    redisReplicator.f_Kt.warn(c_SJ.m_Rea((Object)"mzApPwBwAz\u0004rA\u007f@{V9W>v{@wW>\feY$_c\r>Mm\u0004jL{\u0004mEsA>Em\u0004rK}Er\u0004LAzMm\u00046_c\u001eeY7\n>pvMm\u0004pKzA>SwHr\u0004pKj\u0004\u007fPjAsTj\u0004jK>WrEhA>KxB>MjW{Hx\n>apWkVwJy\u0004rK}Er\u0004LAzMm\u0004wW>I\u007fWjAl\n"), objectArray);
                    Object[] objectArray2 = new Object[--4];
                    objectArray2[3 >> 2] = redisReplicator.f_wR;
                    objectArray2[3 & 5] = redisReplicator.f_GS;
                    objectArray2[1 ^ 3] = a;
                    objectArray2[--3] = n;
                    redisReplicator.f_Kt.error(SpaceFilterAspect.m_Ae((Object)"ackekrc}\u0002rm\u007fdxedppvxm\u007f\u0002xqbwt\u0018\u0011vYKB\u0002_MUG\u0011\nJ_\u000bYL\u000b\u0011KB\u0002_ME\u0002{eCMDRB\u0002]GPFTP\u001d\u0002SWE\u0002EJT\u0002XFTLEKWKTF\u0011hvP^WAQ\u0011NTCUGC\u0005B\u0002cGUKB\u0002TLUR^K_V\u0011\nJ_\u000bYL\u000b\u0011R^K_VB\u0002EM\u0011VYKB\u0002_MUG\u0016Q\u0011N^APN\u0011pTFXQ\u001f\u0002eJXQ\u0011K_FXAPVTQ\u0011C\u0011R^VTLEKPN\u0011OXQRM_DXEDPPVXM_\u0002^P\u0011C_\u0002DLBVP@]G\u0011QECEG\u001f\u0002}MRC]\u0002cGUKB\u0002CGANXAPVXM_\u0002BVPVT\u0002FK]N\u0011l~v\u0011@T\u0002RJPLVGU\u0002PWEM\\CEKRC]NH\u0002EM\u0011RCGGG_V\u0011KBQDGB\f"), objectArray2);
                    return;
                }
                Object[] objectArray = new Object[0x5E & 0x27];
                objectArray[5 >> 3] = clusterNodeInfo.getNodeId();
                objectArray[1] = string;
                objectArray[--2] = redisReplicator.f_wR;
                objectArray[3] = redisReplicator.f_GS;
                objectArray[4] = a;
                objectArray[5] = n;
                redisReplicator.f_Kt.info(c_SJ.m_Rea((Object)"bqQp@>nYVqQnW>H{EzAl\u001e>jq@{mz\u00199_c\u00032\u0004TclKkTmlqWj\u00199_c\u00030\u0004_PjAsTjMpC>Pq\u0004mH\u007fR{\u0004rK}Er\u0004LAzMm\u00046_c\u001eeY7\u0004jK>H{EzAl\u0003m\u0004LAzMm\u0004\u007fP>_c\u001eeY"), objectArray);
                byte[][] byArrayArray = new byte[2][];
                byArrayArray[0] = SafeEncoder.encode((String)a);
                byArrayArray[1] = SafeEncoder.encode((String)String.valueOf(n));
                redisReplicator.f_It.sendCommand(() -> SafeEncoder.encode((String)c_SJ.m_Rea((Object)"wReHaQb")), (byte[][])byArrayArray);
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = redisReplicator.f_wR;
                objectArray3[1] = redisReplicator.f_GS;
                objectArray3[2] = a;
                objectArray3[3] = n;
                redisReplicator.f_Kt.info(SpaceFilterAspect.m_Ae((Object)"n^APN\u0011pTFXQ\u0011\nJ_\u000bYL\u000b\u000b\u0002bG_V\u0011A^O\\C_F\u0011q}cgg~d\u0011YL\u0002J_"), objectArray3);
                return;
            }
            RedisReplicator redisReplicator3 = redisReplicator;
            redisReplicator.f_Kt.warn(c_SJ.m_Rea((Object)"]KkHz\u0004pKj\u0004xMp@>E>nYVqQnW>H{EzAl\u0004pKzA>RwE>vNg>Pq\u0004zAjAlIwJ{\u0004jL{\u0004sEmP{V>v{@wW>MpWjEpG{\n>hqG\u007fH>v{@wW>\feY$_c\r>SwHr\u0004lAsEwJ>Mp\u0004wPm\u0004}QlV{Jj\u0004lAnHwG\u007fPwKp\u0004mP\u007fP{\n>pvMm\u0004wW>PvA>W\u007fB{Wj\u0004\u007fTnVqE}L>Pq\u0004\u007fRqMz\u0004mTrMj\t|V\u007fMp\u0004wJ>G\u007fW{\u0004qB>J{PiKlO>T\u007fVjMjMqJm\n>i\u007fJkEr\u0004wJjAlR{JjMqJ>I\u007f]>F{\u0004lAoQwV{@>Mx\u0004jL{\u0004}HkWjAl\u0004wW>T\u007fVjMjMqJ{@>Kl\u0004jL{\u0004zAmMyJ\u007fP{@>H{EzAl\u0004wW>PlQr]>@qSp\n"), (Object)redisReplicator3.f_wR, (Object)redisReplicator3.f_GS);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[4];
            objectArray[0] = redisReplicator.f_wR;
            objectArray[1] = redisReplicator.f_GS;
            objectArray[2] = exception.getMessage();
            objectArray[3] = exception;
            redisReplicator.f_Kt.error(SpaceFilterAspect.m_Ae((Object)"tPCMC\u0002XL\u0011pTFXQcGANXAPVXM_qTPGKRG\u001fL^V}GPFTP\u0019\u000b\u0011UYK]G\u0011A^LWKVWCK_E\u0011N^APN\u0011pTFXQ\u0011\nJ_\u000bYL\u000b\u000b\u0002J_"), objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RedisReplicator(c_K c_K2, c_hJ c_hJ2, JedisPooled jedisPooled, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void localRedisHost;
        void jedis;
        void runAsManager;
        void clusterOperations;
        RedisReplicator a;
        RedisReplicator redisReplicator = object;
        Object object = n;
        RedisReplicator redisReplicator2 = a = redisReplicator;
        RedisReplicator redisReplicator3 = a;
        redisReplicator3.f_Kt = LoggerFactory.getLogger(RedisReplicator.class);
        redisReplicator3.f_yT = clusterOperations;
        redisReplicator2.f_Ds = runAsManager;
        redisReplicator2.f_It = jedis;
        a.f_wR = localRedisHost;
        a.f_GS = object;
        a.f_yT.m_ba((ClusterNodeListener)a);
    }

    public void leader() {
        RedisReplicator redisReplicator = this;
        try {
            byte[][] byArrayArray = new byte[5 >> 1][];
            byArrayArray[3 ^ 3] = SafeEncoder.encode((String)SpaceFilterAspect.m_Ae((Object)"\u007fm"));
            byArrayArray[3 >> 1] = SafeEncoder.encode((String)c_SJ.m_Rea((Object)"kPa"));
            redisReplicator.f_It.sendCommand(() -> SafeEncoder.encode((String)SpaceFilterAspect.m_Ae((Object)"q}cgg~d")), (byte[][])byArrayArray);
            RedisReplicator redisReplicator2 = redisReplicator;
            redisReplicator.f_Kt.info(SpaceFilterAspect.m_Ae((Object)"vYKB\u0002_MUG\u0011KB\u0002}gpftp\u001f\u0002}MRC]\u0002cGUKB\u0002\u0019YL\u0018J_\u0018\u0002BGE\u0002EM\u0011@T\u0002|cbvtp\u0011\nbnpttmw\u0002\u007fm\u0011m\u007fg\u0018\f"), (Object)redisReplicator2.f_wR, (Object)redisReplicator2.f_GS);
            return;
        }
        catch (Exception a) {
            Object[] objectArray = new Object[--4];
            objectArray[3 >> 2] = redisReplicator.f_wR;
            objectArray[2 ^ 3] = redisReplicator.f_GS;
            objectArray[5 >> 1] = a.getMessage();
            objectArray[--3] = a;
            redisReplicator.f_Kt.error(c_SJ.m_Rea((Object)"alVqV>W{PjMpC>HqG\u007fH>v{@wW>\feY$_c\r>Pq\u0004SeMp[v$\u0004eY"), objectArray);
            return;
        }
    }
}

