/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="animation")
@AttributeOverride(name="id", column=@Column(name="animation_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"svgFileId", "svgFile"})})
public class Animation
extends SpaceBaseModel {
    @Column(name="svg_file_id", updatable=false, insertable=false)
    private String svgFileId;
    @NotNull
    @Min(value=1L)
    @Column(name="play_order")
    private Short playOrder;
    @Size(max=7)
    private String color;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @Column(name="pre_anim_code")
    private String preAnimCode;
    private String alignment;
    @NotNull
    @Min(value=100L)
    private Integer duration;
    @Size(max=255)
    private String dsc;
    @Column(name="anim_join_id")
    private String animJoinId;
    @NotNull
    @Column(name="main_flag")
    private Boolean mainFlag;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @JsonIgnore
    @OneToOne(optional=false)
    @JoinColumn(name="svg_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo svgFile;
    @Column(name="post_anim_code")
    private String postAnimCode;
    @JsonIgnore
    @OneToMany(mappedBy="animation")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<AnimationElement> animationElements;
    private String placeholders;
    @OneToMany(mappedBy="animation")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<AnimationScript> animationScripts;
    private String configs;

    public Boolean getMainFlag() {
        Animation a;
        return a.mainFlag;
    }

    public String getAlignment() {
        Animation a;
        return a.alignment;
    }

    public void setDuration(Integer n) {
        Object a = n;
        Animation a2 = this;
        a2.duration = a;
    }

    public FileInfo getSvgFile() {
        Animation a;
        return a.svgFile;
    }

    public String getPlaceholders() {
        Animation a;
        return a.placeholders;
    }

    public void setAnimationElements(Set<AnimationElement> set) {
        Object a = set;
        Animation a2 = this;
        a2.animationElements = a;
    }

    public int hashCode() {
        Animation a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[2 ^ 3] = a.getProjectId();
        objectArray[1 ^ 3] = a.getName();
        return Objects.hash(objectArray);
    }

    public Set<AnimationScript> getAnimationScripts() {
        Animation a;
        return a.animationScripts;
    }

    public void addScript(AnimationScript animationScript) {
        Animation a;
        Animation a2 = animationScript;
        Animation animation = a = this;
        a2.setAnimation(animation);
        animation.animationScripts.add(a2);
    }

    public void setColor(String string) {
        Object a = string;
        Animation a2 = this;
        a2.color = a;
    }

    public boolean equals(Object object) {
        Animation a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof Animation)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 5 >> 3;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (3 & 5) != 0;
        }
        return false;
    }

    public void setPlayOrder(Short s) {
        Object a = s;
        Animation a2 = this;
        a2.playOrder = a;
    }

    public Project getProject() {
        Animation a;
        return a.project;
    }

    public String getPostAnimCode() {
        Animation a;
        return a.postAnimCode;
    }

    public void setProjectId(String string) {
        Object a = string;
        Animation a2 = this;
        a2.projectId = a;
    }

    public String getPreAnimCode() {
        Animation a;
        return a.preAnimCode;
    }

    public String getSvgFileId() {
        Animation a;
        return a.svgFileId;
    }

    public void setAnimationScripts(Set<AnimationScript> set) {
        Object a = set;
        Animation a2 = this;
        a2.animationScripts = a;
    }

    public void setSvgFileId(String string) {
        Object a = string;
        Animation a2 = this;
        a2.svgFileId = a;
    }

    private static /* synthetic */ boolean lambda$removeScript$1(String string, AnimationScript animationScript) {
        String a = animationScript;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public String getName() {
        Animation a;
        return a.name;
    }

    public void setSvgFile(FileInfo fileInfo) {
        Animation a;
        Animation a2 = fileInfo;
        Animation animation = a = this;
        animation.svgFile = a2;
        animation.svgFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void removeScript(String string) {
        Object a = string;
        Animation a2 = this;
        a2.animationScripts.removeIf(arg_0 -> Animation.lambda$removeScript$1((String)a, arg_0));
    }

    public void setPostAnimCode(String string) {
        Object a = string;
        Animation a2 = this;
        a2.postAnimCode = a;
    }

    public Animation() {
        Animation a;
        Animation animation = a;
        a.animationElements = new HashSet();
        animation.animationScripts = new HashSet();
    }

    public void setAlignment(String string) {
        Object a = string;
        Animation a2 = this;
        a2.alignment = a;
    }

    public void setProject(Project project) {
        Animation a;
        Animation a2 = project;
        Animation animation = a = this;
        animation.project = a2;
        animation.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Short getPlayOrder() {
        Animation a;
        return a.playOrder;
    }

    private static /* synthetic */ boolean lambda$removeElement$0(String string, AnimationElement animationElement) {
        String a = animationElement;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public void setAnimJoinId(String string) {
        Object a = string;
        Animation a2 = this;
        a2.animJoinId = a;
    }

    public String getDsc() {
        Animation a;
        return a.dsc;
    }

    public Integer getDuration() {
        Animation a;
        return a.duration;
    }

    public void removeElement(String string) {
        Object a = string;
        Animation a2 = this;
        a2.animationElements.removeIf(arg_0 -> Animation.lambda$removeElement$0((String)a, arg_0));
    }

    public void addElement(AnimationElement animationElement) {
        Animation a;
        Animation a2 = animationElement;
        Animation animation = a = this;
        a2.setAnimation(animation);
        animation.animationElements.add(a2);
    }

    public void setConfigs(String string) {
        Object a = string;
        Animation a2 = this;
        a2.configs = a;
    }

    public void setMainFlag(Boolean bl) {
        Object a = bl;
        Animation a2 = this;
        a2.mainFlag = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Animation a2 = this;
        a2.dsc = a;
    }

    public void setName(String string) {
        Object a = string;
        Animation a2 = this;
        a2.name = a;
    }

    public String getConfigs() {
        Animation a;
        return a.configs;
    }

    public String getColor() {
        Animation a;
        return a.color;
    }

    public void setPreAnimCode(String string) {
        Object a = string;
        Animation a2 = this;
        a2.preAnimCode = a;
    }

    public String getAnimJoinId() {
        Animation a;
        return a.animJoinId;
    }

    public void setPlaceholders(String string) {
        Object a = string;
        Animation a2 = this;
        a2.placeholders = a;
    }

    public Set<AnimationElement> getAnimationElements() {
        Animation a;
        return a.animationElements;
    }

    public String getProjectId() {
        Animation a;
        return a.projectId;
    }
}

