/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.m.c_ql;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.o.c_Wl;
import com.inscada.mono.alarm.o.c_Yl;
import com.inscada.mono.alarm.o.c_Zk;
import com.inscada.mono.alarm.o.c_gK;
import com.inscada.mono.alarm.o.c_rk;
import com.inscada.mono.alarm.services.c_BJ;
import com.inscada.mono.alarm.services.c_LJ;
import com.inscada.mono.alarm.services.c_fL;
import com.inscada.mono.alarm.services.c_tk;
import com.inscada.mono.auth.c_hJ;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.log.o.c_nA;
import com.inscada.mono.project.o.c_D;
import com.inscada.mono.settings.restcontrollers.LoginController;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.n.c_kc;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_D {
    private final c_nA f_Kw;
    public static final short f_nw = 103;
    public static final short f_NU = 108;
    private final c_tk f_uW;
    public static final short f_zv = 106;
    public static final short f_Lv = 107;
    private static final String f_PU = "activeAlarmGroups";
    public static final short f_bw = 105;
    private final c_K f_eV;
    private final Lock f_Qx;
    private final c_BJ f_jV;
    public static final short f_Kv = 101;
    public static final short f_tw = 102;
    private final c_LJ f_yw;
    private final JedisPooled f_DW;
    public static final short f_cx = 104;
    public static final short f_Tx = 109;
    private final c_hJ f_jW;
    private static final Logger f_Tw = LoggerFactory.getLogger(AlarmManager.class);

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_jV.m_gia((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_ql> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\u0004\u0004\t\u0005\r\u0013ra\u000f$<5!//a)-)3%a;5)5=2-2h''3h:5a\u0001\u0005;a$.+ $-1{h:5"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_Tw.debug(LoginController.m_iF((Object)"QAQ#SK^JZ\\%.Mkn{z}kgqi?bzo{km.yam.~b~|r.lz~zj}z}?hp|?ub.VJl4?ub"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_eV.m_v(Short.valueOf((short)(0x7B & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_eV.m_La();
        f_Tw.info(c_kc.m_YE((Object)"\u0000$ :,\u0005 & /$:{h\u0015 (;a&.,$hi3<aa  ;a*$+.%$h5 $h\r\r\u0000\f\u0004\u001aoh\u0013-2<.:(&&h +5!7-a)-)3%2fof"), a);
        alarmManager2.f_Qx.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_DW.smembers(f_PU));
            if (hashSet.isEmpty()) {
                f_Tw.info(LoginController.m_iF((Object)"^b~|rC~`~iz|?&Sk~jz|?ub'%.Qa?o|zvxz.~b~|r.x|p{o}?hp{qj?gq.Mk{gl.ka?|z}kamk1"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[4 ^ 5] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_Tw.info(c_kc.m_YE((Object)"\t-)3%\f)/)&-3hi\u0004$)%-3h:5hra\u000e.=/,a3<h +5!7-a)-)3%a/3'48a\u0001\u0005;a!/h\u0013-%!2h5'a:$;5'3-{h:5"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[3 >> 1];
            stringArray[5 >> 3] = LoginController.m_iF((Object)"XVKHQ^B^\\RQX\\P[O");
            alarmManager.f_jW.m_nDa(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_jV.m_oia((Set)a2));
            }, stringArray);
            f_Tw.info(c_kc.m_YE((Object)"\u0000$ :,\u0005 & /$:a`\r- ,$:a3<a{h\u0000<5-,85!//a<.h3-2<.:$h:5a)-)3%a/3'482f"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_eV.m_La();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 >> 2] = LoginController.m_iF((Object)"O\\ZVX^ZZQ^B^\\R");
                stringArray[--1] = c_kc.m_YE((Object)"\u0005\r\u0000\u000b\u0015\u0001\u0017\t\u0015\r\u001e\t\r\t\u0013\u0005");
                alarmManager2.f_jW.m_oda(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_Tw.info(LoginController.m_iF((Object)"^b~|rC~`~iz|?&Sk~jz|?ub'%.Ygqglfzj?osomc?|z}kamokgp`?~ma|kl}1"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Tw.error(c_kc.m_YE((Object)"\u0000$ :,\u0005 & /$:a`\r- ,$:a3<a{h\u0004:3'3h%=3!//a)-)3%a:$;5'3)5!.&a83'\"-2;{h:5"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Qx.unlock();
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.info(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\t)/,-!//a\u00183'+-\"<\u0005- +5!7)5-\u0004>$&5h''3h1:.\"$+5h\b\f{h:5"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?Gx`p|v`x.O|pdzmkJzo|zvx~zzKikqz?hp|?~mauk|z?G[4?ub"), a);
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_LJ c_LJ2, c_BJ c_BJ2, c_tk c_tk2, c_nA c_nA2, JedisPooled jedisPooled, c_K c_K2, c_hJ c_hJ2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_hJ2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_Qx = new ReentrantLock();
        a8.f_yw = a7;
        alarmManager5.f_jV = a6;
        alarmManager5.f_uW = a5;
        alarmManager4.f_Kw = a4;
        alarmManager4.f_DW = a3;
        alarmManager3.f_eV = a2;
        alarmManager3.f_jW = a;
    }

    /*
     * WARNING - void declaration
     */
    protected c_ql getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_ql.f_Az;
        }
        AlarmManager a2 = alarmManager.f_uW.m_iIa(a.getGroup().getId());
        if (a2 != null && a2.m_OHa() && a2.m_Mha(a.getId())) {
            return c_ql.f_FY;
        }
        return c_ql.f_Az;
    }

    @TransactionalEventListener(value={c_Zk.class})
    public void handleAlarmGroupDeleteEvent(c_Zk c_Zk2) {
        AlarmManager a = c_Zk2;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.info(c_kc.m_YE((Object)"\u0004\u0004\t\u0005\r\u0013ra\u0000 &%$(&&h\u0000$ :,\u000f3'48\u0005---5-\u0004>$&5h''3h&:.=1h\b\f{h:5"), (Object)a.m_kHa().getId());
            a2.deactivateAlarmGroupInternal(a.m_kHa().getId());
            return;
        }
        f_Tw.debug(LoginController.m_iF((Object)"QAQ#SK^JZ\\%.Viqamgqi?OsomcX|p{oJzbzzzKikqz?hp|?imaj~?G[4?ub"), (Object)a.m_kHa().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_ql getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_yw.m_IIa((String)a2, (String)a)) == null) {
            return c_ql.f_Az;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_jV.m_Vha((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_ql> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\u0006-5<(&&h $-h $ :,h&:.=1h2< <4;$;a..:a83'+-\"<a3<h-'\")-$8f"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?\\z\u007fjklzv`x.sk~jz|?hp|?osb?osomc?imaj~?}kok{lkl.yam.o|pdzmk.ds1"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_eV.m_v(Short.valueOf((short)(0x6A & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_gK.class})
    public void handleAlarmAddEvent(c_gK c_gK2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_eV.m_Ka()) {
            c_fL c_fL2;
            AlarmManager a = a.m_NGa();
            f_Tw.info(c_kc.m_YE((Object)"\u0004\u0004\t\u0005\r\u0013ra\u0000 &%$(&&h\u0000$ :,\t%,\u0004>$&5h''3h $ :,h\b\f{h:5mh\u0006:.=1h\b\f{h:5"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_fL2 = alarmManager.f_uW.m_iIa(a.getGroupId())) != null && c_fL2.m_OHa()) {
                c_fL2.m_qha((Alarm)a);
                return;
            }
        } else {
            f_Tw.debug(LoginController.m_iF((Object)"QAQ#SK^JZ\\%.Viqamgqi?Osomc^j{Kikqz?hp|?osomc?G[4?ub"), (Object)a.m_NGa().getId());
        }
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Qx.lock();
        try {
            c_fL c_fL2 = a2.f_uW.m_iIa(a.getId());
            if (c_fL2 != null) {
                c_fL2.m_eGa();
                a2.f_uW.m_pia(a.getId(), c_fL2);
            }
            String[] stringArray = new String[3 >> 1];
            stringArray[5 >> 3] = a.getId();
            a2.f_DW.srem(f_PU, stringArray);
            return;
        }
        finally {
            a2.f_Qx.unlock();
        }
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_jV.m_xga((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_ql getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\u0006-5<(&&h $ :,h2< <4;a..:a3<h-'\")-$8f"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?\\z\u007fjklzv`x.sk~jz|?hp|?osomc?}kok{l.yam.ds1"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            return (c_ql)a2.f_eV.m_v(Short.valueOf((short)(0x67 & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Qx.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_fL c_fL2 = a2.f_uW.m_Oha((AlarmGroup)a);
            c_fL2.m_QGa();
            if (c_fL2.m_OHa()) {
                String[] stringArray = new String[3 & 5];
                stringArray[5 >> 3] = a.getId();
                a2.f_DW.sadd(f_PU, stringArray);
            }
            return;
        }
        finally {
            a2.f_Qx.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\u0000+5!7)5!//a)-)3%a/3'48a3<h-'\")-$8f"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_Tw.debug(LoginController.m_iF((Object)"QAQ#SK^JZ\\%.Mkn{z}kgqi?bzo{km.ka?o|zvx~zz.~b~|r.x|p{o.ds1"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_eV.m_v(Short.valueOf((short)(0x6D & 0x77)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_ql> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\u0006-5<(&&h $-h $ :,h2< <4;$;a..:a83'+-\"<a3<h-'\")-$8f"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?\\z\u007fjklzv`x.sk~jz|?hp|?osb?osomc?}kok{lkl.yam.o|pdzmk.ds1"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_eV.m_v(Short.valueOf((short)(0x6D & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_Yl.class})
    public void handleAlarmDeleteEvent(c_Yl c_Yl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_eV.m_Ka()) {
            AlarmManager a = a.m_zGa();
            f_Tw.info(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\t)/,-!//a\t-)3%\u0005---5-\u0004>$&5h''3h $ :,h\b\f{h:5mh\u0006:.=1h\b\f{h:5"), (Object)a.getId(), (Object)a.getGroupId());
            c_fL c_fL2 = alarmManager.f_uW.m_iIa(a.getGroupId());
            if (c_fL2 != null && c_fL2.m_OHa()) {
                c_fL2.m_YGa((Alarm)a);
                return;
            }
        } else {
            f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?Gx`p|v`x.^b~|rJzbzzzKikqz?hp|?osomc?G[4?ub"), (Object)a.m_zGa().getId());
        }
    }

    protected Map<String, c_ql> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_jV.m_uga((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Tw.info(c_kc.m_YE((Object)"\u0000$ :,\u0005 & /$:a`\r- ,$:a3<a{h\u0013-2<.:(&&h $ :,h&:.=1ra3<hi\u0001\u0005ra3<a"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[3 & 5] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Kw.m_IL(a2.getProject()).m_q("Alarm Group Restore (Leader " + (String)a + ")", LoginController.m_iF((Object)"+l.7G[4?+l'?h~gsk{.ka?|z}kamk1.\\oj}z4?+l").formatted(objectArray));
            try {
                f_Tw.warn(c_kc.m_YE((Object)"\u0000$ :,\u0005 & /$:a`\r- ,$:a3<a{h\u0000<5-,85!//a<.h%- +5!7)5-a)-)3%a/3'48a3<h .5-3h3-2<.: <('/h')($4:$f"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Tw.error(LoginController.m_iF((Object)"^b~|rC~`~iz|?&Sk~jz|?ub'%.Yovbzj?zp.{k~mkgiokk?osomc?imaj~?ub.~hkkm.mklzp|~zvaq.yovbj|z4?ub"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\u0004\u0004\t\u0005\r\u0013ra\t\"<(> <(&&h $-h $ :,h&:.=1;a..:a83'+-\"<a3<h-'\")-$8f"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?\\z\u007fjklzv`x.sk~jz|?zp.~mkgiokk?osb?osomc?imaj~l.yam.o|pdzmk.ds1"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a;
            a2.f_eV.m_v(Short.valueOf((short)(0x7E & 0x6D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_ql> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_jV.m_Vha((String)a, (String)a3).getId());
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_jV.m_xga((String)a2));
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_eV.m_La();
        f_Tw.info(LoginController.m_iF((Object)"OsomcRoqoxkm4?Zwgl.qa{k?&ds6.v}?@P.SAQIZ\\?ZWK?BZO[KM ?]kao~v`x.~bs.sa|os.~b~|r.v`l~zmkam}1 1"), a);
        alarmManager2.f_Qx.lock();
        try {
            alarmManager.f_uW.m_oga();
            f_Tw.info(c_kc.m_YE((Object)"\t-)3%\f)/)&-3hi\u0006.<a\u0004$)%-3h:5hra\t-$a$.+ $a)-)3%a!/;1-\"<('/h5)2#2h))7-a*$-/h3-0=$;5-%h5'a;5'1f"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Tw.error(LoginController.m_iF((Object)"^b~|rC~`~iz|?&Qak.Sk~jz|?ub'%.Z|mam.{{mgqi?~ma|kl}?ay.lzp~ogqi?bpm~b?osomc?gq}ok|zp|l4?ub"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Qx.unlock();
        }
    }

    protected c_ql getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_uW.m_iIa((String)a)) != null && a.m_OHa()) {
            return c_ql.f_FY;
        }
        return c_ql.f_Az;
    }

    protected Map<String, c_ql> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_yw.m_Hha((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_eV.m_ba((ClusterNodeListener)a);
        f_Tw.info(LoginController.m_iF((Object)"^b~|rC~`~iz|?gqgkg~bvtzj?oqj?|ziv}kkmk{.~}?Ms{lzz|Qa{kSglzz`z|1"));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\u0004\u0004\t\u0005\r\u0013ra\f$)\"<(> <(&&h $-h $ :,h&:.=1;a..:a83'+-\"<a3<h-'\")-$8f"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?\\z\u007fjklzv`x.sk~jz|?zp.{k~mkgiokk?osb?osomc?imaj~l.yam.o|pdzmk.ds1"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            a2.f_eV.m_v(Short.valueOf((short)(0x6D & 0x7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_jW.m_Ifa(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected c_ql getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_yw.m_Hga((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_ql getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\u0006-5<(&&h $ :,h&:.=1h2< <4;a..:a3<h-'\")-$8f"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?\\z\u007fjklzv`x.sk~jz|?hp|?osomc?imaj~?}kok{l.yam.ds1"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (c_ql)a2.f_eV.m_v(Short.valueOf((short)(0x6E & 0x79)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_jW.m_Ifa(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_rk.class})
    public void handleAlarmGroupChangeEvent(c_rk c_rk2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_eV.m_Ka()) {
            f_Tw.info(c_kc.m_YE((Object)"\u0004\u0004\t\u0005\r\u0013ra\u0000 &%$(&&h\u0000$ :,\u000f3'48\u0002  &&-\u0004>$&5h''3h&:.=1h\b\f{h:5"), (Object)a.m_sIa().getId());
            alarmManager.f_Qx.lock();
            try {
                Object a2 = a.m_sIa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_ql.f_FY) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_Qx.unlock();
            }
        }
        f_Tw.debug(LoginController.m_iF((Object)"QAQ#SK^JZ\\%.Viqamgqi?OsomcX|p{oMwoqizKikqz?hp|?imaj~?G[4?ub"), (Object)a.m_sIa().getId());
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_jV.m_gia((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_eV.m_Ka()) {
            f_Tw.debug(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\u0005- +5!7)5!//a)-)3%a/3'48a3<h-'\")-$8f"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_Tw.debug(LoginController.m_iF((Object)"QAQ#SK^JZ\\%.Mkn{z}kgqi?bzo{km.ka?jzo|zvx~zz.~b~|r.x|p{o.ds1"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            a2.f_eV.m_v(Short.valueOf((short)(0x76 & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[3 ^ 3] = String.class;
            alarmManager.f_eV.m_t((short)(0x7D & 0x67), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_kc.m_YE((Object)" +5!7)5-\u0000$ :,\u000f3'48\b&5-3& $"), classArray));
            Class[] classArray2 = new Class[3 & 5];
            classArray2[3 >> 2] = String.class;
            alarmManager.f_eV.m_t((short)(0x66 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoginController.m_iF((Object)"jzo|zvx~zzOsomcX|p{oGqzz|qos"), classArray2));
            Class[] classArray3 = new Class[3 >> 1];
            classArray3[5 >> 3] = String.class;
            alarmManager.f_eV.m_t((short)(0x67 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_kc.m_YE((Object)"&-5\t-)3%\u0012< <4;\b&5-3& $"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 & 4] = String.class;
            alarmManager.f_eV.m_t((short)(0x7F & 0x68), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoginController.m_iF((Object)"xkkOsomcX|p{o]kok{lGqzz|qos"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[3 >> 2] = String.class;
            alarmManager.f_eV.m_t((short)(0x7D & 0x6B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_kc.m_YE((Object)"/$<\u0000$ :,\u001b5)5=2-2\n8\u00183'+-\"<\b,\b&5-3& $"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_eV.m_t((short)(0x6F & 0x7A), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoginController.m_iF((Object)"izz^b~|rImaj~Lz~zj}z}]wO|pdzmkG{Gqzz|qos"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_eV.m_t((short)(0x6F & 0x7B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_kc.m_YE((Object)"&-5\t-)3%\u0012< <4;$;\b&5-3& $"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_eV.m_t((short)(0x6E & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoginController.m_iF((Object)"o|zvx~zzOsomcX|p{o}]wO|pdzmkG{Gqzz|qos"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_eV.m_t((short)(0x6D & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_kc.m_YE((Object)"%- +5!7)5-\u0000$ :,\u000f3'482\n8\u00183'+-\"<\b,\b&5-3& $"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(LoginController.m_iF((Object)"Yovbzj?zp.mkxglzz|?OsomcRoqoxkm.M^\\.rkkfpjl"), a);
        }
    }

    @TransactionalEventListener(value={c_Wl.class})
    public void handleAlarmChangeEvent(c_Wl c_Wl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_eV.m_Ka()) {
            AlarmManager a = a.m_ZGa();
            f_Tw.info(c_kc.m_YE((Object)"\r\r\u0000\f\u0004\u001a{h\t)/,-!//a\t-)3%\u0002  &&-\u0004>$&5h''3h $ :,h\b\f{h:5mh\u0006:.=1h\b\f{h:5"), (Object)a.getId(), (Object)a.getGroupId());
            c_fL c_fL2 = alarmManager.f_uW.m_iIa(a.getGroupId());
            if (c_fL2 != null && c_fL2.m_OHa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_fL2.m_qha((Alarm)a);
                    return;
                }
                c_fL2.m_YGa((Alarm)a);
                return;
            }
        } else {
            f_Tw.debug(LoginController.m_iF((Object)"@P@2BZO[KM4?Gx`p|v`x.^b~|rMwoqizKikqz?hp|?osomc?G[4?ub"), (Object)a.m_ZGa().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_ql getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_jV.m_qga((String)a2, (String)a)) == null) {
            return c_ql.f_Az;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }
}

