/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.repositories;

import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface AlarmRepository<T extends Alarm>
extends BaseJpaRepository<T> {
    public List<T> findByProjectId(String var1);

    @Query(value="select distinct(a.part) p from inscada.alarm a where a.space_id = ?#{authentication.activeSpace.id} and a.project_id = ?1 and a.part is not null and a.deleted_dttm is null order by p", nativeQuery=true)
    public List<String> findDistinctPartsByProjectId(String var1);

    @Query(value="select a from #{#entityName} a join a.group g where g.name = ?2 and a.projectId = ?1")
    public List<T> findByGroupName(String var1, String var2);

    public Page<T> findAll(Pageable var1);

    @Query(value="select alm from #{#entityName} alm where (alm.projectId = ?#{#alarmFilter.projectId} or ?#{#alarmFilter.projectId} is null or ?#{#alarmFilter.projectId} = '') and (alm.groupId = ?#{#alarmFilter.groupId} or ?#{#alarmFilter.groupId} is null or ?#{#alarmFilter.groupId} = '') and (alm.part = ?#{#alarmFilter.part} or ?#{#alarmFilter.part} is null or ?#{#alarmFilter.part} = '') and (?#{#alarmFilter.nameIn} is null or ?#{#alarmFilter.nameIn} = '' or upper(alm.name) like %?#{#alarmFilter.nameIn.toUpperCase()}% ) and(?#{#alarmFilter.dscIn} is null or ?#{#alarmFilter.dscIn} = '' or upper(alm.dsc) like %?#{#alarmFilter.dscIn.toUpperCase()}%)")
    public Page<T> findAlarmsByFilter(@Param(value="alarmFilter") AlarmFilter var1, @Param(value="pageable") Pageable var2);

    public Page<T> findByProjectId(String var1, Pageable var2);

    public List<T> findByProjectIdAndNameIn(String var1, Set<String> var2);

    public List<T> findByGroupIdAndIsActiveTrue(String var1);

    public Optional<T> findOneByProjectIdAndName(String var1, String var2);
}

