/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.repositories;

import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.user.model.User;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface UserRepository
extends BaseJpaRepository<User> {
    @Query(value="SELECT u FROM User u WHERE u.username IN :usernames")
    public List<User> findByUsernameIn(@Param(value="usernames") String[] var1);

    @Query(value="SELECT DISTINCT u FROM User u LEFT JOIN FETCH u.roles WHERE u.id = :id")
    public Optional<User> findByIdWithRoles(@Param(value="id") String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE u.username IN :usernames AND s.id = :spaceId")
    public List<User> findByUsernameInAndSpacesId(@Param(value="usernames") List<String> var1, @Param(value="spaceId") String var2);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE u.id = :userId and s.id = :spaceId")
    public Optional<User> findByIdAndSpacesId(@Param(value="userId") String var1, @Param(value="spaceId") String var2);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE u.id IN :userIds AND s.id = :spaceId")
    public List<User> findByIdInAndSpacesId(@Param(value="userIds") List<String> var1, @Param(value="spaceId") String var2);

    @Query(value="SELECT u FROM User u WHERE u.username = :username")
    public Optional<User> findOneByUsername(@Param(value="username") String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE s.id = :spaceId")
    public List<User> findBySpacesId(@Param(value="spaceId") String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE u.username IN :usernames AND s.name = :space")
    public List<User> findByUsernameInAndSpacesName(@Param(value="usernames") String[] var1, @Param(value="space") String var2);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE u.username = :username AND s.id = :spaceId")
    public Optional<User> findOneByUsernameAndSpacesId(@Param(value="username") String var1, @Param(value="spaceId") String var2);

    @Query(value="SELECT DISTINCT u FROM User u LEFT JOIN FETCH u.spaces WHERE u.id = :id")
    public Optional<User> findByIdWithSpaces(@Param(value="id") String var1);

    public Optional<User> findOneByUsernameIgnoreCase(String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE s.name = :space")
    public List<User> findBySpacesName(@Param(value="space") String var1);
}

