/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.trend.model.Trend;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="trend_tag")
@AttributeOverride(name="id", column=@Column(name="trend_tag_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull.List(value={@CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"}), @CheckAtLeastOneNotNull(fieldNames={"trendId", "trend"})})
public class TrendTag
extends SpaceBaseModel {
    @Size(max=7)
    private String color;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_id", insertable=false, updatable=false)
    private VariableView variable;
    @Column(name="grid_thickness")
    private Double gridThickness;
    @Size(max=255)
    private String dsc;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="trend_id")
    private Trend trend;
    @Column(name="hide_value_axe")
    private Boolean hideValueAxe;
    @Column(name="max_scale")
    private Double maxScale;
    @NotNull
    @Column(name="status_flag")
    private Boolean status;
    @Column(name="min_scale")
    private Double minScale;
    @Column(name="trend_id", insertable=false, updatable=false)
    private String trendId;
    @Min(value=1L)
    private Integer thickness;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="tag_order")
    private Integer order;
    @Column(name="variable_id")
    private String variableId;

    @JsonSetter
    public void setVariable(VariableView variableView) {
        TrendTag a = variableView;
        TrendTag a2 = this;
        a2.variable = a;
        if (a2.variable != null) {
            a2.variableId = a.getId();
            return;
        }
        a2.variableId = null;
    }

    public void setColor(String string) {
        Object a = string;
        TrendTag a2 = this;
        a2.color = a;
    }

    public void setGridThickness(Double d) {
        Object a = d;
        TrendTag a2 = this;
        a2.gridThickness = a;
    }

    public void setMaxScale(Double d) {
        Object a = d;
        TrendTag a2 = this;
        a2.maxScale = a;
    }

    public void setThickness(Integer n) {
        Object a = n;
        TrendTag a2 = this;
        a2.thickness = a;
    }

    public void setStatus(Boolean bl) {
        Object a = bl;
        TrendTag a2 = this;
        a2.status = a;
    }

    public void setVariableId(String string) {
        Object a = string;
        TrendTag a2 = this;
        a2.variableId = a;
    }

    public TrendTag() {
        TrendTag a;
    }

    public Double getGridThickness() {
        TrendTag a;
        return a.gridThickness;
    }

    public void setOrder(Integer n) {
        Object a = n;
        TrendTag a2 = this;
        a2.order = a;
    }

    public boolean equals(Object object) {
        TrendTag a = this;
        Object a2 = object;
        if (a == a2) {
            return 5 >> 2;
        }
        if (!(a2 instanceof TrendTag)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        if (a.getName().equals(object2.getName()) && a.getTrendId().equals(object2.getTrendId())) {
            return --1 != 0;
        }
        return false;
    }

    public Boolean getStatus() {
        TrendTag a;
        return a.status;
    }

    public String getColor() {
        TrendTag a;
        return a.color;
    }

    public String getTrendId() {
        TrendTag a;
        return a.trendId;
    }

    public String getDsc() {
        TrendTag a;
        return a.dsc;
    }

    public Boolean getHideValueAxe() {
        TrendTag a;
        return a.hideValueAxe;
    }

    public VariableView getVariable() {
        TrendTag a;
        return a.variable;
    }

    public void setName(String string) {
        Object a = string;
        TrendTag a2 = this;
        a2.name = a;
    }

    public Double getMaxScale() {
        TrendTag a;
        return a.maxScale;
    }

    public Integer getThickness() {
        TrendTag a;
        return a.thickness;
    }

    public String getVariableName() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getName();
        }
        return null;
    }

    public String getName() {
        TrendTag a;
        return a.name;
    }

    public Double getMinScale() {
        TrendTag a;
        return a.minScale;
    }

    public Short getVariableDecimalPoint() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getFractionalDigitCount();
        }
        return null;
    }

    public String getVariableUnit() {
        TrendTag a;
        if (a.variable != null) {
            return a.variable.getUnit();
        }
        return null;
    }

    public String getVariableId() {
        TrendTag a;
        return a.variableId;
    }

    public int hashCode() {
        TrendTag a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[3 & 5] = a.getName();
        objectArray[--2] = a.getTrendId();
        return Objects.hash(objectArray);
    }

    public Integer getOrder() {
        TrendTag a;
        return a.order;
    }

    public void setDsc(String string) {
        Object a = string;
        TrendTag a2 = this;
        a2.dsc = a;
    }

    public void setHideValueAxe(Boolean bl) {
        Object a = bl;
        TrendTag a2 = this;
        a2.hideValueAxe = a;
    }

    public void setTrend(Trend trend) {
        TrendTag a;
        TrendTag a2 = trend;
        TrendTag trendTag = a = this;
        trendTag.trend = a2;
        trendTag.trendId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setTrendId(String string) {
        Object a = string;
        TrendTag a2 = this;
        a2.trendId = a;
    }

    public void setVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableId = a.getId();
            variable2.variable = VariableView.from(a);
            return;
        }
        a2.variableId = null;
        a2.variable = null;
    }

    public Trend getTrend() {
        TrendTag a;
        return a.trend;
    }

    public void setMinScale(Double d) {
        Object a = d;
        TrendTag a2 = this;
        a2.minScale = a;
    }
}

