/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.trend.model.TrendTag;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="trend")
@AttributeOverride(name="id", column=@Column(name="trend_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Trend
extends SpaceBaseModel {
    private String configs;
    @NotBlank
    @Size(max=100)
    private String name;
    @NotNull
    @Min(value=1000L)
    private Integer period;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @Column(name="trend_order")
    private Integer order;
    @JsonIgnore
    @OneToMany(mappedBy="trend")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<TrendTag> trendTags;
    @Size(max=255)
    private String dsc;

    public void setOrder(Integer n) {
        Object a = n;
        Trend a2 = this;
        a2.order = a;
    }

    public Set<TrendTag> getTrendTags() {
        Trend a;
        return a.trendTags;
    }

    public Integer getOrder() {
        Trend a;
        return a.order;
    }

    public String getConfigs() {
        Trend a;
        return a.configs;
    }

    public Trend() {
        Trend a;
        Trend trend = a;
        trend.trendTags = new HashSet();
    }

    public Project getProject() {
        Trend a;
        return a.project;
    }

    public Integer getPeriod() {
        Trend a;
        return a.period;
    }

    public boolean equals(Object object) {
        Trend a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof Trend)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (3 & 5) != 0;
        }
        return false;
    }

    public String getProjectId() {
        Trend a;
        return a.projectId;
    }

    public void setProjectId(String string) {
        Object a = string;
        Trend a2 = this;
        a2.projectId = a;
    }

    public String getName() {
        Trend a;
        return a.name;
    }

    public void setTrendTags(Set<TrendTag> set) {
        Object a = set;
        Trend a2 = this;
        a2.trendTags = a;
    }

    public void setConfigs(String string) {
        Object a = string;
        Trend a2 = this;
        a2.configs = a;
    }

    public void setName(String string) {
        Object a = string;
        Trend a2 = this;
        a2.name = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Trend a2 = this;
        a2.dsc = a;
    }

    public void setPeriod(Integer n) {
        Object a = n;
        Trend a2 = this;
        a2.period = a;
    }

    public String getDsc() {
        Trend a;
        return a.dsc;
    }

    public void setProject(Project project) {
        Trend a;
        Trend a2 = project;
        Trend trend = a = this;
        trend.project = a2;
        trend.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public int hashCode() {
        Trend a;
        Object[] objectArray = new Object[--3];
        objectArray[3 & 4] = super.hashCode();
        objectArray[3 & 5] = a.getProjectId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }
}

