/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.tracking.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.tracking.model.MonitorVariable;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="monitor_table")
@AttributeOverride(name="id", column=@Column(name="monitor_table_id", length=36, nullable=false, updatable=false))
public class MonitorTable
extends SpaceBaseModel {
    @Column(name="x_count")
    private Integer xCount;
    @Size(max=255)
    private String dsc;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @OneToMany(mappedBy="monitorTable")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<MonitorVariable> monitorVariables;
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;

    public void setProject(Project project) {
        MonitorTable a = project;
        MonitorTable a2 = this;
        a2.project = a;
    }

    public Project getProject() {
        MonitorTable a;
        return a.project;
    }

    public String getName() {
        MonitorTable a;
        return a.name;
    }

    public int hashCode() {
        MonitorTable a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[2 ^ 3] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getDsc() {
        MonitorTable a;
        return a.dsc;
    }

    public String getProjectId() {
        MonitorTable a;
        return a.projectId;
    }

    public void setName(String string) {
        Object a = string;
        MonitorTable a2 = this;
        a2.name = a;
    }

    public void setMonitorVariables(Set<MonitorVariable> set) {
        Object a = set;
        MonitorTable a2 = this;
        a2.monitorVariables = a;
    }

    public MonitorTable() {
        MonitorTable a;
        MonitorTable monitorTable = a;
        monitorTable.monitorVariables = new HashSet();
    }

    public void setProjectId(String string) {
        Object a = string;
        MonitorTable a2 = this;
        a2.projectId = a;
    }

    public void setDsc(String string) {
        Object a = string;
        MonitorTable a2 = this;
        a2.dsc = a;
    }

    public boolean equals(Object object) {
        MonitorTable a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof MonitorTable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return --1 != 0;
        }
        return false;
    }

    public Integer getXCount() {
        MonitorTable a;
        return a.xCount;
    }

    public Set<MonitorVariable> getMonitorVariables() {
        MonitorTable a;
        return a.monitorVariables;
    }

    public void setXCount(Integer n) {
        Object a = n;
        MonitorTable a2 = this;
        a2.xCount = a;
    }
}

