/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_jL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.replication.j.c_xl;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_d;
import com.inscada.mono.communication.base.d.c_Nj;
import com.inscada.mono.communication.base.d.c_sl;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_IG;
import com.inscada.mono.communication.base.services.c_fG;
import com.inscada.mono.communication.base.services.c_lh;
import com.inscada.mono.datatransfer.d.c_FB;
import com.inscada.mono.datatransfer.j.c_Jc;
import com.inscada.mono.datatransfer.j.c_gd;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.services.c_KC;
import com.inscada.mono.datatransfer.services.c_nd;
import com.inscada.mono.job.d.c_LA;
import com.inscada.mono.job.j.c_zC;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.j.c_jd;
import com.inscada.mono.project.j.c_i;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_i {
    public static final short f_Ai = 401;
    private final c_KC f_rG;
    public static final short f_hI = 404;
    public static final short f_Di = 402;
    private static final Logger f_WG = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short f_qG = 407;
    private final c_LA f_LI;
    private final c_d f_Fi;
    private final c_jd f_QG;
    private final c_IG f_ai;
    private final Lock f_Eh;
    public static final short f_EG = 403;
    private final Map<String, Job> f_yH;
    private static final String f_Ph = "scheduledDataTransfers";
    private final c_lh f_JH;
    private final JedisPooled f_eh;
    public static final short f_Nh = 405;
    public static final short f_Pi = 406;
    private final c_fG f_Qg;
    private final c_jL f_JG;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_xl.m_VCa((Object)"fy|mu"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_ai.m_kCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_JH.m_Lca((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Fi.m_Da();
        f_WG.info(c_zC.m_ak((Object)"Kf{f[uni|ajuBfafhb}=/Sgn|'ahkb//tz&'ft/I@'CHA@JU/SGB/KJFKB])/Dnilbckfih'nkc'chlfc'kf{f/s}fatib}'ehmt!)!"), a);
        dataTransferManager2.f_Eh.lock();
        try {
            new ArrayList(dataTransferManager.f_yH.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_yH.clear();
            f_WG.info(c_xl.m_VCa((Object)"\\qlqLby~kv}bUqvq\u007fuj00^wd8\\}q|uj0cm1*8Qt|8|wsy|8tydy0lby~kv}b8zwrk0pqnu8r}uv0juie}clu|0l\u007f8sy~{ut0y~|0{|}qju|0~bw}8|wsy|8djq{{q~\u007f>"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[--2] = exception;
            f_WG.error(c_zC.m_ak((Object)"CnsnS}fatib}Jnin`ju//Ah{'Cbncju/|r.5'Ju}h}'kr}na`/w}hlb|t/hi'lfadjkcna`/k`dnk/cnsn'{uni|aju/m`e|=/|r"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_Eh.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_KC c_KC2, c_IG c_IG2, c_lh c_lh2, c_fG c_fG2, c_LA c_LA2, JedisPooled jedisPooled, c_jd c_jd2, c_d c_d2, c_jL c_jL2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_jL2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_Eh = new ReentrantLock();
        dataTransferManager7.f_yH = new ConcurrentHashMap();
        dataTransferManager7.f_rG = a9;
        dataTransferManager6.f_ai = a8;
        dataTransferManager6.f_JH = a7;
        dataTransferManager5.f_Qg = a6;
        dataTransferManager5.f_LI = a5;
        dataTransferManager4.f_QG = a4;
        dataTransferManager4.f_eh = a3;
        dataTransferManager3.f_Fi = a2;
        dataTransferManager3.f_JG = a;
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return (3 & 5) != 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_gd.class})
    public void handleCancelEvent(c_gd c_gd2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Fi.m_Ma()) {
            DataTransferManager a2 = a.m_bP();
            f_WG.info(c_zC.m_ak((Object)"CBNCJU5'Gfaccna`/DnilbcBybas/a`u/cnsn'{uni|aju5'tz//FC5'tz&"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_WG.debug(c_xl.m_VCa((Object)"V_V=TUYT]B\"0Qwv\u007fjyvw8Sy~{utUnuvd8vwb8tydy0lby~kv}b\"0cm"), (Object)a.m_bP().getId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_Nj c_Nj2) {
        DataTransferManager a = c_Nj2;
        DataTransferManager a2 = this;
        switch (c_nd.f_zg[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return c_zC.m_ak((Object)"kf{f\"s}fatib}=|sns|=yf}nnecb5\"|=*t5\"|").formatted(objectArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_FB getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_xl.m_VCa((Object)"TUYT]B\"0_uldq~\u007f0|qlq8djqvc~uj0kdydmc8vwb8Y\\*8ke0t\u007f{qt|a>"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_WG.debug(c_zC.m_ak((Object)"I@I\"KJFKB]=/Ujvzb|sfih'cbncju/a`u/cnsn'{uni|aju/t{f{r|'ih}'FC5'tz!"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            return (c_FB)a2.f_Fi.m_ka(Short.valueOf((short)(0xBBF & 0x75D3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.info(c_zC.m_ak((Object)"KJFKB]=/Onikkfih'_u`mjd{CjflsfqnsjBybas/a`u/w}hebls/NK=/|r"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_WG.debug(c_xl.m_VCa((Object)"V_V=TUYT]B\"0Qwv\u007fjyvw8@j\u007fru{d\\uyslynqlu]f}~l0~\u007fj0hbwz}sl0QT\"0cm"), a);
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[1 ^ 3] = a.getCalcType();
        return c_xl.m_VCa((Object)"|qlq5djqvc~uj*tqkd5sy|{=lyuu\"fybqqz|}*=c\"5k*=c").formatted(objectArray);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_Fi.m_la((ClusterNodeListener)a);
        f_WG.info(c_zC.m_ak((Object)"CnsnS}fatib}Jnin`ju/nan{nnkf}jc/fac/uj`ft{b}bk'nt/Dcr|sjuAhkbCn|sjiju!"));
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Eh.lock();
        try {
            Job job = (Job)a2.f_yH.get(a.getId());
            if (job != null) {
                a2.f_LI.m_pn(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_yH.remove(a.getId());
            String[] stringArray = new String[5 >> 2];
            stringArray[3 >> 2] = a.getId();
            dataTransferManager.f_eh.srem(f_Ph, stringArray);
            return;
        }
        finally {
            a2.f_Eh.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_yH.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_WG.info(c_zC.m_ak((Object)"CnsnS}fatib}Jnin`ju//Ah{'Cbncju/|r.5'Lfadjkcna`/k`dnk/m`e/a`u/cnsn'{uni|aju/NK=/|r"), (Object)a3, (Object)a);
                dataTransferManager.f_LI.m_pn((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[3 >> 1] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_WG.error(c_xl.m_VCa((Object)"TydyDjqvc~uj]y~yw}b88V\u007fl0Tuyt}b8ke9\"0]bj\u007fj0{qvs}|tyvw8|wsy|8zwr8vwb8tydy0lby~kv}b8Y\\0cm\"0cm"), objectArray);
            }
        }
    }

    protected Map<String, c_FB> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    protected Map<String, c_FB> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_rG.m_HN((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return --1 != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_eh.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return --1 != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_nd.f_zg[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x2B & 0x5F) != calendar.get(0x3B & 0x4F)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x4F & 0x36) != calendar.get(0x26 & 0x5F)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(1 ^ 3) != calendar.get(5 >> 1)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(3 >> 1) != calendar.get(--1) ? 5 >> 2 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[--2];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_eh.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(c_zC.m_ak((Object)"Lr}uji{"))) {
            return false;
        }
        int a222 = switch (c_nd.f_zg[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3C & 0x7F) * (0xBEF & 0x77F8));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_sl[] c_slArray = (c_sl[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_sl[]::new);
        a4 = a7.f_Qg.m_Yca(stringArray, (Date)a5, (Date)((Object)a4), c_slArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_eh.setex(a5, (long)n, String.valueOf(d));
            a4.f_eh.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_xl.m_VCa((Object)"fy|mu"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_ai.m_kCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_JH.m_Lca(object);
        a3 = dataTransferManager2.f_JH.m_Lca((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_rG.m_Ym((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_FB> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_zC.m_ak((Object)"KJFKB]=/@js{na`/fck/cnsn'{uni|aju/t{f{r|b|'ih}'\u007fu`mjd{'tz/k`dnkc~!"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_WG.debug(c_xl.m_VCa((Object)"V_V=TUYT]B\"0Juie}clyvw8|}q|uj0~\u007fj0y|t0|qlq8djqvc~uj0kdydmc}c8vwb8`j\u007fru{d8ke>"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            return (Map)a2.f_Fi.m_ka(Short.valueOf((short)(0x63F7 & 0x1D9F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_eh.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return 3 >> 2;
        }
        return true;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[3 & 4] = String.class;
            dataTransferManager.f_Fi.m_aa((short)(0x7191 & 0xFFF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xl.m_VCa((Object)"kspu|etu\\qlqLby~kv}bQ~luj~y|"), classArray));
            Class[] classArray2 = new Class[4 ^ 5];
            classArray2[2 & 5] = String.class;
            dataTransferManager.f_Fi.m_aa((short)(0x3FFE & 0x4193), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_zC.m_ak((Object)"dnilbcCnsnS}fatib}Nasjuafc"), classArray2));
            Class[] classArray3 = new Class[3 >> 1];
            classArray3[3 ^ 3] = String.class;
            dataTransferManager.f_Fi.m_aa((short)(0xD97 & 0x73FB), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xl.m_VCa((Object)"w}d\\qlqLby~kv}bKdydmcQ~luj~y|"), classArray3));
            Class[] classArray4 = new Class[5 >> 2];
            classArray4[2 & 5] = String.class;
            dataTransferManager.f_Fi.m_aa((short)(0x5FD & 0x7B96), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_zC.m_ak((Object)"tlojczkjCnsnS}fatib}tM~_u`mjd{NkNasjuafc"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[3 & 4] = String.class;
            dataTransferManager.f_Fi.m_aa((short)(0x1D9F & 0x63F5), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xl.m_VCa((Object)"{qvs}|\\qlqLby~kv}bkRa@j\u007fru{dQtQ~luj~y|"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_Fi.m_aa((short)(0x33B6 & 0x4DDF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_zC.m_ak((Object)"`jsKf{f[uni|aju\\snsztjtM~Fc|Nasjuafc"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_Fi.m_aa((short)(0x5FDF & 0x21B7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xl.m_VCa((Object)"\u007fulTydyDjqvc~ujClqlekukRa@j\u007fru{dQtQ~luj~y|"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_zC.m_ak((Object)"Anncbk'{h/uj`ft{b}'Kf{f[uni|ajuBfafhb}']WL'bb{o`c|"), a);
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_rG.m_jm((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    protected c_FB getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_yH.containsKey(a)) {
            return c_FB.f_Tg;
        }
        return c_FB.f_iH;
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_zC.m_ak((Object)"KJFKB]=/Tlojczkfih'kf{f/s}fatib}'tz/k`dnkc~!"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_WG.debug(c_xl.m_VCa((Object)"^W^5\\]Q\\UJ*8B}amukdq~\u007f0tuyt}b8dw0kspu|etu8tydy0lby~kv}b8ke>"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            a2.f_Fi.m_ka(Short.valueOf((short)(0x59D3 & 0x27BD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_Nj c_Nj2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0xD & 0x7F, 3 & 4);
        ((Calendar)object).set(0x3F & 0x4E, 3 ^ 3);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_nd.f_zg[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x7F & 0xC, 3 >> 2);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x1B & 0x6F, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x2B & 0x5F, 0xFFFFFFFE & 0xFFFFFFFF);
                ((Calendar)object3).set(0xD & 0x7E, 3 ^ 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x3B & 0x4F, 5 >> 3);
                ((Calendar)object4).set(0x4D & 0x3E, 2 & 5);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 >> 2);
                ((Calendar)object5).set(0x7D & 0xE, 3 ^ 3);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 3 & 4);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(c_zC.m_ak((Object)"Zij\u007f\u007fblsjc/unihb/svwj"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_JH.m_mAa(a.getProjectId(), (Map)a2);
        }
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_rG.m_oO((String)a2));
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_rG.m_Nn((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_WG.info(c_zC.m_ak((Object)"Kf{f[uni|ajuBfafhb}''Kjfkb}'tz&=/Ujt{h}na`/cnsn'{uni|aju5'tz//FC5'tz&"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_QG.m_hL(a2.getProject()).m_v("Data Transfer Restore (Leader " + (String)a + ")", c_xl.m_VCa((Object)"=c88QT\"0=c10~qq|}t8dw0jukdwb}>8Syeku\"0=c").formatted(objectArray));
            try {
                f_WG.warn(c_zC.m_ak((Object)"Kf{f[uni|ajuBfafhb}''Kjfkb}'tz&=/F{sjj\u007fsfih'{h/dnilbc'kf{f/s}fatib}'tz/fisju/ujt{h}f{n`i/anncr}b!"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_WG.error(c_xl.m_VCa((Object)"\\qlqLby~kv}bUqvq\u007fuj00\\}q|uj0cm1*8Vyytu|0l\u007f8sy~{ut0|qlq8djqvc~uj0cm8q~d}b8b}cl\u007fjqlyw~8vyyteju\"0cm"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_zC.m_ak((Object)"CBNCJU5'\\dgbkrcna`/fck/cnsn'{uni|aju|'ih}'\u007fu`mjd{'tz/k`dnkc~!"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_WG.debug(c_xl.m_VCa((Object)"V_V=TUYT]B\"0Juie}clyvw8|}q|uj0l\u007f8c{x}tm|}0y|t0|qlq8djqvc~ujc8vwb8`j\u007fru{d8ke>"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 >> 2] = a;
            a2.f_Fi.m_ka(Short.valueOf((short)(0x599C & 0x27F7)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_sl c_sl2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_nd.f_Og[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_JG.m_Xda(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_rG.m_Ym((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_zC.m_ak((Object)"CBNCJU5'Lfadjkcna`/fck/cnsn'{uni|aju|'ih}'\u007fu`mjd{'tz/k`dnkc~!"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_WG.debug(c_xl.m_VCa((Object)"V_V=TUYT]B\"0Juie}clyvw8|}q|uj0l\u007f8sy~{ut0y|t0|qlq8djqvc~ujc8vwb8`j\u007fru{d8ke>"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_Fi.m_ka(Short.valueOf((short)(0x5FF5 & 0x219F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_JG.m_Xda(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    @TransactionalEventListener(value={c_Jc.class})
    public void handleRescheduleEvent(c_Jc c_Jc2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Fi.m_Ma()) {
            DataTransferManager a = a.m_HP();
            f_WG.info(c_zC.m_ak((Object)"CBNCJU5'Gfaccna`/UjtlojczkjBybas/a`u/cnsn'{uni|aju5'tz//FC5'tz&"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_FB.f_Tg) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_WG.debug(c_xl.m_VCa((Object)"V_V=TUYT]B\"0Qwv\u007fjyvw8B}c{x}tm|}Unuvd8vwb8tydy0lby~kv}b\"0cm"), (Object)a.m_HP().getId());
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Eh.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[5 >> 3] = a.getName();
            PeriodicJob periodicJob = a2.f_LI.m_mO(a.getProject(), c_xl.m_VCa((Object)"=c8Tydy0Lby~kv}b").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_yH.put(a.getId(), periodicJob);
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_eh.sadd(f_Ph, stringArray);
            return;
        }
        finally {
            a2.f_Eh.unlock();
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_rG.m_Cm((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_FB> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_xl.m_VCa((Object)"\\]Q\\UJ*8W}dlyvw8tydy0lby~kv}b8clqlekuk0~\u007fj0cm8Y\\c8|wsy|ti\"0cm"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_WG.debug(c_zC.m_ak((Object)"AHA*CBNCJU5']b~rjt{na`/kjfkb}'ih}'kf{f/s}fatib}'|snsztjt/a`u/|r'FC|=/|r"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = new ArrayList(a);
            return (Map)a2.f_Fi.m_ka(Short.valueOf((short)(0x1BB6 & 0x65DF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_xl.m_VCa((Object)"<"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Fi.m_Da();
        f_WG.info(c_xl.m_VCa((Object)"\\qlqLby~kv}bUqvq\u007fuj*8Dpyk0v\u007f|u88cm10pqk0zu{\u007fuu8dpu8\\]Q\\UJ>8B}cl\u007fjyvw8c{x}tm|}t8tydy0lby~kv}bk>6>"), a);
        dataTransferManager2.f_Eh.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_eh.smembers(f_Ph));
            if (hashSet.isEmpty()) {
                f_WG.info(c_zC.m_ak((Object)"Kf{f[uni|ajuBfafhb}''Kjfkb}'tz&=/I`'|dgbkrcbk'kf{f/s}fatib}t/a`rac/na']bkn|'{h/ujt{h}b!"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_WG.info(c_xl.m_VCa((Object)"TydyDjqvc~uj]y~yw}b88Tuyt}b8ke9\"0^\u007fm~|0cm8c{x}tm|}t8tydy0lby~kv}b8Y\\c8yv0Ju|yk0l\u007f8b}cl\u007fju\"0cm"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = c_zC.m_ak((Object)"QFBXXKF[FPS]FATIB]");
            dataTransferManager.f_JG.m_Yea(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_rG.m_im((Set)a2));
            }, stringArray);
            f_WG.info(c_xl.m_VCa((Object)"TydyDjqvc~uj]y~yw}b88Tuyt}b8ke9\"0Ydluu`lyvw8dw0jukdwb}0cm8tydy0lby~kv}bk>"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_Fi.m_Da();
                String[] stringArray = new String[--2];
                stringArray[3 & 4] = c_zC.m_ak((Object)"TLOJCZKJXKF[FPS]FATIB]");
                stringArray[2 ^ 3] = c_xl.m_VCa((Object)"[QVS]\\GTYDYOLBY^KV]B");
                dataTransferManager2.f_JG.m_Vda(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_WG.info(c_zC.m_ak((Object)"CnsnS}fatib}Jnin`ju//Cbncju/|r.5'Inan|ojc/cnsn'{uni|aju/ujt{h}f{n`i/w}hlb|t!"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_WG.error(c_xl.m_VCa((Object)"TydyDjqvc~uj]y~yw}b88Tuyt}b8ke9\"0]bj\u007fj0|ejyvw8tydy0lby~kv}b8b}cl\u007fjqlyw~8`j\u007f{ukc\"0cm"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_Eh.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Fi.m_Ma()) {
            f_WG.debug(c_zC.m_ak((Object)"KJFKB]=/Dnilbckfih'kf{f/s}fatib}'tz/k`dnkc~!"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_WG.debug(c_xl.m_VCa((Object)"^W^5\\]Q\\UJ*8B}amukdq~\u007f0tuyt}b8dw0{qvs}|8tydy0lby~kv}b8ke>"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            a2.f_Fi.m_ka(Short.valueOf((short)(0x33B6 & 0x4DDB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_FB getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_rG.m_PM((String)a2, (String)a)) == null) {
            return c_FB.f_iH;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(c_zC.m_ak((Object)"yfcrj"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }
}

