/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.template.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.d.c_UK;
import com.inscada.mono.communication.base.d.c_pl;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.HasTemplateFrame;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})
public class VariableTemplate<TFrameTemplate extends FrameTemplate<?, ?>, TDeviceTemplate extends DeviceTemplate<?>>
extends SpaceBaseModel
implements HasTemplateFrame<TFrameTemplate> {
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected String logExpressionId;
    @NotBlank
    @Size(max=100)
    protected String name;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @Column(name="log_type")
    protected c_pl logType;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Size(max=20)
    protected String code;
    @Column(name="value_expression_type")
    protected c_UK valueExpressionType;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected String valueExpressionId;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected String frameId;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @NotNull
    @Column(name="writable_flag")
    protected Boolean isWritable;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    protected String unit;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @Size(max=255)
    protected String dsc;

    public void setDsc(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.dsc = a;
    }

    public c_UK getValueExpressionType() {
        VariableTemplate a;
        return a.valueExpressionType;
    }

    public void setRawFullScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.rawFullScale = a;
    }

    public void setFrameId(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.frameId = a;
    }

    public Double getEngZeroScale() {
        VariableTemplate a;
        return a.engZeroScale;
    }

    public int hashCode() {
        VariableTemplate a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[2 ^ 3] = a.getFrameId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getLogExpressionId() {
        VariableTemplate a;
        return a.logExpressionId;
    }

    public String getName() {
        VariableTemplate a;
        return a.name;
    }

    public Boolean getIsPulseOff() {
        VariableTemplate a;
        return a.isPulseOff;
    }

    public void setLogThreshold(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.logThreshold = a;
    }

    public Boolean getKeepLastValues() {
        VariableTemplate a;
        return a.keepLastValues;
    }

    public String getValueExpressionId() {
        VariableTemplate a;
        return a.valueExpressionId;
    }

    public void setLogMaxValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.logMaxValue = a;
    }

    public Double getSetMinValue() {
        VariableTemplate a;
        return a.setMinValue;
    }

    public void setValueExpressionId(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.valueExpressionId = a;
    }

    public void setCode(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.code = a;
    }

    public void setUnit(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.unit = a;
    }

    public Integer getPulseOffDuration() {
        VariableTemplate a;
        return a.pulseOffDuration;
    }

    public Double getLogMaxValue() {
        VariableTemplate a;
        return a.logMaxValue;
    }

    public void setLogType(c_pl c_pl2) {
        VariableTemplate a = c_pl2;
        VariableTemplate a2 = this;
        a2.logType = a;
    }

    @JsonIgnore
    public TDeviceTemplate getDevice() {
        VariableTemplate a;
        return (TDeviceTemplate)a.getFrame().getDevice();
    }

    public void setSetMinValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.setMinValue = a;
    }

    public void setLogExpressionCode(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.logExpressionCode = a;
    }

    public Boolean getIsWritable() {
        VariableTemplate a;
        return a.isWritable;
    }

    public void setSetMaxValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.setMaxValue = a;
    }

    public void setRawZeroScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.rawZeroScale = a;
    }

    public Expression getLogExpression() {
        VariableTemplate a;
        return a.logExpression;
    }

    public void setValueExpression(Expression expression) {
        VariableTemplate a = expression;
        VariableTemplate a2 = this;
        a2.valueExpression = a;
    }

    public void setName(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.name = a;
    }

    public void setValueExpressionType(c_UK c_UK2) {
        VariableTemplate a = c_UK2;
        VariableTemplate a2 = this;
        a2.valueExpressionType = a;
    }

    public void setLogExpressionId(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.logExpressionId = a;
    }

    public void setLogExpression(Expression expression) {
        VariableTemplate a = expression;
        VariableTemplate a2 = this;
        a2.logExpression = a;
    }

    public Double getLogThreshold() {
        VariableTemplate a;
        return a.logThreshold;
    }

    public void setValueExpressionCode(String string) {
        Object a = string;
        VariableTemplate a2 = this;
        a2.valueExpressionCode = a;
    }

    public void setPulseOnDuration(Integer n) {
        Object a = n;
        VariableTemplate a2 = this;
        a2.pulseOnDuration = a;
    }

    public Double getLogMinValue() {
        VariableTemplate a;
        return a.logMinValue;
    }

    public void setIsPulseOff(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isPulseOff = a;
    }

    public void setEngFullScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.engFullScale = a;
    }

    public Double getRawZeroScale() {
        VariableTemplate a;
        return a.rawZeroScale;
    }

    public boolean equals(Object object) {
        VariableTemplate a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof VariableTemplate)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 3 >> 2;
        }
        if (a.getFrameId().equals(object2.getFrameId()) && a.getName().equals(object2.getName())) {
            return --1 != 0;
        }
        return false;
    }

    public String getValueExpressionCode() {
        VariableTemplate a;
        return a.valueExpressionCode;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isWritable = a;
    }

    public void setEngZeroScale(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.engZeroScale = a;
    }

    public Double getRawFullScale() {
        VariableTemplate a;
        return a.rawFullScale;
    }

    public String getFrameId() {
        VariableTemplate a;
        return a.frameId;
    }

    public void setPulseOffDuration(Integer n) {
        Object a = n;
        VariableTemplate a2 = this;
        a2.pulseOffDuration = a;
    }

    public String getDeviceId() {
        VariableTemplate a;
        return a.getFrame().getDeviceId();
    }

    public VariableTemplate() {
        VariableTemplate a;
    }

    public String getCode() {
        VariableTemplate a;
        return a.code;
    }

    public void setFractionalDigitCount(Short s) {
        Object a = s;
        VariableTemplate a2 = this;
        a2.fractionalDigitCount = a;
    }

    public Double getEngFullScale() {
        VariableTemplate a;
        return a.engFullScale;
    }

    public Boolean getIsPulseOn() {
        VariableTemplate a;
        return a.isPulseOn;
    }

    public void setIsPulseOn(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isPulseOn = a;
    }

    public String getDsc() {
        VariableTemplate a;
        return a.dsc;
    }

    public Integer getPulseOnDuration() {
        VariableTemplate a;
        return a.pulseOnDuration;
    }

    public Expression getValueExpression() {
        VariableTemplate a;
        return a.valueExpression;
    }

    public Double getSetMaxValue() {
        VariableTemplate a;
        return a.setMaxValue;
    }

    public void setLogMinValue(Double d) {
        Object a = d;
        VariableTemplate a2 = this;
        a2.logMinValue = a;
    }

    public Integer getLogPeriod() {
        VariableTemplate a;
        return a.logPeriod;
    }

    public Short getFractionalDigitCount() {
        VariableTemplate a;
        return a.fractionalDigitCount;
    }

    public String getLogExpressionCode() {
        VariableTemplate a;
        return a.logExpressionCode;
    }

    public String getUnit() {
        VariableTemplate a;
        return a.unit;
    }

    public Boolean getIsActive() {
        VariableTemplate a;
        return a.isActive;
    }

    public void setKeepLastValues(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.keepLastValues = a;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        VariableTemplate a2 = this;
        a2.isActive = a;
    }

    public void setLogPeriod(Integer n) {
        Object a = n;
        VariableTemplate a2 = this;
        a2.logPeriod = a;
    }

    public c_pl getLogType() {
        VariableTemplate a;
        return a.logType;
    }
}

