/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_jL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_d;
import com.inscada.mono.communication.base.d.c_Tl;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.j.c_Yl;
import com.inscada.mono.communication.base.j.c_jl;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_XL;
import com.inscada.mono.communication.base.services.c_Yf;
import com.inscada.mono.communication.base.services.c_k;
import com.inscada.mono.communication.base.services.c_og;
import com.inscada.mono.license.j.c_Ld;
import com.inscada.mono.log.j.c_jd;
import com.inscada.mono.project.j.c_i;
import com.inscada.mono.search.repositories.SearchRepository;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.tracking.restcontrollers.MapVariableController;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_i {
    public static final short f_ws = 207;
    private final c_d f_ns;
    private final c_og<C, V> f_XS;
    private final c_jL f_nT;
    public static final short f_XT = 204;
    public static final short f_OS = 203;
    private static final String f_FS = "activeConnections";
    public static final short f_as = 202;
    public static final short f_yt = 209;
    private final JedisPooled f_Wt;
    public static final short f_AT = 205;
    public static final short f_xT = 206;
    private final c_jd f_DS;
    private final Lock f_vu;
    private final c_XL f_Bs;
    public static final short f_cS = 208;
    public static final short f_UT = 210;
    private static final Logger f_OT = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_Ls = 201;
    private final c_Ld f_pT;

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT'\u0000\u0015\u0006\u0000\u001d\u001a\u0013T\u0015\u0018\u0018T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a\u0007T\u0012\u001b\u0006T\u0004\u0006\u001b\u001e\u0011\u0017\u0000T\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_OT.debug(SearchRepository.m_AD((Object)"`i`\u000bbcobkt\u0014\u0006|C_SKUZO@A\u000eJKGJC\\\u0006ZI\u000eUZG\\R\u000eGBJ\u000eEAH@CMRGI@U\u000e@AT\u000eV\\IDCMR\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = a;
            a2.f_ns.m_ka(Short.valueOf((short)(0x27CF & 0x58FE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Bs.m_LBa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_Bs.m_zba((String)a);
        return connectionManager2.f_nT.m_DFa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Bs.m_LBa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Yl.class})
    public void handleDeleteEvent(c_Yl c_Yl2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_ns.m_Ma()) {
            ConnectionManager a2 = a.m_GBa();
            f_OT.info(SearchRepository.m_AD((Object)"bcobkt\u0014\u0006fG@BBO@A\u000ebKJKRKcXC@R\u000e@AT\u000eEAH@CMRGI@\u001c\u000e]S\u0006\u0006oj\u001c\u000e]S\u000f"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_OT.debug(MapVariableController.m_Zf((Object)":;:Y81501&NT=\u0013\u001a\u001b\u0006\u001d\u001a\u0013T0\u0011\u0018\u0011\u0000\u00111\u0002\u0011\u001a\u0000T\u0012\u001b\u0006T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aNT\u000f\t"), (Object)a.m_GBa().getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_ns.m_la((ClusterNodeListener)a);
        f_OT.info(SearchRepository.m_AD((Object)"mI@HKEZOAHcG@GIC\\\u0006GHGRGGBOTCJ\u0006OHJ\u0006\\CIO]RKTKB\u000eG]\u0006mJ[UZC\\hABKjGUZC@C\\\b"));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT'\u0000\u001b\u0004\u0004\u001d\u001a\u0013T\u0015\u0018\u0018T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a\u0007T\u0012\u001b\u0006T\u0004\u0006\u001b\u001e\u0011\u0017\u0000T\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_OT.debug(SearchRepository.m_AD((Object)"hah\u0003jkgjc|\u001c\u000etKW[C]RGHI\u0006BCOBKT\u000eRA\u0006]RAV\u000eGBJ\u000eEAH@CMRGI@U\u000e@AT\u000eV\\IDCMR\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = a;
            a2.f_ns.m_ka(Short.valueOf((short)(0x4CCF & 0x33FF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Tl getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_Bs.m_CBa((String)a2, (String)a)) == null) {
            return c_Tl.f_kS;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_jl.class})
    public void handleRestartEvent(c_jl c_jl2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_ns.m_Ma()) {
            ConnectionManager a2 = a.m_Vba();
            f_OT.info(SearchRepository.m_AD((Object)"jkgjc|\u001c\u000enOHJJGHI\u0006|C]ROTZcXC@R\u000e@AT\u000eEAH@CMRGI@\u001c\u000e]S\u0006\u0006oj\u001c\u000e]S\u000f"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_vu.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_Tl.f_NT) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_vu.unlock();
            }
        }
        f_OT.debug(MapVariableController.m_Zf((Object)":;:Y81501&NT=\u0013\u001a\u001b\u0006\u001d\u001a\u0013T&\u0011\u0007\u0000\u0015\u0006\u00001\u0002\u0011\u001a\u0000T\u0012\u001b\u0006T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aNT\u000f\t"), (Object)a.m_Vba().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Tl getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT3\u0011\u0000\u0000\u001d\u001a\u0013T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u0007\u0000\u0015\u0000\u0001\u0007T\u0012\u001b\u0006T\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_OT.debug(SearchRepository.m_AD((Object)"hah\u0003jkgjc|\u001c\u000etKW[C]RGHI\u0006BCOBKT\u000e@AT\u000eEAH@CMRGI@\u0006]ROR[U\u000e@AT\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = a;
            return (c_Tl)a2.f_ns.m_ka(Short.valueOf((short)(0x1ADF & 0x65EB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_Tl> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Bs.m_bca((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_ns.m_Da();
        f_OT.info(SearchRepository.m_AD((Object)"eAH@CMRGI@kOHOAKT\u0014\u0006zNGU\u000eHABK\u0006\u0006]S\u000f\u000eO]\u0006`i\u000ejahic|\u0006znk\u0006bcobkt\u0000\u0006}RAV^O@A\u000eGBJ\u000eJAEOJ\u000eEAH@CMRAT]\b\u0000\b"), a);
        connectionManager2.f_vu.lock();
        try {
            connectionManager.f_XS.m_Rca();
            f_OT.info(MapVariableController.m_Zf((Object)"7\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a9\u0015\u001a\u0015\u0013\u0011\u0006T\\:\u001b\u0000T8\u0011\u0015\u0010\u0011\u0006T\u000f\t]NT5\u0018\u0018T\u0018\u001b\u0017\u0015\u0018T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001b\u0006\u0007T\u001c\u0015\u0002\u0011T\u0016\u0011\u0011\u001aT\u0006\u0011\u0005\u0001\u0011\u0007\u0000\u0011\u0010T\u0000\u001bT\u0007\u0000\u001b\u0004T\u0015\u001a\u0010T\u0017\u0018\u0011\u0015\u0006\u0011\u0010T\u0012\u0006\u001b\u0019T\u0018\u001b\u0017\u0015\u0018T\u0000\u0006\u0015\u0017\u001f\u001d\u001a\u0013Z"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_OT.error(SearchRepository.m_AD((Object)"mI@HKEZOAHcG@GIC\\\u0006\u0006hAR\u000ejKGJC\\\u0006U[\u0007\u001c\u000ec\\TAT\u000eB[TGHI\u0006^TAEKU]\u0006A@\u000eUZI^VGHI\u0006BIMGB\u0006MI@HKEZI\\U\u0014\u0006U["), objectArray);
            return;
        }
        finally {
            connectionManager.f_vu.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_Bs.m_LCa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_ns.m_Da();
        f_OT.info(SearchRepository.m_AD((Object)"mI@HKEZOAHcG@GIC\\\u001c\u000erFO]\u0006@IJC\u000e\u000eU[\u0007\u0006FG]\u0006LCMICC\u000eRFC\u000ejkgjc|\b\u000etKUZI\\O@A\u000eGMRGPK\u0006MI@HKEZOAH]\b\u0000\b"), a);
        connectionManager2.f_vu.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_Wt.smembers(f_FS));
            if (hashSet.isEmpty()) {
                f_OT.info(MapVariableController.m_Zf((Object)"7\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a9\u0015\u001a\u0015\u0013\u0011\u0006T\\8\u0011\u0015\u0010\u0011\u0006T\u000f\t]NT:\u001bT\u0015\u0017\u0000\u001d\u0002\u0011T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a\u0007T\u0012\u001b\u0001\u001a\u0010T\u001d\u001aT&\u0011\u0010\u001d\u0007T\u0000\u001bT\u0006\u0011\u0007\u0000\u001b\u0006\u0011Z"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_OT.info(SearchRepository.m_AD((Object)"eAH@CMRGI@kOHOAKT\u000e\u000ebCOBKT\u000e]S\u000f\u0014\u0006hI[HJ\u0006U[\u000eGMRGPK\u0006MI@HKEZOAH\u000eojU\u000eO@\u0006|CJO]\u0006ZI\u000eTKUZI\\C\u0014\u0006U["), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[3 & 4] = MapVariableController.m_Zf((Object)"\"=1#+7;::17 =;:+= 19");
            connectionManager.f_nT.m_Yea(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_Bs.m_hBa((Set)a2));
            }, stringArray);
            f_OT.info(SearchRepository.m_AD((Object)"mI@HKEZOAHcG@GIC\\\u0006\u0006jKGJC\\\u0006U[\u0007\u001c\u000egZRKK^RGHI\u0006ZI\u000eTKUZI\\C\u000e]S\u0006MI@HKEZOAH]\b"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_OT.info(MapVariableController.m_Zf((Object)"7\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a9\u0015\u001a\u0015\u0013\u0011\u0006T\\8\u0011\u0015\u0010\u0011\u0006T\u000f\t]NT2\u001d\u001a\u001d\u0007\u001c\u0011\u0010T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u0006\u0011\u0007\u0000\u001b\u0006\u0015\u0000\u001d\u001b\u001aT\u0004\u0006\u001b\u0017\u0011\u0007\u0007Z"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[--2] = exception;
            f_OT.error(SearchRepository.m_AD((Object)"mI@HKEZOAHcG@GIC\\\u0006\u0006jKGJC\\\u0006U[\u0007\u001c\u000ec\\TAT\u000eB[TGHI\u0006MI@HKEZOAH\u000eTKUZI\\GZOAH\u000eV\\IMC]U\u0014\u0006U["), objectArray);
            return;
        }
        finally {
            connectionManager.f_vu.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_Bs.m_qba((String)a, (String)a3).getId());
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_nT.m_Xda(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_vu.lock();
            try {
                c_Yf c_Yf2 = a2.f_XS.m_ABa(a.getId());
                if (c_Yf2 != null) {
                    c_Yf2.m_Bu();
                    a2.f_XS.m_Lba(a.getId(), c_Yf2);
                }
                String[] stringArray = new String[3 & 5];
                stringArray[2 & 5] = a.getId();
                a2.f_Wt.srem(f_FS, stringArray);
                return;
            }
            finally {
                a2.f_vu.unlock();
            }
        }, a);
    }

    protected Map<String, c_Tl> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_XS.m_ABa((String)a)) != null) {
                void a3;
                a.m_gT((List)a3);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[4 ^ 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_OT.info(MapVariableController.m_Zf((Object)"7\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a9\u0015\u001a\u0015\u0013\u0011\u0006T\\8\u0011\u0015\u0010\u0011\u0006T\u000f\t]NT&\u0011\u0007\u0000\u001b\u0006\u001d\u001a\u0013T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aNT\u000f\tT\\=0NT\u000f\t]"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[5 >> 2] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_DS.m_hL(a2.getProject()).m_v("Connection Restore (Leader " + (String)a + ")", SearchRepository.m_AD((Object)"\u000bU\u000e\u000egb\u0014\u0006\u000bU\u0007\u0006HGGJKB\u000eRA\u0006\\C]RATK\b\u000eeOS]C\u0014\u0006\u000bU").formatted(objectArray));
            try {
                f_OT.warn(MapVariableController.m_Zf((Object)"7\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a9\u0015\u001a\u0015\u0013\u0011\u0006T\\8\u0011\u0015\u0010\u0011\u0006T\u000f\t]NT5\u0000\u0000\u0011\u0019\u0004\u0000\u001d\u001a\u0013T\u0000\u001bT\u0007\u0000\u001b\u0004T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u000f\tT\u0015\u0012\u0000\u0011\u0006T\u0006\u0011\u0007\u0000\u001b\u0006\u0015\u0000\u001d\u001b\u001aT\u0012\u0015\u001d\u0018\u0001\u0006\u0011Z"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[5 >> 2] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_OT.error(SearchRepository.m_AD((Object)"eAH@CMRGI@kOHOAKT\u000e\u000ebCOBKT\u000e]S\u000f\u0014\u0006hGGJKB\u000eRA\u0006]RAV\u000eEAH@CMRGI@\u0006U[\u000eGHRKT\u000eTKUZI\\GZOAH\u000e@OOBS\\C\u0014\u0006U["), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, MapVariableController.m_Zf((Object)"'\u0011\u0000\"\u0015\u0018\u0001\u0011&\u0011\u0005\u0001\u0011\u0007\u0000T\u0017\u0015\u001a\u001a\u001b\u0000T\u0016\u0011T\u001a\u0001\u0018\u0018"));
        Objects.requireNonNull(a.getConnectionId(), SearchRepository.m_AD((Object)"mI@HKEZOAHgB\u000eO@\u0006}CZpOJ[C|C_SKUZ\u0006MG@HAR\u000eDK\u0006@SBJ"));
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT'\u0011\u0000\u0000\u001d\u001a\u0013T\u0002\u0015\u0006\u001d\u0015\u0016\u0018\u0011T\u0002\u0015\u0018\u0001\u0011T\u0012\u001b\u0006T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rNT\u000f\t"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_OT.debug(SearchRepository.m_AD((Object)"hah\u0003jkgjc|\u001c\u000etKW[C]RGHI\u0006BCOBKT\u000eRA\u0006]CZ\u0006XG\\OODBC\u000ePOJ[C\u000e@AT\u000eEAH@CMRGI@\u0006U[\u0014\u0006U["), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_ns.m_ka(Short.valueOf((short)(0x65FE & 0x1ACD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_Bs.m_qba((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT'\u0000\u0015\u0006\u0000\u001d\u001a\u0013T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_OT.debug(SearchRepository.m_AD((Object)"hah\u0003jkgjc|\u001c\u000etKW[C]RGHI\u0006BCOBKT\u000eRA\u0006]ROTZ\u0006MI@HKEZOAH\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_ns.m_ka(Short.valueOf((short)(0x1ACB & 0x65FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_XL c_XL2, c_Ld c_Ld2, c_jd c_jd2, c_og<C, V> c_og2, JedisPooled jedisPooled, c_d c_d2, c_jL c_jL2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_jL2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_vu = new ReentrantLock();
        a8.f_Bs = a7;
        connectionManager5.f_pT = a6;
        connectionManager5.f_DS = a5;
        connectionManager4.f_XS = a4;
        connectionManager4.f_Wt = a3;
        connectionManager3.f_ns = a2;
        connectionManager3.f_nT = a;
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, MapVariableController.m_Zf((Object)"'\u0011\u0000\"\u0015\u0018\u0001\u0011&\u0011\u0005\u0001\u0011\u0007\u0000T\u0017\u0015\u001a\u001a\u001b\u0000T\u0016\u0011T\u001a\u0001\u0018\u0018")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), SearchRepository.m_AD((Object)"mI@HKEZOAHgB\u000eO@\u0006}CZpOJ[C|C_SKUZ\u0006MG@HAR\u000eDK\u0006@SBJ")));
        if (a3.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT'\u0011\u0000\u0000\u001d\u001a\u0013T\u000f\tT\u0002\u0015\u0006\u001d\u0015\u0016\u0018\u0011T\u0002\u0015\u0018\u0001\u0011\u0007T\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_OT.debug(SearchRepository.m_AD((Object)"`i`\u000bbcobkt\u0014\u0006|C_SKUZO@A\u000eJKGJC\\\u0006ZI\u000eUKR\u000e]S\u0006XG\\OODBC\u000ePOJ[C]\b"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = new ArrayList(a22);
            a3.f_ns.m_ka(Short.valueOf((short)(0x33FF & 0x4CCD)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(MapVariableController.m_Zf((Object)"2\u0015\u001d\u0018\u0011\u0010T\u0000\u001bT&$7T\u0007\u0011\u0000T\u0002\u0015\u0006\u001d\u0015\u0016\u0018\u0011T\u0002\u0015\u0018\u0001\u0011\u0007"), (Throwable)a22);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[3 >> 2] = String.class;
            connectionManager.f_ns.m_aa((short)(0x47D9 & 0x38EF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapVariableController.m_Zf((Object)"\u0007\u0000\u0015\u0006\u00007\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a=\u001a\u0000\u0011\u0006\u001a\u0015\u0018"), classArray));
            Class[] classArray2 = new Class[3 & 5];
            classArray2[5 >> 3] = String.class;
            connectionManager.f_ns.m_aa((short)(0x5CFB & 0x23CE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SearchRepository.m_AD((Object)"]RAVmI@HKEZOAHgHZC\\HOJ"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[3 >> 2] = String.class;
            connectionManager.f_ns.m_aa((short)(0xFEF & 0x70DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapVariableController.m_Zf((Object)"\u0013\u0011\u00007\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a'\u0000\u0015\u0000\u0001\u0007=\u001a\u0000\u0011\u0006\u001a\u0015\u0018"), classArray3));
            Class[] classArray4 = new Class[3 >> 1];
            classArray4[3 ^ 3] = SetValueRequest.class;
            connectionManager.f_ns.m_aa((short)(0x7FCD & 0xFE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SearchRepository.m_AD((Object)"]CZpOTGGLJKpOJ[CgHZC\\HOJ"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[2 & 5] = Collection.class;
            connectionManager.f_ns.m_aa((short)(0xBDF & 0x74ED), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapVariableController.m_Zf((Object)"\u0007\u0011\u0000\"\u0015\u0006\u001d\u0015\u0016\u0018\u0011\"\u0015\u0018\u0001\u0011\u0007=\u001a\u0000\u0011\u0006\u001a\u0015\u0018"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_ns.m_aa((short)(0x5BCE & 0x24FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SearchRepository.m_AD((Object)"UZG\\RmI@HKEZOAH]dWv\\IDCMRgBgHZC\\HOJ"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_ns.m_aa((short)(0x7FDF & 0xEF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapVariableController.m_Zf((Object)"\u0007\u0000\u001b\u00047\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a\u00076\r$\u0006\u001b\u001e\u0011\u0017\u0000=\u0010=\u001a\u0000\u0011\u0006\u001a\u0015\u0018"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_ns.m_aa((short)(0x7BFD & 0x4D2), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SearchRepository.m_AD((Object)"ICZeAH@CMRGI@uZGZS]C]dWv\\IDCMRgBgHZC\\HOJ"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_ns.m_aa((short)(0x6ED9 & 0x11F7), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(MapVariableController.m_Zf((Object)"\u0013\u0011\u00007\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a'\u0000\u0015\u0000\u0001\u0007\u0011\u00076\r=\u0010\u0007=\u001a\u0000\u0011\u0006\u001a\u0015\u0018"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_ns.m_aa((short)(0x7FB & 0x78D6), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(SearchRepository.m_AD((Object)"LTAQ]CmI@HKEZOAHgHZC\\HOJ"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(MapVariableController.m_Zf((Object)"2\u0015\u001d\u0018\u0011\u0010T\u0000\u001bT\u0006\u0011\u0013\u001d\u0007\u0000\u0011\u0006T7\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001a9\u0015\u001a\u0015\u0013\u0011\u0006T&$7T\u0019\u0011\u0000\u001c\u001b\u0010\u0007"), a);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.info(SearchRepository.m_AD((Object)"bcobkt\u0014\u0006fG@BBO@A\u000ev\\IDCMRjCOEZOXGZCkPKHZ\u0006HI\\\u0006^TALKEZ\u0006gb\u0014\u0006U["), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_OT.debug(MapVariableController.m_Zf((Object)":;:Y81501&NT=\u0013\u001a\u001b\u0006\u001d\u001a\u0013T$\u0006\u001b\u001e\u0011\u0017\u00000\u0011\u0015\u0017\u0000\u001d\u0002\u0015\u0000\u00111\u0002\u0011\u001a\u0000T\u0012\u001b\u0006T\u0004\u0006\u001b\u001e\u0011\u0017\u0000T=0NT\u000f\t"), a);
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XS.m_ABa((String)a)) instanceof c_k) {
            return ((c_k)a).m_U();
        }
        throw new BrowseOperationException(SearchRepository.m_AD((Object)"lTAQ]C\u000eI^C\\GZOAH\u000eHAR\u000eU[V^I\\RKB"));
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_nT.m_Xda(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_vu.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_pT.m_GL();
                connectionManager.f_XS.m_kBa((Connection)a).m_ls();
                String[] stringArray = new String[--1];
                stringArray[3 & 4] = a.getId();
                connectionManager.f_Wt.sadd(f_FS, stringArray);
                return;
            }
            finally {
                a2.f_vu.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_ns.m_Da();
        String[] stringArray = new String[--3];
        stringArray[2 & 5] = MapVariableController.m_Zf((Object)"' 5& +7;::17 =;:");
        stringArray[4 ^ 5] = SearchRepository.m_AD((Object)"uzi~ymi`hkezoah");
        stringArray[5 >> 1] = MapVariableController.m_Zf((Object)"\"=1#+7;::17 =;:+= 19");
        connectionManager2.f_nT.m_Vda(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT$\u0011\u0006\u0012\u001b\u0006\u0019\u001d\u001a\u0013T\u0016\u0006\u001b\u0003\u0007\u0011T\u001b\u0004\u0011\u0006\u0015\u0000\u001d\u001b\u001aT\u0012\u001b\u0006T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_OT.debug(SearchRepository.m_AD((Object)"`i`\u000bbcobkt\u0014\u0006|C_SKUZO@A\u000eJKGJC\\\u0006ZI\u000eVKTHI\\K\u000eD\\IYUK\u0006AVKTORGI@\u0006HI\\\u0006MI@HKEZOAH\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            return a2.f_ns.m_ka(Short.valueOf((short)(0x26DE & 0x59F3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT'\u0000\u001b\u0004\u0004\u001d\u001a\u0013T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_OT.debug(SearchRepository.m_AD((Object)"`i`\u000bbcobkt\u0014\u0006|C_SKUZO@A\u000eJKGJC\\\u0006ZI\u000eUZI^\u0006MI@HKEZOAH\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            a2.f_ns.m_ka(Short.valueOf((short)(0x1AFF & 0x65CA)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_Bs.m_zba((String)a2));
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_Bs.m_wCa(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Tl> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT3\u0011\u0000\u0000\u001d\u001a\u0013T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u0007\u0000\u0015\u0000\u0001\u0007\u0011\u0007T\u0012\u001b\u0006T\u000f\tT=0\u0007T\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_OT.debug(SearchRepository.m_AD((Object)"hah\u0003jkgjc|\u001c\u000etKW[C]RGHI\u0006BCOBKT\u000e@AT\u000eEAH@CMRGI@\u0006]ROR[UKU\u000e@AT\u000e]S\u0006gb]\b"), (Object)a.length);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_ns.m_ka(Short.valueOf((short)(0x76D5 & 0x9FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Tl> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_ns.m_Ma()) {
            f_OT.debug(MapVariableController.m_Zf((Object)"81501&NT3\u0011\u0000\u0000\u001d\u001a\u0013T\u0015\u0018\u0018T\u0017\u001b\u001a\u001a\u0011\u0017\u0000\u001d\u001b\u001aT\u0007\u0000\u0015\u0000\u0001\u0007\u0011\u0007T\u0012\u001b\u0006T\u0004\u0006\u001b\u001e\u0011\u0017\u0000T\u000f\tT\u0018\u001b\u0017\u0015\u0018\u0018\rZ"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_OT.debug(SearchRepository.m_AD((Object)"hah\u0003jkgjc|\u001c\u000etKW[C]RGHI\u0006BCOBKT\u000e@AT\u000eGBJ\u000eEAH@CMRGI@\u0006]ROR[UKU\u000e@AT\u000eV\\IDCMR\u000e]S\b"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_ns.m_ka(Short.valueOf((short)(0x57F8 & 0x28D7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_Tl getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XS.m_ABa((String)a)) != null && a.m_rs()) {
            return c_Tl.f_NT;
        }
        return c_Tl.f_kS;
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Yf c_Yf2 = a2.f_XS.m_ABa(a.getConnectionId());
        if (c_Yf2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Yf2.m_tT(a);
    }
}

