/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.query.Param;

@NoRepositoryBean
public interface VariableRepository<T extends Variable<?, ?, ?>>
extends BaseJpaRepository<T> {
    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where var.projectId = ?1 and conn.name = ?2 and dev.name = ?3 and fra.name = ?4")
    public List<T> findByProjectIdAndNames(String var1, String var2, String var3, String var4);

    public List<T> findByFrameIdIn(List<String> var1);

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where (var.projectId = ?#{#variableFilter.projectId} or ?#{#variableFilter.projectId} is null or ?#{#variableFilter.projectId} = '') and (conn.id = ?#{#variableFilter.connectionId} or ?#{#variableFilter.connectionId} is null or ?#{#variableFilter.connectionId} = '') and (dev.id = ?#{#variableFilter.deviceId} or ?#{#variableFilter.deviceId} is null or ?#{#variableFilter.deviceId} = '') and (fra.id = ?#{#variableFilter.frameId} or ?#{#variableFilter.frameId} is null or ?#{#variableFilter.frameId} = '') and (var.name = ?#{#variableFilter.name} or ?#{#variableFilter.name} is null or ?#{#variableFilter.name} = '') and(?#{#variableFilter.nameIn} is null or ?#{#variableFilter.nameIn} = '' or upper(var.name) like %?#{#variableFilter.nameIn}% ) and(?#{#variableFilter.dscIn} is null or ?#{#variableFilter.dscIn} = '' or upper(var.dsc) like %?#{#variableFilter.dscIn}%)")
    public Page<T> findVariablesByFilter(@Param(value="variableFilter") VariableFilter var1, @Param(value="pageable") Pageable var2);

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where var.projectId = ?1 and conn.name = ?2")
    public List<T> findVariablesByConnectionName(String var1, String var2);

    public List<T> findByProjectId(String var1);

    public Page<T> findAll(Pageable var1);

    public Page<T> findByProjectId(String var1, Pageable var2);

    public Optional<T> findOneByProjectIdAndName(String var1, String var2);

    public List<T> findByFrameId(String var1);

    @Query(value="select var from #{#entityName} var join var.frame fra join fra.device dev join dev.connection conn where var.projectId = ?1 and conn.name = ?2 and dev.name = ?3")
    public List<T> findVariablesByDeviceName(String var1, String var2, String var3);

    public List<T> findByProjectIdAndNameIn(String var1, String[] var2);
}

