/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.replication;

import com.inscada.mono.auth.c_jL;
import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_d;
import com.inscada.mono.datasource.sql.model.metadata.TableMetadata;
import com.inscada.mono.shared.c.c_Fc;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.util.SafeEncoder;

@Component
@ConditionalOnProperty(value={"ins.cluster.redis.replication.enabled"}, havingValue="true")
public class RedisReplicator
implements ClusterNodeListener {
    private final Logger f_QT;
    private final Integer f_iS;
    private final JedisPooled f_ls;
    private final c_jL f_wT;
    private final c_d f_qs;
    private final String f_TT;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicator redisReplicator;
        RedisReplicator redisReplicator2 = redisReplicator = this;
        redisReplicator.f_QT.info(c_Fc.m_kg((Object)"%.\u00185Q(\u001e\"\u0014f\u00185Q\b>\u0012Q\n4\u00075\u0003#hQ\u0007\u00052\u0014+\u00012\u0018(\u0016f\u0005)Q%\u001e(\u0017/\u00163\u0003#Q*\u001e%\u0010*Q\u0014\u0014\"\u00185Qn\n;K=\foQ'\u0002f\u0002*\u00100\u0014h"), (Object)redisReplicator2.f_TT, (Object)redisReplicator2.f_iS);
        try {
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = TableMetadata.m_op((Object)"|QoOu[fMyLoJuK~Y~My");
            Optional optional = (Optional)redisReplicator.f_wT.m_OEa(() -> {
                RedisReplicator a;
                return a.f_qs.m_La().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            }, stringArray);
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = (ClusterNodeInfo)optional.get();
                String string = clusterNodeInfo.getHost();
                String a = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a == null || n == null) {
                    Object[] objectArray = new Object[--4];
                    objectArray[3 >> 2] = clusterNodeInfo.getNodeId();
                    objectArray[4 ^ 5] = string;
                    objectArray[1 ^ 3] = redisReplicator.f_TT;
                    objectArray[--3] = redisReplicator.f_iS;
                    redisReplicator.f_QT.error(c_Fc.m_kg((Object)"=#\u0010\"\u00144Q(\u001e\"\u0014f\n;Qn;\u0001\u0003)\u00046\u0002f9)\u00022Kf\n;Xf\u0006'\u0002f\u0018\"\u0014(\u0005/\u0017/\u0014\"]f\u00133\u0005f\u00182\u0002f\u00026\u0014%\u0018 \u0018%Q\u0014\u0014\"\u00185Q.\u001e5\u0005i\u0001)\u00032Q/\u0002f\u001c/\u00025\u0018(\u0016f\u0018(Q\u0005\u001d3\u00022\u00144?)\u0015#8(\u0017)_f2'\u001f(\u001e2Q%\u001e(\u0017/\u00163\u0003#Q*\u001e%\u0010*Q\u0014\u0014\"\u00185Qn\n;K=\foQ'\u0002f\u0002*\u00100\u0014hQ\n\u001e%\u0010*Q\u0014\u0014\"\u00185Q4\u0014+\u0010/\u001f5Q/\u001ff\u00182\u0002f\u00123\u00034\u0014(\u0005f\u0003#\u0001*\u0018%\u00102\u0018)\u001ff\u00022\u00102\u0014h"), objectArray);
                    return;
                }
                if (a.equals(redisReplicator.f_TT) && n.equals(redisReplicator.f_iS)) {
                    Object[] objectArray = new Object[--4];
                    objectArray[3 >> 2] = a;
                    objectArray[4 ^ 5] = n;
                    objectArray[1 ^ 3] = redisReplicator.f_TT;
                    objectArray[--3] = redisReplicator.f_iS;
                    redisReplicator.f_QT.warn(TableMetadata.m_op((Object)"c|Ov^qLqO|\ntOyN}X?Y8x}NqY8\u0002cW\"Qe\u00038Ck\nlB}\nkKuO8Kk\ntE{Kt\nJO|Ck\n0Qe\u0010cW1\u00048~pCk\nvE|O8]qFt\nvEl\ny^lOuZl\nlE8YtKnO8E~L8ClY}F~\u00048ovYmXqD\u007f\ntE{Kt\nJO|Ck\nqY8GyYlOj\u0004"), objectArray);
                    Object[] objectArray2 = new Object[--4];
                    objectArray2[3 ^ 3] = redisReplicator.f_TT;
                    objectArray2[3 >> 1] = redisReplicator.f_iS;
                    objectArray2[1 ^ 3] = a;
                    objectArray2[--3] = n;
                    redisReplicator.f_QT.error(c_Fc.m_kg((Object)"\u0005#\u000f%\u000f2\u0007=f2\t?\u00008\u0001$\u00140\u00128\t?f8\u0015\"\u00134|Q\u0012\u0019/\u0002f\u001f)\u0015#Qn\n;K=\foQ/\u0002f\u001f)\u0005f;\u0001\u0003)\u00046\u0002f\u001d#\u0010\"\u00144]f\u00133\u0005f\u0005.\u0014f\u0018\"\u0014(\u0005/\u0017/\u0014\"Q\f64\u001e3\u00015Q*\u0014'\u0015#\u0003a\u0002f##\u0015/\u0002f\u0014(\u00156\u001e/\u001f2Qn\n;K=\foQ6\u001e/\u001f2\u0002f\u0005)Q2\u0019/\u0002f\u001f)\u0015#V5Q*\u001e%\u0010*Q\u0014\u0014\"\u00185_f%.\u00185Q/\u001f\"\u0018%\u00102\u00145Q'Q6\u001e2\u0014(\u0005/\u0010*Q+\u00185\u0012)\u001f \u0018!\u00044\u00102\u0018)\u001ff\u001e4Q'\u001ff\u0004(\u00022\u0010$\u001d#Q5\u0005'\u0005#_f=)\u0012'\u001df##\u0015/\u0002f\u0003#\u0001*\u0018%\u00102\u0018)\u001ff\u00022\u00102\u0014f\u0006/\u001d*Q\b>\u0012Q$\u0014f\u0012.\u0010(\u0016#\u0015f\u00103\u0005)\u001c'\u0005/\u0012'\u001d*\bf\u0005)Q6\u0003#\u0007#\u001f2Q/\u00025\u0004#\u0002h"), objectArray2);
                    return;
                }
                Object[] objectArray = new Object[0x36 & 0x4F];
                objectArray[2 & 5] = clusterNodeInfo.getNodeId();
                objectArray[1] = string;
                objectArray[--2] = redisReplicator.f_TT;
                objectArray[3] = redisReplicator.f_iS;
                objectArray[4] = a;
                objectArray[5] = n;
                redisReplicator.f_QT.info(TableMetadata.m_op((Object)"lw_vN8`_Xw_hY8F}K|Oj\u00108dwN}c|\u0017?Qe\r4\nRmjEmZkbwYl\u0017?Qe\r6\nY^lOuZlCvM8^w\nkFy\\}\ntE{Kt\nJO|Ck\n0Qe\u0010cW1\nlE8F}K|Oj\rk\nJO|Ck\ny^8Qe\u0010cW"), objectArray);
                byte[][] byArrayArray = new byte[2][];
                byArrayArray[0] = SafeEncoder.encode((String)a);
                byArrayArray[1] = SafeEncoder.encode((String)String.valueOf(n));
                redisReplicator.f_ls.sendCommand(() -> SafeEncoder.encode((String)TableMetadata.m_op((Object)"yTkNoWl")), (byte[][])byArrayArray);
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = redisReplicator.f_TT;
                objectArray3[1] = redisReplicator.f_iS;
                objectArray3[2] = a;
                objectArray3[3] = n;
                redisReplicator.f_QT.info(c_Fc.m_kg((Object)"\n\u001e%\u0010*Q\u0014\u0014\"\u00185Qn\n;K=\foKf\"#\u001f2Q%\u001e+\u001c'\u001f\"Q\u0015=\u0007'\u0003>\u0000Q=\ff\n;"), objectArray3);
                return;
            }
            RedisReplicator redisReplicator3 = redisReplicator;
            redisReplicator.f_QT.warn(TableMetadata.m_op((Object)"[EmF|\nvEl\n~CvN8K8`_Xw_hY8F}K|Oj\nvE|O8\\qK8xHi8^w\n|OlOjGqD}\nlB}\nuKk^}X8x}NqY8CvYlKvI}\u00048fwIyF8x}NqY8\u0002cW\"Qe\u00038]qFt\njOuKqD8Cv\nq^k\n{_jX}Dl\njOhFqIy^qEv\nk^y^}\u00048~pCk\nqY8^pO8YyL}Yl\nyZhXwK{B8^w\ny\\wC|\nkZtCl\u0007zXyCv\nqD8IyY}\nwL8D}^oEjA8ZyXlClCwDk\u00048gyDmKt\nqDlOj\\}DlCwD8GyS8H}\njOi_qX}N8C~\nlB}\n{FmYlOj\nqY8ZyXlClCwD}N8Ej\nlB}\n|OkC\u007fDy^}N8F}K|Oj\nqY8^j_tS8Nw]v\u0004"), (Object)redisReplicator3.f_TT, (Object)redisReplicator3.f_iS);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[4];
            objectArray[0] = redisReplicator.f_TT;
            objectArray[1] = redisReplicator.f_iS;
            objectArray[2] = exception.getMessage();
            objectArray[3] = exception;
            redisReplicator.f_QT.error(c_Fc.m_kg((Object)"44\u0003)\u0003f\u0018(Q\u0014\u0014\"\u00185##\u0001*\u0018%\u00102\u0018)\u001f\u0015\u00144\u0007/\u0012#_(\u001e2=#\u0010\"\u00144YoQ1\u0019/\u001d#Q%\u001e(\u0017/\u00163\u0003/\u001f!Q*\u001e%\u0010*Q\u0014\u0014\"\u00185Qn\n;K=\foKf\n;"), objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RedisReplicator(c_d c_d2, c_jL c_jL2, JedisPooled jedisPooled, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void localRedisHost;
        void jedis;
        void runAsManager;
        void clusterOperations;
        RedisReplicator a;
        RedisReplicator redisReplicator = object;
        Object object = n;
        RedisReplicator redisReplicator2 = a = redisReplicator;
        RedisReplicator redisReplicator3 = a;
        redisReplicator3.f_QT = LoggerFactory.getLogger(RedisReplicator.class);
        redisReplicator3.f_qs = clusterOperations;
        redisReplicator2.f_wT = runAsManager;
        redisReplicator2.f_ls = jedis;
        a.f_TT = localRedisHost;
        a.f_iS = object;
        a.f_qs.m_la((ClusterNodeListener)a);
    }

    public void leader() {
        RedisReplicator redisReplicator = this;
        try {
            byte[][] byArrayArray = new byte[1 ^ 3][];
            byArrayArray[3 >> 2] = SafeEncoder.encode((String)c_Fc.m_kg((Object)"?\t"));
            byArrayArray[--1] = SafeEncoder.encode((String)TableMetadata.m_op((Object)"eVo"));
            redisReplicator.f_ls.sendCommand(() -> SafeEncoder.encode((String)c_Fc.m_kg((Object)"\u0015=\u0007'\u0003>\u0000")), (byte[][])byArrayArray);
            RedisReplicator redisReplicator2 = redisReplicator;
            redisReplicator.f_QT.info(c_Fc.m_kg((Object)"\u0012\u0019/\u0002f\u001f)\u0015#Q/\u0002f=\u00030\u00024\u0014_f=)\u0012'\u001df##\u0015/\u0002fY=\f|\n;Xf\u0002#\u0005f\u0005)Q$\u0014f<\u0007\"\u00124\u0014Qn\"\n0\u00104\t7f?\tQ\t?\u0003Xh"), (Object)redisReplicator2.f_TT, (Object)redisReplicator2.f_iS);
            return;
        }
        catch (Exception a) {
            Object[] objectArray = new Object[--4];
            objectArray[3 ^ 3] = redisReplicator.f_TT;
            objectArray[--1] = redisReplicator.f_iS;
            objectArray[5 >> 1] = a.getMessage();
            objectArray[--3] = a;
            redisReplicator.f_QT.error(TableMetadata.m_op((Object)"ojXwX8Y}^lCvM8FwIyF8x}NqY8\u0002cW\"Qe\u00038^w\nUkK~]x\"\ncW"), objectArray);
            return;
        }
    }
}

