/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.animation.c.c_Ml;
import com.inscada.mono.auth.c_zL;
import com.inscada.mono.broadcast.model.Broadcast;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_g;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.z.c_zc;
import com.inscada.mono.log.c.c_mC;
import com.inscada.mono.project.c.c_a;
import com.inscada.mono.script.c.c_OA;
import com.inscada.mono.script.c.c_TC;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_QB;
import com.inscada.mono.script.services.c_Sb;
import com.inscada.mono.script.services.c_vA;
import com.inscada.mono.script.z.c_Gc;
import com.inscada.mono.script.z.c_kd;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener,
c_a {
    private static final Logger f_Rc = LoggerFactory.getLogger(ScriptManager.class);
    private final c_zc f_DB;
    private final c_QB f_vA;
    private final c_g f_bd;
    private final Lock f_hb;
    public static final short f_FA = 306;
    public static final short f_LA = 301;
    private final c_vA f_Gd;
    public static final short f_EA = 303;
    public static final short f_LC = 304;
    private final JedisPooled f_od;
    private final Map<String, Job> f_eb;
    private static final String f_WA = "scheduled_scripts";
    private final c_zL f_AB;
    public static final short f_VA = 307;
    public static final short f_uc = 305;
    public static final short f_Nd = 302;
    private final c_mC f_ec;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a22 = (Job)scriptManager.f_eb.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_Rc.info(Broadcast.m_fFa((Object)"%}\u0004w\u0006j;\u007f\u0018\u007f\u0011{\u0004>^P\u0019jVR\u0013\u007f\u0012{\u0004>\rc_$V]\u0017p\u0015{\u001ar\u001fp\u0011>\u001aq\u0015\u007f\u001a>\u001cq\u0014>\u0010q\u0004>\u0005}\u0004w\u0006jVW2$Ve\u000b"), (Object)a3, (Object)a);
                scriptManager.f_DB.m_bn((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[5 >> 3] = a3;
                objectArray[4 ^ 5] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_Rc.error(c_Ml.m_bfa((Object)"?a\u001ek\u001cv!c\u0002c\u000bg\u001e\"DL\u0003vLN\tc\bg\u001e\"\u0017\u007fE8LG\u001ep\u0003pLa\rl\u000fg\u0000n\u0005l\u000b\"\u0000m\u000fc\u0000\"\u0006m\u000e\"\nm\u001e\"\u001fa\u001ek\u001cvLK(\"\u0017\u007fV\"\u0017\u007f"), objectArray);
            }
        }
    }

    protected void scheduleScriptsByProjectIdInternal(String string) {
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_Gd.m_VE((String)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> {
            if (a.getType() != c_Gc.f_yA) {
                return --1 != 0;
            }
            return false;
        }).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ScriptManager scriptManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[3 & 4] = String.class;
            scriptManager.f_bd.m_Ca((short)(0x333D & 0x4DEF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(Broadcast.m_fFa((Object)"m\u0015v\u0013z\u0003r\u0013M\u0015l\u001fn\u0002W\u0018j\u0013l\u0018\u007f\u001a"), classArray));
            Class[] classArray2 = new Class[2 ^ 3];
            classArray2[5 >> 3] = String.class;
            scriptManager.f_bd.m_Ca((short)(0x457F & 0x3BAE), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ml.m_bfa((Object)"\u000fc\u0002a\tn?a\u001ek\u001cv%l\u0018g\u001el\rn"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 >> 2] = String.class;
            scriptManager.f_bd.m_Ca((short)(0x2BAF & 0x557F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(Broadcast.m_fFa((Object)"\u0011{\u0002M\u0015l\u001fn\u0002M\u0002\u007f\u0002k\u0005W\u0018j\u0013l\u0018\u007f\u001a"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 >> 2] = String.class;
            scriptManager.f_bd.m_Ca((short)(0x1738 & 0x69F7), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ml.m_bfa((Object)"\u001fa\u0004g\bw\u0000g?a\u001ek\u001cv\u001f@\u0015R\u001em\u0006g\u000fv%f%l\u0018g\u001el\rn"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[3 & 4] = String.class;
            scriptManager.f_bd.m_Ca((short)(0x697F & 0x17B1), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(Broadcast.m_fFa((Object)"}\u0017p\u0015{\u001aM\u0015l\u001fn\u0002m4g&l\u0019t\u0013}\u0002W\u0012W\u0018j\u0013l\u0018\u007f\u001a"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            scriptManager.f_bd.m_Ca((short)(0x55BE & 0x2B73), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_Ml.m_bfa((Object)"\u000bg\u0018Q\u000fp\u0005r\u0018Q\u0018c\u0018w\u001fg\u001f@\u0015K\bq%l\u0018g\u001el\rn"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            scriptManager.f_bd.m_Ca((short)(0xB7B & 0x75B7), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(Broadcast.m_fFa((Object)"y\u0013j%}\u0004w\u0006j%j\u0017j\u0003m\u0013m4g&l\u0019t\u0013}\u0002W\u0012W\u0018j\u0013l\u0018\u007f\u001a"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_Ml.m_bfa((Object)"*c\u0005n\tfLv\u0003\"\u001eg\u000bk\u001fv\tpLQ\u000fp\u0005r\u0018O\rl\re\tpLP<ALo\tv\u0004m\bq"), a);
        }
    }

    protected void scheduleScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_AB.m_xea(() -> a2.lambda$scheduleScriptInternal$4((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    protected void scheduleScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.scheduleScriptInternal(scriptManager.f_Gd.m_cg((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$createOnceScriptJob$6(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a2 = Script.newBuilder((RepeatableScript)a).build();
        scriptManager.f_vA.m_gf((Script)a2);
        scriptManager.cancelScript(a.getId());
    }

    private /* synthetic */ void lambda$createPeriodicScriptJob$7(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_vA.m_gf((Script)a);
    }

    private /* synthetic */ void lambda$scheduleScriptInternal$4(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_hb.lock();
        try {
            Job job;
            ScriptManager scriptManager;
            block14: {
                a2.cancelScriptInternal((RepeatableScript)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to schedule script " + a.getName());
                }
                switch (c_Sb.f_lc[a.getType().ordinal()]) {
                    case 1: {
                        ScriptManager scriptManager2 = a2;
                        while (false) {
                        }
                        scriptManager = scriptManager2;
                        job = scriptManager2.createDailyScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 2: {
                        ScriptManager scriptManager3 = a2;
                        scriptManager = scriptManager3;
                        job = scriptManager3.createPeriodicScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 3: {
                        job = a2.createOnceScriptJob((RepeatableScript)a);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                    }
                }
                scriptManager = a2;
            }
            scriptManager.f_eb.put(a.getId(), job);
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = a.getId();
            a2.f_od.sadd(f_WA, stringArray);
            return;
        }
        finally {
            a2.f_hb.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_OA.class})
    public void handleCancelEvent(c_OA c_OA2) {
        void a;
        ScriptManager scriptManager = this;
        if (scriptManager.f_bd.m_La()) {
            ScriptManager a2 = a.m_Ze();
            f_Rc.info(Broadcast.m_fFa((Object)"R3_2[$$VV\u0017p\u0012r\u001fp\u0011>5\u007f\u0018}\u0013r3h\u0013p\u0002>\u0010q\u0004>\u0005}\u0004w\u0006jL>\rcV6?ZL>\rc_"), (Object)a2.getName(), (Object)a2.getId());
            scriptManager.cancelScriptInternal((RepeatableScript)a2);
            return;
        }
        f_Rc.debug(c_Ml.m_bfa((Object)"L#LAN)C(G>8LK\u000bl\u0003p\u0005l\u000b\"/c\u0002a\tn)t\tl\u0018\"\nm\u001e\"\u001fa\u001ek\u001cvV\"\u0017\u007f"), (Object)a.m_Ze().getId());
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.info(Broadcast.m_fFa((Object)"R3_2[$$VV\u0017p\u0012r\u001fp\u0011>&l\u0019t\u0013}\u0002Z\u0013\u007f\u0015j\u001fh\u0017j\u0013[\u0000{\u0018jVx\u0019lVn\u0004q\u001c{\u0015jVW2$Ve\u000b"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_Rc.debug(c_Ml.m_bfa((Object)"\"M\"/ G-F)PV\"%e\u0002m\u001ek\u0002eLR\u001em\u0006g\u000fv(g\ra\u0018k\u001ac\u0018g)t\tl\u0018\"\nm\u001e\"\u001cp\u0003h\ta\u0018\"%FV\"\u0017\u007f"), a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_kd> getScriptStatuses(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_bd.m_La()) {
            f_Rc.debug(Broadcast.m_fFa((Object)"R3_2[$$VY\u0013j\u0002w\u0018yVm\u0015l\u001fn\u0002>\u0005j\u0017j\u0003m\u0013mVx\u0019lVe\u000b>?Z\u0005>\u001aq\u0015\u007f\u001ar\u000f$Ve\u000b"), (Object)a.size(), (Object)a);
            return a2.getScriptStatusesByIdsInternal((List)a);
        }
        f_Rc.debug(c_Ml.m_bfa((Object)"\"M\"/ G-F)PV\">g\u001dw\tq\u0018k\u0002eLn\tc\bg\u001e\"\nm\u001e\"\u001fa\u001ek\u001cvLq\u0018c\u0018w\u001fg\u001f\"\nm\u001e\"\u0017\u007fLK(qV\"\u0017\u007f"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = new ArrayList(a);
            return (Map)a2.f_bd.m_ca(Short.valueOf((short)(0xB7E & 0x75B3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(Broadcast.m_fFa((Object)"Z"))), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_kd getScriptStatus(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.debug(Broadcast.m_fFa((Object)":[7Z3LL>1{\u0002j\u001fp\u0011>\u0005}\u0004w\u0006jVm\u0002\u007f\u0002k\u0005>\u0010q\u0004>\rcVr\u0019}\u0017r\u001agX"), a);
            return a2.getScriptStatusInternal((String)a);
        }
        f_Rc.debug(c_Ml.m_bfa((Object)"L#LAN)C(G>8LP\ts\u0019g\u001fv\u0005l\u000b\"\u0000g\rf\tpLd\u0003pLq\u000fp\u0005r\u0018\"\u001fv\rv\u0019qLd\u0003pLy\u0011,"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            return (c_kd)a2.f_bd.m_ca(Short.valueOf((short)(0x4DEF & 0x333F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_DB.m_Zj(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createOnceScriptJob$6((RepeatableScript)a), Duration.ofMillis(a.getDelay().intValue()), (2 & 5) != 0);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Job createDailyScriptJob(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        Object a2 = a.getTime();
        a2 = LocalTime.of(((Date)a2).getHours(), ((Date)a2).getMinutes(), ((Date)a2).getSeconds());
        return scriptManager.f_DB.m_FN(a.getProject(), scriptManager.generateJobName((RepeatableScript)a), () -> scriptManager.lambda$createDailyScriptJob$8((RepeatableScript)a), (LocalTime)a2);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.debug(Broadcast.m_fFa((Object)"R3_2[$$V]\u0017p\u0015{\u001ar\u001fp\u0011>\u0017r\u001a>\u0005}\u0004w\u0006j\u0005>\u0010q\u0004>\u0006l\u0019t\u0013}\u0002>\rcVr\u0019}\u0017r\u001agX"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_Rc.debug(c_Ml.m_bfa((Object)"L#LAN)C(G>8LP\ts\u0019g\u001fv\u0005l\u000b\"\u0000g\rf\tpLv\u0003\"\u000fc\u0002a\tnLc\u0000nLq\u000fp\u0005r\u0018qLd\u0003pLr\u001em\u0006g\u000fvLy\u0011,"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_bd.m_ca(Short.valueOf((short)(0x2DF1 & 0x533F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel scripts for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$createDailyScriptJob$8(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_vA.m_gf((Script)a);
    }

    protected Map<String, c_kd> getScriptStatusesByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_Gd.m_YE((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, repeatableScriptSummary -> {
            ScriptManager a = repeatableScriptSummary;
            ScriptManager a2 = this;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_DB.m_jN(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createPeriodicScriptJob$7((RepeatableScript)a), Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.scheduleScript(scriptManager.f_Gd.m_sF((String)a, (String)a3).getId());
    }

    public void notLeader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_bd.m_Ma();
        f_Rc.info(c_Ml.m_bfa((Object)"?a\u001ek\u001cv!c\u0002c\u000bg\u001e8LV\u0004k\u001f\"\u0002m\bgL*\u0017\u007fE\"\u0005qLL#\" M\"E)PLV$GLN)C(G>,LA\rl\u000fg\u0000n\u0005l\u000b\"\rn\u0000\"\u0000m\u000fc\u0000\"\u001fa\u001ek\u001cvLh\u0003`\u001f,B,"), a);
        scriptManager2.f_hb.lock();
        try {
            new ArrayList(scriptManager.f_eb.keySet()).forEach(arg_0 -> scriptManager.lambda$notLeader$2((String)a, arg_0));
            scriptManager.f_eb.clear();
            f_Rc.info(Broadcast.m_fFa((Object)"%}\u0004w\u0006j;\u007f\u0018\u007f\u0011{\u0004>^P\u0019jVR\u0013\u007f\u0012{\u0004>\rc_$V_\u001arVr\u0019}\u0017rVm\u0015l\u001fn\u0002>\u001cq\u0014mVv\u0017h\u0013>\u0014{\u0013pVl\u0013o\u0003{\u0005j\u0013zVj\u0019>\u0015\u007f\u0018}\u0013rV\u007f\u0018zV}\u001a{\u0017l\u0013zVx\u0004q\u001b>\u001aq\u0015\u007f\u001a>\u0002l\u0017}\u001dw\u0018yX"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Rc.error(c_Ml.m_bfa((Object)"Q\u000fp\u0005r\u0018O\rl\re\tpL*\"m\u0018\" g\rf\tpLy\u0011+V\")p\u001em\u001e\"\bw\u001ek\u0002eLr\u001em\u000fg\u001fqLm\n\"\u000fc\u0002a\tn\u0000k\u0002eLn\u0003a\rnLq\u000fp\u0005r\u0018\"\u0006m\u000eqV\"\u0017\u007f"), objectArray);
            return;
        }
        finally {
            scriptManager.f_hb.unlock();
        }
    }

    protected c_kd getScriptStatusInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_eb.containsKey(a)) {
            return c_kd.f_nc;
        }
        return c_kd.f_nB;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_kd getScriptStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_Gd.m_XD((String)a2, (String)a)) == null) {
            return c_kd.f_nB;
        }
        return a3.getScriptStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.cancelScript(scriptManager.f_Gd.m_sF((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    public ScriptManager(c_vA c_vA2, c_zc c_zc2, c_QB c_QB2, c_mC c_mC2, JedisPooled jedisPooled, c_g c_g2, c_zL c_zL2) {
        ScriptManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ScriptManager a8;
        ScriptManager scriptManager = scriptManager2;
        ScriptManager scriptManager2 = c_zL2;
        ScriptManager scriptManager3 = a8 = scriptManager;
        ScriptManager scriptManager4 = a8;
        ScriptManager scriptManager5 = a8;
        ScriptManager scriptManager6 = a8;
        ScriptManager scriptManager7 = a8;
        scriptManager6.f_hb = new ReentrantLock();
        scriptManager6.f_eb = new ConcurrentHashMap();
        scriptManager6.f_Gd = a7;
        scriptManager5.f_DB = a6;
        scriptManager5.f_vA = a5;
        scriptManager4.f_ec = a4;
        scriptManager4.f_od = a3;
        scriptManager3.f_bd = a2;
        scriptManager3.f_AB = a;
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.debug(c_Ml.m_bfa((Object)"N)C(G>8LQ\u000fj\tf\u0019n\u0005l\u000b\"\u001fa\u001ek\u001cvLy\u0011\"\u0000m\u000fc\u0000n\u0015,"), a);
            a2.scheduleScriptInternal((String)a);
            return;
        }
        f_Rc.debug(Broadcast.m_fFa((Object)"P9P[R3_2[$$VL\u0013o\u0003{\u0005j\u001fp\u0011>\u001a{\u0017z\u0013lVj\u0019>\u0005}\u001e{\u0012k\u001a{Vm\u0015l\u001fn\u0002>\rcX"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_bd.m_ca(Short.valueOf((short)(0x35EF & 0x4B3D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule script " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_TC.class})
    public void handleRescheduleEvent(c_TC c_TC2) {
        ScriptManager scriptManager = this;
        if (scriptManager.f_bd.m_La()) {
            ScriptManager a = a.m_fg();
            f_Rc.info(Broadcast.m_fFa((Object)"R3_2[$$VV\u0017p\u0012r\u001fp\u0011>${\u0005}\u001e{\u0012k\u001a{3h\u0013p\u0002>\u0010q\u0004>\u0005}\u0004w\u0006jL>\rcV6?ZL>\rc_"), (Object)a.getName(), (Object)a.getId());
            if (scriptManager.getScriptStatusInternal(a.getId()) == c_kd.f_nc) {
                scriptManager.scheduleScriptInternal(a.getId());
                return;
            }
        } else {
            f_Rc.debug(c_Ml.m_bfa((Object)"L#LAN)C(G>8LK\u000bl\u0003p\u0005l\u000b\">g\u001fa\u0004g\bw\u0000g)t\tl\u0018\"\nm\u001e\"\u001fa\u001ek\u001cvV\"\u0017\u007f"), (Object)a.m_fg().getId());
        }
    }

    protected void cancelScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_AB.m_xea(() -> a2.lambda$cancelScriptInternal$9((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelScriptsByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_Gd.m_VE((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_bd.m_Ma();
        f_Rc.info(Broadcast.m_fFa((Object)"%}\u0004w\u0006j;\u007f\u0018\u007f\u0011{\u0004$VJ\u001ew\u0005>\u0018q\u0012{V6\rc_>\u001e\u007f\u0005>\u0014{\u0015q\u001b{Vj\u001e{VR3_2[$0VL\u0013m\u0002q\u0004w\u0018yVm\u0015v\u0013z\u0003r\u0013zVm\u0015l\u001fn\u0002mX0X"), a);
        scriptManager2.f_hb.lock();
        try {
            HashSet hashSet = new HashSet(scriptManager.f_od.smembers(f_WA));
            if (hashSet.isEmpty()) {
                f_Rc.info(c_Ml.m_bfa((Object)"?a\u001ek\u001cv!c\u0002c\u000bg\u001e\"DN\tc\bg\u001e\"\u0017\u007fE8LL\u0003\"\u001fa\u0004g\bw\u0000g\b\"\u001fa\u001ek\u001cv\u001f\"\nm\u0019l\b\"\u0005lLP\tf\u0005qLv\u0003\"\u001eg\u001fv\u0003p\t,"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_Rc.info(Broadcast.m_fFa((Object)"M\u0015l\u001fn\u0002S\u0017p\u0017y\u0013lV6:{\u0017z\u0013lVe\u000b7L>0q\u0003p\u0012>\rcVm\u0015v\u0013z\u0003r\u0013zVm\u0015l\u001fn\u0002>?Z\u0005>\u001fpVL\u0013z\u001fmVj\u0019>\u0004{\u0005j\u0019l\u0013$Ve\u000b"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[5 >> 3] = c_Ml.m_bfa((Object)"T%G;]?A>K<V");
            scriptManager.f_AB.m_iDa(() -> {
                void a;
                Object a2 = hashSet;
                ScriptManager a3 = this;
                a.addAll(a3.f_Gd.m_EF((Set)a2));
            }, stringArray);
            f_Rc.info(Broadcast.m_fFa((Object)"M\u0015l\u001fn\u0002S\u0017p\u0017y\u0013lV6:{\u0017z\u0013lVe\u000b7L>7j\u0002{\u001bn\u0002w\u0018yVj\u0019>\u0004{\u0005j\u0019l\u0013>\rcVm\u0015l\u001fn\u0002mX"), a, (Object)arrayList.size());
            arrayList.forEach(repeatableScript -> {
                void a;
                ScriptManager scriptManager;
                ScriptManager scriptManager2 = scriptManager = this;
                Object a2 = scriptManager2.f_bd.m_Ma();
                String[] stringArray = new String[1 ^ 3];
                stringArray[5 >> 3] = c_Ml.m_bfa((Object)"Q/J)F9N)]?A>K<V");
                stringArray[2 ^ 3] = Broadcast.m_fFa((Object)"5_8]3R)M5L?N\"");
                scriptManager2.f_AB.m_Vda(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1((String)a2, (RepeatableScript)a), a.getSpace(), stringArray);
            });
            f_Rc.info(c_Ml.m_bfa((Object)"Q\u000fp\u0005r\u0018O\rl\re\tpL* g\rf\tpLy\u0011+V\"*k\u0002k\u001fj\tfLq\u000fp\u0005r\u0018\"\u001eg\u001fv\u0003p\rv\u0005m\u0002\"\u001cp\u0003a\tq\u001f,"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[--2] = exception;
            f_Rc.error(Broadcast.m_fFa((Object)"M\u0015l\u001fn\u0002S\u0017p\u0017y\u0013lV6:{\u0017z\u0013lVe\u000b7L>3l\u0004q\u0004>\u0012k\u0004w\u0018yVm\u0015l\u001fn\u0002>\u0004{\u0005j\u0019l\u0017j\u001fq\u0018>\u0006l\u0019}\u0013m\u0005$Ve\u000b"), objectArray);
            return;
        }
        finally {
            scriptManager.f_hb.unlock();
        }
    }

    protected void cancelScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.cancelScriptInternal(scriptManager.f_Gd.m_cg((String)a2));
    }

    protected Map<String, c_kd> getScriptStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.debug(Broadcast.m_fFa((Object)":[7Z3LL>5\u007f\u0018}\u0013r\u001aw\u0018yVm\u0015l\u001fn\u0002>\rcVr\u0019}\u0017r\u001agX"), a);
            a2.cancelScriptInternal((String)a);
            return;
        }
        f_Rc.debug(c_Ml.m_bfa((Object)"\"M\"/ G-F)PV\">g\u001dw\tq\u0018k\u0002eLn\tc\bg\u001e\"\u0018mLa\rl\u000fg\u0000\"\u001fa\u001ek\u001cvLy\u0011,"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_bd.m_ca(Short.valueOf((short)(0x593E & 0x27EF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel script " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ String generateJobName(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        Object[] objectArray = new Object[5 >> 1];
        objectArray[3 & 4] = a.getType().m_Gi();
        objectArray[3 >> 1] = a.getName();
        return c_Ml.m_bfa((Object)"IqLQ\u000fp\u0005r\u0018\"A\"Iq").formatted(objectArray);
    }

    private /* synthetic */ void lambda$cancelScriptInternal$9(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_hb.lock();
        try {
            Job job = (Job)a2.f_eb.get(a.getId());
            if (job != null) {
                a2.f_DB.m_bn(job);
            }
            ScriptManager scriptManager = a2;
            scriptManager.f_eb.remove(a.getId());
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 ^ 3] = a.getId();
            scriptManager.f_od.srem(f_WA, stringArray);
            return;
        }
        finally {
            a2.f_hb.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.f_bd.m_X((ClusterNodeListener)a);
        f_Rc.info(c_Ml.m_bfa((Object)"?a\u001ek\u001cv!c\u0002c\u000bg\u001e\"\u0005l\u0005v\u0005c\u0000k\u0016g\b\"\rl\b\"\u001eg\u000bk\u001fv\tp\tfLc\u001f\"/n\u0019q\u0018g\u001eL\u0003f\tN\u0005q\u0018g\u0002g\u001e,"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String string, RepeatableScript repeatableScript) {
        void a;
        ScriptManager a2 = repeatableScript;
        ScriptManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Rc.info(Broadcast.m_fFa((Object)"M\u0015l\u001fn\u0002S\u0017p\u0017y\u0013lV6:{\u0017z\u0013lVe\u000b7L>${\u0005j\u0019l\u001fp\u0011>\u0005}\u0004w\u0006jL>\rcV6?ZL>\rc_"), objectArray);
            a3.scheduleScriptInternal((RepeatableScript)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[3 & 5] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_ec.m_tk(a2.getProject()).m_s("Script Restore (Leader " + (String)a + ")", c_Ml.m_bfa((Object)"IqL*%FV\"IqE\"\nc\u0005n\tfLv\u0003\"\u001eg\u001fv\u0003p\t,LA\rw\u001fgV\"Iq").formatted(objectArray));
            try {
                f_Rc.warn(Broadcast.m_fFa((Object)"M\u0015l\u001fn\u0002S\u0017p\u0017y\u0013lV6:{\u0017z\u0013lVe\u000b7L>7j\u0002{\u001bn\u0002w\u0018yVj\u0019>\u0015\u007f\u0018}\u0013rVm\u0015l\u001fn\u0002>\rcV\u007f\u0010j\u0013lVl\u0013m\u0002q\u0004\u007f\u0002w\u0019pVx\u0017w\u001ak\u0004{X"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal((RepeatableScript)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Rc.error(c_Ml.m_bfa((Object)"Q\u000fp\u0005r\u0018O\rl\re\tpL* g\rf\tpLy\u0011+V\"*c\u0005n\tfLv\u0003\"\u000fc\u0002a\tnLq\u000fp\u0005r\u0018\"\u0017\u007fLc\nv\tpLp\tq\u0018m\u001ec\u0018k\u0003lLd\rk\u0000w\u001egV\"\u0017\u007f"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_kd> getScriptStatuses(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.debug(c_Ml.m_bfa((Object)"N)C(G>8LE\tv\u0018k\u0002eLc\u0000nLq\u000fp\u0005r\u0018\"\u001fv\rv\u0019q\tqLd\u0003pLr\u001em\u0006g\u000fvLy\u0011\"\u0000m\u000fc\u0000n\u0015,"), a);
            return a2.getScriptStatusesByProjectIdInternal((String)a);
        }
        f_Rc.debug(Broadcast.m_fFa((Object)"8Q83:[7Z3LL>${\u0007k\u0013m\u0002w\u0018yVr\u0013\u007f\u0012{\u0004>\u0010q\u0004>\u0017r\u001a>\u0005}\u0004w\u0006jVm\u0002\u007f\u0002k\u0005{\u0005>\u0010q\u0004>\u0006l\u0019t\u0013}\u0002>\rcX"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = a;
            return (Map)a2.f_bd.m_ca(Short.valueOf((short)(0x1977 & 0x67BB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_bd.m_La()) {
            f_Rc.debug(c_Ml.m_bfa((Object)" G-F)PV\"?a\u0004g\bw\u0000k\u0002eLc\u0000nLq\u000fp\u0005r\u0018qLd\u0003pLr\u001em\u0006g\u000fvLy\u0011\"\u0000m\u000fc\u0000n\u0015,"), a);
            a2.scheduleScriptsByProjectIdInternal((String)a);
            return;
        }
        f_Rc.debug(Broadcast.m_fFa((Object)"8Q83:[7Z3LL>${\u0007k\u0013m\u0002w\u0018yVr\u0013\u007f\u0012{\u0004>\u0002qVm\u0015v\u0013z\u0003r\u0013>\u0017r\u001a>\u0005}\u0004w\u0006j\u0005>\u0010q\u0004>\u0006l\u0019t\u0013}\u0002>\rcX"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_bd.m_ca(Short.valueOf((short)(0x37E & 0x7DB1)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule scripts for project " + (String)a, (Throwable)exception);
        }
    }
}

