/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="jasper_report")
@AttributeOverride(name="id", column=@Column(name="jasper_report_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"templateFileId", "templateFile"})})
public class JasperReport
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    private String parameters;
    @NotBlank
    @Size(max=100)
    private String name;
    private String datasource;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @Size(max=255)
    private String dsc;
    @Column(name="template_file_id", updatable=false, insertable=false)
    private String templateFileId;
    @JsonIgnore
    @OneToOne(optional=false)
    @JoinColumn(name="template_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo templateFile;
    private String subreports;

    public boolean equals(Object object) {
        JasperReport a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof JasperReport)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public String getProjectId() {
        JasperReport a;
        return a.projectId;
    }

    public void setName(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.name = a;
    }

    public Project getProject() {
        JasperReport a;
        return a.project;
    }

    public void setTemplateFile(FileInfo fileInfo) {
        JasperReport a;
        JasperReport a2 = fileInfo;
        JasperReport jasperReport = a = this;
        jasperReport.templateFile = a2;
        jasperReport.templateFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getDatasource() {
        JasperReport a;
        return a.datasource;
    }

    public void setSubreports(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.subreports = a;
    }

    public void setDsc(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.dsc = a;
    }

    public String getSubreports() {
        JasperReport a;
        return a.subreports;
    }

    public FileInfo getTemplateFile() {
        JasperReport a;
        return a.templateFile;
    }

    public void setTemplateFileId(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.templateFileId = a;
    }

    public void setDatasource(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.datasource = a;
    }

    public String getName() {
        JasperReport a;
        return a.name;
    }

    public int hashCode() {
        JasperReport a;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = super.hashCode();
        objectArray[--1] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setParameters(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.parameters = a;
    }

    public String getParameters() {
        JasperReport a;
        return a.parameters;
    }

    public void setProjectId(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.projectId = a;
    }

    public String getTemplateFileId() {
        JasperReport a;
        return a.templateFileId;
    }

    public void setProject(Project project) {
        JasperReport a;
        JasperReport a2 = project;
        JasperReport jasperReport = a = this;
        jasperReport.project = a2;
        jasperReport.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public JasperReport() {
        JasperReport a;
    }

    public String getDsc() {
        JasperReport a;
        return a.dsc;
    }
}

