/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_zL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_g;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.repositories.VariableValueRepository;
import com.inscada.mono.communication.base.services.c_Wi;
import com.inscada.mono.communication.base.services.c_bj;
import com.inscada.mono.communication.base.services.c_eh;
import com.inscada.mono.communication.base.z.c_Kk;
import com.inscada.mono.communication.base.z.c_yj;
import com.inscada.mono.datatransfer.c.c_KA;
import com.inscada.mono.datatransfer.c.c_md;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.services.c_Lb;
import com.inscada.mono.datatransfer.services.c_ad;
import com.inscada.mono.datatransfer.z.c_HC;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.job.z.c_zc;
import com.inscada.mono.log.c.c_mC;
import com.inscada.mono.project.c.c_a;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.f.c_xC;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_a {
    public static final short f_xi = 407;
    public static final short f_Ej = 403;
    private final c_g f_YI;
    private final c_eh f_oG;
    private final Lock f_MG;
    public static final short f_VH = 405;
    private final c_ad f_Wi;
    private static final Logger f_ej = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short f_iI = 406;
    private final c_Wi f_qh;
    public static final short f_Ph = 402;
    public static final short f_Mh = 401;
    private final Map<String, Job> f_Rg;
    public static final short f_yH = 404;
    private final c_zc f_Xh;
    private static final String f_lI = "scheduledDataTransfers";
    private final JedisPooled f_jH;
    private final c_bj f_Ai;
    private final c_mC f_si;
    private final c_zL f_sG;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_qh.m_qca((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_Ai.m_UBa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_HC getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_Wi.m_gm((String)a2, (String)a)) == null) {
            return c_HC.f_fH;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_Wi.m_Zn((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_HC> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.debug(VariableValueRepository.m_bba((Object)"\u000e%\u0003$\u00072x@\u0005\u00056\u0014+\u000e%@#\f.@&\u00016\u0001b\u00140\u0001,\u0013$\u00050@1\u0014#\u00147\u0013'\u0013b\u0006-\u0012b\u00100\u000f(\u0005!\u0014b\u001b?@.\u000f!\u0001.\f;N"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0012\u0005\u0012g\u0010\u000f\u001d\u000e\u0019\u0018fj\u000e/-?99(#2-|&9+8/.j:%.j=&0j8+(+|>.+29:/.j/>=>)999|,38|:.%6/?>|1!d"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_YI.m_ca(Short.valueOf((short)(0x59DF & 0x27B7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Wi.m_sO((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_HC> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_YI.m_La()) {
            f_ej.debug(c_xC.m_mf((Object)"\u0006\u0019\u000b\u0018\u000f\u000ep|\r9>(#2-|.=>=j(8=$/,98|9(+(?///j:%.j'7|\u0003\u00189|&3)=&03fj'7"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_ej.debug(VariableValueRepository.m_bba((Object)".\r.o,\u0007!\u0006%\u0010Zb2'\u00117\u00051\u0014+\u000e%@.\u0005#\u0004'\u0012b\u0006-\u0012b\u0004#\u0014#@6\u0012#\u000e1\u0006'\u0012b\u00136\u00016\u00151\u00051@$\u000f0@9\u001db)\u0006\u0013x@9\u001d"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = new ArrayList(a);
            return (Map)a2.f_YI.m_ca(Short.valueOf((short)(0x2D96 & 0x53FF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_xC.m_mf((Object)"f"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_Wi.m_XM((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_yj[] c_yjArray = (c_yj[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_yj[]::new);
        a4 = a7.f_oG.m_NBa(stringArray, (Date)a5, (Date)((Object)a4), c_yjArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_MG.lock();
        try {
            Job job = (Job)a2.f_Rg.get(a.getId());
            if (job != null) {
                a2.f_Xh.m_bn(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_Rg.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = a.getId();
            dataTransferManager.f_jH.srem(f_lI, stringArray);
            return;
        }
        finally {
            a2.f_MG.unlock();
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.info(VariableValueRepository.m_bba((Object)"\u000e%\u0003$\u00072x@\n\u0001,\u0004.\t,\u0007b00\u000f(\u0005!\u0014\u0006\u0005#\u00036\t4\u00016\u0005\u0007\u0016'\u000e6@$\u000f0@2\u0012-\n'\u00036@\u000b$x@9\u001d"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0012\u0005\u0012g\u0010\u000f\u001d\u000e\u0019\u0018fj\u0015-2%.#2-|\u001a.%6/?>\u0018/=)(#*+(/\u0019<9$(j:%.j,83 9)(j\u0015\u000efj'7"), a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_Rg.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_ej.info(VariableValueRepository.m_bba((Object)"\u0006\u00016\u0001\u0016\u0012#\u000e1\u0006'\u0012\u000f\u0001,\u0001%\u00050@j.-\u0014b,'\u0001&\u00050@9\u001dkZb##\u000e!\u0005.\f+\u000e%@.\u000f!\u0001.@(\u000f @$\u000f0@&\u00016\u0001b\u00140\u0001,\u0013$\u00050@\u000b$x@9\u001d"), (Object)a3, (Object)a);
                dataTransferManager.f_Xh.m_bn((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[2 & 5] = a3;
                objectArray[2 ^ 3] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_ej.error(c_xC.m_mf((Object)"\u000e=>=\u001e.+29:/.\u0007=$=-98|b\u0012%(j\u0010/=.98|1!cfj\u00198.%.j?+2)9&0#2-|&3)=&| 3(|,38|.=>=j(8=$/,98|\u0003\u0018j'7fj'7"), objectArray);
            }
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 >> 2] = String.class;
            dataTransferManager.f_YI.m_Ca((short)(0x1DB9 & 0x63D7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xC.m_mf((Object)"/)4/8?0/\u0018+(+\b8=$/,98\u0015$(/.$=&"), classArray));
            Class[] classArray2 = new Class[2 ^ 3];
            classArray2[3 & 4] = String.class;
            dataTransferManager.f_YI.m_Ca((short)(0xFF2 & 0x719F), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(VariableValueRepository.m_bba((Object)"!\u0001,\u0003'\f\u0006\u00016\u0001\u0016\u0012#\u000e1\u0006'\u0012\u000b\u000e6\u00050\u000e#\f"), classArray2));
            Class[] classArray3 = new Class[3 >> 1];
            classArray3[3 & 4] = String.class;
            dataTransferManager.f_YI.m_Ca((short)(0x6197 & 0x1FFB), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xC.m_mf((Object)"-9>\u0018+(+\b8=$/,98\u000f>=>)9\u0015$(/.$=&"), classArray3));
            Class[] classArray4 = new Class[5 >> 2];
            classArray4[3 ^ 3] = String.class;
            dataTransferManager.f_YI.m_Ca((short)(0x1D5 & 0x7FBE), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(VariableValueRepository.m_bba((Object)"1\u0003*\u0005&\u0015.\u0005\u0006\u00016\u0001\u0016\u0012#\u000e1\u0006'\u00121\";00\u000f(\u0005!\u0014\u000b\u0004\u000b\u000e6\u00050\u000e#\f"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[5 >> 3] = String.class;
            dataTransferManager.f_YI.m_Ca((short)(0x3B7 & 0x7DDD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xC.m_mf((Object)"?+2)9&\u0018+(+\b8=$/,98/\b%\u001a.%6/?>\u0015.\u0015$(/.$=&"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_YI.m_Ca((short)(0x75F6 & 0xB9F), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(VariableValueRepository.m_bba((Object)"%\u00056$#\u0014#40\u0001,\u0013$\u0005036\u00016\u00151\u00051\";)&\u0013\u000b\u000e6\u00050\u000e#\f"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_YI.m_Ca((short)(0x3997 & 0x47FF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_xC.m_mf((Object)";/(\u000e=>=\u001e.+29:/.\u0019(+(?///\b%\u001a.%6/?>\u0015.\u0015$(/.$=&"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(VariableValueRepository.m_bba((Object)"\u0004\u0001+\f'\u0004b\u0014-@0\u0005%\t1\u0014'\u0012b$#\u0014#40\u0001,\u0013$\u00050-#\u000e#\u0007'\u0012b2\u0012#b\r'\u0014*\u000f&\u0013"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_HC getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.debug(c_xC.m_mf((Object)"\u0010\u000f\u001d\u000e\u0019\u0018fj\u001b/(>5$;j8+(+|>.+29:/.j/>=>)9|,38|\u0003\u0018p|1!j0%?+0&%d"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_ej.debug(VariableValueRepository.m_bba((Object)"\f/\fM\u000e%\u0003$\u00072x@\u0010\u00053\u0015'\u00136\t,\u0007b\f'\u0001&\u00050@$\u000f0@&\u00016\u0001b\u00140\u0001,\u0013$\u00050@1\u0014#\u00147\u0013b\u0006-\u0012b)\u0006Zb\u001b?N"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (c_HC)a2.f_YI.m_ca(Short.valueOf((short)(0x6BBF & 0x15D3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_yj c_yj2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_Lb.f_eG[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_xC.m_mf((Object)"<=&)/"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(VariableValueRepository.m_bba((Object)"\u0016#\f7\u0005"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_ad c_ad2, c_Wi c_Wi2, c_bj c_bj2, c_eh c_eh2, c_zc c_zc2, JedisPooled jedisPooled, c_mC c_mC2, c_g c_g2, c_zL c_zL2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_zL2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_MG = new ReentrantLock();
        dataTransferManager7.f_Rg = new ConcurrentHashMap();
        dataTransferManager7.f_Wi = a9;
        dataTransferManager6.f_qh = a8;
        dataTransferManager6.f_Ai = a7;
        dataTransferManager5.f_oG = a6;
        dataTransferManager5.f_Xh = a5;
        dataTransferManager4.f_si = a4;
        dataTransferManager4.f_jH = a3;
        dataTransferManager3.f_YI = a2;
        dataTransferManager3.f_sG = a;
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return c_xC.m_mf((Object)"8+(+q>.+29:/.p0+/>q)=&?g(#1/f<=85+>&9py9fo/py9").formatted(objectArray);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_YI.m_X((ClusterNodeListener)a);
        f_ej.info(VariableValueRepository.m_bba((Object)"\u0006\u00016\u0001\u0016\u0012#\u000e1\u0006'\u0012\u000f\u0001,\u0001%\u00050@+\u000e+\u0014+\u0001.\t8\u0005&@#\u000e&@0\u0005%\t1\u0014'\u0012'\u0004b\u00011@\u0001\f7\u00136\u00050.-\u0004',+\u00136\u0005,\u00050N"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (4 ^ 5) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_jH.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return --1 != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_Lb.f_HG[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0xF & 0x7B) != calendar.get(0x6B & 0x1F)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x7F & 6) != calendar.get(0x77 & 0xE)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(1 ^ 3) != calendar.get(1 ^ 3)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(5 >> 2) != calendar.get(2 ^ 3) ? 4 ^ 5 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[1 ^ 3];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_jH.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(VariableValueRepository.m_bba((Object)"#7\u00120\u0005,\u0014"))) {
            return false;
        }
        int a222 = switch (c_Lb.f_HG[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x7D & 0x3E) * (0x5FEE & 0x23F9));
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_Wi.m_rn((String)a2));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.debug(VariableValueRepository.m_bba((Object)"\u000e%\u0003$\u00072x@\u0001\u0001,\u0003'\f.\t,\u0007b\u0004#\u0014#@6\u0012#\u000e1\u0006'\u0012b\u001b?@.\u000f!\u0001.\f;N"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0004\u0013\u0004q\u0006\u0019\u000b\u0018\u000f\u000ep|\u00189;)//>5$;j0/=.98|>3j?+2)9&|.=>=j(8=$/,98|1!d"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_YI.m_ca(Short.valueOf((short)(0x5B9A & 0x25F7)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_md.class})
    public void handleRescheduleEvent(c_md c_md2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_YI.m_La()) {
            DataTransferManager a = a.m_Ar();
            f_ej.info(VariableValueRepository.m_bba((Object)",\u0007!\u0006%\u0010Zb(#\u000e&\f+\u000e%@\u0010\u00051\u0003*\u0005&\u0015.\u0005\u0007\u0016'\u000e6@$\u000f0@&\u00016\u0001b\u00140\u0001,\u0013$\u00050Zb\u001b?@j)\u0006Zb\u001b?I"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_HC.f_Wg) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_ej.debug(c_xC.m_mf((Object)"\u0012\u0005\u0012g\u0010\u000f\u001d\u000e\u0019\u0018fj\u0015-2%.#2-|\u001899?\"9.)&9\u000f*/2>|,38|.=>=j(8=$/,98fj'7"), (Object)a.m_Ar().getId());
        }
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[3 >> 1] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return VariableValueRepository.m_bba((Object)"\u0004#\u0014#M6\u0012#\u000e1\u0006'\u0012x\u00136\u00016\u0013x\u0016#\u0012+\u0001 \f'Zg\u0013xE1Zg\u0013").formatted(objectArray);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.debug(VariableValueRepository.m_bba((Object)"\u000e%\u0003$\u00072x@\u0011\u0003*\u0005&\u0015.\t,\u0007b\u0004#\u0014#@6\u0012#\u000e1\u0006'\u0012b\u001b?@.\u000f!\u0001.\f;N"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0004\u0013\u0004q\u0006\u0019\u000b\u0018\u000f\u000ep|\u00189;)//>5$;j0/=.98|>3j/)4/8?0/|.=>=j(8=$/,98|1!d"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            a2.f_YI.m_ca(Short.valueOf((short)(0x13D1 & 0x6DBF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_Ai.m_xCa(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_Kk c_Kk2) {
        DataTransferManager a = c_Kk2;
        DataTransferManager a2 = this;
        switch (c_Lb.f_HG[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_jH.setex(a5, (long)n, String.valueOf(d));
            a4.f_jH.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_xC.m_mf((Object)"<=&)/"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_KA.class})
    public void handleCancelEvent(c_KA c_KA2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_YI.m_La()) {
            DataTransferManager a2 = a.m_wP();
            f_ej.info(VariableValueRepository.m_bba((Object)",\u0007!\u0006%\u0010Zb(#\u000e&\f+\u000e%@\u0001\u0001,\u0003'\f\u0007\u0016'\u000e6@$\u000f0@&\u00016\u0001b\u00140\u0001,\u0013$\u00050Zb\u001b?@j)\u0006Zb\u001b?I"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0012\u0005\u0012g\u0010\u000f\u001d\u000e\u0019\u0018fj\u0015-2%.#2-|\t=$?/0\u000f*/2>|,38|.=>=j(8=$/,98fj'7"), (Object)a.m_wP().getId());
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_MG.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a.getName();
            PeriodicJob periodicJob = a2.f_Xh.m_PM(a.getProject(), c_xC.m_mf((Object)"y9|\u000e=>=j\b8=$/,98").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_Rg.put(a.getId(), periodicJob);
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = a.getId();
            dataTransferManager.f_jH.sadd(f_lI, stringArray);
            return;
        }
        finally {
            a2.f_MG.unlock();
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_ej.info(VariableValueRepository.m_bba((Object)"$#\u0014#40\u0001,\u0013$\u00050-#\u000e#\u0007'\u0012bH\u000e\u0005#\u0004'\u0012b\u001b?Ix@\u0010\u00051\u0014-\u0012+\u000e%@&\u00016\u0001b\u00140\u0001,\u0013$\u00050Zb\u001b?@j)\u0006Zb\u001b?I"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_si.m_tk(a2.getProject()).m_s("Data Transfer Restore (Leader " + (String)a + ")", c_xC.m_mf((Object)"y9|b\u0015\u000efjy9uj:+5&9.|>3j.//>389d|\t=?//fjy9").formatted(objectArray));
            try {
                f_ej.warn(VariableValueRepository.m_bba((Object)"$#\u0014#40\u0001,\u0013$\u00050-#\u000e#\u0007'\u0012bH\u000e\u0005#\u0004'\u0012b\u001b?Ix@\u0003\u00146\u0005/\u00106\t,\u0007b\u0014-@!\u0001,\u0003'\fb\u0004#\u0014#@6\u0012#\u000e1\u0006'\u0012b\u001b?@#\u00066\u00050@0\u00051\u0014-\u0012#\u0014+\u000f,@$\u0001+\f7\u0012'N"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_ej.error(c_xC.m_mf((Object)"\u0018+(+\b8=$/,98\u0011+2+;/.jt\u00069+8/.j'7up|\f=#0/8j(%|)=$?/0j8+(+|>.+29:/.j'7|+:>98|899(%.+(#3$|,=#0?./fj'7"), objectArray2);
                return;
            }
        }
    }

    protected Map<String, c_HC> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Wi.m_Nn((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_qh.m_qca((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_Ai.m_UBa(object);
        a3 = dataTransferManager2.f_Ai.m_UBa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    protected c_HC getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Rg.containsKey(a)) {
            return c_HC.f_Wg;
        }
        return c_HC.f_fH;
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_sG.m_xea(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return 3 >> 1;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_Wi.m_XM((String)a, (String)a3).getId());
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_sG.m_xea(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Wi.m_tN((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    protected Map<String, c_HC> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_YI.m_Ma();
        f_ej.info(VariableValueRepository.m_bba((Object)"$#\u0014#40\u0001,\u0013$\u00050-#\u000e#\u0007'\u0012x@\u0016\b+\u0013b\u000e-\u0004'@j\u001b?Ib\t1@\f/b,\r.\u0005%\u0010@\u0016(\u0007@\u000e%\u0003$\u00072l@\u0001\u0001,\u0003'\f.\t,\u0007b\u0001.\fb\f-\u0003#\fb\u0004#\u0014#@6\u0012#\u000e1\u0006'\u0012b\n-\u00021NlN"), a);
        dataTransferManager2.f_MG.lock();
        try {
            new ArrayList(dataTransferManager.f_Rg.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_Rg.clear();
            f_ej.info(c_xC.m_mf((Object)"\u0018+(+\b8=$/,98\u0011+2+;/.jt\u00043>|\u00069+8/.j'7up|\u000b0&|&3)=&|.=>=j(8=$/,98| 3(/j4+*/|(9/2j./-?99(/8j(%|)=$?/0j=$8j?&9+./8j:83'|&3)=&|>.+?!5$;d"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_ej.error(VariableValueRepository.m_bba((Object)"\u0006\u00016\u0001\u0016\u0012#\u000e1\u0006'\u0012\u000f\u0001,\u0001%\u00050@j.-\u0014b,'\u0001&\u00050@9\u001dkZb%0\u0012-\u0012b\u00047\u0012+\u000e%@2\u0012-\u0003'\u00131@-\u0006b\u0003#\u000e!\u0005.\f+\u000e%@.\u000f!\u0001.@&\u00016\u0001b\u00140\u0001,\u0013$\u00050@(\u000f \u0013x@9\u001d"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_MG.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.debug(VariableValueRepository.m_bba((Object)",\u0007!\u0006%\u0010Zb##\u000e!\u0005.\f+\u000e%@#\f.@&\u00016\u0001b\u00140\u0001,\u0013$\u00050\u0013b\u0006-\u0012b\u00100\u000f(\u0005!\u0014b\u001b?@.\u000f!\u0001.\f;N"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0012\u0005\u0012g\u0010\u000f\u001d\u000e\u0019\u0018fj\u000e/-?99(#2-|&9+8/.j(%|)=$?/0j=&0j8+(+|>.+29:/.9|,38|:.%6/?>|1!d"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_YI.m_ca(Short.valueOf((short)(0x4FBF & 0x31D5)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_Kk c_Kk2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x4D & 0x3F, 2 & 5);
        ((Calendar)object).set(0xF & 0x7E, 3 >> 2);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_Lb.f_HG[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x2E & 0x5D, 3 >> 2);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0xF & 0x7B, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x7F & 0xB, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x7E & 0xD, 3 ^ 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x7F & 0xB, 3 & 4);
                ((Calendar)object4).set(0xE & 0x7D, 3 & 4);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 & 4);
                ((Calendar)object5).set(0xC & 0x7F, 3 & 4);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 5 >> 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(5 >> 1, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(VariableValueRepository.m_bba((Object)"5,\u0005:\u0010'\u00036\u0005&@0\u0001,\u0007'@6\u00192\u0005"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_jH.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return (3 ^ 3) != 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_YI.m_Ma();
        f_ej.info(c_xC.m_mf((Object)"\u0018+(+\b8=$/,98\u0011+2+;/.p|\u001e4#/j2%8/|b'7uj4+/j>/?%1/|>4/|\u0006\u0019\u000b\u0018\u000f\u000ed|\u001899(%.#2-|9?\"9.)&9.|.=>=j(8=$/,98/drd"), a);
        dataTransferManager2.f_MG.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_jH.smembers(f_lI));
            if (hashSet.isEmpty()) {
                f_ej.info(VariableValueRepository.m_bba((Object)"$#\u0014#40\u0001,\u0013$\u00050-#\u000e#\u0007'\u0012bH\u000e\u0005#\u0004'\u0012b\u001b?Ix@\f\u000fb\u0013!\b'\u00047\f'\u0004b\u0004#\u0014#@6\u0012#\u000e1\u0006'\u00121@$\u000f7\u000e&@+\u000eb2'\u0004+\u0013b\u0014-@0\u00051\u0014-\u0012'N"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_ej.info(c_xC.m_mf((Object)"\u000e=>=\u001e.+29:/.\u0007=$=-98|b\u0010/=.98|1!cfj\u001a%)$8j'7|9?\"9.)&9.|.=>=j(8=$/,98|\u0003\u00189|#2j\u000e/8#/j(%|899(%./fj'7"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = VariableValueRepository.m_bba((Object)"\u0014)\u00077\u001d$\u00034\u0003?\u00162\u0003.\u0011&\u00072");
            dataTransferManager.f_sG.m_iDa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_Wi.m_Pn((Set)a2));
            }, stringArray);
            f_ej.info(c_xC.m_mf((Object)"\u000e=>=\u001e.+29:/.\u0007=$=-98|b\u0010/=.98|1!cfj\u001d>(/1:(#2-|>3j.//>389j'7|.=>=j(8=$/,98/d"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_YI.m_Ma();
                String[] stringArray = new String[--2];
                stringArray[3 & 4] = VariableValueRepository.m_bba((Object)"\u0011#\n%\u00065\u000e%\u001d$\u00034\u0003?\u00162\u0003.\u0011&\u00072");
                stringArray[5 >> 2] = c_xC.m_mf((Object)"\u001f\u000b\u0012\t\u0019\u0006\u0003\u000e\u001d\u001e\u001d\u0015\b\u0018\u001d\u0004\u000f\f\u0019\u0018");
                dataTransferManager2.f_sG.m_Vda(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_ej.info(VariableValueRepository.m_bba((Object)"\u0006\u00016\u0001\u0016\u0012#\u000e1\u0006'\u0012\u000f\u0001,\u0001%\u00050@j,'\u0001&\u00050@9\u001dkZb&+\u000e+\u0013*\u0005&@&\u00016\u0001b\u00140\u0001,\u0013$\u00050@0\u00051\u0014-\u0012#\u0014+\u000f,@2\u0012-\u0003'\u00131N"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[--2] = exception;
            f_ej.error(c_xC.m_mf((Object)"\u000e=>=\u001e.+29:/.\u0007=$=-98|b\u0010/=.98|1!cfj\u00198.%.j8?.#2-|.=>=j(8=$/,98|899(%.+(#3$|:.%?//9fj'7"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_MG.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_YI.m_La()) {
            f_ej.debug(VariableValueRepository.m_bba((Object)",\u0007!\u0006%\u0010Zb3!\b'\u00047\f+\u000e%@#\f.@&\u00016\u0001b\u00140\u0001,\u0013$\u00050\u0013b\u0006-\u0012b\u00100\u000f(\u0005!\u0014b\u001b?@.\u000f!\u0001.\f;N"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_ej.debug(c_xC.m_mf((Object)"\u0012\u0005\u0012g\u0010\u000f\u001d\u000e\u0019\u0018fj\u000e/-?99(#2-|&9+8/.j(%|9?\"9.)&9j=&0j8+(+|>.+29:/.9|,38|:.%6/?>|1!d"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            a2.f_YI.m_ca(Short.valueOf((short)(0x31F5 & 0x4F9E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }
}

