/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.communication.protocols.opcua.z.c_pe;
import com.inscada.mono.communication.protocols.opcua.z.c_vE;
import com.inscada.mono.communication.protocols.opcua.z.c_wd;
import com.inscada.mono.shared.converters.c_Mb;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @Column(name="password")
    @Convert(converter=c_Mb.class)
    private String password;
    @Column(name="server_name")
    private String serverName;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;
    @NotNull
    @Column(name="security_mode")
    private c_vE securityMode;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;
    @Column(name="encoding_type")
    private c_pe encodingType;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;
    @NotNull
    @Column(name="security_policy")
    private c_wd securityPolicy;
    @Column(name="username")
    private String username;

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public void setSecurityMode(c_vE c_vE2) {
        OpcUaConnection a = c_vE2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }

    public c_vE getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public void setSecurityPolicy(c_wd c_wd2) {
        OpcUaConnection a = c_wd2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public c_pe getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }

    public void setEncodingType(c_pe c_pe2) {
        OpcUaConnection a = c_pe2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public c_wd getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }
}

