/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_zL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_g;
import com.inscada.mono.communication.base.c.c_Al;
import com.inscada.mono.communication.base.c.c_HK;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_aD;
import com.inscada.mono.communication.base.services.c_di;
import com.inscada.mono.communication.base.services.c_fk;
import com.inscada.mono.communication.base.services.c_h;
import com.inscada.mono.communication.base.z.c_PJ;
import com.inscada.mono.datasource.sql.model.metadata.ProcedureMetadata;
import com.inscada.mono.impexp.z.c_FC;
import com.inscada.mono.license.c.c_wc;
import com.inscada.mono.log.c.c_mC;
import com.inscada.mono.project.c.c_a;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_a {
    private final c_g f_Eu;
    private static final Logger f_os = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_at = 202;
    public static final short f_hS = 206;
    private final c_zL f_mT;
    private final c_mC f_DS;
    public static final short f_ES = 204;
    public static final short f_At = 201;
    private final c_di<C, V> f_It;
    public static final short f_SS = 210;
    public static final short f_Ru = 207;
    private final Lock f_Ct;
    public static final short f_PR = 203;
    public static final short f_pu = 208;
    private static final String f_lt = "activeConnections";
    public static final short f_DU = 205;
    private final c_fk f_sR;
    private final c_wc f_fs;
    private final JedisPooled f_Es;
    public static final short f_AT = 209;

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_HK.class})
    public void handleRestartEvent(c_HK c_HK2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_Eu.m_La()) {
            ConnectionManager a2 = a.m_lBa();
            f_os.info(ProcedureMetadata.m_DQ((Object)"\u00155\u00184\u001c\"cP\u0011\u00117\u00145\u00197\u0017y\"<\u0003-\u0011+\u0004\u001c\u0006<\u001e-P?\u001f+P:\u001f7\u001e<\u0013-\u00196\u001ecP\"\ryX\u00104cP\"\rp"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_Ct.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_PJ.f_xu) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_Ct.unlock();
            }
        }
        f_os.debug(c_FC.m_bO((Object)"\u00077\u0007U\u0005=\b<\f*sX\u0000\u001f'\u0017;\u0011'\u001fi*,\u000b=\u0019;\f\f\u000e,\u0016=X/\u0017;X*\u0017'\u0016,\u001b=\u0011&\u0016sX2\u0005"), (Object)a.m_lBa().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_sR.m_Tca((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_Eu.m_Ma();
        String[] stringArray = new String[--3];
        stringArray[3 & 4] = c_FC.m_bO((Object)"\u001a,\b*\u001d'\n7\u00076\f;\u001d1\u00066");
        stringArray[3 & 5] = ProcedureMetadata.m_DQ((Object)"\n$\u0016 \u00063\u0016>\u00175\u001a$\u0010?\u0017");
        stringArray[--2] = c_FC.m_bO((Object)"\u001f1\f/\u0016;\u00066\u0007=\n,\u00007\u0007'\u0000,\f5");
        connectionManager2.f_mT.m_Vda(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_sR.m_Ica((String)a);
        return connectionManager2.f_mT.m_Bea(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_Eu.m_X((ClusterNodeListener)a);
        f_os.info(ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f7=8\u001e8\u0017<\u0002y\u00197\u0019-\u00198\u001c0\n<\u0014y\u00117\u0014y\u0002<\u00170\u0003-\u0015+\u0015=P8\u0003y35\u0005*\u0004<\u0002\u0017\u001f=\u0015\u0015\u0019*\u0004<\u001e<\u0002w"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_PJ> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"4\f9\r=\u001bBi?,\f=\u0011'\u001fi\u0019%\u0014i\u001b&\u0016'\u001d*\f \u0017'X:\f(\f<\u000b,\u000bi\u001e&\ni\b;\u0017#\u001d*\fi\u00034X%\u0017*\u0019%\u00140V"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)"\u0017?\u0017]\u00155\u00184\u001c\"cP\u000b\u0015(\u0005<\u0003-\u00197\u0017y\u001c<\u0011=\u0015+P?\u001f+P8\u001c5P:\u001f7\u001e<\u0013-\u00196\u001ey\u0003-\u0011-\u0005*\u0015*P?\u001f+P)\u00026\u001a<\u0013-P\"\rw"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_Eu.m_ca(Short.valueOf((short)(0xCF5 & 0x73DA)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_Eu.m_Ma();
        f_os.info(ProcedureMetadata.m_DQ((Object)"\u001a\u001f7\u001e<\u0013-\u00196\u001e\u0014\u00117\u0011>\u0015+Jy$1\u0019*P7\u001f=\u0015yX\"\rpP0\u0003y>\u0016P\u0015?\u00177\u001c\"y$\u00115y<\u001c1\u001d5\u000b^y#-\u001f)\u00000\u001e>P8\u001c5P5\u001f:\u00115P:\u001f7\u001e<\u0013-\u001f+\u0003w^w"), a);
        connectionManager2.f_Ct.lock();
        try {
            connectionManager.f_It.m_jCa();
            f_os.info(c_FC.m_bO((Object)"\n\u0017'\u0016,\u001b=\u0011&\u0016\u0004\u0019'\u0019.\u001d;Xa6&\fi4,\u0019-\u001d;X2\u0005`Bi9%\u0014i\u0014&\u001b(\u0014i\u001b&\u0016'\u001d*\f&\n:X!\u0019?\u001di\u001a,\u001d'X;\u001d8\r,\u000b=\u001d-X=\u0017i\u000b=\u00179X(\u0016-X*\u0014,\u0019;\u001d-X/\n&\u0015i\u0014&\u001b(\u0014i\f;\u0019*\u0013 \u0016.V"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[--2] = exception;
            f_os.error(ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f7=8\u001e8\u0017<\u0002yX\u0017\u001f-P\u0015\u00158\u0014<\u0002y\u000b$YcP\u001c\u0002+\u001f+P=\u0005+\u00197\u0017y\u0000+\u001f:\u0015*\u0003y\u001f?P*\u00046\u0000)\u00197\u0017y\u001c6\u00138\u001cy\u00136\u001e7\u0015:\u00046\u0002*Jy\u000b$"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Ct.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_sR.m_Mca((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"\u0005=\b<\f*sX\u001a\f&\b9\u0011'\u001fi\u0019%\u0014i\u001b&\u0016'\u001d*\f \u0017'\u000bi\u001e&\ni\b;\u0017#\u001d*\fi\u00034X%\u0017*\u0019%\u00140V"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)"\u0017?\u0017]\u00155\u00184\u001c\"cP\u000b\u0015(\u0005<\u0003-\u00197\u0017y\u001c<\u0011=\u0015+P-\u001fy\u0003-\u001f)P8\u001c5P:\u001f7\u001e<\u0013-\u00196\u001e*P?\u001f+P)\u00026\u001a<\u0013-P\"\rw"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_Eu.m_ca(Short.valueOf((short)(0x35CF & 0x4AFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, c_FC.m_bO((Object)"\u001a\u001d=.(\u0014<\u001d\u001b\u001d8\r,\u000b=X*\u0019'\u0016&\fi\u001a,X'\r%\u0014"));
        Objects.requireNonNull(a.getConnectionId(), ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f79=P0\u001ey#<\u0004\u000f\u00115\u0005<\"<\u0001,\u0015*\u0004y\u00138\u001e7\u001f-P;\u0015y\u001e,\u001c5"));
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"\u0005=\b<\f*sX\u001a\u001d=\f \u0016.X?\u0019;\u0011(\u001a%\u001di\u000e(\u0014<\u001di\u001e&\ni\u001b&\u0016'\u001d*\f \u0017'X2\u0005i\u0014&\u001b(\u0014%\u0001sX2\u0005"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)"\u0017?\u0017]\u00155\u00184\u001c\"cP\u000b\u0015(\u0005<\u0003-\u00197\u0017y\u001c<\u0011=\u0015+P-\u001fy\u0003<\u0004y\u00068\u00020\u0011;\u001c<P/\u00115\u0005<P?\u001f+P:\u001f7\u001e<\u0013-\u00196\u001ey\u000b$Jy\u000b$"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_Eu.m_ca(Short.valueOf((short)(0x51CC & 0x2EFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"4\f9\r=\u001bBi+=\u0019;\f \u0016.X*\u0017'\u0016,\u001b=\u0011&\u0016i\u00034X%\u0017*\u0019%\u00140V"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)"\u0017?\u0017]\u00155\u00184\u001c\"cP\u000b\u0015(\u0005<\u0003-\u00197\u0017y\u001c<\u0011=\u0015+P-\u001fy\u0003-\u0011+\u0004y\u00136\u001e7\u0015:\u00040\u001f7P\"\rw"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_Eu.m_ca(Short.valueOf((short)(0x60FD & 0x1FCB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_mT.m_xea(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Ct.lock();
            try {
                c_aD c_aD2 = a2.f_It.m_vaa(a.getId());
                if (c_aD2 != null) {
                    c_aD2.m_ou();
                    a2.f_It.m_ICa(a.getId(), c_aD2);
                }
                String[] stringArray = new String[4 ^ 5];
                stringArray[2 & 5] = a.getId();
                a2.f_Es.srem(f_lt, stringArray);
                return;
            }
            finally {
                a2.f_Ct.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_fk c_fk2, c_wc c_wc2, c_mC c_mC2, c_di<C, V> c_di2, JedisPooled jedisPooled, c_g c_g2, c_zL c_zL2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_zL2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_Ct = new ReentrantLock();
        a8.f_sR = a7;
        connectionManager5.f_fs = a6;
        connectionManager5.f_DS = a5;
        connectionManager4.f_It = a4;
        connectionManager4.f_Es = a3;
        connectionManager3.f_Eu = a2;
        connectionManager3.f_mT = a;
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_sR.m_Xca((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"\u0005=\b<\f*sX\u001a\f(\n=\u0011'\u001fi\u0019%\u0014i\u001b&\u0016'\u001d*\f \u0017'\u000bi\u001e&\ni\b;\u0017#\u001d*\fi\u00034X%\u0017*\u0019%\u00140V"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)">\u0016>t<\u001c1\u001d5\u000bJy\"<\u0001,\u0015*\u00040\u001e>P5\u00158\u0014<\u0002y\u00046P*\u00048\u0002-P8\u001c5P:\u001f7\u001e<\u0013-\u00196\u001e*P?\u001f+P)\u00026\u001a<\u0013-P\"\rw"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            a2.f_Eu.m_ca(Short.valueOf((short)(0x64EE & 0x1BDF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_PJ getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_It.m_vaa((String)a)) != null && a.m_ht()) {
            return c_PJ.f_xu;
        }
        return c_PJ.f_ct;
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[5 >> 3] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x11CD & 0x6EFB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_FC.m_bO((Object)"\u000b=\u0019;\f\n\u0017'\u0016,\u001b=\u0011&\u0016\u0000\u0016=\u001d;\u0016(\u0014"), classArray));
            Class[] classArray2 = new Class[4 ^ 5];
            classArray2[3 >> 2] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x38EF & 0x47DA), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ProcedureMetadata.m_DQ((Object)"\u0003-\u001f)36\u001e7\u0015:\u00040\u001f797\u0004<\u00027\u00115"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 ^ 3] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x2CF & 0x7DFB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_FC.m_bO((Object)"\u001f,\f\n\u0017'\u0016,\u001b=\u0011&\u0016\u001a\f(\f<\u000b\u0000\u0016=\u001d;\u0016(\u0014"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[2 & 5] = SetValueRequest.class;
            connectionManager.f_Eu.m_Ca((short)(0x59FF & 0x26CC), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ProcedureMetadata.m_DQ((Object)"\u0003<\u0004\u000f\u0011+\u00198\u00125\u0015\u000f\u00115\u0005<97\u0004<\u00027\u00115"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[5 >> 3] = Collection.class;
            connectionManager.f_Eu.m_Ca((short)(0x3ECF & 0x41FD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_FC.m_bO((Object)"\u000b,\f\u001f\u0019;\u0011(\u001a%\u001d\u001f\u0019%\r,\u000b\u0000\u0016=\u001d;\u0016(\u0014"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x4CCF & 0x33FE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ProcedureMetadata.m_DQ((Object)"*\u00048\u0002-36\u001e7\u0015:\u00040\u001f7\u0003\u001b\t\t\u00026\u001a<\u0013-9=97\u0004<\u00027\u00115"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x36DF & 0x49EF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_FC.m_bO((Object)":\f&\b\n\u0017'\u0016,\u001b=\u0011&\u0016::0(;\u0017#\u001d*\f\u0000\u001c\u0000\u0016=\u001d;\u0016(\u0014"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x7DFF & 0x2D0), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ProcedureMetadata.m_DQ((Object)"\u0017<\u0004\u001a\u001f7\u001e<\u0013-\u00196\u001e\n\u00048\u0004,\u0003<\u0003\u001b\t\t\u00026\u001a<\u0013-9=97\u0004<\u00027\u00115"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_Eu.m_Ca((short)(0x24D9 & 0x5BF7), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_FC.m_bO((Object)".\u001d=;&\u0016'\u001d*\f \u0017'+=\u0019=\r:\u001d::01-\u000b\u0000\u0016=\u001d;\u0016(\u0014"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_Eu.m_Ca((short)(0x59D3 & 0x26FE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ProcedureMetadata.m_DQ((Object)"\u0012+\u001f.\u0003<36\u001e7\u0015:\u00040\u001f797\u0004<\u00027\u00115"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_FC.m_bO((Object)"\u000f\u0019 \u0014,\u001ci\f&X;\u001d.\u0011:\f,\ni;&\u0016'\u001d*\f \u0017'5(\u0016(\u001f,\ni*\u0019;i\u0015,\f!\u0017-\u000b"), a);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_It.m_vaa((String)a)) != null) {
                void a3;
                a.m_Qu((List)a3);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Al.class})
    public void handleDeleteEvent(c_Al c_Al2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_Eu.m_La()) {
            ConnectionManager a2 = a.m_Fca();
            f_os.info(ProcedureMetadata.m_DQ((Object)"<\u001c1\u001d5\u000bJy88\u001e=\u001c0\u001e>P\u001d\u00155\u0015-\u0015\u001c\u0006<\u001e-P?\u001f+P:\u001f7\u001e<\u0013-\u00196\u001ecP\"\ryX\u00104cP\"\rp"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_os.debug(c_FC.m_bO((Object)"6\u00066d4\f9\r=\u001bBi1.\u0016&\n \u0016.X\r\u001d%\u001d=\u001d\f\u000e,\u0016=X/\u0017;X*\u0017'\u0016,\u001b=\u0011&\u0016sX2\u0005"), (Object)a.m_Fca().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_sR.m_Tca((String)a, (String)a3).getId());
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_It.m_vaa((String)a)) instanceof c_h) {
            return ((c_h)a).m_w();
        }
        throw new BrowseOperationException(ProcedureMetadata.m_DQ((Object)"2+\u001f.\u0003<P6\u0000<\u00028\u00040\u001f7P7\u001f-P*\u0005)\u00006\u0002-\u0015="));
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_sR.m_Ica((String)a2));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"4\f9\r=\u001bBi+=\u00179\b \u0016.X*\u0017'\u0016,\u001b=\u0011&\u0016i\u00034X%\u0017*\u0019%\u00140V"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)">\u0016>t<\u001c1\u001d5\u000bJy\"<\u0001,\u0015*\u00040\u001e>P5\u00158\u0014<\u0002y\u00046P*\u00046\u0000y\u00136\u001e7\u0015:\u00040\u001f7P\"\rw"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            a2.f_Eu.m_ca(Short.valueOf((short)(0x8EE & 0x77DB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_sR.m_Xca((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"\u0005=\b<\f*sX\u0019\u001d;\u001e&\n$\u0011'\u001fi\u001a;\u0017>\u000b,X&\b,\n(\f \u0017'X/\u0017;X*\u0017'\u0016,\u001b=\u0011&\u0016i\u00034X%\u0017*\u0019%\u00140V"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)">\u0016>t<\u001c1\u001d5\u000bJy\"<\u0001,\u0015*\u00040\u001e>P5\u00158\u0014<\u0002y\u00046P)\u0015+\u00166\u00024P;\u00026\u0007*\u0015y\u001f)\u0015+\u0011-\u00196\u001ey\u00166\u0002y\u00136\u001e7\u0015:\u00040\u001f7P\"\rw"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return a2.f_Eu.m_ca(Short.valueOf((short)(0x75F7 & 0xADA)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.info(ProcedureMetadata.m_DQ((Object)"<\u001c1\u001d5\u000bJy88\u001e=\u001c0\u001e>P\t\u00026\u001a<\u0013-4<\u0011:\u00040\u00068\u0004<5/\u00157\u0004y\u00166\u0002y\u0000+\u001f3\u0015:\u0004y9\u001dJy\u000b$"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_os.debug(c_FC.m_bO((Object)"\u00077\u0007U\u0005=\b<\f*sX\u0000\u001f'\u0017;\u0011'\u001fi(;\u0017#\u001d*\f\r\u001d(\u001b=\u0011?\u0019=\u001d\f\u000e,\u0016=X/\u0017;X9\n&\u0012,\u001b=X\u0000<sX2\u0005"), a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_Eu.m_Ma();
        f_os.info(ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f7=8\u001e8\u0017<\u0002cP\r\u00180\u0003y\u001e6\u0014<Pq\u000b$Yy\u00188\u0003y\u0012<\u00136\u001d<P-\u0018<P\u00155\u00184\u001c\"wP\u000b\u0015*\u00046\u00020\u001e>P8\u0013-\u0019/\u0015y\u00136\u001e7\u0015:\u00040\u001f7\u0003w^w"), a);
        connectionManager2.f_Ct.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_Es.smembers(f_lt));
            if (hashSet.isEmpty()) {
                f_os.info(c_FC.m_bO((Object)";&\u0016'\u001d*\f \u0017'5(\u0016(\u001f,\niP\u0005\u001d(\u001c,\ni\u00034QsX\u0007\u0017i\u0019*\f \u000e,X*\u0017'\u0016,\u001b=\u0011&\u0016:X/\u0017<\u0016-X \u0016i*,\u001c \u000bi\f&X;\u001d:\f&\n,V"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[4 ^ 5] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_os.info(ProcedureMetadata.m_DQ((Object)"\u001a\u001f7\u001e<\u0013-\u00196\u001e\u0014\u00117\u0011>\u0015+Pq<<\u0011=\u0015+P\"\rpJy66\u00057\u0014y\u000b$P8\u0013-\u0019/\u0015y\u00136\u001e7\u0015:\u00040\u001f7P\u00104*P0\u001ey\"<\u00140\u0003y\u00046P+\u0015*\u00046\u0002<Jy\u000b$"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = c_FC.m_bO((Object)"\u001f1\f/\u0016;\u00066\u0007=\n,\u00007\u0007'\u0000,\f5");
            connectionManager.f_mT.m_iDa(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_sR.m_wca((Set)a2));
            }, stringArray);
            f_os.info(ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f7=8\u001e8\u0017<\u0002yX\u0015\u00158\u0014<\u0002y\u000b$YcP\u0018\u0004-\u00154\u0000-\u00197\u0017y\u00046P+\u0015*\u00046\u0002<P\"\ry\u00136\u001e7\u0015:\u00040\u001f7\u0003w"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_os.info(c_FC.m_bO((Object)";&\u0016'\u001d*\f \u0017'5(\u0016(\u001f,\niP\u0005\u001d(\u001c,\ni\u00034QsX\u000f\u0011'\u0011:\u0010,\u001ci\u001b&\u0016'\u001d*\f \u0017'X;\u001d:\f&\n(\f \u0017'X9\n&\u001b,\u000b:V"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_os.error(ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f7=8\u001e8\u0017<\u0002yX\u0015\u00158\u0014<\u0002y\u000b$YcP\u001c\u0002+\u001f+P=\u0005+\u00197\u0017y\u00136\u001e7\u0015:\u00040\u001f7P+\u0015*\u00046\u00028\u00040\u001f7P)\u00026\u0013<\u0003*Jy\u000b$"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Ct.unlock();
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_aD c_aD2 = a2.f_It.m_vaa(a.getConnectionId());
        if (c_aD2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_aD2.m_As(a);
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_mT.m_xea(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Ct.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_fs.m_CJ();
                connectionManager.f_It.m_dda((Connection)a).m_bS();
                String[] stringArray = new String[5 >> 2];
                stringArray[5 >> 3] = a.getId();
                connectionManager.f_Es.sadd(f_lt, stringArray);
                return;
            }
            finally {
                a2.f_Ct.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_PJ getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_sR.m_hca((String)a2, (String)a)) == null) {
            return c_PJ.f_ct;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    protected Map<String, c_PJ> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_FC.m_bO((Object)"\u001a\u001d=.(\u0014<\u001d\u001b\u001d8\r,\u000b=X*\u0019'\u0016&\fi\u001a,X'\r%\u0014")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), ProcedureMetadata.m_DQ((Object)"36\u001e7\u0015:\u00040\u001f79=P0\u001ey#<\u0004\u000f\u00115\u0005<\"<\u0001,\u0015*\u0004y\u00138\u001e7\u001f-P;\u0015y\u001e,\u001c5")));
        if (a3.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"4\f9\r=\u001bBi+,\f=\u0011'\u001fi\u00034X?\u0019;\u0011(\u001a%\u001di\u000e(\u0014<\u001d:X%\u0017*\u0019%\u00140V"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)">\u0016>t<\u001c1\u001d5\u000bJy\"<\u0001,\u0015*\u00040\u001e>P5\u00158\u0014<\u0002y\u00046P*\u0015-P\"\ry\u00068\u00020\u0011;\u001c<P/\u00115\u0005<\u0003w"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a22);
            a3.f_Eu.m_ca(Short.valueOf((short)(0x63DD & 0x1CEF)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(c_FC.m_bO((Object)">(\u0011%\u001d-X=\u0017i*\u0019;i\u000b,\fi\u000e(\n \u0019+\u0014,X?\u0019%\r,\u000b"), (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_PJ getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"4\f9\r=\u001bBi?,\f=\u0011'\u001fi\u001b&\u0016'\u001d*\f \u0017'X:\f(\f<\u000bi\u001e&\ni\u00034X%\u0017*\u0019%\u00140V"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)"\u0017?\u0017]\u00155\u00184\u001c\"cP\u000b\u0015(\u0005<\u0003-\u00197\u0017y\u001c<\u0011=\u0015+P?\u001f+P:\u001f7\u001e<\u0013-\u00196\u001ey\u0003-\u0011-\u0005*P?\u001f+P\"\rw"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            return (c_PJ)a2.f_Eu.m_ca(Short.valueOf((short)(0x71EF & 0xEDB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_PJ> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_sR.m_qAa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_sR.m_bCa(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_PJ> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_Eu.m_La()) {
            f_os.debug(c_FC.m_bO((Object)"4\f9\r=\u001bBi?,\f=\u0011'\u001fi\u001b&\u0016'\u001d*\f \u0017'X:\f(\f<\u000b,\u000bi\u001e&\ni\u00034X\u0000<:X%\u0017*\u0019%\u00140V"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_os.debug(ProcedureMetadata.m_DQ((Object)"\u0017?\u0017]\u00155\u00184\u001c\"cP\u000b\u0015(\u0005<\u0003-\u00197\u0017y\u001c<\u0011=\u0015+P?\u001f+P:\u001f7\u001e<\u0013-\u00196\u001ey\u0003-\u0011-\u0005*\u0015*P?\u001f+P\"\ry9\u001d\u0003w"), (Object)a.length);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_Eu.m_ca(Short.valueOf((short)(0x57F7 & 0x28D9)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_os.info(c_FC.m_bO((Object)"\n\u0017'\u0016,\u001b=\u0011&\u0016\u0004\u0019'\u0019.\u001d;Xa4,\u0019-\u001d;X2\u0005`Bi*,\u000b=\u0017;\u0011'\u001fi\u001b&\u0016'\u001d*\f \u0017'Bi\u00034Xa1\rBi\u00034Q"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_DS.m_tk(a2.getProject()).m_s("Connection Restore (Leader " + (String)a + ")", ProcedureMetadata.m_DQ((Object)"U*Pq9\u001dJyU*Yy\u00168\u00195\u0015=P-\u001fy\u0002<\u0003-\u001f+\u0015wP\u001a\u0011,\u0003<JyU*").formatted(objectArray));
            try {
                f_os.warn(c_FC.m_bO((Object)"\n\u0017'\u0016,\u001b=\u0011&\u0016\u0004\u0019'\u0019.\u001d;Xa4,\u0019-\u001d;X2\u0005`Bi9=\f,\u00159\f \u0016.X=\u0017i\u000b=\u00179X*\u0017'\u0016,\u001b=\u0011&\u0016i\u00034X(\u001e=\u001d;X;\u001d:\f&\n(\f \u0017'X/\u0019 \u0014<\n,V"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_os.error(ProcedureMetadata.m_DQ((Object)"\u001a\u001f7\u001e<\u0013-\u00196\u001e\u0014\u00117\u0011>\u0015+Pq<<\u0011=\u0015+P\"\rpJy68\u00195\u0015=P-\u001fy\u0003-\u001f)P:\u001f7\u001e<\u0013-\u00196\u001ey\u000b$P8\u0016-\u0015+P+\u0015*\u00046\u00028\u00040\u001f7P?\u00110\u001c,\u0002<Jy\u000b$"), objectArray2);
                return;
            }
        }
    }
}

